/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppFilter;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmController;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMWebApp
extends WebApp
implements YarnWebParams {
    private static final Logger LOG = LoggerFactory.getLogger((String)RMWebApp.class.getName());
    private final ResourceManager rm;
    private boolean standby = false;

    public RMWebApp(ResourceManager rm) {
        this.rm = rm;
    }

    public void setup() {
        this.bind(JAXBContextResolver.class);
        this.bind(RMWebServices.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(RMWebApp.class).toInstance((Object)this);
        if (this.rm != null) {
            this.bind(ResourceManager.class).toInstance((Object)this.rm);
        }
        this.route("/", RmController.class);
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodes", "node.state"}), RmController.class, "nodes");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.state"}), RmController.class);
        this.route("/cluster", RmController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/app", "app.id"}), RmController.class, "app");
        this.route("/scheduler", RmController.class, "scheduler");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/queue", "queue.name"}), RmController.class, "queue");
        this.route("/nodelabels", RmController.class, "nodelabels");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/appattempt", "appattempt.id"}), RmController.class, "appattempt");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), RmController.class, "container");
        this.route("/errors-and-warnings", RmController.class, "errorsAndWarnings");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/logaggregationstatus", "app.id"}), RmController.class, "logaggregationstatus");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/failure", "app.id"}), RmController.class, "failure");
    }

    protected Class<? extends GuiceContainer> getWebAppFilterClass() {
        return RMWebAppFilter.class;
    }

    public void checkIfStandbyRM() {
        this.standby = this.rm.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY;
    }

    public boolean isStandby() {
        return this.standby;
    }

    public String getRedirectPath() {
        if (this.standby) {
            return this.buildRedirectPath();
        }
        return super.getRedirectPath();
    }

    private String buildRedirectPath() {
        YarnConfiguration yarnConf = new YarnConfiguration(this.rm.getConfig());
        String activeRMHAId = RMHAUtils.findActiveRMHAId((YarnConfiguration)yarnConf);
        String path = "";
        if (activeRMHAId != null) {
            yarnConf.set("yarn.resourcemanager.ha.id", activeRMHAId);
            InetSocketAddress sock = YarnConfiguration.useHttps((Configuration)yarnConf) ? yarnConf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090) : yarnConf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088);
            path = sock.getHostName() + ":" + Integer.toString(sock.getPort());
            path = YarnConfiguration.useHttps((Configuration)yarnConf) ? "https://" + path : "http://" + path;
        }
        return path;
    }

    public String getHAZookeeperConnectionState() {
        return this.getRMContext().getHAZookeeperConnectionState();
    }

    public RMContext getRMContext() {
        return this.rm.getRMContext();
    }
}

