/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.AppNameMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementFactory;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInvalidException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSMaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigValidator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.WorkflowPriorityMappingsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.CSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.FileBasedCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.AssignmentInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceAllocationCommitter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintsUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAttributesUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.QueueManagementChangeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ReleaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SimpleCandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
extends AbstractYarnScheduler<FiCaSchedulerApp, FiCaSchedulerNode>
implements PreemptableResourceScheduler,
CapacitySchedulerContext,
Configurable,
ResourceAllocationCommitter,
MutableConfScheduler {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private static final Logger LOG = LoggerFactory.getLogger(CapacityScheduler.class);
    private CapacitySchedulerQueueManager queueManager;
    private WorkflowPriorityMappingsManager workflowPriorityMappingsMgr;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private PreemptionManager preemptionManager = new PreemptionManager();
    private volatile boolean isLazyPreemptionEnabled = false;
    private int offswitchPerHeartbeatLimit;
    private boolean assignMultipleEnabled;
    private int maxAssignPerHeartbeat;
    private CSConfigurationProvider csConfProvider;
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private ResourceCalculator calculator;
    private boolean usePortForNodeName;
    private boolean scheduleAsynchronously;
    @VisibleForTesting
    protected List<AsyncScheduleThread> asyncSchedulerThreads;
    private ResourceCommitterService resourceCommitterService;
    private RMNodeLabelsManager labelManager;
    private AppPriorityACLsManager appPriorityACLManager;
    private boolean multiNodePlacementEnabled;
    private static boolean printedVerboseLoggingForAsyncScheduling = false;
    private long asyncScheduleInterval;
    private static final String ASYNC_SCHEDULER_INTERVAL = "yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms";
    private static final long DEFAULT_ASYNC_SCHEDULER_INTERVAL = 5L;
    private long asyncMaxPendingBacklogs;
    private CSMaxRunningAppsEnforcer maxRunningEnforcer = new CSMaxRunningAppsEnforcer(this);
    private static final Random random = new Random(System.currentTimeMillis());

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    private void validateConf(Configuration conf) {
        CapacitySchedulerConfigValidator.validateMemoryAllocation(conf);
        CapacitySchedulerConfigValidator.validateVCores(conf);
    }

    @Override
    public Configuration getConf() {
        return this.yarnConf;
    }

    public CapacityScheduler() {
        super(CapacityScheduler.class.getName());
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.getRootQueue().getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.queueManager.getRootQueue();
    }

    @Override
    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    @VisibleForTesting
    public void setResourceCalculator(ResourceCalculator rc) {
        this.calculator = rc;
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodeTracker.nodeCount();
    }

    @Override
    public RMContext getRMContext() {
        return this.rmContext;
    }

    @Override
    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void initScheduler(Configuration configuration) throws IOException, YarnException {
        this.writeLock.lock();
        try {
            String confProviderStr;
            switch (confProviderStr = configuration.get("yarn.scheduler.configuration.store.class", "file")) {
                case "file": {
                    this.csConfProvider = new FileBasedCSConfigurationProvider(this.rmContext);
                    break;
                }
                case "memory": 
                case "leveldb": 
                case "zk": 
                case "fs": {
                    this.csConfProvider = new MutableCSConfigurationProvider(this.rmContext);
                    break;
                }
                default: {
                    throw new IOException("Invalid configuration store class: " + confProviderStr);
                }
            }
            this.csConfProvider.init(configuration);
            this.conf = this.csConfProvider.loadConfiguration(configuration);
            this.validateConf(this.conf);
            this.minimumAllocation = super.getMinimumAllocation();
            this.initMaximumResourceCapability(super.getMaximumAllocation());
            this.calculator = this.conf.getResourceCalculator();
            if (this.calculator instanceof DefaultResourceCalculator && ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                throw new YarnRuntimeException("RM uses DefaultResourceCalculator which used only memory as resource-type but invalid resource-types specified " + ResourceUtils.getResourceTypes() + ". Use DominantResourceCalculator instead to make effective use of these resource-types");
            }
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.applications = new ConcurrentHashMap();
            this.labelManager = this.rmContext.getNodeLabelManager();
            this.appPriorityACLManager = new AppPriorityACLsManager(this.conf);
            this.queueManager = new CapacitySchedulerQueueManager(this.yarnConf, this.labelManager, this.appPriorityACLManager);
            this.queueManager.setCapacitySchedulerContext(this);
            this.workflowPriorityMappingsMgr = new WorkflowPriorityMappingsManager();
            this.activitiesManager = new ActivitiesManager(this.rmContext);
            this.activitiesManager.init(this.conf);
            this.initializeQueues(this.conf);
            this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
            this.scheduleAsynchronously = this.conf.getScheduleAynschronously();
            this.asyncScheduleInterval = this.conf.getLong(ASYNC_SCHEDULER_INTERVAL, 5L);
            this.assignMultipleEnabled = this.conf.getAssignMultipleEnabled();
            this.maxAssignPerHeartbeat = this.conf.getMaxAssignPerHeartbeat();
            int maxAsyncSchedulingThreads = this.conf.getInt("yarn.scheduler.capacity.schedule-asynchronously.maximum-threads", 1);
            maxAsyncSchedulingThreads = Math.max(maxAsyncSchedulingThreads, 1);
            if (this.scheduleAsynchronously) {
                this.asyncSchedulerThreads = new ArrayList<AsyncScheduleThread>();
                for (int i = 0; i < maxAsyncSchedulingThreads; ++i) {
                    this.asyncSchedulerThreads.add(new AsyncScheduleThread(this));
                }
                this.resourceCommitterService = new ResourceCommitterService(this);
                this.asyncMaxPendingBacklogs = this.conf.getInt("yarn.scheduler.capacity.schedule-asynchronously.maximum-pending-backlogs", CapacitySchedulerConfiguration.DEFAULT_SCHEDULE_ASYNCHRONOUSLY_MAXIMUM_PENDING_BACKLOGS);
            }
            this.offswitchPerHeartbeatLimit = this.conf.getOffSwitchPerHeartbeatLimit();
            this.multiNodePlacementEnabled = this.conf.getMultiNodePlacementEnabled();
            if (this.rmContext.getMultiNodeSortingManager() != null) {
                this.rmContext.getMultiNodeSortingManager().registerMultiNodePolicyNames(this.multiNodePlacementEnabled, this.conf.getMultiNodePlacementPolicies());
            }
            LOG.info("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", minimumAllocation=<" + this.getMinimumResourceCapability() + ">, maximumAllocation=<" + this.getMaximumResourceCapability() + ">, asynchronousScheduling=" + this.scheduleAsynchronously + ", asyncScheduleInterval=" + this.asyncScheduleInterval + "ms,multiNodePlacementEnabled=" + this.multiNodePlacementEnabled + ", assignMultipleEnabled=" + this.assignMultipleEnabled + ", maxAssignPerHeartbeat=" + this.maxAssignPerHeartbeat + ", offswitchPerHeartbeatLimit=" + this.offswitchPerHeartbeatLimit);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startSchedulerThreads() {
        this.writeLock.lock();
        try {
            this.activitiesManager.start();
            if (this.scheduleAsynchronously) {
                Preconditions.checkNotNull(this.asyncSchedulerThreads, (Object)"asyncSchedulerThreads is null");
                for (Thread thread : this.asyncSchedulerThreads) {
                    thread.start();
                }
                this.resourceCommitterService.start();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        super.serviceInit(conf);
        this.initScheduler(configuration);
        this.schedulingMonitorManager.initialize(this.rmContext, conf);
    }

    @Override
    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    @Override
    public void serviceStop() throws Exception {
        this.writeLock.lock();
        try {
            this.activitiesManager.stop();
            if (this.scheduleAsynchronously && this.asyncSchedulerThreads != null) {
                for (Thread thread : this.asyncSchedulerThreads) {
                    thread.interrupt();
                    thread.join(1000L);
                }
                this.resourceCommitterService.interrupt();
                this.resourceCommitterService.join(1000L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.isConfigurationMutable()) {
            ((MutableConfigurationProvider)((Object)this.csConfProvider)).close();
        }
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(Configuration newConf, RMContext rmContext, boolean validation) throws IOException {
        this.writeLock.lock();
        try {
            Configuration configuration = new Configuration(newConf);
            CapacitySchedulerConfiguration oldConf = this.conf;
            this.conf = validation ? new CapacitySchedulerConfiguration(newConf, false) : this.csConfProvider.loadConfiguration(configuration);
            this.validateConf(this.conf);
            try {
                LOG.info("Re-initializing queues...");
                this.refreshMaximumAllocation(ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf));
                this.reinitializeQueues(this.conf);
            }
            catch (Throwable t) {
                this.conf = oldConf;
                this.refreshMaximumAllocation(ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf));
                throw new IOException("Failed to re-init queues : " + t.getMessage(), t);
            }
            if (!validation) {
                this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
                this.assignMultipleEnabled = this.conf.getAssignMultipleEnabled();
                this.maxAssignPerHeartbeat = this.conf.getMaxAssignPerHeartbeat();
                this.offswitchPerHeartbeatLimit = this.conf.getOffSwitchPerHeartbeatLimit();
                LOG.info("assignMultipleEnabled = " + this.assignMultipleEnabled + "\nmaxAssignPerHeartbeat = " + this.maxAssignPerHeartbeat + "\noffswitchPerHeartbeatLimit = " + this.offswitchPerHeartbeatLimit);
                super.reinitialize(newConf, rmContext);
            }
            this.maxRunningEnforcer.updateRunnabilityOnReload();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void reinitialize(Configuration newConf, RMContext rmContext) throws IOException {
        this.reinitialize(newConf, rmContext, false);
    }

    long getAsyncScheduleInterval() {
        return this.asyncScheduleInterval;
    }

    private static boolean shouldSkipNodeSchedule(FiCaSchedulerNode node, CapacityScheduler cs, boolean printVerboseLog) {
        long timeElapsedFromLastHeartbeat = Time.monotonicNow() - node.getLastHeartbeatMonotonicTime();
        if (timeElapsedFromLastHeartbeat > cs.nmHeartbeatInterval * 2L) {
            if (printVerboseLog && LOG.isDebugEnabled()) {
                LOG.debug("Skip scheduling on node because it haven't heartbeated for " + (float)timeElapsedFromLastHeartbeat / 1000.0f + " secs");
            }
            return true;
        }
        return false;
    }

    static void schedule(CapacityScheduler cs) throws InterruptedException {
        int current = 0;
        List nodes = cs.nodeTracker.getAllNodes();
        int nodeSize = nodes.size();
        if (nodeSize == 0) {
            return;
        }
        int start = random.nextInt(nodeSize);
        boolean printSkipedNodeLogging = false;
        if (Time.monotonicNow() / 1000L % 10L == 0L) {
            printSkipedNodeLogging = !printedVerboseLoggingForAsyncScheduling;
        } else {
            printedVerboseLoggingForAsyncScheduling = false;
        }
        for (FiCaSchedulerNode node : nodes) {
            if (current++ < start || CapacityScheduler.shouldSkipNodeSchedule(node, cs, printSkipedNodeLogging)) continue;
            cs.allocateContainersToNode(node.getNodeID(), false);
        }
        current = 0;
        for (FiCaSchedulerNode node : nodes) {
            if (current++ > start) break;
            if (CapacityScheduler.shouldSkipNodeSchedule(node, cs, printSkipedNodeLogging)) continue;
            cs.allocateContainersToNode(node.getNodeID(), false);
        }
        if (printSkipedNodeLogging) {
            printedVerboseLoggingForAsyncScheduling = true;
        }
        Thread.sleep(cs.getAsyncScheduleInterval());
    }

    @VisibleForTesting
    public PlacementRule getUserGroupMappingPlacementRule() throws IOException {
        this.readLock.lock();
        try {
            UserGroupMappingPlacementRule ugRule = new UserGroupMappingPlacementRule();
            ugRule.initialize(this);
            UserGroupMappingPlacementRule userGroupMappingPlacementRule = ugRule;
            return userGroupMappingPlacementRule;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PlacementRule getAppNameMappingPlacementRule() throws IOException {
        this.readLock.lock();
        try {
            AppNameMappingPlacementRule anRule = new AppNameMappingPlacementRule();
            anRule.initialize(this);
            AppNameMappingPlacementRule appNameMappingPlacementRule = anRule;
            return appNameMappingPlacementRule;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public void updatePlacementRules() throws IOException {
        ArrayList<String> placementRuleStrs = this.conf.getStringCollection("yarn.scheduler.queue-placement-rules");
        ArrayList<PlacementRule> placementRules = new ArrayList<PlacementRule>();
        Set<String> distinguishRuleSet = CapacitySchedulerConfigValidator.validatePlacementRules((Collection<String>)placementRuleStrs);
        if (distinguishRuleSet.isEmpty()) {
            distinguishRuleSet.add("user-group");
        }
        placementRuleStrs = new ArrayList<String>(distinguishRuleSet);
        Iterator iterator = placementRuleStrs.iterator();
        block12: while (iterator.hasNext()) {
            String placementRuleStr;
            switch (placementRuleStr = (String)iterator.next()) {
                case "user-group": {
                    PlacementRule ugRule = this.getUserGroupMappingPlacementRule();
                    if (null == ugRule) continue block12;
                    placementRules.add(ugRule);
                    continue block12;
                }
                case "app-name": {
                    PlacementRule anRule = this.getAppNameMappingPlacementRule();
                    if (null == anRule) continue block12;
                    placementRules.add(anRule);
                    continue block12;
                }
            }
            try {
                boolean isMappingNotEmpty;
                PlacementRule rule = PlacementFactory.getPlacementRule(placementRuleStr, this.conf);
                if (null == rule) continue;
                try {
                    isMappingNotEmpty = rule.initialize(this);
                }
                catch (IOException ie) {
                    throw new IOException(ie);
                }
                if (!isMappingNotEmpty) continue;
                placementRules.add(rule);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
        }
        this.rmContext.getQueuePlacementManager().updateRules(placementRules);
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws YarnException {
        try {
            this.queueManager.initializeQueues(conf);
            this.updatePlacementRules();
            this.workflowPriorityMappingsMgr.initialize(this);
            this.preemptionManager.refreshQueues(null, this.getRootQueue());
        }
        catch (Exception e) {
            throw new YarnException("Failed to initialize queues", (Throwable)e);
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration newConf) throws IOException {
        this.queueManager.reinitializeQueues(newConf);
        this.updatePlacementRules();
        this.workflowPriorityMappingsMgr.initialize(this);
        this.preemptionManager.refreshQueues(null, this.getRootQueue());
    }

    @Override
    public CSQueue getQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        return this.queueManager.getQueue(queueName);
    }

    public String normalizeQueueName(String name) {
        if (this.queueManager == null) {
            return name;
        }
        return this.queueManager.normalizeQueueName(name);
    }

    public boolean isAmbiguous(String queueName) {
        return this.queueManager.isAmbiguous(queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplicationOnRecovery(ApplicationId applicationId, String queueName, String user, Priority priority, ApplicationPlacementContext placementContext) {
        this.writeLock.lock();
        try {
            CSQueue queue = this.getOrCreateQueueFromPlacementContext(applicationId, user, queueName, placementContext, true);
            if (queue == null) {
                if (!this.getConfiguration().shouldAppFailFast(this.getConfig())) {
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which no longer exists after restart."));
                    return;
                }
                String queueErrorMsg = "Queue named " + queueName + " missing during application recovery. Queue removal during recovery is not presently supported by the capacity scheduler, please restart with all queues configured which were present before shutdown/restart.";
                LOG.error(FATAL, queueErrorMsg);
                throw new QueueInvalidException(queueErrorMsg);
            }
            if (!(queue instanceof LeafQueue)) {
                if (!this.getConfiguration().shouldAppFailFast(this.getConfig())) {
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which is no longer a leaf queue after restart."));
                    return;
                }
                String queueErrorMsg = "Queue named " + queueName + " is no longer a leaf queue during application recovery. Changing a leaf queue to a parent queue during recovery is not presently supported by the capacity scheduler. Please restart with leaf queues before shutdown/restart continuing as leaf queues.";
                LOG.error(FATAL, queueErrorMsg);
                throw new QueueInvalidException(queueErrorMsg);
            }
            if (queue.getState() == QueueState.STOPPED) {
                ((LeafQueue)queue).recoverDrainingState();
            }
            try {
                queue.submitApplication(applicationId, user, queueName);
            }
            catch (AccessControlException ace) {
                LOG.warn("AccessControlException received when trying to recover " + applicationId + " in queue " + queueName + " for user " + user + ". Since the app was in the queue prior to recovery, the Capacity Scheduler will recover the app anyway.", (Throwable)ace);
            }
            queue.getMetrics().submitApp(user);
            SchedulerApplication application = new SchedulerApplication(queue, user, priority);
            this.applications.put(applicationId, application);
            LOG.info("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName);
            LOG.debug(applicationId + " is recovering. Skip notifying APP_ACCEPTED");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CSQueue getOrCreateQueueFromPlacementContext(ApplicationId applicationId, String user, String queueName, ApplicationPlacementContext placementContext, boolean isRecovery) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null && placementContext != null && placementContext.hasParentQueue()) {
            try {
                return this.autoCreateLeafQueue(placementContext);
            }
            catch (IOException | YarnException e) {
                if (isRecovery) {
                    if (!this.getConfiguration().shouldAppFailFast(this.getConfig())) {
                        LOG.error("Could not auto-create leaf queue " + queueName + " due to : ", e);
                        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which could not be auto-created"));
                    }
                    String queueErrorMsg = "Queue named " + queueName + " could not be auto-created during application recovery.";
                    LOG.error(FATAL, queueErrorMsg, e);
                    throw new QueueInvalidException(queueErrorMsg);
                }
                LOG.error("Could not auto-create leaf queue due to : ", e);
                String message = "Application " + applicationId + " submission by user : " + user + " to  queue : " + queueName + " failed : " + e.getMessage();
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplication(ApplicationId applicationId, String queueName, String user, Priority priority, ApplicationPlacementContext placementContext) {
        this.writeLock.lock();
        try {
            if (this.isSystemAppsLimitReached()) {
                String message = "Maximum system application limit reached,cannot accept submission of application: " + applicationId;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            CSQueue queue = this.getOrCreateQueueFromPlacementContext(applicationId, user, queueName, placementContext, false);
            if (queue == null) {
                String message = this.isAmbiguous(queueName) ? "Application " + applicationId + " submitted by user " + user + " to ambiguous queue: " + queueName + " please use full queue path instead." : "Application " + applicationId + " submitted by user " + user + " to unknown queue: " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            if (!(queue instanceof LeafQueue)) {
                String message = "Application " + applicationId + " submitted by user : " + user + " to non-leaf queue : " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
                if (placementContext == null) {
                    String message = "Application " + applicationId + " submission by user : " + user + " to specified queue : " + queueName + "  is prohibited. Verify automatic queue mapping for user exists in " + "yarn.scheduler.capacity.queue-mappings";
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    return;
                }
                if (!queue.getParent().getQueueShortName().equals(placementContext.getParentQueue()) && !queue.getParent().getQueuePath().equals(placementContext.getParentQueue())) {
                    String message = "Auto created Leaf queue " + placementContext.getQueue() + " already exists under queue : " + queue.getParent().getQueueShortName() + ". But Queue mapping configuration " + "yarn.scheduler.capacity.queue-mappings" + " has been updated to a different parent queue : " + placementContext.getParentQueue() + " for the specified user : " + user;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    return;
                }
            }
            try {
                priority = this.workflowPriorityMappingsMgr.mapWorkflowPriorityForApp(applicationId, queue, user, priority);
            }
            catch (YarnException e) {
                String message = "Failed to submit application " + applicationId + " submitted by user " + user + " reason: " + e.getMessage();
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                this.writeLock.unlock();
                return;
            }
            try {
                queue.submitApplication(applicationId, user, queueName);
            }
            catch (AccessControlException ace) {
                LOG.info("Failed to submit application " + applicationId + " to queue " + queueName + " from user " + user, (Throwable)ace);
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, ace.toString()));
                this.writeLock.unlock();
                return;
            }
            queue.getMetrics().submitApp(user);
            SchedulerApplication application = new SchedulerApplication(queue, user, priority);
            this.applications.put(applicationId, application);
            LOG.info("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        this.writeLock.lock();
        try {
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
            if (application == null) {
                LOG.warn("Application " + applicationAttemptId.getApplicationId() + " cannot be found in scheduler.");
                return;
            }
            CSQueue queue = (CSQueue)application.getQueue();
            FiCaSchedulerApp attempt = new FiCaSchedulerApp(applicationAttemptId, application.getUser(), queue, queue.getAbstractUsersManager(), this.rmContext, application.getPriority(), isAttemptRecovering, this.activitiesManager);
            if (transferStateFromPreviousAttempt) {
                attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
            }
            application.setCurrentAppAttempt(attempt);
            attempt.setPriority(application.getPriority());
            this.maxRunningEnforcer.checkRunnabilityWithUpdate(attempt);
            this.maxRunningEnforcer.trackApp(attempt);
            queue.submitApplicationAttempt(attempt, application.getUser());
            LOG.info("Added Application Attempt " + applicationAttemptId + " to scheduler from user " + application.getUser() + " in queue " + queue.getQueuePath());
            if (isAttemptRecovering) {
                LOG.debug("{} is recovering. Skipping notifying ATTEMPT_ADDED", (Object)applicationAttemptId);
            } else {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        this.writeLock.lock();
        try {
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
            if (application == null) {
                LOG.warn("Couldn't find application " + applicationId);
                return;
            }
            CSQueue queue = (CSQueue)application.getQueue();
            if (!(queue instanceof LeafQueue)) {
                LOG.error("Cannot finish application from non-leaf queue: " + queue.getQueuePath());
            } else {
                queue.finishApplication(applicationId, application.getUser());
            }
            application.stop(finalState);
            this.applications.remove(applicationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        this.writeLock.lock();
        try {
            LOG.info("Application Attempt " + applicationAttemptId + " is done. finalState=" + (Object)((Object)rmAppAttemptFinalState));
            FiCaSchedulerApp attempt = this.getApplicationAttempt(applicationAttemptId);
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
            if (application == null || attempt == null) {
                LOG.info("Unknown application " + applicationAttemptId + " has completed!");
                return;
            }
            for (RMContainer rmContainer : attempt.getLiveContainers()) {
                if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                    LOG.info("Skip killing " + rmContainer.getContainerId());
                    continue;
                }
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
            }
            for (RMContainer rmContainer : attempt.getReservedContainers()) {
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
            }
            attempt.stop(rmAppAttemptFinalState);
            Queue queue = attempt.getQueue();
            CSQueue csQueue = (CSQueue)queue;
            if (!(csQueue instanceof LeafQueue)) {
                LOG.error("Cannot finish application from non-leaf queue: " + csQueue.getQueuePath());
            } else {
                csQueue.finishApplicationAttempt(attempt, csQueue.getQueuePath());
                this.maxRunningEnforcer.untrackApp(attempt);
                if (attempt.isRunnable()) {
                    this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void normalizeSchedulingRequests(List<SchedulingRequest> asks) {
        if (asks == null) {
            return;
        }
        Resource maxAllocation = this.getMaximumResourceCapability();
        for (SchedulingRequest ask : asks) {
            ResourceSizing sizing = ask.getResourceSizing();
            if (sizing == null || sizing.getResources() == null) continue;
            sizing.setResources(this.getNormalizedResource(sizing.getResources(), maxAllocation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<SchedulingRequest> schedulingRequests, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        Allocation allocation;
        FiCaSchedulerApp application = this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            LOG.error("Calling allocate on removed or non existent application " + applicationAttemptId.getApplicationId());
            return EMPTY_ALLOCATION;
        }
        if (!application.getApplicationAttemptId().equals((Object)applicationAttemptId)) {
            LOG.error("Calling allocate on previous or removed or non existent application attempt " + applicationAttemptId);
            return EMPTY_ALLOCATION;
        }
        this.handleContainerUpdates(application, updateRequests);
        this.releaseContainers(release, application);
        LeafQueue updateDemandForQueue = null;
        this.normalizeResourceRequests(ask);
        this.normalizeSchedulingRequests(schedulingRequests);
        application.getWriteLock().lock();
        try {
            if (application.isStopped()) {
                Allocation allocation2 = EMPTY_ALLOCATION;
                return allocation2;
            }
            if (!ask.isEmpty() || schedulingRequests != null && !schedulingRequests.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("allocate: pre-update " + applicationAttemptId + " ask size =" + ask.size());
                    application.showRequests();
                }
                if (application.updateResourceRequests(ask) || application.updateSchedulingRequests(schedulingRequests)) {
                    updateDemandForQueue = (LeafQueue)application.getQueue();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("allocate: post-update");
                    application.showRequests();
                }
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            allocation = application.getAllocation(this.getResourceCalculator(), this.getClusterResource(), this.getMinimumResourceCapability());
        }
        finally {
            application.getWriteLock().unlock();
        }
        if (updateDemandForQueue != null && !application.isWaitingForAMContainer()) {
            updateDemandForQueue.getOrderingPolicy().demandUpdated(application);
        }
        LOG.debug("Allocation for application {} : {} with cluster resource : {}", new Object[]{applicationAttemptId, allocation, this.getClusterResource()});
        return allocation;
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        queue = this.getQueue(queueName);
        if (queue == null) {
            if (this.isAmbiguous(queueName)) {
                throw new IOException("Ambiguous queue reference: " + queueName + " please use full queue path instead.");
            }
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.getRootQueue().getQueueUserAclInfo(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeUpdate(RMNode rmNode) {
        long begin = System.nanoTime();
        this.readLock.lock();
        try {
            this.setLastNodeUpdateTime(Time.now());
            super.nodeUpdate(rmNode);
        }
        finally {
            this.readLock.unlock();
        }
        if (!this.scheduleAsynchronously) {
            this.writeLock.lock();
            try {
                this.updateSchedulerHealth(this.lastNodeUpdateTime, rmNode.getNodeID(), CSAssignment.NULL_ASSIGNMENT);
                this.allocateContainersToNode(rmNode.getNodeID(), true);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        long latency = System.nanoTime() - begin;
        CapacitySchedulerMetrics.getMetrics().addNodeUpdate(latency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeAndQueueResource(RMNode nm, ResourceOption resourceOption) {
        this.writeLock.lock();
        try {
            this.updateNodeResource(nm, resourceOption);
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateLabelsOnNode(NodeId nodeId, Set<String> newLabels) {
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId);
        if (null == node) {
            return;
        }
        String newPartition = newLabels.isEmpty() ? "" : newLabels.iterator().next();
        String oldPartition = node.getPartition();
        for (RMContainer rmContainer : node.getCopiedListOfRunningContainers()) {
            FiCaSchedulerApp application = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
            if (null != application) {
                application.nodePartitionUpdated(rmContainer, oldPartition, newPartition);
                continue;
            }
            LOG.warn("There's something wrong, some RMContainers running on a node, but we cannot find SchedulerApplicationAttempt for it. Node=" + node.getNodeID() + " applicationAttemptId=" + rmContainer.getApplicationAttemptId());
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (null != reservedContainer) {
            this.killReservedContainer(reservedContainer);
        }
        node.updateLabels(newLabels);
    }

    private void updateSchedulerHealth(long now, NodeId nodeId, CSAssignment assignment) {
        NodeId updatedNodeid;
        List<AssignmentInformation.AssignmentDetails> allocations = assignment.getAssignmentInformation().getAllocationDetails();
        List<AssignmentInformation.AssignmentDetails> reservations = assignment.getAssignmentInformation().getReservationDetails();
        NodeId nodeId2 = updatedNodeid = nodeId == null ? allocations.get((int)(allocations.size() - 1)).rmContainer.getNodeId() : nodeId;
        if (!allocations.isEmpty()) {
            ContainerId allocatedContainerId = allocations.get((int)(allocations.size() - 1)).containerId;
            String allocatedQueue = allocations.get((int)(allocations.size() - 1)).queue;
            this.schedulerHealth.updateAllocation(now, updatedNodeid, allocatedContainerId, allocatedQueue);
        }
        if (!reservations.isEmpty()) {
            ContainerId reservedContainerId = reservations.get((int)(reservations.size() - 1)).containerId;
            String reservedQueue = reservations.get((int)(reservations.size() - 1)).queue;
            this.schedulerHealth.updateReservation(now, updatedNodeid, reservedContainerId, reservedQueue);
        }
        this.schedulerHealth.updateSchedulerReservationCounts(assignment.getAssignmentInformation().getNumReservations());
        this.schedulerHealth.updateSchedulerAllocationCounts(assignment.getAssignmentInformation().getNumAllocations());
        this.schedulerHealth.updateSchedulerRunDetails(now, assignment.getAssignmentInformation().getAllocated(), assignment.getAssignmentInformation().getReserved());
    }

    private boolean canAllocateMore(CSAssignment assignment, int offswitchCount, int assignedContainers) {
        if (assignment == null || Resources.equals((Resource)assignment.getResource(), (Resource)Resources.none())) {
            return false;
        }
        if (offswitchCount >= this.offswitchPerHeartbeatLimit) {
            return false;
        }
        if (assignment.getAssignmentInformation().getNumReservations() > 0) {
            return false;
        }
        return this.assignMultipleEnabled && (this.maxAssignPerHeartbeat == -1 || assignedContainers < this.maxAssignPerHeartbeat);
    }

    private CandidateNodeSet<FiCaSchedulerNode> getCandidateNodeSet(FiCaSchedulerNode node) {
        SimpleCandidateNodeSet<FiCaSchedulerNode> candidates = null;
        candidates = new SimpleCandidateNodeSet<FiCaSchedulerNode>(node);
        if (this.multiNodePlacementEnabled) {
            HashMap nodesByPartition = new HashMap();
            List nodes = this.nodeTracker.getNodesPerPartition(node.getPartition());
            if (nodes != null && !nodes.isEmpty()) {
                nodes.forEach(n -> nodesByPartition.put(n.getNodeID(), n));
                candidates = new SimpleCandidateNodeSet(nodesByPartition, node.getPartition());
            }
        }
        return candidates;
    }

    private void allocateContainersToNode(NodeId nodeId, boolean withNodeHeartbeat) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        if (null != node) {
            int offswitchCount = 0;
            int assignedContainers = 0;
            CandidateNodeSet<FiCaSchedulerNode> candidates = this.getCandidateNodeSet(node);
            CSAssignment assignment = this.allocateContainersToNode(candidates, withNodeHeartbeat);
            if (null != assignment && withNodeHeartbeat) {
                if (assignment.getType() == NodeType.OFF_SWITCH) {
                    ++offswitchCount;
                }
                if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) {
                    ++assignedContainers;
                }
                while (this.canAllocateMore(assignment, offswitchCount, assignedContainers)) {
                    assignment = this.allocateContainersToNode(candidates, true);
                    if (null != assignment && assignment.getType() == NodeType.OFF_SWITCH) {
                        ++offswitchCount;
                    }
                    if (null == assignment || !Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) continue;
                    ++assignedContainers;
                }
                if (offswitchCount >= this.offswitchPerHeartbeatLimit) {
                    LOG.debug("Assigned maximum number of off-switch containers: {}, assignments so far: {}", (Object)offswitchCount, (Object)assignment);
                }
            }
        }
    }

    private CSAssignment allocateContainerOnSingleNode(CandidateNodeSet<FiCaSchedulerNode> candidates, FiCaSchedulerNode node, boolean withNodeHeartbeat) {
        LOG.debug("Trying to schedule on node: {}, available: {}", (Object)node.getNodeName(), (Object)node.getUnallocatedResource());
        if (this.getNode(node.getNodeID()) != node) {
            LOG.error("Trying to schedule on a removed node, please double check, nodeId=" + node.getNodeID());
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, "", this.getRootQueue().getQueuePath(), ActivityState.REJECTED, "Initial check: node has been removed from scheduler");
            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
            return null;
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.allocateFromReservedContainer(node, withNodeHeartbeat, reservedContainer);
            LOG.debug("Skipping scheduling since node {} is reserved by application {}", (Object)node.getNodeID(), (Object)reservedContainer.getContainerId().getApplicationAttemptId());
            return null;
        }
        if (this.calculator.computeAvailableContainers(Resources.add((Resource)node.getUnallocatedResource(), (Resource)node.getTotalKillableResources()), this.minimumAllocation) <= 0L) {
            LOG.debug("This node " + node.getNodeID() + " doesn't have sufficient available or preemptible resource for minimum allocation");
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, "", this.getRootQueue().getQueuePath(), ActivityState.REJECTED, "Initial check: node resource is insufficient for minimum allocation");
            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, node);
            return null;
        }
        return this.allocateOrReserveNewContainers(candidates, withNodeHeartbeat);
    }

    private void allocateFromReservedContainer(FiCaSchedulerNode node, boolean withNodeHeartbeat, RMContainer reservedContainer) {
        FiCaSchedulerApp reservedApplication = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(reservedContainer.getContainerId());
        if (reservedApplication == null) {
            LOG.error("Trying to schedule for a finished app, please double check. nodeId=" + node.getNodeID() + " container=" + reservedContainer.getContainerId());
            return;
        }
        LOG.debug("Trying to fulfill reservation for application {} on node: {}", (Object)reservedApplication.getApplicationId(), (Object)node.getNodeID());
        LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
        CSAssignment assignment = queue.assignContainers(this.getClusterResource(), new SimpleCandidateNodeSet<FiCaSchedulerNode>(node), new ResourceLimits(this.labelManager.getResourceByLabel("", this.getClusterResource())), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        if (assignment.isFulfilledReservation()) {
            if (withNodeHeartbeat) {
                this.updateSchedulerHealth(this.lastNodeUpdateTime, node.getNodeID(), assignment);
            }
            this.schedulerHealth.updateSchedulerFulfilledReservationCounts(1L);
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, queue.getParent().getQueuePath(), queue.getQueuePath(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
            ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, reservedContainer.getContainerId(), AllocationState.ALLOCATED_FROM_RESERVED);
        } else if (assignment.getAssignmentInformation().getNumReservations() > 0) {
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, queue.getParent().getQueuePath(), queue.getQueuePath(), ActivityState.RE_RESERVED, ActivityDiagnosticConstant.EMPTY);
            ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, reservedContainer.getContainerId(), AllocationState.RESERVED);
        }
        assignment.setSchedulingMode(SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.submitResourceCommitRequest(this.getClusterResource(), assignment);
    }

    private CSAssignment allocateOrReserveNewContainers(CandidateNodeSet<FiCaSchedulerNode> candidates, boolean withNodeHeartbeat) {
        CSAssignment assignment = this.getRootQueue().assignContainers(this.getClusterResource(), candidates, new ResourceLimits(this.labelManager.getResourceByLabel(candidates.getPartition(), this.getClusterResource())), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        assignment.setSchedulingMode(SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.submitResourceCommitRequest(this.getClusterResource(), assignment);
        if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) {
            FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
            NodeId nodeId = null;
            if (node != null) {
                nodeId = node.getNodeID();
            }
            if (withNodeHeartbeat) {
                this.updateSchedulerHealth(this.lastNodeUpdateTime, nodeId, assignment);
            }
            return assignment;
        }
        if (StringUtils.equals((CharSequence)candidates.getPartition(), (CharSequence)"")) {
            return null;
        }
        try {
            if (this.rmContext.getNodeLabelManager().isExclusiveNodeLabel(candidates.getPartition())) {
                return null;
            }
        }
        catch (IOException e) {
            LOG.warn("Exception when trying to get exclusivity of node label=" + candidates.getPartition(), (Throwable)e);
            return null;
        }
        assignment = this.getRootQueue().assignContainers(this.getClusterResource(), candidates, new ResourceLimits(this.labelManager.getResourceByLabel("", this.getClusterResource())), SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY);
        assignment.setSchedulingMode(SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY);
        this.submitResourceCommitRequest(this.getClusterResource(), assignment);
        return assignment;
    }

    private CSAssignment allocateContainersOnMultiNodes(CandidateNodeSet<FiCaSchedulerNode> candidates) {
        if (this.getRootQueue().getQueueCapacities().getUsedCapacity(candidates.getPartition()) >= 1.0f && this.preemptionManager.getKillableResource("root", candidates.getPartition()) == Resources.none()) {
            for (FiCaSchedulerNode node : candidates.getAllNodes().values()) {
                RMContainer reservedContainer = node.getReservedContainer();
                if (reservedContainer == null) continue;
                this.allocateFromReservedContainer(node, false, reservedContainer);
            }
            LOG.debug("This partition '{}' doesn't have available or killable resource", (Object)candidates.getPartition());
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, null, "", this.getRootQueue().getQueuePath(), ActivityState.REJECTED, "Initial check: insufficient resource in partition");
            ActivitiesLogger.NODE.finishSkippedNodeAllocation(this.activitiesManager, null);
            return null;
        }
        return this.allocateOrReserveNewContainers(candidates, false);
    }

    @VisibleForTesting
    CSAssignment allocateContainersToNode(CandidateNodeSet<FiCaSchedulerNode> candidates, boolean withNodeHeartbeat) {
        CSAssignment assignment;
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return null;
        }
        long startTime = System.nanoTime();
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        if (!this.multiNodePlacementEnabled) {
            ActivitiesLogger.NODE.startNodeUpdateRecording(this.activitiesManager, node.getNodeID());
            assignment = this.allocateContainerOnSingleNode(candidates, node, withNodeHeartbeat);
            ActivitiesLogger.NODE.finishNodeUpdateRecording(this.activitiesManager, node.getNodeID(), candidates.getPartition());
        } else {
            ActivitiesLogger.NODE.startNodeUpdateRecording(this.activitiesManager, ActivitiesManager.EMPTY_NODE_ID);
            assignment = this.allocateContainersOnMultiNodes(candidates);
            ActivitiesLogger.NODE.finishNodeUpdateRecording(this.activitiesManager, ActivitiesManager.EMPTY_NODE_ID, candidates.getPartition());
        }
        if (assignment != null && assignment.getAssignmentInformation() != null && assignment.getAssignmentInformation().getNumAllocations() > 0) {
            long allocateTime = System.nanoTime() - startTime;
            CapacitySchedulerMetrics.getMetrics().addAllocate(allocateTime);
        }
        return assignment;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeAndQueueResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case NODE_LABELS_UPDATE: {
                NodeLabelsUpdateSchedulerEvent labelUpdateEvent = (NodeLabelsUpdateSchedulerEvent)event;
                this.updateNodeLabelsAndQueueResource(labelUpdateEvent);
                break;
            }
            case NODE_ATTRIBUTES_UPDATE: {
                NodeAttributesUpdateSchedulerEvent attributeUpdateEvent = (NodeAttributesUpdateSchedulerEvent)event;
                this.updateNodeAttributes(attributeUpdateEvent);
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queueName = this.resolveReservationQueueName(appAddedEvent.getQueue(), appAddedEvent.getApplicationId(), appAddedEvent.getReservationID(), appAddedEvent.getIsAppRecovering());
                if (queueName == null) break;
                if (!appAddedEvent.getIsAppRecovering()) {
                    this.addApplication(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority(), appAddedEvent.getPlacementContext());
                    break;
                }
                this.addApplicationOnRecovery(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority(), appAddedEvent.getPlacementContext());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                if (containerExpiredEvent.isIncrease()) {
                    this.rollbackContainerUpdate(containerId);
                    break;
                }
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            case RELEASE_CONTAINER: {
                RMContainer container = ((ReleaseContainerEvent)event).getContainer();
                this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released by application"), RMContainerEventType.RELEASED);
                break;
            }
            case KILL_RESERVED_CONTAINER: {
                ContainerPreemptEvent killReservedContainerEvent = (ContainerPreemptEvent)event;
                RMContainer container = killReservedContainerEvent.getContainer();
                this.killReservedContainer(container);
                break;
            }
            case MARK_CONTAINER_FOR_PREEMPTION: {
                ContainerPreemptEvent preemptContainerEvent = (ContainerPreemptEvent)event;
                ApplicationAttemptId aid = preemptContainerEvent.getAppId();
                RMContainer containerToBePreempted = preemptContainerEvent.getContainer();
                this.markContainerForPreemption(aid, containerToBePreempted);
                break;
            }
            case MARK_CONTAINER_FOR_KILLABLE: {
                ContainerPreemptEvent containerKillableEvent = (ContainerPreemptEvent)event;
                RMContainer killableContainer = containerKillableEvent.getContainer();
                this.markContainerForKillable(killableContainer);
                break;
            }
            case MARK_CONTAINER_FOR_NONKILLABLE: {
                if (!this.isLazyPreemptionEnabled) break;
                ContainerPreemptEvent cancelKillContainerEvent = (ContainerPreemptEvent)event;
                this.markContainerForNonKillable(cancelKillContainerEvent.getContainer());
                break;
            }
            case MANAGE_QUEUE: {
                QueueManagementChangeEvent queueManagementChangeEvent = (QueueManagementChangeEvent)event;
                ParentQueue parentQueue = queueManagementChangeEvent.getParentQueue();
                try {
                    List<QueueManagementChange> queueManagementChanges = queueManagementChangeEvent.getQueueManagementChanges();
                    ((ManagedParentQueue)parentQueue).validateAndApplyQueueManagementChanges(queueManagementChanges);
                }
                catch (SchedulerDynamicEditException sde) {
                    LOG.error("Queue Management Change event cannot be applied for parent queue : " + parentQueue.getQueuePath(), (Throwable)((Object)sde));
                }
                catch (IOException ioe) {
                    LOG.error("Queue Management Change event cannot be applied for parent queue : " + parentQueue.getQueuePath(), (Throwable)ioe);
                }
                break;
            }
            default: {
                LOG.error("Invalid eventtype " + event.getType() + ". Ignoring!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeAttributes(NodeAttributesUpdateSchedulerEvent attributeUpdateEvent) {
        this.writeLock.lock();
        try {
            for (Map.Entry<String, Set<NodeAttribute>> entry : attributeUpdateEvent.getUpdatedNodeToAttributes().entrySet()) {
                String hostname = entry.getKey();
                Set<NodeAttribute> attributes = entry.getValue();
                List<NodeId> nodeIds = this.nodeTracker.getNodeIdsByResourceName(hostname);
                this.updateAttributesOnNode(nodeIds, attributes);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateAttributesOnNode(List<NodeId> nodeIds, Set<NodeAttribute> attributes) {
        nodeIds.forEach(k -> {
            Object node = this.nodeTracker.getNode((NodeId)k);
            ((SchedulerNode)node).updateNodeAttributes(attributes);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeLabelsAndQueueResource(NodeLabelsUpdateSchedulerEvent labelUpdateEvent) {
        this.writeLock.lock();
        try {
            HashSet<String> updateLabels = new HashSet<String>();
            for (Map.Entry<NodeId, Set<String>> entry : labelUpdateEvent.getUpdatedNodeToLabels().entrySet()) {
                NodeId id = entry.getKey();
                Set<String> labels = entry.getValue();
                FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodeTracker.getNode(id);
                if (node != null) {
                    updateLabels.add(node.getPartition());
                }
                this.updateLabelsOnNode(id, labels);
                updateLabels.addAll(labels);
            }
            this.refreshLabelToNodeCache(updateLabels);
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void refreshLabelToNodeCache(Set<String> updateLabels) {
        Map labelMapping = this.labelManager.getLabelsToNodes(updateLabels);
        for (String label : updateLabels) {
            Set nodes = (Set)labelMapping.get(label);
            if (nodes == null) continue;
            this.nodeTracker.updateNodesPerPartition(label, nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(List<FiCaSchedulerNode> nodesToAdd) {
        this.writeLock.lock();
        try {
            for (FiCaSchedulerNode node : nodesToAdd) {
                this.nodeTracker.addNode(node);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(RMNode nodeManager) {
        this.writeLock.lock();
        try {
            FiCaSchedulerNode schedulerNode = new FiCaSchedulerNode(nodeManager, this.usePortForNodeName, nodeManager.getNodeLabels());
            this.nodeTracker.addNode(schedulerNode);
            if (this.labelManager != null) {
                this.labelManager.activateNode(nodeManager.getNodeID(), schedulerNode.getTotalResource());
            }
            if (this.rmContext.getNodeAttributesManager() != null) {
                this.rmContext.getNodeAttributesManager().refreshNodeAttributesToScheduler(schedulerNode.getNodeID());
            }
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
            LOG.info("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + clusterResource);
            if (this.scheduleAsynchronously && this.getNumClusterNodes() == 1) {
                for (AsyncScheduleThread t : this.asyncSchedulerThreads) {
                    t.beginSchedule();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(RMNode nodeInfo) {
        this.writeLock.lock();
        try {
            NodeId nodeId;
            FiCaSchedulerNode node;
            if (this.labelManager != null) {
                this.labelManager.deactivateNode(nodeInfo.getNodeID());
            }
            if ((node = (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId = nodeInfo.getNodeID())) == null) {
                LOG.error("Attempting to remove non-existent node " + nodeId);
                return;
            }
            List<RMContainer> runningContainers = node.getCopiedListOfRunningContainers();
            for (RMContainer container : runningContainers) {
                super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
                node.releaseContainer(container.getContainerId(), true);
            }
            RMContainer reservedContainer = node.getReservedContainer();
            if (reservedContainer != null) {
                super.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
            }
            this.nodeTracker.removeNode(nodeId);
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
            int numNodes = this.nodeTracker.nodeCount();
            if (this.scheduleAsynchronously && numNodes == 0) {
                for (AsyncScheduleThread t : this.asyncSchedulerThreads) {
                    t.suspendSchedule();
                }
            }
            LOG.info("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.getClusterResource());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void completedContainerInternal(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info("Container " + container + " of finished application " + appId + " completed with event " + (Object)((Object)event));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        if (null == node) {
            LOG.info("Container " + container + " of removed node " + container.getNodeId() + " completed with event " + (Object)((Object)event));
            return;
        }
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.getClusterResource(), application, node, rmContainer, containerStatus, event, null, true);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    @VisibleForTesting
    public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        return (FiCaSchedulerApp)super.getApplicationAttempt(applicationAttemptId);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId);
    }

    @Lock(value={Lock.NoLock.class})
    public List<FiCaSchedulerNode> getAllNodes() {
        return this.nodeTracker.getAllNodes();
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public void killReservedContainer(RMContainer container) {
        LOG.debug("{}:{}", (Object)SchedulerEventType.KILL_RESERVED_CONTAINER, (Object)container);
        super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container reservation no longer required."), RMContainerEventType.KILL);
    }

    @Override
    public void markContainerForPreemption(ApplicationAttemptId aid, RMContainer cont) {
        LOG.debug("{}: appAttempt:{} container:{}", new Object[]{SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION, aid, cont});
        FiCaSchedulerApp app = this.getApplicationAttempt(aid);
        if (app != null) {
            app.markContainerForPreemption(cont.getContainerId());
        }
    }

    @Override
    @VisibleForTesting
    public void killContainer(RMContainer container) {
        this.markContainerForKillable(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerForKillable(RMContainer killableContainer) {
        this.writeLock.lock();
        try {
            LOG.debug("{}: container {}", (Object)SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE, (Object)killableContainer);
            if (!this.isLazyPreemptionEnabled) {
                super.completedContainer(killableContainer, SchedulerUtils.createPreemptedContainerStatus(killableContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL);
            } else {
                FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(killableContainer.getAllocatedNode());
                FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(killableContainer.getContainerId());
                node.markContainerToKillable(killableContainer.getContainerId());
                if (null != application) {
                    String leafQueuePath = application.getCSLeafQueue().getQueuePath();
                    this.getPreemptionManager().addKillableContainer(new KillableContainer(killableContainer, node.getPartition(), leafQueuePath));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markContainerForNonKillable(RMContainer nonKillableContainer) {
        this.writeLock.lock();
        try {
            LOG.debug("{}: container {}", (Object)SchedulerEventType.MARK_CONTAINER_FOR_NONKILLABLE, (Object)nonKillableContainer);
            FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(nonKillableContainer.getAllocatedNode());
            FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(nonKillableContainer.getContainerId());
            node.markContainerToNonKillable(nonKillableContainer.getContainerId());
            if (null != application) {
                String leafQueuePath = application.getCSLeafQueue().getQueuePath();
                this.getPreemptionManager().removeKillableContainer(new KillableContainer(nonKillableContainer, node.getPartition(), leafQueuePath));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queueName.startsWith("root.")) {
            while (queue == null) {
                int sepIndex = queueName.lastIndexOf(".");
                String parentName = queueName.substring(0, sepIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queue {} does not exist, checking parent {}", (Object)queueName, (Object)parentName);
                }
                queueName = parentName;
                queue = this.queueManager.getQueue(queueName);
            }
        }
        if (queue == null) {
            LOG.debug("ACL not found for queue access-type {} for queue {}", (Object)acl, (Object)queueName);
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    public boolean isSystemAppsLimitReached() {
        return this.getRootQueue().getNumApplications() >= this.conf.getMaximumSystemApplications();
    }

    private String getDefaultReservationQueueName(String planQueueName) {
        return planQueueName + "-default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveReservationQueueName(String queueName, ApplicationId applicationId, ReservationId reservationID, boolean isRecovering) {
        this.readLock.lock();
        try {
            CSQueue queue = this.getQueue(queueName);
            if (queue == null || !(queue instanceof PlanQueue)) {
                String string = queueName;
                return string;
            }
            if (reservationID != null) {
                String resQName = reservationID.toString();
                queue = this.getQueue(resQName);
                if (queue == null) {
                    if (isRecovering && this.conf.getMoveOnExpiry(this.getQueue(queueName).getQueuePath())) {
                        String string = this.getDefaultReservationQueueName(queueName);
                        return string;
                    }
                    String message = "Application " + applicationId + " submitted to a reservation which is not currently active: " + resQName;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    String string = null;
                    return string;
                }
                if (!queue.getParent().getQueuePath().equals(queueName)) {
                    String message = "Application: " + applicationId + " submitted to a reservation " + resQName + " which does not belong to the specified queue: " + queueName;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    String string = null;
                    return string;
                }
                queueName = resQName;
            } else {
                queueName = this.getDefaultReservationQueueName(queueName);
            }
            String string = queueName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueue(String queueName) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            LOG.info("Removing queue: " + queueName);
            CSQueue q = this.getQueue(queueName);
            if (!AbstractAutoCreatedLeafQueue.class.isAssignableFrom(q.getClass())) {
                throw new SchedulerDynamicEditException("The queue that we are asked to remove (" + queueName + ") is not a AutoCreatedLeafQueue or ReservationQueue");
            }
            AbstractAutoCreatedLeafQueue disposableLeafQueue = (AbstractAutoCreatedLeafQueue)q;
            if (disposableLeafQueue.getNumApplications() > 0) {
                throw new SchedulerDynamicEditException("The queue " + queueName + " is not empty " + disposableLeafQueue.getApplications().size() + " active apps " + disposableLeafQueue.getPendingApplications().size() + " pending apps");
            }
            ((AbstractManagedParentQueue)disposableLeafQueue.getParent()).removeChildQueue(q);
            this.queueManager.removeQueue(queueName);
            LOG.info("Removal of AutoCreatedLeafQueue " + queueName + " has succeeded");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueue(Queue queue) throws SchedulerDynamicEditException, IOException {
        this.writeLock.lock();
        try {
            if (queue == null) {
                throw new SchedulerDynamicEditException("Queue specified is null. Should be an implementation of AbstractAutoCreatedLeafQueue");
            }
            if (!AbstractAutoCreatedLeafQueue.class.isAssignableFrom(queue.getClass())) {
                throw new SchedulerDynamicEditException("Queue is not an implementation of AbstractAutoCreatedLeafQueue : " + queue.getClass());
            }
            AbstractAutoCreatedLeafQueue newQueue = (AbstractAutoCreatedLeafQueue)queue;
            if (newQueue.getParent() == null || !AbstractManagedParentQueue.class.isAssignableFrom(newQueue.getParent().getClass())) {
                throw new SchedulerDynamicEditException("ParentQueue for " + newQueue + " is not properly set (should be set and be a PlanQueue or ManagedParentQueue)");
            }
            AbstractManagedParentQueue parent = (AbstractManagedParentQueue)newQueue.getParent();
            String queuePath = newQueue.getQueuePath();
            parent.addChildQueue(newQueue);
            this.queueManager.addQueue(queuePath, newQueue);
            LOG.info("Creation of AutoCreatedLeafQueue " + newQueue + " succeeded");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntitlement(String inQueue, QueueEntitlement entitlement) throws YarnException {
        this.writeLock.lock();
        try {
            LeafQueue queue = this.queueManager.getAndCheckLeafQueue(inQueue);
            AbstractManagedParentQueue parent = (AbstractManagedParentQueue)queue.getParent();
            if (!AbstractAutoCreatedLeafQueue.class.isAssignableFrom(queue.getClass())) {
                throw new SchedulerDynamicEditException("Entitlement can not be modified dynamically since queue " + inQueue + " is not a AutoCreatedLeafQueue");
            }
            if (parent == null || !AbstractManagedParentQueue.class.isAssignableFrom(parent.getClass())) {
                throw new SchedulerDynamicEditException("The parent of AutoCreatedLeafQueue " + inQueue + " must be a PlanQueue/ManagedParentQueue");
            }
            AbstractAutoCreatedLeafQueue newQueue = (AbstractAutoCreatedLeafQueue)queue;
            parent.validateQueueEntitlementChange(newQueue, entitlement);
            newQueue.setEntitlement(entitlement);
            LOG.info("Set entitlement for AutoCreatedLeafQueue " + inQueue + "  to " + queue.getCapacity() + " request was (" + entitlement.getCapacity() + ")");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveApplication(ApplicationId appId, String targetQueueName) throws YarnException {
        this.writeLock.lock();
        try {
            SchedulerApplication application = (SchedulerApplication)this.applications.get(appId);
            if (application == null) {
                throw new YarnException("App to be moved " + appId + " not found.");
            }
            String sourceQueueName = application.getQueue().getQueueName();
            LeafQueue source = this.queueManager.getAndCheckLeafQueue(sourceQueueName);
            String destQueueName = this.handleMoveToPlanQueue(targetQueueName);
            LeafQueue dest = this.queueManager.getAndCheckLeafQueue(destQueueName);
            String user = application.getUser();
            try {
                dest.submitApplication(appId, user, destQueueName);
            }
            catch (AccessControlException e) {
                throw new YarnException((Throwable)e);
            }
            FiCaSchedulerApp app = (FiCaSchedulerApp)application.getCurrentAppAttempt();
            if (app != null) {
                for (RMContainer rmContainer : app.getLiveContainers()) {
                    source.detachContainer(this.getClusterResource(), app, rmContainer);
                    dest.attachContainer(this.getClusterResource(), app, rmContainer);
                }
                for (RMContainer rmContainer : app.getReservedContainers()) {
                    source.detachContainer(this.getClusterResource(), app, rmContainer);
                    dest.attachContainer(this.getClusterResource(), app, rmContainer);
                }
                if (!app.isStopped()) {
                    source.finishApplicationAttempt(app, sourceQueueName);
                    dest.submitApplicationAttempt(app, user, true);
                }
                app.move(dest);
            }
            source.appFinished();
            source.getParent().finishApplication(appId, user);
            application.setQueue(dest);
            LOG.info("App: " + appId + " successfully moved from " + sourceQueueName + " to: " + destQueueName);
            String string = targetQueueName;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preValidateMoveApplication(ApplicationId appId, String newQueue) throws YarnException {
        this.writeLock.lock();
        try {
            SchedulerApplication application = (SchedulerApplication)this.applications.get(appId);
            if (application == null) {
                throw new YarnException("App to be moved " + appId + " not found.");
            }
            Queue queue = application.getQueue();
            String sourceQueueName = queue instanceof CSQueue ? ((CSQueue)queue).getQueuePath() : queue.getQueueName();
            this.queueManager.getAndCheckLeafQueue(sourceQueueName);
            String destQueueName = this.handleMoveToPlanQueue(newQueue);
            LeafQueue dest = this.queueManager.getAndCheckLeafQueue(destQueueName);
            String user = application.getUser();
            FiCaSchedulerApp appAttempt = this.getApplicationAttempt(ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0));
            if (null != appAttempt) {
                this.checkQueuePartition(appAttempt, dest);
            }
            try {
                dest.validateSubmitApplication(appId, user, destQueueName);
            }
            catch (AccessControlException e) {
                throw new YarnException((Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkQueuePartition(FiCaSchedulerApp app, LeafQueue dest) throws YarnException {
        if (!YarnConfiguration.areNodeLabelsEnabled((Configuration)this.conf)) {
            return;
        }
        Set<String> targetqueuelabels = dest.getAccessibleNodeLabels();
        AppSchedulingInfo schedulingInfo = app.getAppSchedulingInfo();
        Set<String> appLabelexpressions = schedulingInfo.getRequestedPartitions();
        appLabelexpressions.remove("");
        HashSet<String> nonAccessiblelabels = new HashSet<String>();
        for (String label : appLabelexpressions) {
            if (SchedulerUtils.checkQueueLabelExpression(targetqueuelabels, label, null)) continue;
            nonAccessiblelabels.add(label);
        }
        if (nonAccessiblelabels.size() > 0) {
            throw new YarnException("Specified queue=" + dest.getQueuePath() + " can't satisfy following apps label expressions =" + nonAccessiblelabels + " accessible node labels =" + targetqueuelabels);
        }
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        if (this.calculator.getClass().getName().equals(DefaultResourceCalculator.class.getName())) {
            return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
        }
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU);
    }

    @Override
    public Resource getMaximumResourceCapability(String queueName) {
        if (queueName == null || queueName.isEmpty()) {
            return this.getMaximumResourceCapability();
        }
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (this.isAmbiguous(queueName)) {
                LOG.error("Ambiguous queue reference: " + queueName + " please use full queue path instead.");
            } else {
                LOG.error("Unknown queue: " + queueName);
            }
            return this.getMaximumResourceCapability();
        }
        if (!(queue instanceof LeafQueue)) {
            LOG.error("queue " + queueName + " is not an leaf queue");
            return this.getMaximumResourceCapability();
        }
        Resource queueMaxAllocation = ((LeafQueue)queue).getMaximumAllocation();
        Resource clusterMaxAllocationConsiderNodeMax = this.getMaximumResourceCapability();
        return Resources.componentwiseMin((Resource)queueMaxAllocation, (Resource)clusterMaxAllocationConsiderNodeMax);
    }

    private String handleMoveToPlanQueue(String targetQueueName) {
        CSQueue dest = this.getQueue(targetQueueName);
        if (dest != null && dest instanceof PlanQueue) {
            targetQueueName = targetQueueName + "-default";
        }
        return targetQueueName;
    }

    @Override
    public Set<String> getPlanQueues() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, CSQueue> l : this.queueManager.getQueues().entrySet()) {
            if (!(l.getValue() instanceof PlanQueue)) continue;
            ret.add(l.getKey());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Priority checkAndGetApplicationPriority(Priority priorityRequestedByApp, UserGroupInformation user, String queuePath, ApplicationId applicationId) throws YarnException {
        this.readLock.lock();
        try {
            Priority appPriority = priorityRequestedByApp;
            if (null == appPriority) {
                appPriority = this.appPriorityACLManager.getDefaultPriority(this.normalizeQueueName(queuePath), user);
                if (null == appPriority) {
                    appPriority = this.queueManager.getDefaultPriorityForQueue(this.normalizeQueueName(queuePath));
                }
                LOG.info("Application '" + applicationId + "' is submitted without priority hence considering default queue/cluster priority: " + appPriority.getPriority());
            }
            if (appPriority.getPriority() > this.getMaxClusterLevelAppPriority().getPriority()) {
                appPriority = Priority.newInstance((int)this.getMaxClusterLevelAppPriority().getPriority());
            }
            if (!this.appPriorityACLManager.checkAccess(user, this.normalizeQueueName(queuePath), appPriority)) {
                throw new YarnException((Throwable)new AccessControlException("User " + user + " does not have permission to submit/update " + applicationId + " for " + appPriority));
            }
            LOG.info("Priority '" + appPriority.getPriority() + "' is acceptable in queue : " + queuePath + " for application: " + applicationId);
            Priority priority = appPriority;
            return priority;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Priority updateApplicationPriority(Priority newPriority, ApplicationId applicationId, SettableFuture<Object> future, UserGroupInformation user) throws YarnException {
        this.writeLock.lock();
        try {
            Priority appPriority = null;
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
            if (application == null) {
                throw new YarnException("Application '" + applicationId + "' is not present, hence could not change priority.");
            }
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
            appPriority = this.checkAndGetApplicationPriority(newPriority, user, rmApp.getQueue(), applicationId);
            if (application.getPriority().equals((Object)appPriority)) {
                future.set(null);
                Priority priority = appPriority;
                return priority;
            }
            rmApp.getApplicationSubmissionContext().setPriority(appPriority);
            ApplicationStateData appState = ApplicationStateData.newInstance(rmApp.getSubmitTime(), rmApp.getStartTime(), rmApp.getApplicationSubmissionContext(), rmApp.getUser(), rmApp.getRealUser(), rmApp.getCallerContext());
            appState.setApplicationTimeouts(rmApp.getApplicationTimeouts());
            appState.setLaunchTime(rmApp.getLaunchTime());
            this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, future);
            LeafQueue queue = (LeafQueue)this.getQueue(rmApp.getQueue());
            queue.updateApplicationPriority(application, appPriority);
            LOG.info("Priority '" + appPriority + "' is updated in queue :" + rmApp.getQueue() + " for application: " + applicationId + " for the user: " + rmApp.getUser());
            Priority priority = appPriority;
            return priority;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PreemptionManager getPreemptionManager() {
        return this.preemptionManager;
    }

    @Override
    public ResourceUsage getClusterResourceUsage() {
        return this.getRootQueue().getQueueResourceUsage();
    }

    private SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> getSchedulerContainer(RMContainer rmContainer, boolean allocated) {
        if (null == rmContainer) {
            return null;
        }
        FiCaSchedulerApp app = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
        if (null == app) {
            return null;
        }
        NodeId nodeId = rmContainer.getState() == RMContainerState.RESERVED ? rmContainer.getReservedNode() : rmContainer.getNodeId();
        FiCaSchedulerNode node = this.getNode(nodeId);
        if (null == node) {
            return null;
        }
        return new SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>(app, node, rmContainer, node.getPartition(), allocated);
    }

    private List<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>> getSchedulerContainersToRelease(CSAssignment csAssignment) {
        ArrayList<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>> list = null;
        if (csAssignment.getContainersToKill() != null && !csAssignment.getContainersToKill().isEmpty()) {
            list = new ArrayList<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>>();
            for (RMContainer rmContainer : csAssignment.getContainersToKill()) {
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = this.getSchedulerContainer(rmContainer, false);
                if (schedulerContainer == null) continue;
                list.add(schedulerContainer);
            }
        }
        if (csAssignment.getExcessReservation() != null) {
            SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer;
            if (null == list) {
                list = new ArrayList();
            }
            if ((schedulerContainer = this.getSchedulerContainer(csAssignment.getExcessReservation(), false)) != null) {
                list.add(schedulerContainer);
            }
        }
        if (list != null && list.isEmpty()) {
            list = null;
        }
        return list;
    }

    @VisibleForTesting
    public void submitResourceCommitRequest(Resource cluster, CSAssignment csAssignment) {
        ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request = this.createResourceCommitRequest(csAssignment);
        if (null == request) {
            return;
        }
        if (this.scheduleAsynchronously) {
            this.resourceCommitterService.addNewCommitRequest(request);
        } else {
            this.tryCommit(cluster, request, true);
        }
    }

    @Override
    public boolean attemptAllocationOnNode(SchedulerApplicationAttempt appAttempt, SchedulingRequest schedulingRequest, SchedulerNode schedulerNode) {
        if (schedulingRequest.getResourceSizing() != null) {
            if (schedulingRequest.getResourceSizing().getNumAllocations() > 1) {
                LOG.warn("The SchedulingRequest has requested more than 1 allocation, but only 1 will be attempted !!");
            }
            if (!appAttempt.isStopped()) {
                ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> resourceCommitRequest = this.createResourceCommitRequest(appAttempt, schedulingRequest, schedulerNode);
                try {
                    if (!PlacementConstraintsUtil.canSatisfyConstraints(appAttempt.getApplicationId(), schedulingRequest, schedulerNode, this.rmContext.getPlacementConstraintManager(), this.rmContext.getAllocationTagsManager())) {
                        LOG.info("Failed to allocate container for application " + appAttempt.getApplicationId() + " on node " + schedulerNode.getNodeName() + " because this allocation violates the placement constraint.");
                        return false;
                    }
                }
                catch (InvalidAllocationTagsQueryException e) {
                    LOG.warn("Unable to allocate container", (Throwable)((Object)e));
                    return false;
                }
                return this.tryCommit(this.getClusterResource(), resourceCommitRequest, false);
            }
        }
        return false;
    }

    private ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> createResourceCommitRequest(SchedulerApplicationAttempt appAttempt, SchedulingRequest schedulingRequest, SchedulerNode schedulerNode) {
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocated = null;
        Resource resource = schedulingRequest.getResourceSizing().getResources();
        if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)resource, (Resource)Resources.none())) {
            ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)appAttempt.getApplicationAttemptId(), (long)appAttempt.getAppSchedulingInfo().getNewContainerId());
            Container container = BuilderUtils.newContainer((ContainerId)cId, (NodeId)schedulerNode.getNodeID(), (String)schedulerNode.getHttpAddress(), (Resource)resource, (Priority)schedulingRequest.getPriority(), null, (ExecutionType)ExecutionType.GUARANTEED, (long)schedulingRequest.getAllocationRequestId());
            RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), appAttempt.getApplicationAttemptId(), container.getNodeId(), appAttempt.getUser(), this.rmContext, false);
            rmContainer.setAllocationTags(new HashSet<String>(schedulingRequest.getAllocationTags()));
            SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = this.getSchedulerContainer(rmContainer, true);
            allocated = schedulerContainer == null ? null : new ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode>(schedulerContainer, null, null, NodeType.NODE_LOCAL, NodeType.NODE_LOCAL, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, resource);
        }
        if (null != allocated) {
            ArrayList allocationsList = new ArrayList();
            allocationsList.add(allocated);
            return new ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>(allocationsList, null, null);
        }
        return null;
    }

    @VisibleForTesting
    public ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> createResourceCommitRequest(CSAssignment csAssignment) {
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocated = null;
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> reserved = null;
        List released = null;
        if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)csAssignment.getResource(), (Resource)Resources.none())) {
            List<AssignmentInformation.AssignmentDetails> reservation;
            List<AssignmentInformation.AssignmentDetails> allocations = csAssignment.getAssignmentInformation().getAllocationDetails();
            if (!allocations.isEmpty()) {
                RMContainer rmContainer = allocations.get((int)0).rmContainer;
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = this.getSchedulerContainer(rmContainer, true);
                if (schedulerContainer == null) {
                    allocated = null;
                    FiCaSchedulerApp app = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
                    if (app != null) {
                        app.decUnconfirmedRes(rmContainer.getAllocatedResource());
                    }
                } else {
                    allocated = new ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode>(schedulerContainer, this.getSchedulerContainersToRelease(csAssignment), this.getSchedulerContainer(csAssignment.getFulfilledReservedContainer(), false), csAssignment.getType(), csAssignment.getRequestLocalityType(), csAssignment.getSchedulingMode() != null ? csAssignment.getSchedulingMode() : SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, csAssignment.getResource());
                }
            }
            if (!(reservation = csAssignment.getAssignmentInformation().getReservationDetails()).isEmpty()) {
                RMContainer rmContainer = reservation.get((int)0).rmContainer;
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = this.getSchedulerContainer(rmContainer, false);
                reserved = schedulerContainer == null ? null : new ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode>(schedulerContainer, this.getSchedulerContainersToRelease(csAssignment), this.getSchedulerContainer(csAssignment.getFulfilledReservedContainer(), false), csAssignment.getType(), csAssignment.getRequestLocalityType(), csAssignment.getSchedulingMode() != null ? csAssignment.getSchedulingMode() : SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, csAssignment.getResource());
            }
        }
        if (null == allocated && null == reserved) {
            released = this.getSchedulerContainersToRelease(csAssignment);
        }
        if (null != allocated || null != reserved || null != released && !released.isEmpty()) {
            ArrayList allocationsList = null;
            if (allocated != null) {
                allocationsList = new ArrayList();
                allocationsList.add(allocated);
            }
            ArrayList reservationsList = null;
            if (reserved != null) {
                reservationsList = new ArrayList();
                reservationsList.add(reserved);
            }
            return new ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>(allocationsList, reservationsList, released);
        }
        return null;
    }

    @Override
    public boolean tryCommit(Resource cluster, ResourceCommitRequest r, boolean updatePending) {
        FiCaSchedulerApp app;
        boolean updateUnconfirmedAllocatedResource;
        long commitStart = System.nanoTime();
        ResourceCommitRequest request = r;
        ApplicationAttemptId attemptId = null;
        boolean bl = updateUnconfirmedAllocatedResource = request.getContainersToAllocate() != null && !request.getContainersToAllocate().isEmpty();
        if (request.anythingAllocatedOrReserved()) {
            ContainerAllocationProposal c = request.getFirstAllocatedOrReservedContainer();
            attemptId = ((FiCaSchedulerApp)c.getAllocatedOrReservedContainer().getSchedulerApplicationAttempt()).getApplicationAttemptId();
        } else if (!request.getContainersToRelease().isEmpty()) {
            attemptId = ((FiCaSchedulerApp)request.getContainersToRelease().get(0).getSchedulerApplicationAttempt()).getApplicationAttemptId();
        }
        LOG.debug("Try to commit allocation proposal={}", (Object)request);
        boolean isSuccess = false;
        if (attemptId != null && (app = this.getApplicationAttempt(attemptId)) != null && attemptId.equals((Object)app.getApplicationAttemptId())) {
            if (app.accept(cluster, request, updatePending) && app.apply(cluster, request, updatePending)) {
                long commitSuccess = System.nanoTime() - commitStart;
                CapacitySchedulerMetrics.getMetrics().addCommitSuccess(commitSuccess);
                LOG.info("Allocation proposal accepted");
                isSuccess = true;
            } else {
                long commitFailed = System.nanoTime() - commitStart;
                CapacitySchedulerMetrics.getMetrics().addCommitFailure(commitFailed);
                LOG.info("Failed to accept allocation proposal");
            }
            LOG.debug("Allocation proposal accepted={}, proposal={}", (Object)isSuccess, (Object)request);
            if (updateUnconfirmedAllocatedResource) {
                app.decUnconfirmedRes(request.getTotalAllocatedResource());
            }
        }
        return isSuccess;
    }

    public int getAsyncSchedulingPendingBacklogs() {
        if (this.scheduleAsynchronously) {
            return this.resourceCommitterService.getPendingBacklogs();
        }
        return 0;
    }

    @Override
    public CapacitySchedulerQueueManager getCapacitySchedulerQueueManager() {
        return this.queueManager;
    }

    public WorkflowPriorityMappingsManager getWorkflowPriorityMappingsManager() {
        return this.workflowPriorityMappingsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveReservedContainer(RMContainer toBeMovedContainer, FiCaSchedulerNode targetNode) {
        this.writeLock.lock();
        try {
            LOG.debug("Trying to move container={} to node={}", (Object)toBeMovedContainer, (Object)targetNode.getNodeID());
            FiCaSchedulerNode sourceNode = this.getNode(toBeMovedContainer.getNodeId());
            if (null == sourceNode) {
                LOG.debug("Failed to move reservation, cannot find source node={}", (Object)toBeMovedContainer.getNodeId());
                boolean bl = false;
                return bl;
            }
            if (this.getNode(targetNode.getNodeID()) != targetNode) {
                LOG.debug("Failed to move reservation, node updated or removed, moving cancelled.");
                boolean bl = false;
                return bl;
            }
            if (targetNode.getReservedContainer() != null) {
                LOG.debug("Target node's reservation status changed, moving cancelled.");
                boolean bl = false;
                return bl;
            }
            FiCaSchedulerApp app = this.getApplicationAttempt(toBeMovedContainer.getApplicationAttemptId());
            if (null == app) {
                LOG.debug("Cannot find to-be-moved container's application={}", (Object)toBeMovedContainer.getApplicationAttemptId());
                boolean bl = false;
                return bl;
            }
            boolean bl = app.moveReservation(toBeMovedContainer, sourceNode, targetNode);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkAndGetApplicationLifetime(String queueName, long lifetimeRequestedByApp) {
        this.readLock.lock();
        try {
            CSQueue queue = this.getQueue(queueName);
            if (queue == null || !(queue instanceof LeafQueue)) {
                long l = lifetimeRequestedByApp;
                return l;
            }
            long defaultApplicationLifetime = ((LeafQueue)queue).getDefaultApplicationLifetime();
            long maximumApplicationLifetime = ((LeafQueue)queue).getMaximumApplicationLifetime();
            if (maximumApplicationLifetime <= 0L) {
                long l = lifetimeRequestedByApp <= 0L ? defaultApplicationLifetime : lifetimeRequestedByApp;
                return l;
            }
            if (lifetimeRequestedByApp <= 0L) {
                long l = defaultApplicationLifetime;
                return l;
            }
            if (lifetimeRequestedByApp > maximumApplicationLifetime) {
                long l = maximumApplicationLifetime;
                return l;
            }
            long l = lifetimeRequestedByApp;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getMaximumApplicationLifetime(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null || !(queue instanceof LeafQueue)) {
            if (this.isAmbiguous(queueName)) {
                LOG.error("Ambiguous queue reference: " + queueName + " please use full queue path instead.");
            } else {
                LOG.error("Unknown queue: " + queueName);
            }
            return -1L;
        }
        return ((LeafQueue)queue).getMaximumApplicationLifetime();
    }

    @Override
    public boolean isConfigurationMutable() {
        return this.csConfProvider instanceof MutableConfigurationProvider;
    }

    @Override
    public MutableConfigurationProvider getMutableConfProvider() {
        if (this.isConfigurationMutable()) {
            return (MutableConfigurationProvider)((Object)this.csConfProvider);
        }
        return null;
    }

    private LeafQueue autoCreateLeafQueue(ApplicationPlacementContext placementContext) throws IOException, YarnException {
        CSQueue parentQueue;
        AutoCreatedLeafQueue autoCreatedLeafQueue = null;
        String leafQueueName = placementContext.getQueue();
        String parentQueueName = placementContext.getParentQueue();
        if (!StringUtils.isEmpty((CharSequence)parentQueueName)) {
            parentQueue = this.getQueue(parentQueueName);
            if (parentQueue == null || !this.conf.isAutoCreateChildQueueEnabled(parentQueue.getQueuePath())) {
                throw new SchedulerDynamicEditException("Could not auto-create leaf queue for " + leafQueueName + ". Queue mapping specifies an invalid parent queue which does not exist " + parentQueueName);
            }
        } else {
            throw new SchedulerDynamicEditException("Could not auto-create leaf queue for " + leafQueueName + ". Queue mapping does not specify which parent queue it needs to be created under.");
        }
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        autoCreatedLeafQueue = new AutoCreatedLeafQueue(this, leafQueueName, autoCreateEnabledParentQueue);
        this.addQueue(autoCreatedLeafQueue);
        return autoCreatedLeafQueue;
    }

    @Override
    public void resetSchedulerMetrics() {
        CapacitySchedulerMetrics.destroy();
    }

    public boolean isMultiNodePlacementEnabled() {
        return this.multiNodePlacementEnabled;
    }

    public int getNumAsyncSchedulerThreads() {
        return this.asyncSchedulerThreads == null ? 0 : this.asyncSchedulerThreads.size();
    }

    @VisibleForTesting
    public void setMaxRunningAppsEnforcer(CSMaxRunningAppsEnforcer enforcer) {
        this.maxRunningEnforcer = enforcer;
    }

    @Override
    public boolean placementConstraintEnabled() {
        return true;
    }

    @VisibleForTesting
    public void setQueueManager(CapacitySchedulerQueueManager qm) {
        this.queueManager = qm;
    }

    static class ResourceCommitterService
    extends Thread {
        private final CapacityScheduler cs;
        private BlockingQueue<ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>> backlogs = new LinkedBlockingQueue<ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>>();

        public ResourceCommitterService(CapacityScheduler cs) {
            this.cs = cs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request = this.backlogs.take();
                    this.cs.writeLock.lock();
                    try {
                        this.cs.tryCommit(this.cs.getClusterResource(), request, true);
                    }
                    finally {
                        this.cs.writeLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error(e.toString());
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("ResourceCommitterService exited!");
        }

        public void addNewCommitRequest(ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> proposal) {
            this.backlogs.add(proposal);
        }

        public int getPendingBacklogs() {
            return this.backlogs.size();
        }
    }

    static class AsyncScheduleThread
    extends Thread {
        private final CapacityScheduler cs;
        private AtomicBoolean runSchedules = new AtomicBoolean(false);

        public AsyncScheduleThread(CapacityScheduler cs) {
            this.cs = cs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int debuggingLogCounter = 0;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.runSchedules.get()) {
                        Thread.sleep(100L);
                        continue;
                    }
                    if ((long)this.cs.getAsyncSchedulingPendingBacklogs() > this.cs.asyncMaxPendingBacklogs) {
                        Thread.sleep(1L);
                        continue;
                    }
                    CapacityScheduler.schedule(this.cs);
                    if (!LOG.isDebugEnabled() || debuggingLogCounter++ <= 10000) continue;
                    debuggingLogCounter = 0;
                    LOG.debug("AsyncScheduleThread[" + this.getName() + "] is running!");
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info("AsyncScheduleThread[" + this.getName() + "] exited!");
        }

        public void beginSchedule() {
            this.runSchedules.set(true);
        }

        public void suspendSchedule() {
            this.runSchedules.set(false);
        }
    }
}

