/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.AllocationExpirationInfo;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeFinishedContainersPulledByAMEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRMNodeTransitions {
    RMNodeImpl node;
    private RMContext rmContext;
    private YarnScheduler scheduler;
    private SchedulerEventType eventType;
    private List<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
    private NodesListManagerEvent nodesListManagerEvent = null;
    private List<NodeState> nodesListManagerEventsNodeStateSequence = new LinkedList<NodeState>();

    @Before
    public void setUp() throws Exception {
        InlineDispatcher rmDispatcher = new InlineDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)rmDispatcher, (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class), null, null, (DelegationTokenRenewer)Mockito.mock(DelegationTokenRenewer.class), null, null, null, null, null);
        NodesListManager nodesListManager = (NodesListManager)Mockito.mock(NodesListManager.class);
        HostsFileReader reader = (HostsFileReader)Mockito.mock(HostsFileReader.class);
        Mockito.when((Object)nodesListManager.getHostsReader()).thenReturn((Object)reader);
        ((RMContextImpl)this.rmContext).setNodesListManager(nodesListManager);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ((YarnScheduler)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                SchedulerEvent event = (SchedulerEvent)invocation.getArguments()[0];
                TestRMNodeTransitions.this.eventType = (SchedulerEventType)event.getType();
                if (TestRMNodeTransitions.this.eventType == SchedulerEventType.NODE_UPDATE) {
                    List lastestContainersInfoList = ((NodeUpdateSchedulerEvent)event).getRMNode().pullContainerUpdates();
                    for (UpdatedContainerInfo lastestContainersInfo : lastestContainersInfoList) {
                        TestRMNodeTransitions.this.completedContainers.addAll(lastestContainersInfo.getCompletedContainers());
                    }
                }
                return null;
            }
        }).when((Object)this.scheduler)).handle((Event)ArgumentMatchers.any(SchedulerEvent.class));
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher());
        rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)new TestNodeListManagerEventDispatcher());
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        this.node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null, null);
        this.nodesListManagerEvent = null;
        this.nodesListManagerEventsNodeStateSequence.clear();
    }

    @After
    public void tearDown() throws Exception {
    }

    private RMNodeStatusEvent getMockRMNodeStatusEvent(List<ContainerStatus> containerStatus) {
        NodeHealthStatus healthStatus = (NodeHealthStatus)Mockito.mock(NodeHealthStatus.class);
        Boolean yes = new Boolean(true);
        ((NodeHealthStatus)Mockito.doReturn((Object)yes).when((Object)healthStatus)).getIsNodeHealthy();
        RMNodeStatusEvent event = (RMNodeStatusEvent)Mockito.mock(RMNodeStatusEvent.class);
        ((RMNodeStatusEvent)Mockito.doReturn((Object)healthStatus).when((Object)event)).getNodeHealthStatus();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)RMNodeEventType.STATUS_UPDATE).when((Object)event)).getType();
        if (containerStatus != null) {
            ((RMNodeStatusEvent)Mockito.doReturn(containerStatus).when((Object)event)).getContainers();
        }
        return event;
    }

    private RMNodeStatusEvent getMockRMNodeStatusEventWithRunningApps() {
        NodeHealthStatus healthStatus = (NodeHealthStatus)Mockito.mock(NodeHealthStatus.class);
        Boolean yes = new Boolean(true);
        ((NodeHealthStatus)Mockito.doReturn((Object)yes).when((Object)healthStatus)).getIsNodeHealthy();
        RMNodeStatusEvent event = (RMNodeStatusEvent)Mockito.mock(RMNodeStatusEvent.class);
        ((RMNodeStatusEvent)Mockito.doReturn((Object)healthStatus).when((Object)event)).getNodeHealthStatus();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)RMNodeEventType.STATUS_UPDATE).when((Object)event)).getType();
        ((RMNodeStatusEvent)Mockito.doReturn(this.getAppIdList()).when((Object)event)).getKeepAliveAppIds();
        return event;
    }

    private List<ApplicationId> getAppIdList() {
        ArrayList<ApplicationId> appIdList = new ArrayList<ApplicationId>();
        appIdList.add(BuilderUtils.newApplicationId((long)0L, (int)0));
        return appIdList;
    }

    private List<ContainerId> getContainerIdList() {
        ArrayList<ContainerId> containerIdList = new ArrayList<ContainerId>();
        containerIdList.add(BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L));
        return containerIdList;
    }

    private RMNodeStatusEvent getMockRMNodeStatusEventWithoutRunningApps() {
        NodeHealthStatus healthStatus = (NodeHealthStatus)Mockito.mock(NodeHealthStatus.class);
        Boolean yes = new Boolean(true);
        ((NodeHealthStatus)Mockito.doReturn((Object)yes).when((Object)healthStatus)).getIsNodeHealthy();
        RMNodeStatusEvent event = (RMNodeStatusEvent)Mockito.mock(RMNodeStatusEvent.class);
        ((RMNodeStatusEvent)Mockito.doReturn((Object)healthStatus).when((Object)event)).getNodeHealthStatus();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)RMNodeEventType.STATUS_UPDATE).when((Object)event)).getType();
        ((RMNodeStatusEvent)Mockito.doReturn(null).when((Object)event)).getKeepAliveAppIds();
        return event;
    }

    @Test(timeout=5000L)
    public void testExpiredContainer() {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        this.node.handle((RMNodeEvent)new RMNodeStartedEvent(null, null, null, mockNodeStatus));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler)).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        ContainerId completedContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L);
        this.node.handle((RMNodeEvent)new RMNodeCleanContainerEvent(null, completedContainerId));
        Assert.assertEquals((long)1L, (long)this.node.getContainersToCleanUp().size());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent(null);
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId).when((Object)containerStatus)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus)).when((Object)statusEvent)).getContainers();
        this.node.handle((RMNodeEvent)statusEvent);
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeUpdateSchedulerEvent.class));
    }

    @Test
    public void testStatusUpdateOnDecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEventWithRunningApps();
        node.handle((RMNodeEvent)statusEvent);
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)initialDecommissioning, (long)cm.getNumDecommissioningNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
    }

    @Test
    public void testRecommissionNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.RECOMMISSION));
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive + 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)(initialDecommissioning - 1), (long)cm.getNumDecommissioningNMs());
    }

    @Test(timeout=5000L)
    public void testContainerUpdate() throws InterruptedException {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        this.node.handle((RMNodeEvent)new RMNodeStartedEvent(null, null, null, mockNodeStatus));
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost:1", (int)1);
        RMNodeImpl node2 = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null, null);
        node2.handle((RMNodeEvent)new RMNodeStartedEvent(null, null, null, mockNodeStatus));
        ApplicationId app0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        ApplicationId app1 = BuilderUtils.newApplicationId((long)1L, (int)1);
        ContainerId completedContainerIdFromNode1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)app0, (int)0), (long)0L);
        ContainerId completedContainerIdFromNode2_1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)app1, (int)1), (long)1L);
        ContainerId completedContainerIdFromNode2_2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)app1, (int)1), (long)2L);
        this.rmContext.getRMApps().put(app0, Mockito.mock(RMApp.class));
        this.rmContext.getRMApps().put(app1, Mockito.mock(RMApp.class));
        RMNodeStatusEvent statusEventFromNode1 = this.getMockRMNodeStatusEvent(null);
        RMNodeStatusEvent statusEventFromNode2_1 = this.getMockRMNodeStatusEvent(null);
        RMNodeStatusEvent statusEventFromNode2_2 = this.getMockRMNodeStatusEvent(null);
        ContainerStatus containerStatusFromNode1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatusFromNode2_1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatusFromNode2_2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode1).when((Object)containerStatusFromNode1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode1)).when((Object)statusEventFromNode1)).getContainers();
        this.node.handle((RMNodeEvent)statusEventFromNode1);
        Assert.assertEquals((long)1L, (long)this.completedContainers.size());
        Assert.assertEquals((Object)completedContainerIdFromNode1, (Object)this.completedContainers.get(0).getContainerId());
        this.completedContainers.clear();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode2_1).when((Object)containerStatusFromNode2_1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode2_1)).when((Object)statusEventFromNode2_1)).getContainers();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerIdFromNode2_2).when((Object)containerStatusFromNode2_2)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatusFromNode2_2)).when((Object)statusEventFromNode2_2)).getContainers();
        node2.setNextHeartBeat(false);
        node2.handle((RMNodeEvent)statusEventFromNode2_1);
        node2.setNextHeartBeat(true);
        node2.handle((RMNodeEvent)statusEventFromNode2_2);
        Assert.assertEquals((long)2L, (long)this.completedContainers.size());
        Assert.assertEquals((Object)completedContainerIdFromNode2_1, (Object)this.completedContainers.get(0).getContainerId());
        Assert.assertEquals((Object)completedContainerIdFromNode2_2, (Object)this.completedContainers.get(1).getContainerId());
    }

    @Test(timeout=5000L)
    public void testStatusChange() {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        this.node.handle((RMNodeEvent)new RMNodeStartedEvent(null, null, null, mockNodeStatus));
        this.node.setNextHeartBeat(false);
        ContainerId completedContainerId1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L);
        ContainerId completedContainerId2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)1L, (int)1), (int)1), (long)1L);
        RMNodeStatusEvent statusEvent1 = this.getMockRMNodeStatusEvent(null);
        RMNodeStatusEvent statusEvent2 = this.getMockRMNodeStatusEvent(null);
        ContainerStatus containerStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ContainerStatus containerStatus2 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId1).when((Object)containerStatus1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus1)).when((Object)statusEvent1)).getContainers();
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId2).when((Object)containerStatus2)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus2)).when((Object)statusEvent2)).getContainers();
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        this.node.handle((RMNodeEvent)statusEvent1);
        this.node.handle((RMNodeEvent)statusEvent2);
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        Assert.assertEquals((long)2L, (long)this.node.getQueueSize());
        this.node.handle(new RMNodeEvent(this.node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((long)0L, (long)this.node.getQueueSize());
    }

    @Test
    public void testRunningExpire() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)(initialLost + 1), (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testRunningExpireMultiple() {
        RMNodeImpl node1 = this.getRunningNode(null, 10001);
        RMNodeImpl node2 = this.getRunningNode(null, 10002);
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node1.handle(new RMNodeEvent(node1.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)(initialLost + 1), (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.LOST, (Object)node1.getState());
        Assert.assertTrue((String)("Node " + node1.toString() + " should be inactive"), (boolean)this.rmContext.getInactiveRMNodes().containsKey(node1.getNodeID()));
        Assert.assertFalse((String)("Node " + node2.toString() + " should not be inactive"), (boolean)this.rmContext.getInactiveRMNodes().containsKey(node2.getNodeID()));
        node2.handle(new RMNodeEvent(node1.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 2), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)(initialLost + 2), (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.LOST, (Object)node2.getState());
        Assert.assertTrue((String)("Node " + node1.toString() + " should be inactive"), (boolean)this.rmContext.getInactiveRMNodes().containsKey(node1.getNodeID()));
        Assert.assertTrue((String)("Node " + node2.toString() + " should be inactive"), (boolean)this.rmContext.getInactiveRMNodes().containsKey(node2.getNodeID()));
    }

    @Test
    public void testUnhealthyExpire() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)(initialLost + 1), (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)(initialUnhealthy - 1), (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testUnhealthyExpireForSchedulerRemove() {
        RMNodeImpl node = this.getUnhealthyNode();
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeRemovedSchedulerEvent.class));
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeRemovedSchedulerEvent.class));
        Assert.assertEquals((Object)NodeState.LOST, (Object)node.getState());
    }

    @Test
    public void testRunningDecommission() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)(initialDecommissioned + 1), (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testDecommissionOnDecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)(initialDecommissioning - 1), (long)cm.getNumDecommissioningNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)(initialDecommissioned + 1), (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testUnhealthyDecommission() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)(initialUnhealthy - 1), (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)(initialDecommissioned + 1), (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testUnhealthyDecommissioning() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.GRACEFUL_DECOMMISSION));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)(initialUnhealthy - 1), (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)(initialDecommissioning + 1), (long)cm.getNumDecommissioningNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
    }

    @Test
    public void testRunningRebooting() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)(initialRebooted + 1), (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
    }

    @Test
    public void testUnhealthyRebooting() {
        RMNodeImpl node = this.getUnhealthyNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)(initialUnhealthy - 1), (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)(initialRebooted + 1), (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
    }

    @Test
    public void testAddUnhealthyNode() {
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        NodeHealthStatus status = NodeHealthStatus.newInstance((boolean)false, (String)"sick", (long)System.currentTimeMillis());
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)this.node.getNodeID(), (int)0, new ArrayList(), null, (NodeHealthStatus)status, null, null, null);
        this.node.handle((RMNodeEvent)new RMNodeStartedEvent(this.node.getNodeID(), null, null, nodeStatus));
        Assert.assertEquals((String)"Unhealthy Nodes", (long)(initialUnhealthy + 1), (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.UNHEALTHY, (Object)this.node.getState());
    }

    @Test
    public void testNMShutdown() {
        RMNodeImpl node = this.getRunningNode();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.SHUTDOWN));
        Assert.assertEquals((Object)NodeState.SHUTDOWN, (Object)node.getState());
    }

    @Test
    public void testUnhealthyNMShutdown() {
        RMNodeImpl node = this.getUnhealthyNode();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.SHUTDOWN));
        Assert.assertEquals((Object)NodeState.SHUTDOWN, (Object)node.getState());
    }

    @Test(timeout=20000L)
    public void testUpdateHeartbeatResponseForCleanup() {
        RMNodeImpl node = this.getRunningNode();
        NodeId nodeId = node.getNodeID();
        ContainerId completedContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L);
        node.handle((RMNodeEvent)new RMNodeCleanContainerEvent(nodeId, completedContainerId));
        Assert.assertEquals((long)1L, (long)node.getContainersToCleanUp().size());
        ApplicationId finishedAppId = BuilderUtils.newApplicationId((long)0L, (int)1);
        node.handle((RMNodeEvent)new RMNodeCleanAppEvent(nodeId, finishedAppId));
        Assert.assertEquals((long)1L, (long)node.getAppsToCleanup().size());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent(null);
        node.handle((RMNodeEvent)statusEvent);
        Assert.assertEquals((long)1L, (long)node.getContainersToCleanUp().size());
        Assert.assertEquals((long)1L, (long)node.getAppsToCleanup().size());
        NodeHeartbeatResponse hbrsp = (NodeHeartbeatResponse)Records.newRecord(NodeHeartbeatResponse.class);
        node.setAndUpdateNodeHeartbeatResponse(hbrsp);
        Assert.assertEquals((long)0L, (long)node.getContainersToCleanUp().size());
        Assert.assertEquals((long)0L, (long)node.getAppsToCleanup().size());
        Assert.assertEquals((long)1L, (long)hbrsp.getContainersToCleanup().size());
        Assert.assertEquals((Object)completedContainerId, hbrsp.getContainersToCleanup().get(0));
        Assert.assertEquals((long)1L, (long)hbrsp.getApplicationsToCleanup().size());
        Assert.assertEquals((Object)finishedAppId, hbrsp.getApplicationsToCleanup().get(0));
    }

    @Test(timeout=20000L)
    public void testUpdateHeartbeatResponseForAppLifeCycle() {
        RMNodeImpl node = this.getRunningNode();
        NodeId nodeId = node.getNodeID();
        ApplicationId runningAppId = BuilderUtils.newApplicationId((long)0L, (int)1);
        this.rmContext.getRMApps().put(runningAppId, Mockito.mock(RMApp.class));
        ContainerId runningContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)runningAppId, (int)0), (long)0L);
        ContainerStatus status = ContainerStatus.newInstance((ContainerId)runningContainerId, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        ArrayList<ContainerStatus> statusList = new ArrayList<ContainerStatus>();
        statusList.add(status);
        NodeHealthStatus nodeHealth = NodeHealthStatus.newInstance((boolean)true, (String)"", (long)System.currentTimeMillis());
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)nodeId, (int)0, statusList, null, (NodeHealthStatus)nodeHealth, null, null, null);
        node.handle((RMNodeEvent)new RMNodeStatusEvent(nodeId, nodeStatus, null));
        Assert.assertEquals((long)1L, (long)node.getRunningApps().size());
        ApplicationId finishedAppId = runningAppId;
        node.handle((RMNodeEvent)new RMNodeCleanAppEvent(nodeId, finishedAppId));
        Assert.assertEquals((long)1L, (long)node.getAppsToCleanup().size());
        Assert.assertEquals((long)0L, (long)node.getRunningApps().size());
    }

    @Test
    public void testUnknownNodeId() {
        NodeId nodeId = NodesListManager.createUnknownNodeId((String)"host1");
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null, null);
        this.rmContext.getInactiveRMNodes().putIfAbsent(nodeId, node);
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.DECOMMISSION));
        Assert.assertNull((String)"Must be null as there is no NODE_UNUSABLE update", (Object)this.nodesListManagerEvent);
    }

    private RMNodeImpl getRunningNode() {
        return this.getRunningNode(null, 0);
    }

    private RMNodeImpl getRunningNode(String nmVersion) {
        return this.getRunningNode(nmVersion, 0);
    }

    private RMNodeImpl getRunningNode(String nmVersion, int port) {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)port);
        Resource capability = Resource.newInstance((int)4096, (int)4);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, capability, nmVersion);
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        node.handle((RMNodeEvent)new RMNodeStartedEvent(node.getNodeID(), null, null, mockNodeStatus));
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        return node;
    }

    private RMNodeImpl getDecommissioningNode() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.GRACEFUL_DECOMMISSION));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        Assert.assertEquals(Arrays.asList(NodeState.NEW, NodeState.RUNNING), this.nodesListManagerEventsNodeStateSequence);
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive - 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)(initialDecommissioning + 1), (long)cm.getNumDecommissioningNMs());
        return node;
    }

    private RMNodeImpl getUnhealthyNode() {
        RMNodeImpl node = this.getRunningNode();
        NodeHealthStatus status = NodeHealthStatus.newInstance((boolean)false, (String)"sick", (long)System.currentTimeMillis());
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)node.getNodeID(), (int)0, new ArrayList(), null, (NodeHealthStatus)status, null, null, null);
        node.handle((RMNodeEvent)new RMNodeStatusEvent(node.getNodeID(), nodeStatus, null));
        Assert.assertEquals((Object)NodeState.UNHEALTHY, (Object)node.getState());
        return node;
    }

    private RMNodeImpl getNewNode() {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, null, null);
        return node;
    }

    private RMNodeImpl getNewNode(Resource capability) {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, capability, null);
        return node;
    }

    private RMNodeImpl getRebootedNode() {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        Resource capability = Resource.newInstance((int)4096, (int)4);
        RMNodeImpl node = new RMNodeImpl(nodeId, this.rmContext, null, 0, 0, null, capability, null);
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        node.handle((RMNodeEvent)new RMNodeStartedEvent(node.getNodeID(), null, null, mockNodeStatus));
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.REBOOTING));
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
        return node;
    }

    @Test
    public void testAdd() {
        RMNodeImpl node = this.getNewNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        node.handle((RMNodeEvent)new RMNodeStartedEvent(node.getNodeID(), null, null, mockNodeStatus));
        Assert.assertEquals((String)"Active Nodes", (long)(initialActive + 1), (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_USABLE, (Object)this.nodesListManagerEvent.getType());
    }

    @Test
    public void testReconnect() {
        RMNodeImpl node = this.getRunningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialLost = cm.getNumLostNMs();
        int initialUnhealthy = cm.getUnhealthyNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        int initialRebooted = cm.getNumRebootedNMs();
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node, null, null));
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Lost Nodes", (long)initialLost, (long)cm.getNumLostNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnhealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        Assert.assertEquals((String)"Rebooted Nodes", (long)initialRebooted, (long)cm.getNumRebootedNMs());
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_USABLE, (Object)this.nodesListManagerEvent.getType());
    }

    @Test
    public void testReconnectOnDecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        int initialDecommissioned = cm.getNumDecommisionedNMs();
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node, this.getAppIdList(), null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)initialDecommissioning, (long)cm.getNumDecommissioningNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)initialDecommissioned, (long)cm.getNumDecommisionedNMs());
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node, null, null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)(initialDecommissioning - 1), (long)cm.getNumDecommissioningNMs());
        Assert.assertEquals((String)"Decommissioned Nodes", (long)(initialDecommissioned + 1), (long)cm.getNumDecommisionedNMs());
    }

    @Test
    public void testReconnectWithNewPortOnDecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        Random r = new Random();
        node.setHttpPort(r.nextInt(10000));
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node, this.getAppIdList(), null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        node.setHttpPort(r.nextInt(10000));
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)node, null, null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testResourceUpdateOnRunningNode() {
        RMNodeImpl node = this.getRunningNode();
        Resource oldCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)oldCapacity.getMemorySize(), (long)4096L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)oldCapacity.getVirtualCores(), (long)4L);
        node.handle((RMNodeEvent)new RMNodeResourceUpdateEvent(node.getNodeID(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)-1)));
        Resource newCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)newCapacity.getMemorySize(), (long)2048L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)newCapacity.getVirtualCores(), (long)2L);
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_USABLE, (Object)this.nodesListManagerEvent.getType());
    }

    @Test
    public void testDecommissioningOnRunningNode() {
        this.getDecommissioningNode();
    }

    @Test
    public void testResourceUpdateOnNewNode() {
        RMNodeImpl node = this.getNewNode(Resource.newInstance((int)4096, (int)4));
        Resource oldCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)oldCapacity.getMemorySize(), (long)4096L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)oldCapacity.getVirtualCores(), (long)4L);
        node.handle((RMNodeEvent)new RMNodeResourceUpdateEvent(node.getNodeID(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)-1)));
        Resource newCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)newCapacity.getMemorySize(), (long)2048L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)newCapacity.getVirtualCores(), (long)2L);
        Assert.assertEquals((Object)NodeState.NEW, (Object)node.getState());
    }

    @Test
    public void testResourceUpdateOnRebootedNode() {
        RMNodeImpl node = this.getRebootedNode();
        ClusterMetrics cm = ClusterMetrics.getMetrics();
        int initialActive = cm.getNumActiveNMs();
        int initialUnHealthy = cm.getUnhealthyNMs();
        int initialDecommissioning = cm.getNumDecommissioningNMs();
        Resource oldCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)oldCapacity.getMemorySize(), (long)4096L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)oldCapacity.getVirtualCores(), (long)4L);
        node.handle((RMNodeEvent)new RMNodeResourceUpdateEvent(node.getNodeID(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)-1)));
        Resource newCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)newCapacity.getMemorySize(), (long)2048L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)newCapacity.getVirtualCores(), (long)2L);
        Assert.assertEquals((Object)NodeState.REBOOTED, (Object)node.getState());
        Assert.assertEquals((String)"Active Nodes", (long)initialActive, (long)cm.getNumActiveNMs());
        Assert.assertEquals((String)"Unhealthy Nodes", (long)initialUnHealthy, (long)cm.getUnhealthyNMs());
        Assert.assertEquals((String)"Decommissioning Nodes", (long)initialDecommissioning, (long)cm.getNumDecommissioningNMs());
    }

    @Test
    public void testDecommissioningUnhealthy() {
        RMNodeImpl node = this.getDecommissioningNode();
        NodeHealthStatus status = NodeHealthStatus.newInstance((boolean)false, (String)"sick", (long)System.currentTimeMillis());
        ArrayList<ApplicationId> keepAliveApps = new ArrayList<ApplicationId>();
        keepAliveApps.add(BuilderUtils.newApplicationId((long)1L, (int)1));
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)node.getNodeID(), (int)0, null, keepAliveApps, (NodeHealthStatus)status, null, null, null);
        node.handle((RMNodeEvent)new RMNodeStatusEvent(node.getNodeID(), nodeStatus, null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        nodeStatus.setKeepAliveApplications(null);
        node.handle((RMNodeEvent)new RMNodeStatusEvent(node.getNodeID(), nodeStatus, null));
        Assert.assertEquals((Object)NodeState.DECOMMISSIONED, (Object)node.getState());
    }

    @Test
    public void testReconnnectUpdate() {
        String nmVersion1 = "nm version 1";
        String nmVersion2 = "nm version 2";
        RMNodeImpl node = this.getRunningNode("nm version 1");
        Assert.assertEquals((Object)"nm version 1", (Object)node.getNodeManagerVersion());
        RMNodeImpl reconnectingNode = this.getRunningNode("nm version 2");
        node.handle((RMNodeEvent)new RMNodeReconnectEvent(node.getNodeID(), (RMNode)reconnectingNode, null, null));
        Assert.assertEquals((Object)"nm version 2", (Object)node.getNodeManagerVersion());
    }

    @Test
    public void testContainerExpire() throws Exception {
        ContainerAllocationExpirer mockExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        this.rmContext.getRMApps().put(appId, Mockito.mock(RMApp.class));
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)2L);
        AllocationExpirationInfo expirationInfo1 = new AllocationExpirationInfo(containerId1);
        AllocationExpirationInfo expirationInfo2 = new AllocationExpirationInfo(containerId2);
        mockExpirer.register((Object)expirationInfo1);
        mockExpirer.register((Object)expirationInfo2);
        ((ContainerAllocationExpirer)Mockito.verify((Object)mockExpirer)).register((Object)expirationInfo1);
        ((ContainerAllocationExpirer)Mockito.verify((Object)mockExpirer)).register((Object)expirationInfo2);
        ((RMContextImpl)this.rmContext).setContainerAllocationExpirer(mockExpirer);
        RMNodeImpl rmNode = this.getRunningNode();
        ContainerStatus status1 = ContainerStatus.newInstance((ContainerId)containerId1, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        ContainerStatus status2 = ContainerStatus.newInstance((ContainerId)containerId2, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0);
        ArrayList<ContainerStatus> statusList = new ArrayList<ContainerStatus>();
        statusList.add(status1);
        statusList.add(status2);
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent(statusList);
        rmNode.handle((RMNodeEvent)statusEvent);
        ((ContainerAllocationExpirer)Mockito.verify((Object)mockExpirer)).unregister((Object)expirationInfo1);
        ((ContainerAllocationExpirer)Mockito.verify((Object)mockExpirer)).unregister((Object)expirationInfo2);
    }

    @Test
    public void testResourceUpdateOnDecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        Resource oldCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)oldCapacity.getMemorySize(), (long)4096L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)oldCapacity.getVirtualCores(), (long)4L);
        node.handle((RMNodeEvent)new RMNodeResourceUpdateEvent(node.getNodeID(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)-1)));
        Resource originalCapacity = node.getOriginalTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)originalCapacity.getMemorySize(), (long)oldCapacity.getMemorySize());
        Assert.assertEquals((String)"CPU resource is not match.", (long)originalCapacity.getVirtualCores(), (long)oldCapacity.getVirtualCores());
        Resource newCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)newCapacity.getMemorySize(), (long)2048L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)newCapacity.getVirtualCores(), (long)2L);
        Assert.assertEquals((Object)NodeState.DECOMMISSIONING, (Object)node.getState());
        Assert.assertNotNull((Object)this.nodesListManagerEvent);
        Assert.assertEquals((Object)NodesListManagerEventType.NODE_DECOMMISSIONING, (Object)this.nodesListManagerEvent.getType());
    }

    @Test
    public void testResourceUpdateOnRecommissioningNode() {
        RMNodeImpl node = this.getDecommissioningNode();
        Resource oldCapacity = node.getTotalCapability();
        Assert.assertEquals((String)"Memory resource is not match.", (long)oldCapacity.getMemorySize(), (long)4096L);
        Assert.assertEquals((String)"CPU resource is not match.", (long)oldCapacity.getVirtualCores(), (long)4L);
        Assert.assertFalse((String)"updatedCapability should be false.", (boolean)node.isUpdatedCapability());
        node.handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.RECOMMISSION));
        Resource originalCapacity = node.getOriginalTotalCapability();
        Assert.assertEquals((String)"Original total capability not null after recommission", null, (Object)originalCapacity);
        Assert.assertTrue((String)"updatedCapability should be set.", (boolean)node.isUpdatedCapability());
    }

    @Test
    public void testDisappearingContainer() {
        ContainerId cid1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)1L, (int)1), (int)1), (long)1L);
        ContainerId cid2 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)2L, (int)2), (int)2), (long)2L);
        ArrayList<ContainerStatus> containerStats = new ArrayList<ContainerStatus>();
        containerStats.add(ContainerStatus.newInstance((ContainerId)cid1, (ContainerState)ContainerState.RUNNING, (String)"", (int)-1));
        containerStats.add(ContainerStatus.newInstance((ContainerId)cid2, (ContainerState)ContainerState.RUNNING, (String)"", (int)-1));
        this.node = this.getRunningNode();
        this.node.handle((RMNodeEvent)this.getMockRMNodeStatusEvent(containerStats));
        Assert.assertEquals((String)"unexpected number of running containers", (long)2L, (long)this.node.getLaunchedContainers().size());
        Assert.assertTrue((String)"first container not running", (boolean)this.node.getLaunchedContainers().contains(cid1));
        Assert.assertTrue((String)"second container not running", (boolean)this.node.getLaunchedContainers().contains(cid2));
        Assert.assertEquals((String)"unexpected number of running containers", (long)2L, (long)this.node.getUpdatedExistContainers().size());
        Assert.assertTrue((String)"first container not running", (boolean)this.node.getUpdatedExistContainers().containsKey(cid1));
        Assert.assertTrue((String)"second container not running", (boolean)this.node.getUpdatedExistContainers().containsKey(cid2));
        Assert.assertEquals((String)"already completed containers", (long)0L, (long)this.completedContainers.size());
        containerStats.remove(0);
        this.node.handle((RMNodeEvent)this.getMockRMNodeStatusEvent(containerStats));
        Assert.assertEquals((String)"expected one container to be completed", (long)1L, (long)this.completedContainers.size());
        ContainerStatus cs = this.completedContainers.get(0);
        Assert.assertEquals((String)"first container not the one that completed", (Object)cid1, (Object)cs.getContainerId());
        Assert.assertEquals((String)"completed container not marked complete", (Object)ContainerState.COMPLETE, (Object)cs.getState());
        Assert.assertEquals((String)"completed container not marked aborted", (long)-100L, (long)cs.getExitStatus());
        Assert.assertTrue((String)"completed container not marked missing", (boolean)cs.getDiagnostics().contains("not reported"));
        Assert.assertEquals((String)"unexpected number of running containers", (long)1L, (long)this.node.getLaunchedContainers().size());
        Assert.assertTrue((String)"second container not running", (boolean)this.node.getLaunchedContainers().contains(cid2));
        Assert.assertEquals((String)"unexpected number of running containers", (long)1L, (long)this.node.getUpdatedExistContainers().size());
        Assert.assertTrue((String)"second container not running", (boolean)this.node.getUpdatedExistContainers().containsKey(cid2));
    }

    @Test
    public void testForHandlingDuplicatedCompltedContainers() {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        this.node.handle((RMNodeEvent)new RMNodeStartedEvent(null, null, null, mockNodeStatus));
        this.node.setNextHeartBeat(false);
        ContainerId completedContainerId1 = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L);
        RMNodeStatusEvent statusEvent1 = this.getMockRMNodeStatusEvent(null);
        ContainerStatus containerStatus1 = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        ((ContainerStatus)Mockito.doReturn((Object)completedContainerId1).when((Object)containerStatus1)).getContainerId();
        ((RMNodeStatusEvent)Mockito.doReturn(Collections.singletonList(containerStatus1)).when((Object)statusEvent1)).getContainers();
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        this.node.handle((RMNodeEvent)statusEvent1);
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.any(NodeAddedSchedulerEvent.class));
        Assert.assertEquals((long)1L, (long)this.node.getQueueSize());
        Assert.assertEquals((long)1L, (long)this.node.getCompletedContainers().size());
        this.node.handle((RMNodeEvent)statusEvent1);
        Assert.assertEquals((long)1L, (long)this.node.getQueueSize());
        this.node.handle((RMNodeEvent)new RMNodeFinishedContainersPulledByAMEvent(this.node.getNodeID(), Collections.singletonList(completedContainerId1)));
        NodeHeartbeatResponse hbrsp = (NodeHeartbeatResponse)Records.newRecord(NodeHeartbeatResponse.class);
        this.node.setAndUpdateNodeHeartbeatResponse(hbrsp);
        Assert.assertEquals((long)1L, (long)hbrsp.getContainersToBeRemovedFromNM().size());
        Assert.assertEquals((long)0L, (long)this.node.getCompletedContainers().size());
    }

    @Test
    public void testFinishedContainersPulledByAMOnNewNode() {
        RMNodeImpl rmNode = this.getNewNode();
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        rmNode.handle((RMNodeEvent)new RMNodeFinishedContainersPulledByAMEvent(nodeId, this.getContainerIdList()));
        Assert.assertEquals((long)1L, (long)rmNode.getContainersToBeRemovedFromNM().size());
    }

    private void calcIntervalTest(RMNodeImpl rmNode, ResourceUtilization nodeUtil, long hbDefault, long hbMin, long hbMax, float speedup, float slowdown, float cpuUtil, long expectedHb) {
        nodeUtil.setCPU(cpuUtil);
        rmNode.setNodeUtilization(nodeUtil);
        long hbInterval = rmNode.calculateHeartBeatInterval(hbDefault, hbMin, hbMax, speedup, slowdown);
        Assert.assertEquals((String)"heartbeat interval incorrect", (long)expectedHb, (long)hbInterval);
    }

    @Test
    public void testCalculateHeartBeatInterval() {
        RMNodeImpl rmNode = this.getRunningNode();
        Resource nodeCapability = rmNode.getTotalCapability();
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        int vcoreUnit = nodeCapability.getVirtualCores();
        rmNode.setPhysicalResource(nodeCapability);
        int clusterVcores = vcoreUnit * 10;
        metrics.incrCapability(Resource.newInstance((long)(10L * nodeCapability.getMemorySize()), (int)clusterVcores));
        long hbDefault = 2000L;
        long hbMin = 1500L;
        long hbMax = 2500L;
        float speedup = 1.0f;
        float slowdown = 1.0f;
        metrics.incrUtilizedVirtualCores((long)(vcoreUnit * 5));
        ResourceUtilization nodeUtil = ResourceUtilization.newInstance((int)1024, (int)vcoreUnit, (float)(0.0f * (float)vcoreUnit));
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.0f, hbMin);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.1f, hbMin);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.2f, hbMin);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.3f, 1600L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.4f, 1800L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.5f, hbDefault);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.6f, 2200L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.7f, 2400L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.8f, hbMax);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.9f, hbMax);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 1.0f, hbMax);
        speedup = 0.5f;
        slowdown = 0.5f;
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.0f, hbMin);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.1f, 1600L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.2f, 1700L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.3f, 1800L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.4f, 1900L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.5f, hbDefault);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.6f, 2100L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.7f, 2200L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.8f, 2300L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.9f, 2400L);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 1.0f, hbMax);
        rmNode.setPhysicalResource(null);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 0.1f, hbDefault);
        this.calcIntervalTest(rmNode, nodeUtil, hbDefault, hbMin, hbMax, speedup, slowdown, (float)vcoreUnit * 1.0f, hbDefault);
    }

    private class TestNodeListManagerEventDispatcher
    implements EventHandler<NodesListManagerEvent> {
        private TestNodeListManagerEventDispatcher() {
        }

        public void handle(NodesListManagerEvent event) {
            TestRMNodeTransitions.this.nodesListManagerEvent = event;
            TestRMNodeTransitions.this.nodesListManagerEventsNodeStateSequence.add(event.getNode().getState());
        }
    }

    private final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            TestRMNodeTransitions.this.scheduler.handle((Event)event);
        }
    }
}

