/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.UpdateContainerRequestPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMServerUtils {
    @Test
    public void testValidateAndSplitUpdateResourceRequests() {
        ArrayList<UpdateContainerRequestPBImpl> updateRequests = new ArrayList<UpdateContainerRequestPBImpl>();
        int containerVersion = 10;
        int resource = 10;
        Resource maxAllocation = Resource.newInstance((int)resource, (int)resource);
        UpdateContainerRequestPBImpl updateContainerRequestPBFail = new UpdateContainerRequestPBImpl();
        updateContainerRequestPBFail.setContainerVersion(containerVersion);
        updateContainerRequestPBFail.setCapability(Resource.newInstance((int)(resource + 1), (int)(resource + 1)));
        updateContainerRequestPBFail.setContainerId((ContainerId)Mockito.mock(ContainerId.class));
        ContainerId containerIdOk = (ContainerId)Mockito.mock(ContainerId.class);
        Resource capabilityOk = Resource.newInstance((int)(resource - 1), (int)(resource - 1));
        UpdateContainerRequestPBImpl updateContainerRequestPBOk = new UpdateContainerRequestPBImpl();
        updateContainerRequestPBOk.setContainerVersion(containerVersion);
        updateContainerRequestPBOk.setCapability(capabilityOk);
        updateContainerRequestPBOk.setContainerUpdateType(ContainerUpdateType.INCREASE_RESOURCE);
        updateContainerRequestPBOk.setContainerId(containerIdOk);
        updateRequests.add(updateContainerRequestPBOk);
        updateRequests.add(updateContainerRequestPBFail);
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        RMContainer rmContainer = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)scheduler.getRMContainer((ContainerId)Mockito.any())).thenReturn((Object)rmContainer);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getVersion()).thenReturn((Object)containerVersion);
        Mockito.when((Object)rmContainer.getContainer()).thenReturn((Object)container);
        Mockito.when((Object)scheduler.getNormalizedResource(capabilityOk, maxAllocation)).thenReturn((Object)capabilityOk);
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)1, (float)0.5f, new ArrayList(), new ArrayList(), updateRequests, null);
        ArrayList updateErrors = new ArrayList();
        ContainerUpdates containerUpdates = RMServerUtils.validateAndSplitUpdateResourceRequests((RMContext)rmContext, (AllocateRequest)allocateRequest, (Resource)maxAllocation, updateErrors);
        Assert.assertEquals((long)1L, (long)updateErrors.size());
        Assert.assertEquals((long)(resource + 1), (long)((UpdateContainerError)updateErrors.get(0)).getUpdateContainerRequest().getCapability().getMemorySize());
        Assert.assertEquals((long)(resource + 1), (long)((UpdateContainerError)updateErrors.get(0)).getUpdateContainerRequest().getCapability().getVirtualCores());
        Assert.assertEquals((Object)"RESOURCE_OUTSIDE_ALLOWED_RANGE", (Object)((UpdateContainerError)updateErrors.get(0)).getReason());
        Assert.assertEquals((long)1L, (long)containerUpdates.getIncreaseRequests().size());
        UpdateContainerRequest increaseRequest = (UpdateContainerRequest)containerUpdates.getIncreaseRequests().get(0);
        Assert.assertEquals((long)capabilityOk.getVirtualCores(), (long)increaseRequest.getCapability().getVirtualCores());
        Assert.assertEquals((long)capabilityOk.getMemorySize(), (long)increaseRequest.getCapability().getMemorySize());
        Assert.assertEquals((Object)containerIdOk, (Object)increaseRequest.getContainerId());
    }

    @Test
    public void testQueryRMNodes() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        NodeId node1 = NodeId.newInstance((String)"node1", (int)1234);
        RMNode rmNode1 = (RMNode)Mockito.mock(RMNode.class);
        ConcurrentHashMap<NodeId, RMNode> inactiveList = new ConcurrentHashMap<NodeId, RMNode>();
        Mockito.when((Object)rmNode1.getState()).thenReturn((Object)NodeState.SHUTDOWN);
        inactiveList.put(node1, rmNode1);
        Mockito.when((Object)rmContext.getInactiveRMNodes()).thenReturn(inactiveList);
        List result = RMServerUtils.queryRMNodes((RMContext)rmContext, EnumSet.of(NodeState.SHUTDOWN));
        Assert.assertTrue((result.size() != 0 ? 1 : 0) != 0);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)rmNode1);
        Mockito.when((Object)rmNode1.getState()).thenReturn((Object)NodeState.DECOMMISSIONED);
        result = RMServerUtils.queryRMNodes((RMContext)rmContext, EnumSet.of(NodeState.DECOMMISSIONED));
        Assert.assertTrue((result.size() != 0 ? 1 : 0) != 0);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)rmNode1);
        Mockito.when((Object)rmNode1.getState()).thenReturn((Object)NodeState.LOST);
        result = RMServerUtils.queryRMNodes((RMContext)rmContext, EnumSet.of(NodeState.LOST));
        Assert.assertTrue((result.size() != 0 ? 1 : 0) != 0);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)rmNode1);
        Mockito.when((Object)rmNode1.getState()).thenReturn((Object)NodeState.REBOOTED);
        result = RMServerUtils.queryRMNodes((RMContext)rmContext, EnumSet.of(NodeState.REBOOTED));
        Assert.assertTrue((result.size() != 0 ? 1 : 0) != 0);
        Assertions.assertThat(result.get(0)).isEqualTo((Object)rmNode1);
    }

    @Test
    public void testGetApplicableNodeCountForAMLocality() throws Exception {
        ArrayList<NodeId> rack1Nodes = new ArrayList<NodeId>();
        for (int i = 0; i < 29; ++i) {
            rack1Nodes.add(NodeId.newInstance((String)("host" + i), (int)1234));
        }
        NodeId node1 = NodeId.newInstance((String)"node1", (int)1234);
        NodeId node2 = NodeId.newInstance((String)"node2", (int)1234);
        rack1Nodes.add(node2);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", false);
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getNumClusterNodes()).thenReturn((Object)100);
        Mockito.when((Object)scheduler.getNodeIds("/rack1")).thenReturn(rack1Nodes);
        Mockito.when((Object)scheduler.getNodeIds("node1")).thenReturn(Collections.singletonList(node1));
        Mockito.when((Object)scheduler.getNodeIds("node2")).thenReturn(Collections.singletonList(node2));
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        ResourceRequest anyReq = this.createResourceRequest("*", true, null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(anyReq);
        Assert.assertEquals((long)100L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest rackReq = this.createResourceRequest("/rack1", true, null);
        reqs.add(rackReq);
        Assert.assertEquals((long)30L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        anyReq.setRelaxLocality(false);
        Assert.assertEquals((long)30L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)100L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest node1Req = this.createResourceRequest("node1", false, null);
        reqs.add(node1Req);
        Assert.assertEquals((long)100L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(true);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(true);
        Assert.assertEquals((long)31L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest node2Req = this.createResourceRequest("node2", false, null);
        reqs.add(node2Req);
        Assert.assertEquals((long)31L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(true);
        Assert.assertEquals((long)31L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)2L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(false);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(false);
        Assert.assertEquals((long)100L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
    }

    @Test
    public void testGetApplicableNodeCountForAMLabels() throws Exception {
        HashSet<NodeId> noLabelNodes = new HashSet<NodeId>();
        for (int i = 0; i < 80; ++i) {
            noLabelNodes.add(NodeId.newInstance((String)("host" + i), (int)1234));
        }
        HashSet<NodeId> label1Nodes = new HashSet<NodeId>();
        for (int i = 80; i < 90; ++i) {
            label1Nodes.add(NodeId.newInstance((String)("host" + i), (int)1234));
        }
        label1Nodes.add(NodeId.newInstance((String)"host101", (int)0));
        label1Nodes.add(NodeId.newInstance((String)"host102", (int)0));
        HashMap<String, HashSet<NodeId>> label1NodesMap = new HashMap<String, HashSet<NodeId>>();
        label1NodesMap.put("label1", label1Nodes);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getNumClusterNodes()).thenReturn((Object)100);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        RMNodeLabelsManager labMan = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)labMan.getNodesWithoutALabel()).thenReturn(noLabelNodes);
        Mockito.when((Object)labMan.getLabelsToNodes(Collections.singleton("label1"))).thenReturn(label1NodesMap);
        Mockito.when((Object)rmContext.getNodeLabelManager()).thenReturn((Object)labMan);
        ResourceRequest anyReq = this.createResourceRequest("*", true, null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(anyReq);
        Assert.assertEquals((long)80L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        anyReq.setNodeLabelExpression("label1");
        Assert.assertEquals((long)10L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
    }

    @Test
    public void testGetApplicableNodeCountForAMLocalityAndLabels() throws Exception {
        int i;
        int i2;
        ArrayList<NodeId> rack1Nodes = new ArrayList<NodeId>();
        for (int i3 = 0; i3 < 29; ++i3) {
            rack1Nodes.add(NodeId.newInstance((String)("host" + i3), (int)1234));
        }
        NodeId node1 = NodeId.newInstance((String)"node1", (int)1234);
        NodeId node2 = NodeId.newInstance((String)"node2", (int)1234);
        rack1Nodes.add(node2);
        HashSet noLabelNodes = new HashSet();
        for (i2 = 0; i2 < 19; ++i2) {
            noLabelNodes.add(rack1Nodes.get(i2));
        }
        noLabelNodes.add(node2);
        for (i2 = 29; i2 < 89; ++i2) {
            noLabelNodes.add(NodeId.newInstance((String)("host" + i2), (int)1234));
        }
        HashSet<Object> label1Nodes = new HashSet<Object>();
        label1Nodes.add(node1);
        for (i = 89; i < 93; ++i) {
            label1Nodes.add(NodeId.newInstance((String)("host" + i), (int)1234));
        }
        for (i = 19; i < 29; ++i) {
            label1Nodes.add(rack1Nodes.get(i));
        }
        label1Nodes.add(NodeId.newInstance((String)"host101", (int)0));
        label1Nodes.add(NodeId.newInstance((String)"host102", (int)0));
        HashMap<String, HashSet<Object>> label1NodesMap = new HashMap<String, HashSet<Object>>();
        label1NodesMap.put("label1", label1Nodes);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getNumClusterNodes()).thenReturn((Object)100);
        Mockito.when((Object)scheduler.getNodeIds("/rack1")).thenReturn(rack1Nodes);
        Mockito.when((Object)scheduler.getNodeIds("node1")).thenReturn(Collections.singletonList(node1));
        Mockito.when((Object)scheduler.getNodeIds("node2")).thenReturn(Collections.singletonList(node2));
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        RMNodeLabelsManager labMan = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)labMan.getNodesWithoutALabel()).thenReturn(noLabelNodes);
        Mockito.when((Object)labMan.getLabelsToNodes(Collections.singleton("label1"))).thenReturn(label1NodesMap);
        Mockito.when((Object)rmContext.getNodeLabelManager()).thenReturn((Object)labMan);
        ResourceRequest anyReq = this.createResourceRequest("*", true, null);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(anyReq);
        Assert.assertEquals((long)80L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest rackReq = this.createResourceRequest("/rack1", true, null);
        reqs.add(rackReq);
        Assert.assertEquals((long)20L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        anyReq.setRelaxLocality(false);
        Assert.assertEquals((long)20L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)80L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest node1Req = this.createResourceRequest("node1", false, null);
        reqs.add(node1Req);
        Assert.assertEquals((long)80L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(true);
        Assert.assertEquals((long)0L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(true);
        Assert.assertEquals((long)20L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        ResourceRequest node2Req = this.createResourceRequest("node2", false, null);
        reqs.add(node2Req);
        Assert.assertEquals((long)20L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(true);
        Assert.assertEquals((long)20L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(false);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(false);
        Assert.assertEquals((long)80L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        anyReq.setNodeLabelExpression("label1");
        rackReq.setNodeLabelExpression("label1");
        node1Req.setNodeLabelExpression("label1");
        node2Req.setNodeLabelExpression("label1");
        anyReq.setRelaxLocality(true);
        reqs = new ArrayList();
        reqs.add(anyReq);
        Assert.assertEquals((long)15L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(true);
        reqs.add(rackReq);
        Assert.assertEquals((long)10L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        anyReq.setRelaxLocality(false);
        Assert.assertEquals((long)10L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)15L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(false);
        reqs.add(node1Req);
        Assert.assertEquals((long)15L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(true);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(true);
        Assert.assertEquals((long)11L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(false);
        reqs.add(node2Req);
        Assert.assertEquals((long)11L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(true);
        Assert.assertEquals((long)11L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        rackReq.setRelaxLocality(false);
        Assert.assertEquals((long)1L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node1Req.setRelaxLocality(false);
        Assert.assertEquals((long)0L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
        node2Req.setRelaxLocality(false);
        Assert.assertEquals((long)15L, (long)RMServerUtils.getApplicableNodeCountForAM((RMContext)rmContext, (Configuration)conf, reqs));
    }

    private ResourceRequest createResourceRequest(String resource, boolean relaxLocality, String nodeLabel) {
        return ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)resource, (Resource)Resource.newInstance((int)1, (int)1), (int)1, (boolean)relaxLocality, (String)nodeLabel);
    }
}

