/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestWorkPreservingRMRestart
extends ParameterizedSchedulerTestBase {
    private YarnConfiguration conf;
    MockRM rm1 = null;
    MockRM rm2 = null;
    private static final String R = "Default";
    private static final String A = "QueueA";
    private static final String B = "QueueB";
    private static final String B1 = "QueueB1";
    private static final String B2 = "QueueB2";
    private static final String QUEUE_DOESNT_EXIST = "NoSuchQueue";
    private static final String USER_1 = "user1";
    private static final String USER_2 = "user2";

    public TestWorkPreservingRMRestart(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setup() throws UnknownHostException {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        this.conf = this.getConf();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.set("yarn.resourcemanager.recovery.enabled", "true");
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    @Override
    @After
    public void tearDown() {
        if (this.rm1 != null) {
            this.rm1.stop();
        }
        if (this.rm2 != null) {
            this.rm2.stop();
        }
        this.conf = null;
    }

    @Test(timeout=20000L)
    public void testSchedulerRecovery() throws Exception {
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        int containerMemory = 1024;
        Resource containerResource = Resource.newInstance((int)containerMemory, (int)1);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        Resource amResources = ((ResourceRequest)app1.getAMResourceRequests().get(0)).getCapability();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.rm1.clearQueueMetrics(app1);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = recoveredApp1.getCurrentAppAttempt();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1.getApplicationAttemptId());
        Set launchedContainers = ((RMNodeImpl)this.rm2.getRMContext().getRMNodes().get(nm1.getNodeId())).getLaunchedContainers();
        Assert.assertTrue((boolean)launchedContainers.contains(amContainer.getContainerId()));
        Assert.assertTrue((boolean)launchedContainers.contains(runningContainer.getContainerId()));
        this.rm2.waitForState(nm1, amContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForState(nm1, runningContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForContainerToComplete(loadedAttempt1, completedContainer);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        SchedulerNode schedulerNode1 = scheduler.getSchedulerNode(nm1.getNodeId());
        Assert.assertTrue((String)"SchedulerNode#toString is not in expected format", (boolean)schedulerNode1.toString().contains(schedulerNode1.getUnallocatedResource().toString()));
        Assert.assertTrue((String)"SchedulerNode#toString is not in expected format", (boolean)schedulerNode1.toString().contains(schedulerNode1.getAllocatedResource().toString()));
        Resource usedResources = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource nmResource = Resource.newInstance((long)nm1.getMemory(), (int)nm1.getvCores());
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(amContainer.getContainerId()));
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(runningContainer.getContainerId()));
        Assert.assertFalse((boolean)schedulerNode1.isValidContainer(completedContainer.getContainerId()));
        Assert.assertEquals((long)2L, (long)schedulerNode1.getNumContainers());
        Assert.assertEquals((Object)Resources.subtract((Resource)nmResource, (Resource)usedResources), (Object)schedulerNode1.getUnallocatedResource());
        Assert.assertEquals((Object)usedResources, (Object)schedulerNode1.getAllocatedResource());
        Resource availableResources = Resources.subtract((Resource)nmResource, (Resource)usedResources);
        Map schedulerApps = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp = (SchedulerApplication)schedulerApps.get(recoveredApp1.getApplicationId());
        if (this.getSchedulerType() == ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            this.checkCSQueue(this.rm2, (SchedulerApplication<SchedulerApplicationAttempt>)schedulerApp, nmResource, nmResource, usedResources, 2);
        } else {
            this.checkFSQueue(this.rm2, schedulerApp, usedResources, availableResources, amResources);
        }
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(amContainer.getContainerId())));
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(runningContainer.getContainerId())));
        Assertions.assertThat((Comparable)schedulerAttempt.getCurrentConsumption()).isEqualTo((Object)usedResources);
        Assert.assertEquals((long)0x10000000001L, (long)schedulerAttempt.getNewContainerId());
    }

    private Configuration getSchedulerDynamicConfiguration() throws IOException {
        this.conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        this.conf.setTimeDuration("yarn.resourcemanager.reservation-system.planfollower.time-step", 1L, TimeUnit.SECONDS);
        if (this.getSchedulerType() == ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            CapacitySchedulerConfiguration schedulerConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
            ReservationSystemTestUtil.setupDynamicQueueConfiguration(schedulerConf);
            return schedulerConf;
        }
        String allocFile = new File(FairSchedulerTestBase.TEST_DIR, TestWorkPreservingRMRestart.class.getSimpleName() + ".xml").getAbsolutePath();
        ReservationSystemTestUtil.setupFSAllocationFile(allocFile);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.scheduler.fair.allocation.file", allocFile);
        return this.conf;
    }

    private CapacitySchedulerConfiguration getSchedulerAutoCreatedQueueConfiguration(boolean overrideWithQueueMappings) throws IOException {
        CapacitySchedulerConfiguration schedulerConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfigurationForSingleAutoCreatedLeafQueue(schedulerConf);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(schedulerConf, "c", overrideWithQueueMappings, new int[]{0, 1});
        return schedulerConf;
    }

    @Test(timeout=30000L)
    public void testDynamicQueueRecovery() throws Exception {
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        Configuration schedulerConf = this.getSchedulerDynamicConfiguration();
        int containerMemory = 1024;
        Resource containerResource = Resource.newInstance((int)containerMemory, (int)1);
        this.rm1 = new MockRM(schedulerConf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        this.rm1.getRMContext().getReservationSystem().synchronizePlan("root.dedicated", true);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, this.rm1).withAppName("dynamicQApp").withUser(UserGroupInformation.getCurrentUser().getShortUserName()).withAcls(null).withQueue(ReservationSystemTestUtil.getReservationQueueName()).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(this.rm1, data);
        Resource amResources = ((ResourceRequest)app1.getAMResourceRequests().get(0)).getCapability();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.rm1.clearQueueMetrics(app1);
        this.rm2 = new MockRM(schedulerConf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = recoveredApp1.getCurrentAppAttempt();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1.getApplicationAttemptId());
        Set launchedContainers = ((RMNodeImpl)this.rm2.getRMContext().getRMNodes().get(nm1.getNodeId())).getLaunchedContainers();
        Assert.assertTrue((boolean)launchedContainers.contains(amContainer.getContainerId()));
        Assert.assertTrue((boolean)launchedContainers.contains(runningContainer.getContainerId()));
        this.rm2.waitForState(nm1, amContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForState(nm1, runningContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForContainerToComplete(loadedAttempt1, completedContainer);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        SchedulerNode schedulerNode1 = scheduler.getSchedulerNode(nm1.getNodeId());
        Resource usedResources = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource nmResource = Resource.newInstance((long)nm1.getMemory(), (int)nm1.getvCores());
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(amContainer.getContainerId()));
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(runningContainer.getContainerId()));
        Assert.assertFalse((boolean)schedulerNode1.isValidContainer(completedContainer.getContainerId()));
        Assert.assertEquals((long)2L, (long)schedulerNode1.getNumContainers());
        Assert.assertEquals((Object)Resources.subtract((Resource)nmResource, (Resource)usedResources), (Object)schedulerNode1.getUnallocatedResource());
        Assert.assertEquals((Object)usedResources, (Object)schedulerNode1.getAllocatedResource());
        Resource availableResources = Resources.subtract((Resource)nmResource, (Resource)usedResources);
        Map sa = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp = (SchedulerApplication)sa.get(recoveredApp1.getApplicationId());
        if (this.getSchedulerType() == ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            this.checkCSQueue(this.rm2, (SchedulerApplication<SchedulerApplicationAttempt>)schedulerApp, nmResource, nmResource, usedResources, 2);
        } else {
            this.checkFSQueue(this.rm2, schedulerApp, usedResources, availableResources, amResources);
        }
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(amContainer.getContainerId())));
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(runningContainer.getContainerId())));
        Assertions.assertThat((Comparable)schedulerAttempt.getCurrentConsumption()).isEqualTo((Object)usedResources);
        Assert.assertEquals((long)0x10000000001L, (long)schedulerAttempt.getNewContainerId());
    }

    private void checkCSQueue(MockRM rm, SchedulerApplication<SchedulerApplicationAttempt> app, Resource clusterResource, Resource queueResource, Resource usedResource, int numContainers) throws Exception {
        this.checkCSLeafQueue(rm, app, clusterResource, queueResource, usedResource, numContainers);
        LeafQueue queue = (LeafQueue)app.getQueue();
        Resource availableResources = Resources.subtract((Resource)queueResource, (Resource)usedResource);
        SchedulerApplicationAttempt schedulerAttempt = app.getCurrentAppAttempt();
        Assert.assertEquals((Object)availableResources, (Object)schedulerAttempt.getHeadroom());
        CSQueueMetrics queueMetrics = queue.getMetrics();
        this.assertMetrics((QueueMetrics)queueMetrics, 1, 0, 1, 0, 2, availableResources.getMemorySize(), availableResources.getVirtualCores(), usedResource.getMemorySize(), usedResource.getVirtualCores());
        QueueMetrics userMetrics = queueMetrics.getUserMetrics(app.getUser());
        this.assertMetrics(userMetrics, 1, 0, 1, 0, 2, availableResources.getMemorySize(), availableResources.getVirtualCores(), usedResource.getMemorySize(), usedResource.getVirtualCores());
    }

    private void checkCSLeafQueue(MockRM rm, SchedulerApplication<SchedulerApplicationAttempt> app, Resource clusterResource, Resource queueResource, Resource usedResource, int numContainers) {
        LeafQueue leafQueue = (LeafQueue)app.getQueue();
        Assert.assertEquals((Object)usedResource, (Object)leafQueue.getUsedResources());
        Assert.assertEquals((long)numContainers, (long)leafQueue.getNumContainers());
        ResourceCalculator calc = ((CapacityScheduler)rm.getResourceScheduler()).getResourceCalculator();
        float usedCapacity = Resources.divide((ResourceCalculator)calc, (Resource)clusterResource, (Resource)usedResource, (Resource)queueResource);
        Assert.assertEquals((double)usedCapacity, (double)leafQueue.getUsedCapacity(), (double)1.0E-8);
        float absoluteUsedCapacity = Resources.divide((ResourceCalculator)calc, (Resource)clusterResource, (Resource)usedResource, (Resource)clusterResource);
        Assert.assertEquals((double)absoluteUsedCapacity, (double)leafQueue.getAbsoluteUsedCapacity(), (double)1.0E-8);
        Assert.assertEquals((Object)usedResource, (Object)leafQueue.getUser(app.getUser()).getUsed());
    }

    private void checkFSQueue(ResourceManager rm, SchedulerApplication schedulerApp, Resource usedResources, Resource availableResources, Resource amResources) throws Exception {
        int retry = 0;
        Resource assumedFairShare = Resource.newInstance((int)8192, (int)8);
        while (true) {
            Thread.sleep(100L);
            if (assumedFairShare.equals((Object)((FairScheduler)rm.getResourceScheduler()).getQueueManager().getRootQueue().getFairShare())) break;
            if (++retry <= 30) continue;
            Assert.fail((String)"Apps are not scheduled within assumed timeout");
        }
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        FSParentQueue root = scheduler.getQueueManager().getRootQueue();
        Assert.assertTrue((boolean)(root.getPolicy() instanceof DominantResourceFairnessPolicy));
        Assert.assertEquals((Object)usedResources, (Object)root.getResourceUsage());
        FSAppAttempt schedulerAttempt = (FSAppAttempt)schedulerApp.getCurrentAppAttempt();
        Assert.assertEquals((Object)availableResources, (Object)schedulerAttempt.getHeadroom());
        QueueMetrics queueMetrics = scheduler.getRootQueueMetrics();
        this.assertMetrics(queueMetrics, 1, 0, 1, 0, 2, availableResources.getMemorySize(), availableResources.getVirtualCores(), usedResources.getMemorySize(), usedResources.getVirtualCores());
        Assert.assertEquals((Object)amResources, (Object)schedulerApp.getCurrentAppAttempt().getAMResource());
        FSQueueMetrics fsQueueMetrics = (FSQueueMetrics)schedulerApp.getQueue().getMetrics();
        Assert.assertEquals((long)amResources.getMemorySize(), (long)fsQueueMetrics.getAMResourceUsageMB());
        Assert.assertEquals((long)amResources.getVirtualCores(), (long)fsQueueMetrics.getAMResourceUsageVCores());
    }

    public static List<NMContainerStatus> createNMContainerStatusForApp(MockAM am) {
        ArrayList<NMContainerStatus> list = new ArrayList<NMContainerStatus>();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        list.add(amContainer);
        list.add(runningContainer);
        list.add(completedContainer);
        return list;
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{R});
        String Q_R = "root.Default";
        conf.setCapacity("root.Default", 100.0f);
        String Q_A = "root.Default.QueueA";
        String Q_B = "root.Default.QueueB";
        conf.setQueues("root.Default", new String[]{A, B});
        conf.setCapacity("root.Default.QueueA", 50.0f);
        conf.setCapacity("root.Default.QueueB", 50.0f);
        conf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", 0.5);
    }

    private void setupQueueConfigurationOnlyA(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{R});
        String Q_R = "root.Default";
        conf.setCapacity("root.Default", 100.0f);
        String Q_A = "root.Default.QueueA";
        conf.setQueues("root.Default", new String[]{A});
        conf.setCapacity("root.Default.QueueA", 100.0f);
        conf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", 1.0);
    }

    private void setupQueueConfigurationChildOfB(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{R});
        String Q_R = "root.Default";
        conf.setCapacity("root.Default", 100.0f);
        String Q_A = "root.Default.QueueA";
        String Q_B = "root.Default.QueueB";
        String Q_B1 = "root.Default.QueueB.QueueB1";
        String Q_B2 = "root.Default.QueueB.QueueB2";
        conf.setQueues("root.Default", new String[]{A, B});
        conf.setCapacity("root.Default.QueueA", 50.0f);
        conf.setCapacity("root.Default.QueueB", 50.0f);
        conf.setQueues("root.Default.QueueB", new String[]{B1, B2});
        conf.setCapacity("root.Default.QueueB.QueueB1", 50.0f);
        conf.setCapacity("root.Default.QueueB.QueueB2", 50.0f);
        conf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", 0.5);
    }

    @Test(timeout=30000L)
    public void testRMRestartWithRemovedQueue() throws Exception {
        this.conf.setBoolean("yarn.acl.enable", true);
        this.conf.set("yarn.admin.acl", "");
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1").withUser(USER_1).withAcls(null).build();
        final RMApp app1 = MockRMAppSubmitter.submit(this.rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        MockRM.finishAMAndVerifyAppState(app1, this.rm1, nm1, am1);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{QUEUE_DOESNT_EXIST});
        String noQueue = "root.NoSuchQueue";
        csConf.setCapacity("root.NoSuchQueue", 100.0f);
        this.rm2 = new MockRM((Configuration)csConf, (RMStateStore)memStore);
        this.rm2.start();
        UserGroupInformation user2 = UserGroupInformation.createRemoteUser((String)USER_2);
        ApplicationReport report = (ApplicationReport)user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

            @Override
            public ApplicationReport run() throws Exception {
                return TestWorkPreservingRMRestart.this.rm2.getApplicationReport(app1.getApplicationId());
            }
        });
        Assert.assertNotNull((Object)report);
    }

    @Test(timeout=30000L)
    public void testCapacitySchedulerRecovery() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            return;
        }
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfiguration(csConf);
        this.rm1 = new MockRM((Configuration)csConf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1_1").withUser(USER_1).withAcls(null).withQueue(A).withUnmanagedAM(false).build();
        RMApp app1_1 = MockRMAppSubmitter.submit(this.rm1, data2);
        MockAM am1_1 = MockRM.launchAndRegisterAM(app1_1, this.rm1, nm1);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1_2").withUser(USER_1).withAcls(null).withQueue(A).withUnmanagedAM(false).build();
        RMApp app1_2 = MockRMAppSubmitter.submit(this.rm1, data1);
        MockAM am1_2 = MockRM.launchAndRegisterAM(app1_2, this.rm1, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app2").withUser(USER_2).withAcls(null).withQueue(B).withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(this.rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, this.rm1, nm2);
        this.rm1.clearQueueMetrics(app1_1);
        this.rm1.clearQueueMetrics(app1_2);
        this.rm1.clearQueueMetrics(app2);
        csConf.set("yarn.scheduler.capacity.root.Default.QueueB.state", "STOPPED");
        this.rm2 = new MockRM((Configuration)csConf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        nm2.setResourceTrackerService(this.rm2.getResourceTrackerService());
        List<NMContainerStatus> am1_1Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am1_1);
        List<NMContainerStatus> am1_2Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am1_2);
        am1_1Containers.addAll(am1_2Containers);
        nm1.registerNode(am1_1Containers, null);
        List<NMContainerStatus> am2Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am2);
        nm2.registerNode(am2Containers, null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1_1.getApplicationAttemptId());
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1_2.getApplicationAttemptId());
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am2.getApplicationAttemptId());
        Resource containerResource = Resource.newInstance((int)1024, (int)1);
        Resource nmResource = Resource.newInstance((long)nm1.getMemory(), (int)nm1.getvCores());
        Resource clusterResource = Resources.multiply((Resource)nmResource, (double)2.0);
        Resource q1Resource = Resources.multiply((Resource)clusterResource, (double)0.5);
        Resource q2Resource = Resources.multiply((Resource)clusterResource, (double)0.5);
        Resource q1UsedResource = Resources.multiply((Resource)containerResource, (double)4.0);
        Resource q2UsedResource = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource totalUsedResource = Resources.add((Resource)q1UsedResource, (Resource)q2UsedResource);
        Resource q1availableResources = Resources.subtract((Resource)q1Resource, (Resource)q1UsedResource);
        Resource q2availableResources = Resources.subtract((Resource)q2Resource, (Resource)q2UsedResource);
        Resource totalAvailableResource = Resources.add((Resource)q1availableResources, (Resource)q2availableResources);
        Map schedulerApps = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp1_1 = (SchedulerApplication)schedulerApps.get(app1_1.getApplicationId());
        this.checkCSLeafQueue(this.rm2, (SchedulerApplication<SchedulerApplicationAttempt>)schedulerApp1_1, clusterResource, q1Resource, q1UsedResource, 4);
        QueueMetrics queue1Metrics = schedulerApp1_1.getQueue().getMetrics();
        this.assertMetrics(queue1Metrics, 2, 0, 2, 0, 4, q1availableResources.getMemorySize(), q1availableResources.getVirtualCores(), q1UsedResource.getMemorySize(), q1UsedResource.getVirtualCores());
        SchedulerApplication schedulerApp2 = (SchedulerApplication)schedulerApps.get(app2.getApplicationId());
        this.checkCSLeafQueue(this.rm2, (SchedulerApplication<SchedulerApplicationAttempt>)schedulerApp2, clusterResource, q2Resource, q2UsedResource, 2);
        QueueMetrics queue2Metrics = schedulerApp2.getQueue().getMetrics();
        this.assertMetrics(queue2Metrics, 1, 0, 1, 0, 2, q2availableResources.getMemorySize(), q2availableResources.getVirtualCores(), q2UsedResource.getMemorySize(), q2UsedResource.getVirtualCores());
        LeafQueue leafQueue = (LeafQueue)schedulerApp2.getQueue();
        ParentQueue parentQueue = (ParentQueue)leafQueue.getParent();
        this.checkParentQueue(parentQueue, 6, totalUsedResource, 0.375f, 0.375f);
        this.assertMetrics((QueueMetrics)parentQueue.getMetrics(), 3, 0, 3, 0, 6, totalAvailableResource.getMemorySize(), totalAvailableResource.getVirtualCores(), totalUsedResource.getMemorySize(), totalUsedResource.getVirtualCores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAppRecoveryWithWrongQueueConfig(CapacitySchedulerConfiguration csConf, RMApp app, String diagnostics, MockMemoryRMStateStore memStore, RMStateStore.RMState state) throws Exception {
        csConf.setBoolean("yarn.resourcemanager.fail-fast", false);
        csConf.setBoolean("yarn.scheduler.capacity.application.fail-fast", false);
        this.rm2 = new MockRM((Configuration)csConf, (RMStateStore)memStore);
        this.rm2.start();
        MockMemoryRMStateStore memStore2 = (MockMemoryRMStateStore)this.rm2.getRMStateStore();
        this.rm2.waitForState(app.getApplicationId(), RMAppState.KILLED);
        ApplicationReport report = this.rm2.getApplicationReport(app.getApplicationId());
        Assert.assertEquals((Object)report.getFinalApplicationStatus(), (Object)FinalApplicationStatus.KILLED);
        Assertions.assertThat((Comparable)report.getYarnApplicationState()).isEqualTo((Object)YarnApplicationState.KILLED);
        Assertions.assertThat((String)report.getDiagnostics()).isEqualTo((Object)diagnostics);
        RMStateStore.RMState newState = memStore2.reloadStateWithClonedAppSubCtxt(state);
        for (Map.Entry entry : newState.getApplicationState().entrySet()) {
            ApplicationStateData appState = (ApplicationStateData)Mockito.mock(ApplicationStateData.class);
            ApplicationSubmissionContext ctxt = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
            Mockito.when((Object)appState.getApplicationSubmissionContext()).thenReturn((Object)ctxt);
            Mockito.when((Object)ctxt.getApplicationId()).thenReturn(entry.getKey());
            memStore2.removeApplicationStateInternal(appState);
            memStore2.storeApplicationStateInternal((ApplicationId)entry.getKey(), (ApplicationStateData)entry.getValue());
        }
        csConf.setBoolean("yarn.resourcemanager.fail-fast", true);
        csConf.setBoolean("yarn.scheduler.capacity.application.fail-fast", true);
        try (MockRM rm = new MockRM((Configuration)csConf, (RMStateStore)memStore2);){
            rm.start();
            Assert.fail((String)"QueueException must have been thrown");
        }
    }

    @Test(timeout=30000L)
    public void testCapacityLeafQueueBecomesParentOnRecovery() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            return;
        }
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfiguration(csConf);
        this.rm1 = new MockRM((Configuration)csConf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm = new MockNM("127.1.1.1:4321", 8192, this.rm1.getResourceTrackerService());
        nm.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app").withUser(USER_2).withAcls(null).withQueue(B).withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(this.rm1, data);
        MockRM.launchAndRegisterAM(app, this.rm1, nm);
        Assert.assertEquals((Object)this.rm1.getApplicationReport(app.getApplicationId()).getYarnApplicationState(), (Object)YarnApplicationState.RUNNING);
        RMStateStore.RMState state = this.rm1.getRMStateStore().loadState();
        csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfigurationChildOfB(csConf);
        String diags = "Application killed on recovery as it was submitted to queue QueueB which is no longer a leaf queue after restart.";
        this.verifyAppRecoveryWithWrongQueueConfig(csConf, app, diags, memStore, state);
    }

    @Test(timeout=30000L)
    public void testCapacitySchedulerQueueRemovedRecovery() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            return;
        }
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfiguration(csConf);
        this.rm1 = new MockRM((Configuration)csConf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1_1").withUser(USER_1).withAcls(null).withQueue(A).withUnmanagedAM(false).build();
        RMApp app1_1 = MockRMAppSubmitter.submit(this.rm1, data2);
        MockAM am1_1 = MockRM.launchAndRegisterAM(app1_1, this.rm1, nm1);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1_2").withUser(USER_1).withAcls(null).withQueue(A).withUnmanagedAM(false).build();
        RMApp app1_2 = MockRMAppSubmitter.submit(this.rm1, data1);
        MockAM am1_2 = MockRM.launchAndRegisterAM(app1_2, this.rm1, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app2").withUser(USER_2).withAcls(null).withQueue(B).withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(this.rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, this.rm1, nm2);
        Assert.assertEquals((Object)this.rm1.getApplicationReport(app2.getApplicationId()).getYarnApplicationState(), (Object)YarnApplicationState.RUNNING);
        RMApp appNA = MockRMAppSubmitter.submit(this.rm1, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm1).withAppName("app1_2").withUser(USER_1).withAcls(null).withQueue(QUEUE_DOESNT_EXIST).withWaitForAppAcceptedState(false).build());
        this.rm1.clearQueueMetrics(app1_1);
        this.rm1.clearQueueMetrics(app1_2);
        this.rm1.clearQueueMetrics(app2);
        RMStateStore.RMState state = memStore.loadState();
        csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfigurationOnlyA(csConf);
        String diags = "Application killed on recovery as it was submitted to queue QueueB which no longer exists after restart.";
        this.verifyAppRecoveryWithWrongQueueConfig(csConf, app2, diags, memStore, state);
    }

    private void checkParentQueue(ParentQueue parentQueue, int numContainers, Resource usedResource, float UsedCapacity, float absoluteUsedCapacity) {
        Assert.assertEquals((long)numContainers, (long)parentQueue.getNumContainers());
        Assert.assertEquals((Object)usedResource, (Object)parentQueue.getUsedResources());
        Assert.assertEquals((double)UsedCapacity, (double)parentQueue.getUsedCapacity(), (double)1.0E-8);
        Assert.assertEquals((double)absoluteUsedCapacity, (double)parentQueue.getAbsoluteUsedCapacity(), (double)1.0E-8);
    }

    @Test(timeout=20000L)
    public void testAMfailedBetweenRMRestart() throws Exception {
        this.conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        this.rm2.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(3000L);
        ResourceScheduler scheduler = this.rm2.getResourceScheduler();
        Assert.assertNull((Object)scheduler.getRMContainer(runningContainer.getContainerId()));
        Assert.assertNull((Object)scheduler.getRMContainer(completedContainer.getContainerId()));
        this.rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8192, this.rm2.getResourceTrackerService());
        NMContainerStatus previousAttemptContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 4, ContainerState.RUNNING);
        nm2.registerNode(Arrays.asList(previousAttemptContainer), null);
        Thread.sleep(3000L);
        Assert.assertNull((Object)scheduler.getRMContainer(previousAttemptContainer.getContainerId()));
    }

    @Test(timeout=20000L)
    public void testContainersNotRecoveredForCompletedApps() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        MockRM.finishAMAndVerifyAppState(app1, this.rm1, nm1, am1);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(runningContainer, completedContainer), null);
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)recoveredApp1.getState());
        Thread.sleep(3000L);
        ResourceScheduler scheduler = this.rm2.getResourceScheduler();
        Assert.assertNull((Object)scheduler.getRMContainer(runningContainer.getContainerId()));
        Assert.assertNull((Object)scheduler.getRMContainer(completedContainer.getContainerId()));
    }

    @Test(timeout=600000L)
    public void testAppReregisterOnRMWorkPreservingRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am0 = MockRM.launchAM(app0, this.rm1, nm1);
        am0.registerAppAttempt();
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.LAUNCHED);
        am0.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService(), this.rm2.getRMContext());
        am0.registerAppAttempt(true);
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.RUNNING);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
    }

    @Test(timeout=30000L)
    public void testAMContainerStatusWithRMRestart() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1_1 = MockRMAppSubmitter.submitWithMemory(1024L, this.rm1);
        MockAM am1_1 = MockRM.launchAndRegisterAM(app1_1, this.rm1, nm1);
        RMAppAttempt attempt0 = app1_1.getCurrentAppAttempt();
        ResourceScheduler scheduler = this.rm1.getResourceScheduler();
        Assert.assertTrue((boolean)scheduler.getRMContainer(attempt0.getMasterContainer().getId()).isAMContainer());
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        List<NMContainerStatus> am1_1Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am1_1);
        nm1.registerNode(am1_1Containers, null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1_1.getApplicationAttemptId());
        scheduler = this.rm2.getResourceScheduler();
        Assert.assertTrue((boolean)scheduler.getRMContainer(attempt0.getMasterContainer().getId()).isAMContainer());
    }

    @Test(timeout=20000L)
    public void testRecoverSchedulerAppAndAttemptSynchronously() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am0 = MockRM.launchAndRegisterAM(app0, this.rm1, nm1);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        Assert.assertNotNull((Object)this.rm2.getResourceScheduler().getSchedulerAppInfo(am0.getApplicationAttemptId()));
        this.rm2.getResourceScheduler().getTransferredContainers(am0.getApplicationAttemptId());
        List<NMContainerStatus> containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am0);
        nm1.registerNode(containers, null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am0.getApplicationAttemptId());
    }

    @Test(timeout=50000L)
    public void testReleasedContainerNotRecovered() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        MockNM nm1 = new MockNM("h1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        this.rm1.start();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, this.rm1);
        final MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.conf.setInt("yarn.nm.liveness-monitor.expiry-interval-ms", 8000);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        this.rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        am1.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService(), this.rm2.getRMContext());
        am1.registerAppAttempt(true);
        final ContainerId runningContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        am1.allocate(null, Arrays.asList(runningContainer));
        List<NMContainerStatus> containerStatuses = TestWorkPreservingRMRestart.createNMContainerStatusForApp(am1);
        nm1.registerNode(containerStatuses, null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(1, this.rm2, am1.getApplicationAttemptId());
        final AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        AllocateResponse response = am1.allocate(null, null);
        boolean receivedCompletedContainer = false;
        for (ContainerStatus status : response.getCompletedContainersStatuses()) {
            if (!status.getContainerId().equals((Object)runningContainer)) continue;
            receivedCompletedContainer = true;
        }
        Assert.assertTrue((boolean)receivedCompletedContainer);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return scheduler.getApplicationAttempt(am1.getApplicationAttemptId()).getPendingRelease().isEmpty() && scheduler.getRMContainer(runningContainer) == null;
            }
        }, (long)1000L, (long)20000L);
    }

    private void assertMetrics(QueueMetrics qm, int appsSubmitted, int appsPending, int appsRunning, int appsCompleted, int allocatedContainers, long availableMB, long availableVirtualCores, long allocatedMB, long allocatedVirtualCores) {
        Assert.assertEquals((long)appsSubmitted, (long)qm.getAppsSubmitted());
        Assert.assertEquals((long)appsPending, (long)qm.getAppsPending());
        Assert.assertEquals((long)appsRunning, (long)qm.getAppsRunning());
        Assert.assertEquals((long)appsCompleted, (long)qm.getAppsCompleted());
        Assert.assertEquals((long)allocatedContainers, (long)qm.getAllocatedContainers());
        Assert.assertEquals((long)availableMB, (long)qm.getAvailableMB());
        Assert.assertEquals((long)availableVirtualCores, (long)qm.getAvailableVirtualCores());
        Assert.assertEquals((long)allocatedMB, (long)qm.getAllocatedMB());
        Assert.assertEquals((long)allocatedVirtualCores, (long)qm.getAllocatedVirtualCores());
    }

    public static void waitForNumContainersToRecover(int num, MockRM rm, ApplicationAttemptId attemptId) throws Exception {
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplicationAttempt attempt = scheduler.getApplicationAttempt(attemptId);
        while (attempt == null) {
            System.out.println("Wait for scheduler attempt " + attemptId + " to be created");
            Thread.sleep(200L);
            attempt = scheduler.getApplicationAttempt(attemptId);
        }
        while (attempt.getLiveContainers().size() < num) {
            System.out.println("Wait for " + num + " containers to recover. currently: " + attempt.getLiveContainers().size());
            Thread.sleep(200L);
        }
    }

    @Test(timeout=20000L)
    public void testNewContainersNotAllocatedDuringSchedulerRecovery() throws Exception {
        this.conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 4000L);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        nm1.registerNode();
        ControlledClock clock = new ControlledClock();
        long startTime = System.currentTimeMillis();
        ((RMContextImpl)this.rm2.getRMContext()).setSystemClock((Clock)clock);
        am1.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService(), this.rm2.getRMContext());
        am1.registerAppAttempt(true);
        this.rm2.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        am1.allocate("127.0.0.1", 1000, 1, new ArrayList<ContainerId>());
        ArrayList containers = new ArrayList();
        clock.setTime(startTime + 2000L);
        nm1.nodeHeartbeat(true);
        Thread.sleep(3000L);
        containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
        Assert.assertTrue((boolean)containers.isEmpty());
        clock.setTime(startTime + 8000L);
        nm1.nodeHeartbeat(true);
        while (containers.isEmpty()) {
            containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
    }

    @Test(timeout=20000L)
    public void testRetriedFinishApplicationMasterRequest() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am0 = MockRM.launchAM(app0, this.rm1, nm1);
        am0.registerAppAttempt();
        MockRM.finishAMAndVerifyAppState(app0, this.rm1, nm1, am0);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        am0.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService(), this.rm2.getRMContext());
        am0.unregisterAppAttempt(false);
    }

    @Test(timeout=30000L)
    public void testAppFailedToRenewTokenOnRecovery() throws Exception {
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        TestRMRestart.TestSecurityMockRM rm1 = new TestRMRestart.TestSecurityMockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        TestRMRestart.TestSecurityMockRM rm2 = new TestRMRestart.TestSecurityMockRM((Configuration)this.conf, rm1.getRMStateStore()){

            protected DelegationTokenRenewer createDelegationTokenRenewer() {
                return new DelegationTokenRenewer(){

                    public void addApplicationSync(ApplicationId applicationId, Credentials ts, boolean shouldCancelAtEnd, String user) throws IOException {
                        throw new IOException("Token renew failed !!");
                    }
                };
            }
        };
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        rm2.start();
        NMContainerStatus containerStatus = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        nm1.registerNode(Arrays.asList(containerStatus), null);
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        am1.setAMRMProtocol((ApplicationMasterProtocol)rm2.getApplicationMasterService(), rm2.getRMContext());
        am1.registerAppAttempt(true);
        rm2.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm2.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm2.waitForState(app1.getApplicationId(), RMAppState.FAILED);
    }

    @Test(timeout=30000L)
    public void testAppFailToValidateResourceRequestOnRecovery() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 50);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 100);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        this.rm2.start();
    }

    @Test(timeout=20000L)
    public void testContainerCompleteMsgNotLostAfterAMFailedAndRMRestart() throws Exception {
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize(200L);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithResource(resource, this.rm1).withKeepContainers(true).withMaxAppAttempts(2).build();
        RMApp app0 = MockRMAppSubmitter.submit(this.rm1, data);
        MockAM am0 = MockRM.launchAndRegisterAM(app0, this.rm1, nm1);
        am0.allocate("127.0.0.1", 1000, 2, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List conts = am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() < 2) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(100L);
        }
        nm1.nodeHeartbeat(am0.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        this.rm1.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am1 = MockRM.launchAndRegisterAM(app0, this.rm1, nm1);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 2, ContainerState.COMPLETE);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 3, ContainerState.RUNNING);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        Thread.sleep(200L);
        RMApp recoveredApp0 = (RMApp)this.rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        RMAppAttempt loadedAttempt1 = recoveredApp0.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)loadedAttempt1.getJustFinishedContainers().size());
    }

    @Test(timeout=20000L)
    public void testAppStateSavedButAttemptStateNotSaved() throws Exception {
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){

            public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptState) {
            }
        };
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        MockRM.finishAMAndVerifyAppState(app1, this.rm1, nm1, am1);
        ApplicationStateData appSavedState = (ApplicationStateData)memStore.getState().getApplicationState().get(app1.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)appSavedState.getState());
        Assert.assertNull((Object)appSavedState.getAttempt(am1.getApplicationAttemptId()).getState());
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)recoveredApp1.getState());
        Assert.assertEquals((Object)RMAppAttemptState.FINISHED, (Object)recoveredApp1.getCurrentAppAttempt().getState());
    }

    @Test(timeout=600000L)
    public void testUAMRecoveryOnRMWorkPreservingRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)this.rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, this.rm1).withUnmanagedAM(true).build();
        RMApp app0 = MockRMAppSubmitter.submit(this.rm1, data);
        MockAM am0 = MockRM.launchUAM(app0, this.rm1, nm1);
        am0.registerAppAttempt();
        int numContainers = 2;
        am0.allocate("127.0.0.1", 1000, numContainers, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List conts = am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() < 2) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(100L);
        }
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        MockMemoryRMStateStore memStore2 = (MockMemoryRMStateStore)this.rm2.getRMStateStore();
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.LAUNCHED);
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        RMApp recoveredApp = (RMApp)this.rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        NMContainerStatus container1 = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus container2 = TestRMRestart.createNMContainerStatus(am0.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        nm1.registerNode(Arrays.asList(container1, container2), null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am0.getApplicationAttemptId());
        am0.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService(), this.rm2.getRMContext());
        am0.registerAppAttempt(true);
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.RUNNING);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        Map schedulerApps = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp = (SchedulerApplication)schedulerApps.get(recoveredApp.getApplicationId());
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertEquals((long)numContainers, (long)schedulerAttempt.getLiveContainers().size());
        Assert.assertNotNull((Object)am0.doHeartbeat());
        am0.unregisterAppAttempt(false);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.FINISHED);
        Assert.assertEquals((Object)FinalApplicationStatus.SUCCEEDED, (Object)recoveredApp.getFinalApplicationStatus());
        MockRM rm3 = new MockRM((Configuration)this.conf, (RMStateStore)memStore2);
        rm3.start();
        recoveredApp = (RMApp)rm3.getRMContext().getRMApps().get(app0.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)recoveredApp.getState());
    }

    @Test(timeout=30000L)
    public void testUnknownUserOnRecovery() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm1.getRMStateStore();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withUnmanagedAM(true).build();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am0 = MockRM.launchUAM(app0, rm1, nm1);
        am0.registerAppAttempt();
        rm1.killApp(app0.getApplicationId());
        final PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doThrow((Throwable[])new Throwable[]{new YarnException("No groups for user")}).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)ArgumentMatchers.any(ApplicationSubmissionContext.class), (String)ArgumentMatchers.any(String.class));
        MockRM rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore){

            protected RMAppManager createRMAppManager() {
                return new RMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, (Configuration)TestWorkPreservingRMRestart.this.conf){

                    ApplicationPlacementContext placeApplication(PlacementManager placementManager, ApplicationSubmissionContext context, String user, boolean isRecovery) throws YarnException {
                        return super.placeApplication(placementMgr, context, user, isRecovery);
                    }
                };
            }
        };
        rm2.start();
        RMApp recoveredApp = (RMApp)rm2.getRMContext().getRMApps().get(app0.getApplicationId());
        Assert.assertEquals((Object)RMAppState.KILLED, (Object)recoveredApp.getState());
    }

    @Test(timeout=30000L)
    public void testDynamicAutoCreatedQueueRecoveryWithDefaultQueue() throws Exception {
        this.testDynamicAutoCreatedQueueRecovery("user_1", null);
    }

    @Test(timeout=30000L)
    public void testDynamicAutoCreatedQueueRecoveryWithOverrideQueueMappingFlag() throws Exception {
        this.testDynamicAutoCreatedQueueRecovery("user_1", "user_1");
    }

    public void testDynamicAutoCreatedQueueRecovery(String user, String queueName) throws Exception {
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.conf.setBoolean("yarn.resourcemanager.fail-fast", true);
        CapacitySchedulerConfiguration schedulerConf = null;
        schedulerConf = queueName == null || queueName.equals("default") ? this.getSchedulerAutoCreatedQueueConfiguration(false) : this.getSchedulerAutoCreatedQueueConfiguration(true);
        int containerMemory = 1024;
        Resource containerResource = Resource.newInstance((int)containerMemory, (int)1);
        this.rm1 = new MockRM((Configuration)schedulerConf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, this.rm1).withAppName("autoCreatedQApp").withUser(user).withAcls(null).withQueue(queueName).withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(this.rm1, data);
        Resource amResources = ((ResourceRequest)app1.getAMResourceRequests().get(0)).getCapability();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm1, nm1);
        this.rm1.clearQueueMetrics(app1);
        this.rm2 = new MockRM((Configuration)schedulerConf, this.rm1.getRMStateStore());
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = recoveredApp1.getCurrentAppAttempt();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 1, ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 2, ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus(am1.getApplicationAttemptId(), 3, ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        TestWorkPreservingRMRestart.waitForNumContainersToRecover(2, this.rm2, am1.getApplicationAttemptId());
        Set launchedContainers = ((RMNodeImpl)this.rm2.getRMContext().getRMNodes().get(nm1.getNodeId())).getLaunchedContainers();
        Assert.assertTrue((boolean)launchedContainers.contains(amContainer.getContainerId()));
        Assert.assertTrue((boolean)launchedContainers.contains(runningContainer.getContainerId()));
        this.rm2.waitForState(nm1, amContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForState(nm1, runningContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForContainerToComplete(loadedAttempt1, completedContainer);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        SchedulerNode schedulerNode1 = scheduler.getSchedulerNode(nm1.getNodeId());
        Resource usedResources = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource nmResource = Resource.newInstance((long)nm1.getMemory(), (int)nm1.getvCores());
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(amContainer.getContainerId()));
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(runningContainer.getContainerId()));
        Assert.assertFalse((boolean)schedulerNode1.isValidContainer(completedContainer.getContainerId()));
        Assert.assertEquals((long)2L, (long)schedulerNode1.getNumContainers());
        Assert.assertEquals((Object)Resources.subtract((Resource)nmResource, (Resource)usedResources), (Object)schedulerNode1.getUnallocatedResource());
        Assert.assertEquals((Object)usedResources, (Object)schedulerNode1.getAllocatedResource());
        Map sa = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp = (SchedulerApplication)sa.get(recoveredApp1.getApplicationId());
        if (this.getSchedulerType() == ParameterizedSchedulerTestBase.SchedulerType.CAPACITY) {
            this.checkCSQueue(this.rm2, (SchedulerApplication<SchedulerApplicationAttempt>)schedulerApp, nmResource, nmResource, usedResources, 2);
        }
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(amContainer.getContainerId())));
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(runningContainer.getContainerId())));
        Assertions.assertThat((Comparable)schedulerAttempt.getCurrentConsumption()).isEqualTo((Object)usedResources);
        Assert.assertEquals((long)0x10000000001L, (long)schedulerAttempt.getNewContainerId());
    }

    @Test(timeout=20000L)
    public void testFairSchedulerCompletedAppsQueue() throws Exception {
        if (this.getSchedulerType() != ParameterizedSchedulerTestBase.SchedulerType.FAIR) {
            return;
        }
        this.rm1 = new MockRM((Configuration)this.conf);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app = MockRMAppSubmitter.submitWithMemory(200L, this.rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app, this.rm1, nm1);
        MockRM.finishAMAndVerifyAppState(app, this.rm1, nm1, am1);
        String fsQueueContext = app.getApplicationSubmissionContext().getQueue();
        String fsQueueApp = app.getQueue();
        Assert.assertEquals((String)"Queue in app not equal to submission context", (Object)fsQueueApp, (Object)fsQueueContext);
        RMAppAttempt rmAttempt = app.getCurrentAppAttempt();
        Assert.assertNotNull((String)"No AppAttempt found", (Object)rmAttempt);
        this.rm2 = new MockRM((Configuration)this.conf, this.rm1.getRMStateStore());
        this.rm2.start();
        RMApp recoveredApp = (RMApp)this.rm2.getRMContext().getRMApps().get(app.getApplicationId());
        RMAppAttempt rmAttemptRecovered = recoveredApp.getCurrentAppAttempt();
        Assert.assertNotNull((String)"No AppAttempt found after recovery", (Object)rmAttemptRecovered);
        String fsQueueContextRecovered = recoveredApp.getApplicationSubmissionContext().getQueue();
        String fsQueueAppRecovered = recoveredApp.getQueue();
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)recoveredApp.getState());
        Assert.assertEquals((String)"Recovered app queue is not the same as context queue", (Object)fsQueueAppRecovered, (Object)fsQueueContextRecovered);
    }
}

