/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.UnknownHostException;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreHeartbeat;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFederationRMStateStoreService {
    private final HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
    private final SubClusterId subClusterId = SubClusterId.newInstance((String)"SC-1");
    private final GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)this.subClusterId);
    private Configuration conf;
    private FederationStateStore stateStore;
    private long lastHearbeatTS = 0L;
    private JSONJAXBContext jc;
    private JSONUnmarshaller unmarshaller;

    @Before
    public void setUp() throws IOException, YarnException, JAXBException {
        this.conf = new YarnConfiguration();
        this.jc = new JSONJAXBContext(JSONConfiguration.mapped().rootUnwrapping(false).build(), new Class[]{ClusterMetricsInfo.class});
        this.unmarshaller = this.jc.createJSONUnmarshaller();
    }

    @After
    public void tearDown() throws Exception {
        this.unmarshaller = null;
        this.jc = null;
    }

    @Test
    public void testFederationStateStoreService() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(this.request);
        Assert.assertNull((Object)response);
        rm.start();
        String capability = this.checkSubClusterInfo(SubClusterState.SC_NEW);
        Assert.assertTrue((boolean)capability.isEmpty());
        FederationStateStoreHeartbeat storeHeartbeat = rm.getFederationStateStoreService().getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 0);
        rm.registerNode("127.0.0.1:1234", 4096);
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 1);
        rm.getFederationStateStoreService().deregisterSubCluster(SubClusterDeregisterRequest.newInstance((SubClusterId)this.subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED));
        this.checkSubClusterInfo(SubClusterState.SC_UNREGISTERED);
        this.explicitFailover(rm);
        capability = this.checkSubClusterInfo(SubClusterState.SC_NEW);
        Assert.assertTrue((boolean)capability.isEmpty());
        storeHeartbeat = rm.getFederationStateStoreService().getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 0);
        rm.registerNode("127.0.0.1:1234", 4096);
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 1);
        rm.stop();
    }

    private void explicitFailover(MockRM rm) throws IOException {
        rm.getAdminService().transitionToStandby(this.requestInfo);
        Assert.assertTrue((rm.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
        rm.getAdminService().transitionToActive(this.requestInfo);
        Assert.assertTrue((rm.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
        this.lastHearbeatTS = 0L;
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
    }

    private void checkClusterMetricsInfo(String capability, int numNodes) throws JAXBException {
        ClusterMetricsInfo clusterMetricsInfo = (ClusterMetricsInfo)this.unmarshaller.unmarshalFromJSON((Reader)new StringReader(capability), ClusterMetricsInfo.class);
        Assert.assertEquals((long)numNodes, (long)clusterMetricsInfo.getTotalNodes());
    }

    private String checkSubClusterInfo(SubClusterState state) throws YarnException, UnknownHostException {
        Assert.assertNotNull((Object)this.stateStore.getSubCluster(this.request));
        SubClusterInfo response = this.stateStore.getSubCluster(this.request).getSubClusterInfo();
        Assert.assertEquals((Object)state, (Object)response.getState());
        Assert.assertTrue((response.getLastHeartBeat() >= this.lastHearbeatTS ? 1 : 0) != 0);
        String expectedAddress = response.getClientRMServiceAddress().split(":")[0];
        Assert.assertEquals((Object)expectedAddress, (Object)response.getAMRMServiceAddress().split(":")[0]);
        Assert.assertEquals((Object)expectedAddress, (Object)response.getRMAdminServiceAddress().split(":")[0]);
        Assert.assertEquals((Object)expectedAddress, (Object)response.getRMWebServiceAddress().split(":")[0]);
        this.lastHearbeatTS = response.getLastHeartBeat();
        return response.getCapability();
    }
}

