/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ContainerSpecification;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.MockContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockApplication {
    private static final Logger LOG = LoggerFactory.getLogger(MockApplication.class);
    private List<RMContainer> liveContainers = new ArrayList<RMContainer>();
    private List<RMContainer> reservedContainers = new ArrayList<RMContainer>();
    private ApplicationId appId;
    final String containersConfig;
    final String queueName;
    ApplicationAttemptId appAttemptId;
    FiCaSchedulerApp app;

    MockApplication(int id, String containersConfig, String queueName) {
        this.appId = ApplicationId.newInstance((long)0L, (int)id);
        this.containersConfig = containersConfig;
        this.queueName = queueName;
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        this.setupInitialMocking(queueName);
    }

    private void setupInitialMocking(String queueName) {
        this.app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)this.app.getAMResource(ArgumentMatchers.anyString())).thenReturn((Object)Resources.createResource((int)0, (int)0));
        Mockito.when((Object)this.app.getLiveContainers()).thenReturn(this.liveContainers);
        Mockito.when((Object)this.app.getReservedContainers()).thenReturn(this.reservedContainers);
        Mockito.when((Object)this.app.getApplicationAttemptId()).thenReturn((Object)this.appAttemptId);
        Mockito.when((Object)this.app.getApplicationId()).thenReturn((Object)this.appId);
        Mockito.when((Object)this.app.getQueueName()).thenReturn((Object)queueName);
    }

    private void addLiveContainer(RMContainer c) {
        this.liveContainers.add(c);
    }

    private void addReservedContainer(RMContainer c) {
        this.reservedContainers.add(c);
    }

    void addMockContainer(MockContainer mockContainer, FiCaSchedulerNode schedulerNode, LeafQueue queue) {
        int containerId = mockContainer.containerId;
        ContainerSpecification containerSpec = mockContainer.containerSpec;
        if (containerId == 1) {
            Mockito.when((Object)this.app.getAMResource(containerSpec.label)).thenReturn((Object)containerSpec.resource);
            Mockito.when((Object)this.app.getAppAMNodePartitionName()).thenReturn((Object)containerSpec.label);
        }
        if (containerSpec.reserved) {
            this.addReservedContainer((RMContainer)mockContainer.rmContainerMock);
        } else {
            this.addLiveContainer((RMContainer)mockContainer.rmContainerMock);
        }
        this.addContainerToSchedulerNode((SchedulerNode)schedulerNode, (RMContainer)mockContainer.rmContainerMock, containerSpec.reserved);
        String partition = null;
        if (containerSpec.label.isEmpty() && !(partition = schedulerNode.getPartition()).isEmpty()) {
            Map ignoreExclusivityContainers = queue.getIgnoreExclusivityRMContainers();
            if (!ignoreExclusivityContainers.containsKey(partition)) {
                ignoreExclusivityContainers.put(partition, new TreeSet());
            }
            ((TreeSet)ignoreExclusivityContainers.get(partition)).add(mockContainer.rmContainerMock);
            LOG.info("Added an ignore-exclusivity container to partition {}, new size is: {}", (Object)partition, (Object)((TreeSet)ignoreExclusivityContainers.get(partition)).size());
        }
        LOG.debug("add container to app=" + this.appAttemptId + " res=" + containerSpec.resource + " node=" + containerSpec.nodeId + " nodeLabelExpression=" + containerSpec.label + " partition=" + partition);
    }

    void addAggregatedContainerData(ContainerSpecification containerSpec, Resource usedResources) {
        if (containerSpec.repeat == 0) {
            Mockito.when((Object)this.app.getAppAMNodePartitionName()).thenReturn((Object)containerSpec.label);
        }
        Mockito.when((Object)this.app.getPriority()).thenReturn((Object)containerSpec.priority);
        Mockito.when((Object)this.app.getUser()).thenReturn((Object)containerSpec.username);
        Mockito.when((Object)this.app.getCurrentConsumption()).thenReturn((Object)usedResources);
        Mockito.when((Object)this.app.getCurrentReservation()).thenReturn((Object)Resources.createResource((int)0, (int)0));
        HashMap<String, Resource> pendingForDefaultPartition = new HashMap<String, Resource>();
        pendingForDefaultPartition.put(containerSpec.label, containerSpec.pendingResource);
        Mockito.when((Object)this.app.getTotalPendingRequestsPerPartition()).thenReturn(pendingForDefaultPartition);
        ResourceUsage ru = (ResourceUsage)Mockito.spy((Object)new ResourceUsage());
        ru.setUsed(containerSpec.label, usedResources);
        Mockito.when((Object)ru.getCachedUsed(ArgumentMatchers.anyString())).thenReturn((Object)usedResources);
        Mockito.when((Object)this.app.getAppAttemptResourceUsage()).thenReturn((Object)ru);
        Mockito.when((Object)this.app.getSchedulingResourceUsage()).thenReturn((Object)ru);
    }

    private void addContainerToSchedulerNode(SchedulerNode node, RMContainer container, boolean isReserved) {
        assert (node != null);
        if (isReserved) {
            Mockito.when((Object)node.getReservedContainer()).thenReturn((Object)container);
        } else {
            node.getCopiedListOfRunningContainers().add(container);
            Resources.subtractFrom((Resource)node.getUnallocatedResource(), (Resource)container.getAllocatedResource());
        }
    }
}

