/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.preprocessor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.ContextProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.NodeLabelProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.QueueProcessor;
import org.apache.hadoop.yarn.server.resourcemanager.preprocessor.TagAddProcessor;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestContextProcessor {
    @Test
    public void testContextProcessor() {
        HashMap<Object, String> contextProcessorsAndValues = new HashMap<Object, String>();
        contextProcessorsAndValues.put(new NodeLabelProcessor(), "foo");
        contextProcessorsAndValues.put(new QueueProcessor(), "queue1");
        contextProcessorsAndValues.put(new TagAddProcessor(), "cluster:cluster1");
        ApplicationId app = ApplicationId.newInstance((long)123456L, (int)111);
        ApplicationSubmissionContext applicationSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        for (Map.Entry entry : contextProcessorsAndValues.entrySet()) {
            ((ContextProcessor)entry.getKey()).process("host.cluster2.com", (String)entry.getValue(), app, applicationSubmissionContext);
        }
        HashSet<String> applicationTags = new HashSet<String>();
        applicationTags.add("cluster:cluster1");
        ((ApplicationSubmissionContext)Mockito.verify((Object)applicationSubmissionContext, (VerificationMode)Mockito.times((int)1))).setNodeLabelExpression("foo");
        ((ApplicationSubmissionContext)Mockito.verify((Object)applicationSubmissionContext, (VerificationMode)Mockito.times((int)1))).setQueue("queue1");
        ((ApplicationSubmissionContext)Mockito.verify((Object)applicationSubmissionContext, (VerificationMode)Mockito.times((int)1))).setApplicationTags(applicationTags);
    }
}

