/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestAbsoluteResourceConfiguration {
    private static final int GB = 1024;
    private static final float DELTA = 0.001f;
    private static final String QUEUEA = "queueA";
    private static final String QUEUEB = "queueB";
    private static final String QUEUEC = "queueC";
    private static final String QUEUEA1 = "queueA1";
    private static final String QUEUEA2 = "queueA2";
    private static final String QUEUEB1 = "queueB1";
    private static final String QUEUEA_FULL = "root.queueA";
    private static final String QUEUEB_FULL = "root.queueB";
    private static final String QUEUEC_FULL = "root.queueC";
    private static final String QUEUEA1_FULL = "root.queueA.queueA1";
    private static final String QUEUEA2_FULL = "root.queueA.queueA2";
    private static final String QUEUEB1_FULL = "root.queueB.queueB1";
    private static final Resource QUEUE_A_MINRES = Resource.newInstance((int)102400, (int)10);
    private static final Resource QUEUE_A_MAXRES = Resource.newInstance((int)204800, (int)30);
    private static final Resource QUEUE_A1_MINRES = Resource.newInstance((int)51200, (int)5);
    private static final Resource QUEUE_A2_MINRES = Resource.newInstance((int)51200, (int)5);
    private static final Resource QUEUE_B_MINRES = Resource.newInstance((int)51200, (int)10);
    private static final Resource QUEUE_B1_MINRES = Resource.newInstance((int)40960, (int)10);
    private static final Resource QUEUE_B_MAXRES = Resource.newInstance((int)153600, (int)30);
    private static final Resource QUEUE_C_MINRES = Resource.newInstance((int)51200, (int)10);
    private static final Resource QUEUE_C_MAXRES = Resource.newInstance((int)153600, (int)20);
    private static final Resource QUEUEA_REDUCED = Resource.newInstance((int)64000, (int)6);
    private static final Resource QUEUEB_REDUCED = Resource.newInstance((int)32000, (int)6);
    private static final Resource QUEUEC_REDUCED = Resource.newInstance((int)32000, (int)6);
    private static final Resource QUEUEMAX_REDUCED = Resource.newInstance((int)128000, (int)20);
    private static Set<String> resourceTypes = new HashSet<String>(Arrays.asList("memory", "vcores"));

    private CapacitySchedulerConfiguration setupSimpleQueueConfiguration(boolean isCapacityNeeded) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC});
        if (isCapacityNeeded) {
            csConf.setCapacity(QUEUEA_FULL, 50.0f);
            csConf.setCapacity(QUEUEB_FULL, 25.0f);
            csConf.setCapacity(QUEUEC_FULL, 25.0f);
        }
        return csConf;
    }

    private CapacitySchedulerConfiguration setupComplexQueueConfiguration(boolean isCapacityNeeded) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC});
        csConf.setQueues(QUEUEA_FULL, new String[]{QUEUEA1, QUEUEA2});
        csConf.setQueues(QUEUEB_FULL, new String[]{QUEUEB1});
        if (isCapacityNeeded) {
            csConf.setCapacity(QUEUEA_FULL, 50.0f);
            csConf.setCapacity(QUEUEB_FULL, 25.0f);
            csConf.setCapacity(QUEUEC_FULL, 25.0f);
            csConf.setCapacity(QUEUEA1_FULL, 50.0f);
            csConf.setCapacity(QUEUEA2_FULL, 50.0f);
            csConf.setCapacity(QUEUEB1_FULL, 100.0f);
        }
        return csConf;
    }

    private CapacitySchedulerConfiguration setupMinMaxResourceConfiguration(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MINRES);
        csConf.setMaximumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MAXRES);
        return csConf;
    }

    private CapacitySchedulerConfiguration setupComplexMinMaxResourceConfig(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEA1_FULL, QUEUE_A1_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEA2_FULL, QUEUE_A2_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB1_FULL, QUEUE_B1_MINRES);
        csConf.setMaximumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MAXRES);
        return csConf;
    }

    @Test
    public void testSimpleMinMaxResourceConfigurartionPerQueue() {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(true);
        this.setupMinMaxResourceConfiguration(csConf);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEA_FULL, resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEA_FULL, resourceTypes));
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEB_FULL, resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEB_FULL, resourceTypes));
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEC_FULL, resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEC_FULL, resourceTypes));
    }

    @Test
    public void testEffectiveMinMaxResourceConfigurartionPerQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA = (LeafQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qB = (LeafQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        rm.stop();
    }

    @Test
    public void testSimpleValidateAbsoluteResourceConfig() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CapacitySchedulerConfiguration csConf1 = this.setupSimpleQueueConfiguration(true);
        this.setupMinMaxResourceConfiguration(csConf1);
        try {
            cs.reinitialize((Configuration)csConf1, rm.getRMContext());
        }
        catch (IOException e) {
            Assert.fail();
        }
        rm.stop();
        CapacitySchedulerConfiguration csConf2 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf2);
        rm = new MockRM((Configuration)csConf2);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA1 = (LeafQueue)cs.getQueue(QUEUEA1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qA2 = (LeafQueue)cs.getQueue(QUEUEA2);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qB1 = (LeafQueue)cs.getQueue(QUEUEB1);
        Assert.assertNotNull((Object)qB1);
        Assert.assertEquals((String)"Min resource configured for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        CapacitySchedulerConfiguration csConf3 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf3);
        csConf3.setMinimumResourceRequirement("", QUEUEB1_FULL, QUEUE_B_MAXRES);
        csConf3.setMaximumResourceRequirement("", QUEUEB1_FULL, QUEUE_B1_MINRES);
        try {
            cs.reinitialize((Configuration)csConf3, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Min resource configuration <memory:153600, vCores:30> is greater than its max value:<memory:40960, vCores:10> in queue:root.queueB.queueB1", (Object)e.getMessage());
        }
        CapacitySchedulerConfiguration csConf4 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf4);
        csConf4.setMaximumResourceRequirement("", QUEUEB1_FULL, QUEUE_A_MAXRES);
        try {
            cs.reinitialize((Configuration)csConf4, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Max resource configuration <memory:204800, vCores:30> is greater than parents max value:<memory:153600, vCores:30> in queue:root.queueB.queueB1", (Object)e.getMessage());
        }
        rm.stop();
    }

    @Test
    public void testComplexValidateAbsoluteResourceConfig() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        csConf.setCapacity(QUEUEA_FULL, 50.0f);
        csConf.setCapacity(QUEUEB_FULL, 25.0f);
        csConf.setCapacity(QUEUEC_FULL, 25.0f);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        try {
            cs.reinitialize((Configuration)csConf, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Parent queue 'root.queueA' and child queue 'root.queueA.queueA1' should use either percentage based capacity configuration or absolute resource together.", (Object)e.getMessage());
        }
        CapacitySchedulerConfiguration csConf1 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf1);
        csConf1.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A1_MINRES);
        try {
            cs.reinitialize((Configuration)csConf1, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Parent Queues capacity: <memory:51200, vCores:5> is less than to its children:<memory:102400, vCores:10> for queue:queueA", (Object)e.getMessage());
        }
    }

    @Test
    public void testEffectiveResourceAfterReducingClusterResource() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 128000, 20);
        rm.registerNode("127.0.0.2:1234", 128000, 20);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA = (LeafQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qB = (LeafQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        rm.unRegisterNode(nm1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUEA_REDUCED, (Object)qA.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUEMAX_REDUCED, (Object)qA.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUEB_REDUCED, (Object)qB.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUEMAX_REDUCED, (Object)qB.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUEC_REDUCED, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUEMAX_REDUCED, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        rm.stop();
    }

    @Test
    public void testEffectiveResourceAfterIncreasingClusterResource() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 128000, 20);
        rm.registerNode("127.0.0.2:1234", 128000, 20);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ParentQueue qA = (ParentQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA is not correct", (double)0.4, (double)qA.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA is not correct", (double)0.8, (double)qA.getAbsoluteMaximumCapacity(), (double)0.001f);
        ParentQueue qB = (ParentQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB is not correct", (double)0.2, (double)qB.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB is not correct", (double)0.6, (double)qB.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEC is not correct", (double)0.2, (double)qC.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEC is not correct", (double)0.6, (double)qC.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qA1 = (LeafQueue)cs.getQueue(QUEUEA1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA1 is not correct", (double)0.2, (double)qA1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA1 is not correct", (double)0.8, (double)qA1.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qA2 = (LeafQueue)cs.getQueue(QUEUEA2);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA2 is not correct", (double)0.2, (double)qA2.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA2 is not correct", (double)0.8, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qB1 = (LeafQueue)cs.getQueue(QUEUEB1);
        Assert.assertEquals((String)"Min resource configured for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.queueResourceQuotas.getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.queueResourceQuotas.getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB1 is not correct", (double)0.16, (double)qB1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB1 is not correct", (double)0.6, (double)qB1.getAbsoluteMaximumCapacity(), (double)0.001f);
        rm.registerNode("127.0.0.3:1234", 128000, 20);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA is not correct", (double)0.266, (double)qA.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA is not correct", (double)0.533, (double)qA.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB is not correct", (double)0.133, (double)qB.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB is not correct", (double)0.4, (double)qB.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEC is not correct", (double)0.133, (double)qC.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEC is not correct", (double)0.4, (double)qC.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB1 is not correct", (double)0.106, (double)qB1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB1 is not correct", (double)0.4, (double)qB1.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA1 is not correct", (double)0.133, (double)qA1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA1 is not correct", (double)0.533, (double)qA1.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.queueResourceQuotas.getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.queueResourceQuotas.getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA2 is not correct", (double)0.133, (double)qA2.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA2 is not correct", (double)0.533, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001f);
        rm.stop();
    }
}

