/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerNodeLabelUpdate {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 100.0f);
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        conf.setCapacityByLabel("root.a", "y", 100.0f);
        conf.setCapacityByLabel("root.a", "z", 100.0f);
        return conf;
    }

    private Configuration getConfigurationWithSubQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf2 = new CapacitySchedulerConfiguration(config);
        conf2.setQueues("root", new String[]{"a", "b"});
        conf2.setCapacityByLabel("root", "x", 100.0f);
        conf2.setCapacityByLabel("root", "y", 100.0f);
        String a = "root.a";
        String b = "root.b";
        String aa1 = "root.a.a1";
        String aa2 = "root.a.a2";
        String aa3 = "root.a.a3";
        String aa4 = "root.a.a4";
        conf2.setQueues("root.a", new String[]{"a1", "a2", "a3", "a4"});
        conf2.setCapacity("root.a", 50.0f);
        conf2.setCapacity("root.b", 50.0f);
        conf2.setCapacity("root.a.a1", 40.0f);
        conf2.setCapacity("root.a.a2", 20.0f);
        conf2.setCapacity("root.a.a3", 20.0f);
        conf2.setCapacity("root.a.a4", 20.0f);
        conf2.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        conf2.setAccessibleNodeLabels("root.a.a1", (Set)ImmutableSet.of((Object)"x", (Object)"y"));
        conf2.setAccessibleNodeLabels("root.a.a2", (Set)ImmutableSet.of((Object)"y"));
        conf2.setAccessibleNodeLabels("root.a.a3", (Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        conf2.setAccessibleNodeLabels("root.a.a4", (Set)ImmutableSet.of((Object)"x", (Object)"y"));
        conf2.setCapacityByLabel("root.a", "x", 50.0f);
        conf2.setCapacityByLabel("root.a", "y", 50.0f);
        conf2.setCapacityByLabel("root.a", "z", 50.0f);
        conf2.setCapacityByLabel("root.b", "x", 50.0f);
        conf2.setCapacityByLabel("root.b", "y", 50.0f);
        conf2.setCapacityByLabel("root.b", "z", 50.0f);
        conf2.setCapacityByLabel("root.a.a1", "x", 50.0f);
        conf2.setCapacityByLabel("root.a.a3", "x", 25.0f);
        conf2.setCapacityByLabel("root.a.a4", "x", 25.0f);
        conf2.setCapacityByLabel("root.a.a1", "y", 25.0f);
        conf2.setCapacityByLabel("root.a.a2", "y", 25.0f);
        conf2.setCapacityByLabel("root.a.a4", "y", 50.0f);
        conf2.setCapacityByLabel("root.a.a3", "z", 50.0f);
        conf2.setCapacityByLabel("root.a.a4", "z", 50.0f);
        return conf2;
    }

    private Set<String> toSet(String ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    private void checkUsedResource(MockRM rm, String queueName, int memory) {
        this.checkUsedResource(rm, queueName, memory, "");
    }

    private void checkAMUsedResource(MockRM rm, String queueName, int memory) {
        this.checkAMUsedResource(rm, queueName, memory, "");
    }

    private void checkUsedCapacity(MockRM rm, String queueName, int capacity, int total) {
        this.checkUsedCapacity(rm, queueName, capacity, total, "");
    }

    private void checkUsedResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = scheduler.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getUsed(label).getMemorySize());
    }

    private void checkUsedCapacity(MockRM rm, String queueName, int capacity, int total, String label) {
        float epsillon = 1.0E-4f;
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = scheduler.getQueue(queueName);
        Assert.assertEquals((float)((float)capacity / (float)total), (float)queue.getQueueCapacities().getUsedCapacity(label), (float)epsillon);
    }

    private void checkAMUsedResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = scheduler.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getAMUsed(label).getMemorySize());
    }

    private void checkUserUsedResource(MockRM rm, String queueName, String userName, String partition, int memory) {
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue queue = (LeafQueue)scheduler.getQueue(queueName);
        UsersManager.User user = queue.getUser(userName);
        Assert.assertEquals((long)memory, (long)user.getResourceUsage().getUsed(partition).getMemorySize());
    }

    @Test(timeout=60000L)
    public void testRequestContainerAfterNodePartitionUpdated() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 2048);
        MockNM nm2 = rm.registerNode("h2:1234", 2048);
        MockNM nm3 = rm.registerNode("h3:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm3);
        ApplicationResourceUsageReport appResourceUsageReport = rm.getResourceScheduler().getAppResourceUsageReport(am1.getApplicationAttemptId());
        Assert.assertEquals((long)1024L, (long)appResourceUsageReport.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1L, (long)appResourceUsageReport.getUsedResources().getVirtualCores());
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm.waitForState(nm1, containerId, RMContainerState.ALLOCATED);
        appResourceUsageReport = rm.getResourceScheduler().getAppResourceUsageReport(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2048L, (long)appResourceUsageReport.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2L, (long)appResourceUsageReport.getUsedResources().getVirtualCores());
        LeafQueue queue = (LeafQueue)((CapacityScheduler)rm.getResourceScheduler()).getQueue("a");
        ArrayList users = queue.getUsersManager().getUsersInfo();
        for (UserInfo userInfo : users) {
            if (!userInfo.getUsername().equals("user")) continue;
            ResourceInfo resourcesUsed = userInfo.getResourcesUsed();
            Assert.assertEquals((long)2048L, (long)resourcesUsed.getMemorySize());
            Assert.assertEquals((long)2L, (long)resourcesUsed.getvCores());
        }
        rm.stop();
    }

    @Test
    public void testResourceUsageWhenNodeUpdatesPartition() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 8000);
        MockNM nm2 = rm.registerNode("h2:1234", 8000);
        MockNM nm3 = rm.registerNode("h3:1234", 8000);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId2, RMContainerState.ALLOCATED));
        this.checkUsedResource(rm, "a", 1024, "x");
        this.checkUsedResource(rm, "a", 1024);
        this.checkUsedCapacity(rm, "a", 1024, 8000, "x");
        this.checkUsedCapacity(rm, "a", 1024, 8000);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("z")));
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("z"))));
        Thread.sleep(100L);
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 1024, "z");
        this.checkUsedResource(rm, "a", 1024);
        this.checkUsedCapacity(rm, "a", 0, 8000, "x");
        this.checkUsedCapacity(rm, "a", 1024, 8000, "z");
        this.checkUsedCapacity(rm, "a", 1024, 8000);
        this.checkUsedResource(rm, "root", 0, "x");
        this.checkUsedResource(rm, "root", 1024, "z");
        this.checkUsedResource(rm, "root", 1024);
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "z", 1024);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed("z").getMemorySize());
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("y")));
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("y"))));
        Thread.sleep(100L);
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 1024, "y");
        this.checkUsedResource(rm, "a", 0, "z");
        this.checkUsedResource(rm, "a", 1024);
        this.checkUsedCapacity(rm, "a", 0, 8000, "x");
        this.checkUsedCapacity(rm, "a", 1024, 16000, "y");
        this.checkUsedCapacity(rm, "a", 0, 8000, "z");
        this.checkUsedCapacity(rm, "a", 1024, 8000);
        this.checkUsedResource(rm, "root", 0, "x");
        this.checkUsedResource(rm, "root", 1024, "y");
        this.checkUsedResource(rm, "root", 0, "z");
        this.checkUsedResource(rm, "root", 1024);
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "y", 1024);
        this.checkUserUsedResource(rm, "a", "user", "z", 0);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed("y").getMemorySize());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("z").getMemorySize());
        HashSet emptyLabels = new HashSet();
        ImmutableMap map = ImmutableMap.of((Object)nm1.getNodeId(), emptyLabels);
        this.mgr.replaceLabelsOnNode((Map)map);
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)map));
        Thread.sleep(100L);
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 0, "y");
        this.checkUsedResource(rm, "a", 0, "z");
        this.checkUsedResource(rm, "a", 2048);
        this.checkUsedCapacity(rm, "a", 0, 8000, "x");
        this.checkUsedCapacity(rm, "a", 0, 8000, "y");
        this.checkUsedCapacity(rm, "a", 0, 8000, "z");
        this.checkUsedCapacity(rm, "a", 2048, 16000);
        this.checkUsedResource(rm, "root", 0, "x");
        this.checkUsedResource(rm, "root", 0, "y");
        this.checkUsedResource(rm, "root", 0, "z");
        this.checkUsedResource(rm, "root", 2048);
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "y", 0);
        this.checkUserUsedResource(rm, "a", "user", "z", 0);
        this.checkUserUsedResource(rm, "a", "user", "", 2048);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("y").getMemorySize());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed("z").getMemorySize());
        Assert.assertEquals((long)2048L, (long)app.getAppAttemptResourceUsage().getUsed("").getMemorySize());
        cs.completedContainer(cs.getRMContainer(containerId2), ContainerStatus.newInstance((ContainerId)containerId2, (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL);
        cs.completedContainer(cs.getRMContainer(containerId1), ContainerStatus.newInstance((ContainerId)containerId1, (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL);
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 0, "y");
        this.checkUsedResource(rm, "a", 0, "z");
        this.checkUsedResource(rm, "a", 0);
        this.checkUsedCapacity(rm, "a", 0, 8000, "x");
        this.checkUsedCapacity(rm, "a", 0, 8000, "y");
        this.checkUsedCapacity(rm, "a", 0, 8000, "z");
        this.checkUsedCapacity(rm, "a", 0, 16000);
        this.checkUsedResource(rm, "root", 0, "x");
        this.checkUsedResource(rm, "root", 0, "y");
        this.checkUsedResource(rm, "root", 0, "z");
        this.checkUsedResource(rm, "root", 0);
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "y", 0);
        this.checkUserUsedResource(rm, "a", "user", "z", 0);
        this.checkUserUsedResource(rm, "a", "user", "", 0);
        rm.close();
    }

    @Test(timeout=300000L)
    public void testMoveApplicationWithLabel() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h4", (int)0), this.toSet("z")));
        MockRM rm = new MockRM(this.getConfigurationWithSubQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 8192);
        MockNM nm2 = rm.registerNode("h2:1234", 8192);
        MockNM nm3 = rm.registerNode("h3:1234", 8192);
        MockNM nm4 = rm.registerNode("h4:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId container1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm.waitForState(nm1, container1, RMContainerState.ALLOCATED, 10000);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        ContainerId container2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm.waitForState(nm2, container2, RMContainerState.ALLOCATED, 10000);
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        try {
            scheduler.preValidateMoveApplication(app1.getApplicationId(), "a2");
            scheduler.moveApplication(app1.getApplicationId(), "a2");
            Assert.fail((String)"Should throw exception since target queue doesnt have required labels");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Yarn Exception should be thrown", (boolean)(e instanceof YarnException));
            Assert.assertEquals((Object)"Specified queue=root.a.a2 can't satisfy following apps label expressions =[x] accessible node labels =[y]", (Object)e.getMessage());
        }
        try {
            scheduler.moveApplication(app1.getApplicationId(), "a3");
            scheduler.moveApplication(app1.getApplicationId(), "a4");
            scheduler.moveApplication(app1.getApplicationId(), "b");
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw exception since target queue has required labels");
        }
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testComplexResourceUsageWhenNodeUpdatesPartition() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 80000);
        MockNM nm2 = rm.registerNode("h2:1234", 80000);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("u1").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("u2").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am2.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "x");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        this.checkUsedResource(rm, "a", 3072, "x");
        this.checkUsedResource(rm, "a", 3072);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp application1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp application2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("z"))));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 3072, "z");
        this.checkUsedResource(rm, "a", 3072);
        this.checkUsedResource(rm, "root", 0, "x");
        this.checkUsedResource(rm, "root", 3072, "z");
        this.checkUsedResource(rm, "root", 3072);
        this.checkUserUsedResource(rm, "a", "u1", "x", 0);
        this.checkUserUsedResource(rm, "a", "u1", "z", 1024);
        this.checkUserUsedResource(rm, "a", "u1", "", 2048);
        this.checkUserUsedResource(rm, "a", "u2", "x", 0);
        this.checkUserUsedResource(rm, "a", "u2", "z", 2048);
        this.checkUserUsedResource(rm, "a", "u2", "", 1024);
        Assert.assertEquals((long)0L, (long)application1.getAppAttemptResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)1024L, (long)application1.getAppAttemptResourceUsage().getUsed("z").getMemorySize());
        Assert.assertEquals((long)2048L, (long)application1.getAppAttemptResourceUsage().getUsed("").getMemorySize());
        Assert.assertEquals((long)0L, (long)application2.getAppAttemptResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)2048L, (long)application2.getAppAttemptResourceUsage().getUsed("z").getMemorySize());
        Assert.assertEquals((long)1024L, (long)application2.getAppAttemptResourceUsage().getUsed("").getMemorySize());
        rm.close();
    }

    @Test
    public void testAMResourceLimitNodeUpdatePartition() throws Exception {
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 64);
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        rm.registerNode("h1:1234", 6400);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.checkAMResourceLimit(rm, "a", 640, "");
        this.checkAMResourceLimit(rm, "a", 0, "x");
        this.checkAMResourceLimit(rm, "a", 0, "y");
        this.checkAMResourceLimit(rm, "a", 0, "z");
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        rm.drainEvents();
        this.checkAMResourceLimit(rm, "a", 640, "x");
        this.checkAMResourceLimit(rm, "a", 0, "y");
        this.checkAMResourceLimit(rm, "a", 0, "z");
        this.checkAMResourceLimit(rm, "a", 0, "");
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        rm.drainEvents();
        this.checkAMResourceLimit(rm, "a", 0, "x");
        this.checkAMResourceLimit(rm, "a", 640, "y");
        this.checkAMResourceLimit(rm, "a", 0, "z");
        this.checkAMResourceLimit(rm, "a", 0, "");
    }

    @Test(timeout=60000L)
    public void testAMResourceUsageWhenNodeUpdatesPartition() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 8000);
        rm.registerNode("h2:1234", 8000);
        rm.registerNode("h3:1234", 8000);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId2, RMContainerState.ALLOCATED));
        this.checkUsedResource(rm, "a", 2048, "x");
        this.checkAMUsedResource(rm, "a", 1024, "x");
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)ImmutableMap.of((Object)nm1.getNodeId(), this.toSet("z"))));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 2048, "z");
        this.checkAMUsedResource(rm, "a", 0, "x");
        this.checkAMUsedResource(rm, "a", 1024, "z");
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "z", 2048);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getAMUsed("x").getMemorySize());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getAMUsed("z").getMemorySize());
        HashSet emptyLabels = new HashSet();
        ImmutableMap map = ImmutableMap.of((Object)nm1.getNodeId(), emptyLabels);
        cs.handle((SchedulerEvent)new NodeLabelsUpdateSchedulerEvent((Map)map));
        this.checkUsedResource(rm, "a", 0, "x");
        this.checkUsedResource(rm, "a", 0, "z");
        this.checkUsedResource(rm, "a", 2048);
        this.checkAMUsedResource(rm, "a", 0, "x");
        this.checkAMUsedResource(rm, "a", 0, "z");
        this.checkAMUsedResource(rm, "a", 1024);
        this.checkUserUsedResource(rm, "a", "user", "x", 0);
        this.checkUserUsedResource(rm, "a", "user", "z", 0);
        this.checkUserUsedResource(rm, "a", "user", "", 2048);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getAMUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getAMUsed("z").getMemorySize());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getAMUsed("").getMemorySize());
        rm.close();
    }

    @Test(timeout=30000L)
    public void testBlacklistAMDisableLabel() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.am-scheduling.node-blacklisting-enabled", true);
        this.conf.setFloat("yarn.resourcemanager.am-scheduling.node-blacklisting-disable-threshold", 0.5f);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h6", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h4", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h5", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h7", (int)0), this.toSet("y")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 2048);
        MockNM nm2 = rm.registerNode("h2:1234", 2048);
        rm.registerNode("h3:1234", 2048);
        rm.registerNode("h4:1234", 2048);
        rm.registerNode("h5:1234", 2048);
        rm.registerNode("h6:1234", 2048);
        rm.registerNode("h7:1234", 2048);
        rm.registerNode("h8:1234", 2048);
        rm.registerNode("h9:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        MockRM.launchAndRegisterAM(app, rm, nm1);
        RMAppAttempt appAttempt = app.getCurrentAppAttempt();
        appAttempt.getAMBlacklistManager().addNode("h1");
        ResourceBlacklistRequest blacklistUpdates = appAttempt.getAMBlacklistManager().getBlacklistUpdates();
        Assert.assertEquals((long)1L, (long)blacklistUpdates.getBlacklistAdditions().size());
        Assert.assertEquals((long)0L, (long)blacklistUpdates.getBlacklistRemovals().size());
        appAttempt.getAMBlacklistManager().addNode("h8");
        blacklistUpdates = appAttempt.getAMBlacklistManager().getBlacklistUpdates();
        Assert.assertEquals((long)0L, (long)blacklistUpdates.getBlacklistAdditions().size());
        Assert.assertEquals((long)2L, (long)blacklistUpdates.getBlacklistRemovals().size());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("x").build();
        RMApp applabel = MockRMAppSubmitter.submit(rm, data1);
        MockRM.launchAndRegisterAM(applabel, rm, nm2);
        RMAppAttempt appAttemptlabelx = applabel.getCurrentAppAttempt();
        appAttemptlabelx.getAMBlacklistManager().addNode("h2");
        ResourceBlacklistRequest blacklistUpdatesOnx = appAttemptlabelx.getAMBlacklistManager().getBlacklistUpdates();
        Assert.assertEquals((long)1L, (long)blacklistUpdatesOnx.getBlacklistAdditions().size());
        Assert.assertEquals((long)0L, (long)blacklistUpdatesOnx.getBlacklistRemovals().size());
        appAttemptlabelx.getAMBlacklistManager().addNode("h3");
        blacklistUpdatesOnx = appAttempt.getAMBlacklistManager().getBlacklistUpdates();
        Assert.assertEquals((long)0L, (long)blacklistUpdatesOnx.getBlacklistAdditions().size());
        Assert.assertEquals((long)2L, (long)blacklistUpdatesOnx.getBlacklistRemovals().size());
        rm.close();
    }

    private void checkAMResourceLimit(MockRM rm, String queuename, int memory, String label) throws InterruptedException {
        Assert.assertEquals((long)memory, (long)this.waitForResourceUpdate(rm, queuename, memory, label, 3000L));
    }

    private long waitForResourceUpdate(MockRM rm, String queuename, long memory, String label, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        long memorySize = 0L;
        while (System.currentTimeMillis() - start < timeout) {
            CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
            CSQueue queue = scheduler.getQueue(queuename);
            memorySize = queue.getQueueResourceUsage().getAMLimit(label).getMemorySize();
            if (memory == memorySize) {
                return memorySize;
            }
            Thread.sleep(100L);
        }
        return memorySize;
    }

    private long waitForNodeLabelSchedulerEventUpdate(MockRM rm, String partition, long expectedNodeCount, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        long size = 0L;
        while (System.currentTimeMillis() - start < timeout) {
            CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
            size = scheduler.getNodeTracker().getNodesPerPartition(partition).size();
            if (size == expectedNodeCount) {
                return size;
            }
            Thread.sleep(100L);
        }
        return size;
    }

    @Test
    public void testNodeCountBasedOnNodeLabelsFromClusterNodeTracker() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)1234), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)1234), this.toSet("x")));
        MockRM rm = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerNodeLabelUpdate.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 8000);
        rm.registerNode("h2:1234", 8000);
        rm.registerNode("h3:1234", 8000);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((long)2L, (long)cs.getNodeTracker().getNodesPerPartition("x").size());
        Assert.assertEquals((long)1L, (long)cs.getNodeTracker().getNodesPerPartition("").size());
        rm.unRegisterNode(nm1);
        rm.registerNode("h4:1234", 8000);
        Assert.assertEquals((long)1L, (long)cs.getNodeTracker().getNodesPerPartition("x").size());
        Assert.assertEquals((long)2L, (long)cs.getNodeTracker().getNodesPerPartition("").size());
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)1234), this.toSet("")));
        Assert.assertEquals((long)0L, (long)this.waitForNodeLabelSchedulerEventUpdate(rm, "x", 0L, 3000L));
    }
}

