/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ConfigurationStoreBaseTest {
    static final String TEST_USER = "testUser";
    YarnConfigurationStore confStore = this.createConfStore();
    Configuration conf;
    Configuration schedConf;
    RMContext rmContext;

    abstract YarnConfigurationStore createConfStore();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        this.schedConf = new Configuration(false);
    }

    @Test
    public void testConfigurationUpdate() throws Exception {
        this.schedConf.set("key1", "val1");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val1", (Object)this.confStore.retrieve().get("key1"));
        this.confStore.confirmMutation(this.prepareLogMutation("keyUpdate1", "valUpdate1"), true);
        Assert.assertEquals((Object)"valUpdate1", (Object)this.confStore.retrieve().get("keyUpdate1"));
        this.confStore.confirmMutation(this.prepareLogMutation("keyUpdate2", "valUpdate2"), false);
        Assert.assertNull((String)"Configuration should not be updated", (Object)this.confStore.retrieve().get("keyUpdate2"));
        this.confStore.close();
    }

    @Test
    public void testNullConfigurationUpdate() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.confirmMutation(this.prepareLogMutation("key", null), true);
        Assert.assertNull((Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }

    YarnConfigurationStore.LogMutation prepareLogMutation(String ... values) throws Exception {
        HashMap<String, String> updates = new HashMap<String, String>();
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("The number of parameters should be even.");
        }
        for (int i = 1; i <= values.length; i += 2) {
            String key = values[i - 1];
            String value = values[i];
            updates.put(key, value);
        }
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(updates, TEST_USER);
        this.confStore.logMutation(mutation);
        return mutation;
    }
}

