/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.FSSchedulerConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.PersistentConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSSchedulerConfigurationStore
extends PersistentConfigurationStoreBaseTest {
    private File testSchedulerConfigurationDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.testSchedulerConfigurationDir = new File(TestFSSchedulerConfigurationStore.class.getResource("").getPath() + FSSchedulerConfigurationStore.class.getSimpleName());
        this.testSchedulerConfigurationDir.mkdirs();
        this.conf.set("yarn.scheduler.configuration.fs.path", this.testSchedulerConfigurationDir.getAbsolutePath());
    }

    private void writeConf(Configuration config) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)new Configuration(config));
        String schedulerConfigurationFile = "capacity-scheduler.xml." + System.currentTimeMillis();
        FSDataOutputStream outputStream = fileSystem.create(new Path(this.testSchedulerConfigurationDir.getAbsolutePath(), schedulerConfigurationFile));
        config.writeXml((OutputStream)outputStream);
        outputStream.close();
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testSchedulerConfigurationDir);
    }

    @Test
    public void checkVersion() {
        try {
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            Assert.fail((String)"checkVersion throw exception");
        }
    }

    @Test
    public void confirmMutationWithValid() throws Exception {
        this.conf.setInt("yarn.scheduler.configuration.max.version", 2);
        this.conf.set("a", "a");
        this.conf.set("b", "b");
        this.conf.set("c", "c");
        this.writeConf(this.conf);
        this.confStore.initialize(this.conf, this.conf, null);
        Configuration storeConf = this.confStore.retrieve();
        this.compareConfig(this.conf, storeConf);
        Configuration expectConfig = new Configuration(this.conf);
        expectConfig.unset("a");
        expectConfig.set("b", "bb");
        this.confStore.confirmMutation(this.prepareLogMutation("a", null, "b", "bb"), true);
        storeConf = this.confStore.retrieve();
        Assert.assertNull((Object)storeConf.get("a"));
        Assert.assertEquals((Object)"bb", (Object)storeConf.get("b"));
        Assert.assertEquals((Object)"c", (Object)storeConf.get("c"));
        this.compareConfig(expectConfig, storeConf);
        this.confStore.confirmMutation(this.prepareLogMutation("a", null, "b", "bbb"), true);
        storeConf = this.confStore.retrieve();
        Assert.assertNull((Object)storeConf.get("a"));
        Assert.assertEquals((Object)"bbb", (Object)storeConf.get("b"));
        Assert.assertEquals((Object)"c", (Object)storeConf.get("c"));
    }

    @Test
    public void confirmMutationWithInvalid() throws Exception {
        this.conf.set("a", "a");
        this.conf.set("b", "b");
        this.conf.set("c", "c");
        this.writeConf(this.conf);
        this.confStore.initialize(this.conf, this.conf, null);
        Configuration storeConf = this.confStore.retrieve();
        this.compareConfig(this.conf, storeConf);
        this.confStore.confirmMutation(this.prepareLogMutation("a", null, "b", "bb"), false);
        storeConf = this.confStore.retrieve();
        this.compareConfig(this.conf, storeConf);
    }

    @Test
    public void testConfigRetrieval() throws Exception {
        Configuration schedulerConf = new Configuration();
        schedulerConf.set("a", "a");
        schedulerConf.setLong("long", 1L);
        schedulerConf.setBoolean("boolean", true);
        this.writeConf(schedulerConf);
        this.confStore.initialize(this.conf, this.conf, null);
        Configuration storedConfig = this.confStore.retrieve();
        this.compareConfig(schedulerConf, storedConfig);
    }

    @Test
    public void testFormatConfiguration() throws Exception {
        Configuration persistedSchedConf = new Configuration();
        persistedSchedConf.set("a", "a");
        this.writeConf(persistedSchedConf);
        this.confStore.initialize(this.conf, this.conf, null);
        Configuration storedConfig = this.confStore.retrieve();
        Assert.assertEquals((String)"Retrieved config should match the stored one", (Object)"a", (Object)storedConfig.get("a"));
        this.confStore.format();
        try {
            this.confStore.retrieve();
            Assert.fail((String)"Expected an IOException with message containing \"no capacity scheduler file in\" to be thrown");
        }
        catch (IOException e) {
            Assert.assertThat((String)"Exception message should contain the predefined string.", (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no capacity scheduler file in"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemClose() throws Exception {
        block9: {
            DistributedFileSystem fs;
            MiniDFSCluster hdfsCluster = null;
            Path path = new Path("/tmp/confstore");
            try {
                HdfsConfiguration hdfsConfig = new HdfsConfiguration();
                hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
                fs = hdfsCluster.getFileSystem();
                if (!fs.exists(path)) {
                    fs.mkdirs(path);
                }
                hdfsConfig.set("yarn.scheduler.configuration.fs.path", path.toString());
                this.confStore.initialize((Configuration)hdfsConfig, (Configuration)hdfsConfig, null);
                fs.close();
                try {
                    this.confStore.confirmMutation(this.prepareLogMutation("key", "val"), true);
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Filesystem closed")) {
                        Assert.fail((String)"FSSchedulerConfigurationStore failed to handle FileSystem close");
                        break block9;
                    }
                    Assert.fail((String)"Should not get any exceptions");
                }
            }
            finally {
                assert (hdfsCluster != null);
                fs = hdfsCluster.getFileSystem();
                if (fs.exists(path)) {
                    fs.delete(path, true);
                }
                hdfsCluster.shutdown();
            }
        }
    }

    private void compareConfig(Configuration schedulerConf, Configuration storedConfig) {
        for (Map.Entry entry : schedulerConf) {
            Assert.assertEquals((String)((String)entry.getKey()), (Object)schedulerConf.get((String)entry.getKey()), (Object)storedConfig.get((String)entry.getKey()));
        }
        for (Map.Entry entry : storedConfig) {
            Assert.assertEquals((String)((String)entry.getKey()), (Object)storedConfig.get((String)entry.getKey()), (Object)schedulerConf.get((String)entry.getKey()));
        }
    }

    @Override
    public YarnConfigurationStore createConfStore() {
        return new FSSchedulerConfigurationStore();
    }

    @Override
    Version getVersion() {
        return null;
    }
}

