/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.api.records.ContainerQueuingLimit;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.NodeQueueLoadMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNodeQueueLoadMonitor {
    private static final int DEFAULT_MAX_QUEUE_LENGTH = 200;

    @Test
    public void testWaitTimeSort() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_WAIT_TIME);
        selector.updateNode(this.createRMNode("h1", 1, 15, 10));
        selector.updateNode(this.createRMNode("h2", 2, 5, 10));
        selector.updateNode(this.createRMNode("h3", 3, 10, 10));
        selector.computeTask.run();
        List nodeIds = selector.selectNodes();
        System.out.println("1-> " + nodeIds);
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h3", 3, 2, 10));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("2-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h4", 4, -1, 10));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("3-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h2", 2, 1, 10, NodeState.DECOMMISSIONING));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        Assert.assertEquals((long)2L, (long)nodeIds.size());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(1)).toString());
        selector.updateNode(this.createRMNode("h2", 2, 1, 10, NodeState.RUNNING));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
    }

    @Test
    public void testQueueLengthSort() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        selector.updateNode(this.createRMNode("h1", 1, -1, 15));
        selector.updateNode(this.createRMNode("h2", 2, -1, 5));
        selector.updateNode(this.createRMNode("h3", 3, -1, 10));
        selector.computeTask.run();
        List nodeIds = selector.selectNodes();
        System.out.println("1-> " + nodeIds);
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h3", 3, -1, 2));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("2-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h4", 4, -1, 20));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("3-> " + nodeIds);
        Assert.assertEquals((Object)"h3:3", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(2)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(3)).toString());
        selector.updateNode(this.createRMNode("h3", 3, -1, 200));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        System.out.println("4-> " + nodeIds);
        Assert.assertEquals((long)3L, (long)nodeIds.size());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(2)).toString());
        selector.updateNode(this.createRMNode("h2", 2, -1, 5, NodeState.DECOMMISSIONING));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        Assert.assertEquals((long)2L, (long)nodeIds.size());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(1)).toString());
        selector.updateNode(this.createRMNode("h2", 2, -1, 5, NodeState.RUNNING));
        selector.computeTask.run();
        nodeIds = selector.selectNodes();
        Assert.assertEquals((long)3L, (long)nodeIds.size());
        Assert.assertEquals((Object)"h2:2", (Object)((NodeId)nodeIds.get(0)).toString());
        Assert.assertEquals((Object)"h1:1", (Object)((NodeId)nodeIds.get(1)).toString());
        Assert.assertEquals((Object)"h4:4", (Object)((NodeId)nodeIds.get(2)).toString());
    }

    @Test
    public void testContainerQueuingLimit() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        selector.updateNode(this.createRMNode("h1", 1, -1, 15));
        selector.updateNode(this.createRMNode("h2", 2, -1, 5));
        selector.updateNode(this.createRMNode("h3", 3, -1, 10));
        selector.initThresholdCalculator(0.0f, 6, 100);
        QueueLimitCalculator calculator = selector.getThresholdCalculator();
        ContainerQueuingLimit containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)6L, (long)containerQueuingLimit.getMaxQueueLength());
        Assert.assertEquals((long)-1L, (long)containerQueuingLimit.getMaxQueueWaitTimeInMs());
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)10L, (long)containerQueuingLimit.getMaxQueueLength());
        Assert.assertEquals((long)-1L, (long)containerQueuingLimit.getMaxQueueWaitTimeInMs());
        selector.updateNode(this.createRMNode("h1", 1, -1, 110));
        selector.updateNode(this.createRMNode("h2", 2, -1, 120));
        selector.updateNode(this.createRMNode("h3", 3, -1, 130));
        selector.updateNode(this.createRMNode("h4", 4, -1, 140));
        selector.updateNode(this.createRMNode("h5", 5, -1, 150));
        selector.updateNode(this.createRMNode("h6", 6, -1, 160));
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)100L, (long)containerQueuingLimit.getMaxQueueLength());
        selector.updateNode(this.createRMNode("h1", 1, -1, 1));
        selector.updateNode(this.createRMNode("h2", 2, -1, 2));
        selector.updateNode(this.createRMNode("h3", 3, -1, 3));
        selector.updateNode(this.createRMNode("h4", 4, -1, 4));
        selector.updateNode(this.createRMNode("h5", 5, -1, 5));
        selector.updateNode(this.createRMNode("h6", 6, -1, 6));
        selector.computeTask.run();
        containerQueuingLimit = calculator.createContainerQueuingLimit();
        Assert.assertEquals((long)6L, (long)containerQueuingLimit.getMaxQueueLength());
    }

    @Test
    public void testSelectLocalNode() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        RMNode h1 = this.createRMNode("h1", 1, -1, 2, 5);
        RMNode h2 = this.createRMNode("h2", 2, -1, 5, 5);
        RMNode h3 = this.createRMNode("h3", 3, -1, 4, 5);
        selector.addNode(null, h1);
        selector.addNode(null, h2);
        selector.addNode(null, h3);
        selector.updateNode(h1);
        selector.updateNode(h2);
        selector.updateNode(h3);
        HashSet<String> blacklist = new HashSet<String>();
        RMNode node = selector.selectLocalNode("h1", blacklist);
        Assert.assertEquals((Object)"h1", (Object)node.getHostName());
        blacklist.add("h1");
        node = selector.selectLocalNode("h1", blacklist);
        Assert.assertNull((Object)node);
        node = selector.selectLocalNode("h2", blacklist);
        Assert.assertNull((Object)node);
        node = selector.selectLocalNode("h3", blacklist);
        Assert.assertEquals((Object)"h3", (Object)node.getHostName());
    }

    @Test
    public void testSelectRackLocalNode() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        RMNode h1 = this.createRMNode("h1", 1, "rack1", -1, 2, 5);
        RMNode h2 = this.createRMNode("h2", 2, "rack2", -1, 5, 5);
        RMNode h3 = this.createRMNode("h3", 3, "rack2", -1, 4, 5);
        selector.addNode(null, h1);
        selector.addNode(null, h2);
        selector.addNode(null, h3);
        selector.updateNode(h1);
        selector.updateNode(h2);
        selector.updateNode(h3);
        HashSet<String> blacklist = new HashSet<String>();
        RMNode node = selector.selectRackLocalNode("rack1", blacklist);
        Assert.assertEquals((Object)"h1", (Object)node.getHostName());
        blacklist.add("h1");
        node = selector.selectRackLocalNode("rack1", blacklist);
        Assert.assertNull((Object)node);
        node = selector.selectRackLocalNode("rack2", blacklist);
        Assert.assertEquals((Object)"h3", (Object)node.getHostName());
        blacklist.add("h3");
        node = selector.selectRackLocalNode("rack2", blacklist);
        Assert.assertNull((Object)node);
    }

    @Test
    public void testSelectAnyNode() {
        NodeQueueLoadMonitor selector = new NodeQueueLoadMonitor(NodeQueueLoadMonitor.LoadComparator.QUEUE_LENGTH);
        RMNode h1 = this.createRMNode("h1", 1, "rack1", -1, 2, 5);
        RMNode h2 = this.createRMNode("h2", 2, "rack2", -1, 5, 5);
        RMNode h3 = this.createRMNode("h3", 3, "rack2", -1, 4, 10);
        selector.addNode(null, h1);
        selector.addNode(null, h2);
        selector.addNode(null, h3);
        selector.updateNode(h1);
        selector.updateNode(h2);
        selector.updateNode(h3);
        selector.computeTask.run();
        Assert.assertEquals((long)2L, (long)selector.getSortedNodes().size());
        HashSet<String> blacklist = new HashSet<String>();
        RMNode node = selector.selectAnyNode(blacklist);
        Assert.assertTrue((node.getHostName().equals("h1") || node.getHostName().equals("h3") ? 1 : 0) != 0);
        blacklist.add("h1");
        node = selector.selectAnyNode(blacklist);
        Assert.assertEquals((Object)"h3", (Object)node.getHostName());
        blacklist.add("h3");
        node = selector.selectAnyNode(blacklist);
        Assert.assertNull((Object)node);
    }

    private RMNode createRMNode(String host, int port, int waitTime, int queueLength) {
        return this.createRMNode(host, port, waitTime, queueLength, 200);
    }

    private RMNode createRMNode(String host, int port, int waitTime, int queueLength, NodeState state) {
        return this.createRMNode(host, port, "default", waitTime, queueLength, 200, state);
    }

    private RMNode createRMNode(String host, int port, int waitTime, int queueLength, int queueCapacity) {
        return this.createRMNode(host, port, "default", waitTime, queueLength, queueCapacity, NodeState.RUNNING);
    }

    private RMNode createRMNode(String host, int port, String rack, int waitTime, int queueLength, int queueCapacity) {
        return this.createRMNode(host, port, rack, waitTime, queueLength, queueCapacity, NodeState.RUNNING);
    }

    private RMNode createRMNode(String host, int port, String rack, int waitTime, int queueLength, int queueCapacity, NodeState state) {
        RMNode node1 = (RMNode)Mockito.mock(RMNode.class);
        FakeNodeId nID1 = new FakeNodeId(host, port);
        Mockito.when((Object)node1.getHostName()).thenReturn((Object)host);
        Mockito.when((Object)node1.getRackName()).thenReturn((Object)rack);
        Mockito.when((Object)node1.getNodeID()).thenReturn((Object)nID1);
        Mockito.when((Object)node1.getState()).thenReturn((Object)state);
        OpportunisticContainersStatus status1 = (OpportunisticContainersStatus)Mockito.mock(OpportunisticContainersStatus.class);
        Mockito.when((Object)status1.getEstimatedQueueWaitTime()).thenReturn((Object)waitTime);
        Mockito.when((Object)status1.getWaitQueueLength()).thenReturn((Object)queueLength);
        Mockito.when((Object)status1.getOpportQueueCapacity()).thenReturn((Object)queueCapacity);
        Mockito.when((Object)node1.getOpportunisticContainersStatus()).thenReturn((Object)status1);
        return node1;
    }

    static class FakeNodeId
    extends NodeId {
        final String host;
        final int port;

        public FakeNodeId(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        protected void setHost(String host) {
        }

        protected void setPort(int port) {
        }

        protected void build() {
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

