/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSPreemptionThread;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;

public class FairSchedulerWithMockPreemption
extends FairScheduler {
    static final long DELAY_FOR_NEXT_STARVATION_CHECK_MS = 600000L;

    protected void createPreemptionThread() {
        this.preemptionThread = new MockPreemptionThread(this);
    }

    static class MockPreemptionThread
    extends FSPreemptionThread {
        private Set<FSAppAttempt> appsAdded = new HashSet<FSAppAttempt>();
        private int totalAppsAdded = 0;

        private MockPreemptionThread(FairScheduler scheduler) {
            super(scheduler);
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    FSAppAttempt app = this.context.getStarvedApps().take();
                    this.appsAdded.add(app);
                    ++this.totalAppsAdded;
                    app.preemptionTriggered(600000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        int uniqueAppsAdded() {
            return this.appsAdded.size();
        }

        int totalAppsAdded() {
            return this.totalAppsAdded;
        }
    }
}

