/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FakeSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestComputeFairShares {
    private List<Schedulable> scheds;

    @Before
    public void setUp() throws Exception {
        this.scheds = new ArrayList<Schedulable>();
    }

    @Test
    public void testEqualSharing() {
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        this.scheds.add(new FakeSchedulable());
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)40), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(10L, 10L, 10L, 10L);
    }

    @Test
    public void testLowMaxShares() {
        this.scheds.add(new FakeSchedulable(0, 100));
        this.scheds.add(new FakeSchedulable(0, 50));
        this.scheds.add(new FakeSchedulable(0, 11));
        this.scheds.add(new FakeSchedulable(0, 3));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)40), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(13L, 13L, 11L, 3L);
    }

    @Test
    public void testMinShares() {
        this.scheds.add(new FakeSchedulable(20));
        this.scheds.add(new FakeSchedulable(18));
        this.scheds.add(new FakeSchedulable(0));
        this.scheds.add(new FakeSchedulable(2));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)40), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(20L, 18L, 0L, 2L);
    }

    @Test
    public void testWeightedSharing() {
        this.scheds.add(new FakeSchedulable(0, 2.0f));
        this.scheds.add(new FakeSchedulable(0, 1.0f));
        this.scheds.add(new FakeSchedulable(0, 1.0f));
        this.scheds.add(new FakeSchedulable(0, 0.5f));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)45), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(20L, 10L, 10L, 5L);
    }

    @Test
    public void testWeightedSharingWithMaxShares() {
        this.scheds.add(new FakeSchedulable(0, 10, 2.0f));
        this.scheds.add(new FakeSchedulable(0, 11, 1.0f));
        this.scheds.add(new FakeSchedulable(0, 30, 1.0f));
        this.scheds.add(new FakeSchedulable(0, 20, 0.5f));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)45), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(10L, 11L, 16L, 8L);
    }

    @Test
    public void testWeightedSharingWithMinShares() {
        this.scheds.add(new FakeSchedulable(20, 2.0f));
        this.scheds.add(new FakeSchedulable(0, 1.0f));
        this.scheds.add(new FakeSchedulable(5, 1.0f));
        this.scheds.add(new FakeSchedulable(15, 0.5f));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)45), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(20L, 5L, 5L, 15L);
    }

    @Test
    public void testLargeShares() {
        long giga = 4000000000L;
        this.scheds.add(new FakeSchedulable(0L, giga));
        this.scheds.add(new FakeSchedulable(0L, giga));
        this.scheds.add(new FakeSchedulable(0L, giga));
        this.scheds.add(new FakeSchedulable(0L, giga));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((long)(4L * giga)), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(giga, giga, giga, giga);
    }

    @Test
    public void testLargeMinimums() {
        long giga = 4000000000L;
        this.scheds.add(new FakeSchedulable(Long.MAX_VALUE, Long.MAX_VALUE));
        this.scheds.add(new FakeSchedulable(giga, giga));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((long)(4L * giga)), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(Long.MAX_VALUE, giga);
    }

    @Test
    public void testOverflowMaxShare() {
        long giga = 1000000000L;
        this.scheds.add(new FakeSchedulable(0L, giga));
        this.scheds.add(new FakeSchedulable(0L, Long.MAX_VALUE));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((long)(2L * giga)), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(giga, giga);
    }

    @Test
    public void testOverflowFixedShare() {
        long giga = 1000000000L;
        long minValue = 0x7FFFFFFFFFFFFFFEL;
        this.scheds.add(new FakeSchedulable(giga, giga, 0.0f));
        this.scheds.add(new FakeSchedulable(minValue, Long.MAX_VALUE, 0.0f));
        this.scheds.add(new FakeSchedulable(0L, giga));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((long)1000L), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(giga, minValue, 0L);
    }

    @Test
    public void testEmptyList() {
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)40), (String)ResourceInformation.MEMORY_MB.getName());
        this.verifyMemoryShares(new long[0]);
    }

    @Test
    public void testCPU() {
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)20), 2.0f));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)0), 1.0f));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)5), 1.0f));
        this.scheds.add(new FakeSchedulable(Resources.createResource((int)0, (int)15), 0.5f));
        ComputeFairShares.computeShares(this.scheds, (Resource)Resources.createResource((int)0, (int)45), (String)ResourceInformation.VCORES.getName());
        this.verifyCPUShares(20, 5, 5, 15);
    }

    private void verifyMemoryShares(long ... shares) {
        Assert.assertEquals((String)"Number of shares and schedulables are not consistent", (long)this.scheds.size(), (long)shares.length);
        for (int i = 0; i < shares.length; ++i) {
            Assert.assertEquals((String)("Expected share number " + i + " in list wrong"), (long)shares[i], (long)this.scheds.get(i).getFairShare().getMemorySize());
        }
    }

    private void verifyCPUShares(int ... shares) {
        Assert.assertEquals((String)"Number of shares and schedulables are not consistent", (long)this.scheds.size(), (long)shares.length);
        for (int i = 0; i < shares.length; ++i) {
            Assert.assertEquals((String)("Expected share number " + i + " in list wrong"), (long)shares[i], (long)this.scheds.get(i).getFairShare().getVirtualCores());
        }
    }
}

