/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.QueuePlacementConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestQueuePlacementConverter {
    @Mock
    private PlacementManager placementManager;
    @Mock
    private FSConfigToCSConfigRuleHandler ruleHandler;
    private QueuePlacementConverter converter;

    @Before
    public void setup() {
        this.converter = new QueuePlacementConverter();
    }

    @Test
    public void testConvertUserAsDefaultQueue() {
        Map<String, String> properties = this.convert(true);
        this.verifyMapping(properties, "u:%user:%user");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertUserPlacementRuleWithoutUserAsDefaultQueue() {
        this.testConvertUserPlacementRule(false);
    }

    @Test
    public void testConvertUserPlacementRuleWithUserAsDefaultQueue() {
        this.testConvertUserPlacementRule(true);
    }

    private void testConvertUserPlacementRule(boolean userAsDefaultQueue) {
        PlacementRule rule = (PlacementRule)Mockito.mock(UserPlacementRule.class);
        this.initPlacementManagerMock(rule);
        Map<String, String> properties = this.convert(userAsDefaultQueue);
        this.verifyMapping(properties, "u:%user:%user");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSpecifiedPlacementRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(SpecifiedPlacementRule.class);
        this.initPlacementManagerMock(rule);
        Map<String, String> properties = this.convert(false);
        this.verifyMappingNoOverride(properties, 1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSpecifiedPlacementRuleAtSecondPlace() {
        PlacementRule rule = (PlacementRule)Mockito.mock(UserPlacementRule.class);
        PlacementRule rule2 = (PlacementRule)Mockito.mock(SpecifiedPlacementRule.class);
        this.initPlacementManagerMock(rule, rule2);
        Map<String, String> properties = this.convert(false);
        this.verifyMappingNoOverride(properties, 2);
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleSpecifiedNotFirstRule();
    }

    @Test
    public void testConvertPrimaryGroupPlacementRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        this.initPlacementManagerMock(rule);
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:%primary_group");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSecondaryGroupPlacementRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        this.initPlacementManagerMock(rule);
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:%secondary_group");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertDefaultPlacementRule() {
        DefaultPlacementRule rule = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        rule.defaultQueueName = "abc";
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:abc");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertUnsupportedPlacementRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(TestPlacementRule.class);
        this.initPlacementManagerMock(rule);
        this.convert(false);
    }

    @Test
    public void testConvertRejectPlacementRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(RejectPlacementRule.class);
        this.initPlacementManagerMock(rule);
        Map<String, String> properties = this.convert(false);
        Assert.assertEquals((String)"Map is not empty", (long)0L, (long)properties.size());
    }

    @Test
    public void testConvertNestedPrimaryGroupRule() {
        UserPlacementRule rule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)rule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:%primary_group.%user");
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleDynamicMappedQueue((String)ArgumentMatchers.eq((Object)"u:%user:%primary_group.%user"), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testConvertNestedSecondaryGroupRule() {
        UserPlacementRule rule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        SecondaryGroupExistingPlacementRule parent = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)rule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:%secondary_group.%user");
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleDynamicMappedQueue((String)ArgumentMatchers.eq((Object)"u:%user:%secondary_group.%user"), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testConvertNestedDefaultRule() {
        UserPlacementRule rule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        DefaultPlacementRule parent = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        parent.defaultQueueName = "abc";
        Mockito.when((Object)rule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:abc.%user");
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleDynamicMappedQueue((String)ArgumentMatchers.eq((Object)"u:%user:abc.%user"), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testConvertMultiplePlacementRules() {
        UserPlacementRule rule1 = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule rule2 = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        SecondaryGroupExistingPlacementRule rule3 = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        this.initPlacementManagerMock(new PlacementRule[]{rule1, rule2, rule3});
        Map<String, String> properties = this.convert(false);
        this.verifyMapping(properties, "u:%user:%user,u:%user:%primary_group,u:%user:%secondary_group");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    private void initPlacementManagerMock(PlacementRule ... rules) {
        ArrayList listOfRules = Lists.newArrayList((Object[])rules);
        Mockito.when((Object)this.placementManager.getPlacementRules()).thenReturn((Object)listOfRules);
    }

    private Map<String, String> convert(boolean userAsDefaultQueue) {
        return this.converter.convertPlacementPolicy(this.placementManager, this.ruleHandler, userAsDefaultQueue);
    }

    private void verifyMapping(Map<String, String> properties, String expectedValue) {
        Assert.assertEquals((String)"Map size", (long)1L, (long)properties.size());
        String value = properties.get("yarn.scheduler.capacity.queue-mappings");
        Assert.assertNotNull((String)"No mapping property found", (Object)value);
        Assert.assertEquals((String)"Mapping", (Object)expectedValue, (Object)value);
    }

    private void verifyMappingNoOverride(Map<String, String> properties, int expectedSize) {
        Assert.assertEquals((String)"Map size", (long)expectedSize, (long)properties.size());
        String value = properties.get("yarn.scheduler.capacity.queue-mappings-override.enable");
        Assert.assertNotNull((String)"No mapping property found", (Object)value);
        Assert.assertEquals((String)"Override mapping", (Object)"false", (Object)value);
    }

    private class TestPlacementRule
    extends FSPlacementRule {
        private TestPlacementRule() {
        }

        public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
            return null;
        }
    }
}

