/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Timer;
import java.util.TimerTask;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSelector;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenIdentifierForTest;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestClientToAMTokens
extends ParameterizedSchedulerTestBase {
    private YarnConfiguration conf;

    public TestClientToAMTokens(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setup() {
        this.conf = this.getConf();
    }

    @Test
    public void testClientToAMTokens() throws Exception {
        this.conf.set("hadoop.security.authentication", "kerberos");
        RPC.setProtocolEngine((Configuration)this.conf, CustomProtocol.class, ProtobufRpcEngine2.class);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        ContainerManagementProtocol containerManager = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)containerManager.startContainers((StartContainersRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher((Configuration)this.conf, containerManager){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }

            protected void doSecureLogin() throws IOException {
            }
        };
        rm.start();
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        MockNM nm1 = rm.registerNode("localhost:1234", 3072);
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        ApplicationAttemptId appAttempt = app.getCurrentAppAttempt().getAppAttemptId();
        final MockAM mockAM = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), app.getCurrentAppAttempt().getAppAttemptId());
        UserGroupInformation appUgi = UserGroupInformation.createRemoteUser((String)appAttempt.toString());
        RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)appUgi.doAs((PrivilegedAction)new PrivilegedAction<RegisterApplicationMasterResponse>(){

            @Override
            public RegisterApplicationMasterResponse run() {
                RegisterApplicationMasterResponse response = null;
                try {
                    response = mockAM.registerAppAttempt();
                }
                catch (Exception e) {
                    Assert.fail((String)"Exception was not expected");
                }
                return response;
            }
        });
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(app.getApplicationId());
        GetApplicationReportResponse reportResponse = rm.getClientRMService().getApplicationReport(request);
        ApplicationReport appReport = reportResponse.getApplicationReport();
        org.apache.hadoop.yarn.api.records.Token originalClientToAMToken = appReport.getClientToAMToken();
        Assert.assertNotNull((Object)response.getClientToAMTokenMasterKey());
        Assert.assertTrue((response.getClientToAMTokenMasterKey().array().length > 0 ? 1 : 0) != 0);
        ApplicationAttemptId appAttemptId = (ApplicationAttemptId)app.getAppAttempts().keySet().iterator().next();
        Assert.assertNotNull((Object)appAttemptId);
        CustomAM am = new CustomAM(appAttemptId, response.getClientToAMTokenMasterKey().array());
        am.init((Configuration)this.conf);
        am.start();
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new CustomSecurityInfo()});
        try {
            CustomProtocol client = (CustomProtocol)RPC.getProxy(CustomProtocol.class, (long)1L, (InetSocketAddress)am.address, (Configuration)this.conf);
            client.ping(null, TestRpcBase.newEmptyRequest());
            Assert.fail((String)"Access by unauthenticated user should fail!!");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)am.pinged);
        }
        Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)originalClientToAMToken, (InetSocketAddress)am.address);
        this.verifyTokenWithTamperedID((Configuration)this.conf, am, (Token<ClientToAMTokenIdentifier>)token);
        this.verifyTokenWithTamperedUserName((Configuration)this.conf, am, (Token<ClientToAMTokenIdentifier>)token);
        this.verifyValidToken((Configuration)this.conf, am, (Token<ClientToAMTokenIdentifier>)token);
        this.verifyNewVersionToken((Configuration)this.conf, am, (Token<ClientToAMTokenIdentifier>)token, rm);
        am.stop();
        rm.stop();
    }

    private void verifyTokenWithTamperedID(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ClientToAMTokenIdentifier maliciousID = new ClientToAMTokenIdentifier(BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)am.appAttemptId.getApplicationId().getClusterTimestamp(), (int)42), (int)43), UserGroupInformation.getCurrentUser().getShortUserName());
        this.verifyTamperedToken(conf, am, token, ugi, maliciousID);
    }

    private void verifyTokenWithTamperedUserName(Configuration conf, CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ClientToAMTokenIdentifier maliciousID = new ClientToAMTokenIdentifier(am.appAttemptId, "evilOrc");
        this.verifyTamperedToken(conf, am, token, ugi, maliciousID);
    }

    private void verifyTamperedToken(final Configuration conf, final CustomAM am, Token<ClientToAMTokenIdentifier> token, UserGroupInformation ugi, ClientToAMTokenIdentifier maliciousID) {
        Token maliciousToken = new Token(maliciousID.getBytes(), token.getPassword(), token.getKind(), token.getService());
        ugi.addToken(maliciousToken);
        try {
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        CustomProtocol client = (CustomProtocol)RPC.getProxy(CustomProtocol.class, (long)1L, (InetSocketAddress)am.address, (Configuration)conf);
                        client.ping(null, TestRpcBase.newEmptyRequest());
                        Assert.fail((String)"Connection initiation with illegally modified tokens is expected to fail.");
                        return null;
                    }
                    catch (ServiceException ex) {
                        throw (Exception)ex.getCause();
                    }
                }
            });
        }
        catch (Exception e2) {
            Assert.assertEquals((Object)RemoteException.class.getName(), (Object)e2.getClass().getName());
            IOException e2 = ((RemoteException)e2).unwrapRemoteException();
            Assert.assertEquals((Object)SaslException.class.getCanonicalName(), (Object)e2.getClass().getCanonicalName());
            Assert.assertTrue((boolean)e2.getMessage().contains("DIGEST-MD5: digest response format violation. Mismatched response."));
            Assert.assertFalse((boolean)am.pinged);
        }
    }

    private void verifyNewVersionToken(final Configuration conf, final CustomAM am, Token<ClientToAMTokenIdentifier> token, MockRM rm) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        Token newToken = new Token((TokenIdentifier)new ClientToAMTokenIdentifierForTest((ClientToAMTokenIdentifier)token.decodeIdentifier(), "message"), (SecretManager)am.getClientToAMTokenSecretManager());
        newToken.setService(token.getService());
        ugi.addToken(newToken);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                CustomProtocol client = (CustomProtocol)RPC.getProxy(CustomProtocol.class, (long)1L, (InetSocketAddress)am.address, (Configuration)conf);
                client.ping(null, TestRpcBase.newEmptyRequest());
                Assert.assertTrue((boolean)am.pinged);
                return null;
            }
        });
    }

    private void verifyValidToken(final Configuration conf, final CustomAM am, Token<ClientToAMTokenIdentifier> token) throws IOException, InterruptedException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"me");
        ugi.addToken(token);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                CustomProtocol client = (CustomProtocol)RPC.getProxy(CustomProtocol.class, (long)1L, (InetSocketAddress)am.address, (Configuration)conf);
                client.ping(null, TestRpcBase.newEmptyRequest());
                Assert.assertTrue((boolean)am.pinged);
                return null;
            }
        });
    }

    @Test(timeout=20000L)
    public void testClientTokenRace() throws Exception {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        ContainerManagementProtocol containerManager = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)containerManager.startContainers((StartContainersRequest)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher((Configuration)this.conf, containerManager){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }

            protected void doSecureLogin() throws IOException {
            }
        };
        rm.start();
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        MockNM nm1 = rm.registerNode("localhost:1234", 3072);
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        ApplicationAttemptId appAttempt = app.getCurrentAppAttempt().getAppAttemptId();
        final MockAM mockAM = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), app.getCurrentAppAttempt().getAppAttemptId());
        UserGroupInformation appUgi = UserGroupInformation.createRemoteUser((String)appAttempt.toString());
        RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)appUgi.doAs((PrivilegedAction)new PrivilegedAction<RegisterApplicationMasterResponse>(){

            @Override
            public RegisterApplicationMasterResponse run() {
                RegisterApplicationMasterResponse response = null;
                try {
                    response = mockAM.registerAppAttempt();
                }
                catch (Exception e) {
                    Assert.fail((String)"Exception was not expected");
                }
                return response;
            }
        });
        GetApplicationReportRequest request = (GetApplicationReportRequest)Records.newRecord(GetApplicationReportRequest.class);
        request.setApplicationId(app.getApplicationId());
        GetApplicationReportResponse reportResponse = rm.getClientRMService().getApplicationReport(request);
        ApplicationReport appReport = reportResponse.getApplicationReport();
        org.apache.hadoop.yarn.api.records.Token originalClientToAMToken = appReport.getClientToAMToken();
        final ByteBuffer clientMasterKey = response.getClientToAMTokenMasterKey();
        Assert.assertNotNull((Object)clientMasterKey);
        Assert.assertTrue((clientMasterKey.array().length > 0 ? 1 : 0) != 0);
        ApplicationAttemptId appAttemptId = (ApplicationAttemptId)app.getAppAttempts().keySet().iterator().next();
        Assert.assertNotNull((Object)appAttemptId);
        final CustomAM am = new CustomAM(appAttemptId, null);
        am.init((Configuration)this.conf);
        am.start();
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new CustomSecurityInfo()});
        Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)originalClientToAMToken, (InetSocketAddress)am.address);
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                am.setClientSecretKey(clientMasterKey.array());
            }
        };
        timer.schedule(timerTask, 250L);
        this.verifyValidToken((Configuration)this.conf, am, (Token<ClientToAMTokenIdentifier>)token);
        am.stop();
        rm.stop();
    }

    private static class CustomAM
    extends AbstractService
    implements CustomProtocol {
        private final ApplicationAttemptId appAttemptId;
        private final byte[] secretKey;
        private InetSocketAddress address;
        private boolean pinged = false;
        private ClientToAMTokenSecretManager secretMgr;

        public CustomAM(ApplicationAttemptId appId, byte[] secretKey) {
            super("CustomAM");
            this.appAttemptId = appId;
            this.secretKey = secretKey;
        }

        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            this.pinged = true;
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        public ClientToAMTokenSecretManager getClientToAMTokenSecretManager() {
            return this.secretMgr;
        }

        protected void serviceStart() throws Exception {
            RPC.Server server;
            Configuration conf = this.getConfig();
            RPC.setProtocolEngine((Configuration)conf, CustomProtocol.class, ProtobufRpcEngine2.class);
            UserGroupInformation.setConfiguration((Configuration)conf);
            BlockingService service = TestRpcServiceProtos.CustomProto.newReflectiveBlockingService((TestRpcServiceProtos.CustomProto.BlockingInterface)this);
            try {
                this.secretMgr = new ClientToAMTokenSecretManager(this.appAttemptId, this.secretKey);
                server = new RPC.Builder(conf).setProtocol(CustomProtocol.class).setNumHandlers(1).setSecretManager((SecretManager)this.secretMgr).setInstance((Object)service).build();
            }
            catch (Exception e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            server.start();
            this.address = NetUtils.getConnectAddress((Server)server);
            super.serviceStart();
        }

        public void setClientSecretKey(byte[] key) {
            this.secretMgr.setMasterKey(key);
        }
    }

    private static class CustomSecurityInfo
    extends SecurityInfo {
        private CustomSecurityInfo() {
        }

        public TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
            return new TokenInfo(){

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public Class<? extends TokenSelector<? extends TokenIdentifier>> value() {
                    return ClientToAMTokenSelector.class;
                }
            };
        }

        public KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
            return null;
        }
    }

    @TokenInfo(value=ClientToAMTokenSelector.class)
    @ProtocolInfo(protocolName="org.apache.hadoop.yarn.server.resourcemanager.security$CustomProtocol", protocolVersion=1L)
    public static interface CustomProtocol
    extends TestRpcServiceProtos.CustomProto.BlockingInterface {
    }
}

