/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import org.apache.hadoop.yarn.server.volume.csi.VolumeCapabilityRange;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;
import org.apache.hadoop.yarn.server.volume.csi.VolumeMetaData;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;
import org.junit.Assert;
import org.junit.Test;

public class TestVolumeMetaData {
    @Test
    public void testPreprovisionedVolume() throws InvalidVolumeException {
        VolumeCapabilityRange cap = VolumeCapabilityRange.newBuilder().minCapacity(1L).maxCapacity(5L).unit("Gi").build();
        VolumeMetaData meta = VolumeMetaData.newBuilder().volumeId(new VolumeId("id-000001")).capability(cap).driverName("csi-demo-driver").mountPoint("/mnt/data").build();
        Assert.assertEquals((Object)new VolumeId("id-000001"), (Object)meta.getVolumeId());
        Assert.assertEquals((long)1L, (long)meta.getVolumeCapabilityRange().getMinCapacity());
        Assert.assertEquals((long)5L, (long)meta.getVolumeCapabilityRange().getMaxCapacity());
        Assert.assertEquals((Object)"Gi", (Object)meta.getVolumeCapabilityRange().getUnit());
        Assert.assertEquals((Object)"csi-demo-driver", (Object)meta.getDriverName());
        Assert.assertEquals((Object)"/mnt/data", (Object)meta.getMountPoint());
        Assert.assertNull((Object)meta.getVolumeName());
        Assert.assertTrue((boolean)meta.isProvisionedVolume());
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(meta.toString());
        JsonObject json = element.getAsJsonObject();
        Assert.assertNotNull((Object)json);
        Assert.assertNull((Object)json.get("volume.name"));
        Assert.assertEquals((Object)"id-000001", (Object)json.get("volume.id").getAsString());
        Assert.assertEquals((Object)"csi-demo-driver", (Object)json.get("driver.name").getAsString());
        Assert.assertEquals((Object)"/mnt/data", (Object)json.get("volume.mount").getAsString());
    }

    @Test
    public void testDynamicalProvisionedVolume() throws InvalidVolumeException {
        VolumeCapabilityRange cap = VolumeCapabilityRange.newBuilder().minCapacity(1L).maxCapacity(5L).unit("Gi").build();
        VolumeMetaData meta = VolumeMetaData.newBuilder().volumeName("volume-name").capability(cap).driverName("csi-demo-driver").mountPoint("/mnt/data").build();
        Assert.assertNotNull((Object)meta);
        Assert.assertEquals((Object)"volume-name", (Object)meta.getVolumeName());
        Assert.assertEquals((long)1L, (long)meta.getVolumeCapabilityRange().getMinCapacity());
        Assert.assertEquals((long)5L, (long)meta.getVolumeCapabilityRange().getMaxCapacity());
        Assert.assertEquals((Object)"Gi", (Object)meta.getVolumeCapabilityRange().getUnit());
        Assert.assertEquals((Object)"csi-demo-driver", (Object)meta.getDriverName());
        Assert.assertEquals((Object)"/mnt/data", (Object)meta.getMountPoint());
        Assert.assertFalse((boolean)meta.isProvisionedVolume());
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(meta.toString());
        JsonObject json = element.getAsJsonObject();
        Assert.assertNotNull((Object)json);
        Assert.assertNull((Object)json.get("volume.id"));
        Assert.assertEquals((Object)"volume-name", (Object)json.get("volume.name").getAsString());
        Assert.assertEquals((Object)"csi-demo-driver", (Object)json.get("driver.name").getAsString());
        Assert.assertEquals((Object)"/mnt/data", (Object)json.get("volume.mount").getAsString());
    }

    @Test(expected=InvalidVolumeException.class)
    public void testMissingMountpoint() throws InvalidVolumeException {
        VolumeCapabilityRange cap = VolumeCapabilityRange.newBuilder().minCapacity(1L).maxCapacity(5L).unit("Gi").build();
        VolumeMetaData.newBuilder().volumeId(new VolumeId("id-000001")).capability(cap).driverName("csi-demo-driver").build();
    }

    @Test(expected=InvalidVolumeException.class)
    public void testMissingCsiDriverName() throws InvalidVolumeException {
        VolumeCapabilityRange cap = VolumeCapabilityRange.newBuilder().minCapacity(1L).maxCapacity(5L).unit("Gi").build();
        VolumeMetaData.newBuilder().volumeId(new VolumeId("id-000001")).capability(cap).mountPoint("/mnt/data").build();
    }

    @Test(expected=InvalidVolumeException.class)
    public void testMissingVolumeCapability() throws InvalidVolumeException {
        VolumeMetaData.newBuilder().volumeId(new VolumeId("id-000001")).driverName("csi-demo-driver").mountPoint("/mnt/data").build();
    }

    @Test
    public void testVolumeId() {
        VolumeId id1 = new VolumeId("test00001");
        VolumeId id11 = new VolumeId("test00001");
        VolumeId id2 = new VolumeId("test00002");
        Assert.assertEquals((Object)id1, (Object)id11);
        Assert.assertEquals((long)id1.hashCode(), (long)id11.hashCode());
        Assert.assertNotEquals((Object)id1, (Object)id2);
        HashMap<VolumeId, String> map = new HashMap<VolumeId, String>();
        map.put(id1, "1");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"1", map.get(id11));
        map.put(id11, "2");
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"2", map.get(id11));
        Assert.assertEquals((Object)"2", map.get(new VolumeId("test00001")));
        Assert.assertNotEquals((Object)id1, (Object)id2);
    }
}

