/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebApp;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestNodesPage {
    final int numberOfRacks = 2;
    final int numberOfNodesPerRack = 8;
    final int numberOfLostNodesPerRack = 1;
    private final int numberOfThInMetricsTable = 23;
    private final int numberOfActualTableHeaders = 16;
    private final int numberOfThForOpportunisticContainers = 4;
    private Injector injector;

    @Before
    public void setUp() throws Exception {
        this.setUpInternal(false);
    }

    private void setUpInternal(final boolean useDRC) throws Exception {
        final RMContext mockRMContext = TestRMWebApp.mockRMContext(3, 2, 8, 8192);
        this.injector = WebAppTests.createMockInjector(RMContext.class, (Object)mockRMContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    binder.bind(ResourceManager.class).toInstance((Object)TestRMWebApp.mockRm(mockRMContext, useDRC));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
    }

    @Test
    public void testNodesBlockRender() throws Exception {
        ((NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class)).render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)39))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForLostNodes() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.state", "lost");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)39))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForLostNodesWithGPUResources() throws Exception {
        Map oldRtMap = ResourceUtils.getResourceTypes();
        CustomResourceTypesConfigurationProvider.initResourceTypes((String[])new String[]{"yarn.io/gpu"});
        this.setUpInternal(true);
        try {
            this.testNodesBlockRenderForLostNodesWithGPU();
        }
        finally {
            ResourceUtils.initializeResourcesFromResourceInformationMap((Map)oldRtMap);
        }
    }

    public void testNodesBlockRenderForLostNodesWithGPU() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.state", "lost");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)41))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithNonEmptyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "x");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)1))).print("<script");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithEmptyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForNodeLabelFilterWithAnyLabel() {
        NodesPage.NodesBlock nodesBlock = (NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class);
        nodesBlock.set("node.label", "*");
        nodesBlock.render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }

    @Test
    public void testNodesBlockRenderForOpportunisticContainers() {
        final RMContext mockRMContext = TestRMWebApp.mockRMContext(3, 2, 8, 8192);
        mockRMContext.getYarnConfiguration().setBoolean("yarn.resourcemanager.opportunistic-container-allocation.enabled", true);
        this.injector = WebAppTests.createMockInjector(RMContext.class, (Object)mockRMContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    binder.bind(ResourceManager.class).toInstance((Object)TestRMWebApp.mockRm(mockRMContext));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        ((NodesPage.NodesBlock)this.injector.getInstance(NodesPage.NodesBlock.class)).render();
        PrintWriter writer = (PrintWriter)this.injector.getInstance(PrintWriter.class);
        WebAppTests.flushOutput((Injector)this.injector);
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)43))).print("<th");
        ((PrintWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.times((int)23))).print("<td");
    }
}

