/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceOptionInfo;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesNodes
extends JerseyTestBase {
    private static MockRM rm;
    private static YarnConfiguration conf;
    private static String userName;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServicesNodes() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testNodes() throws JSONException, Exception {
        this.testNodesHelper("nodes", "application/json");
    }

    @Test
    public void testNodesSlash() throws JSONException, Exception {
        this.testNodesHelper("nodes/", "application/json");
    }

    @Test
    public void testNodesDefault() throws JSONException, Exception {
        this.testNodesHelper("nodes/", "");
    }

    @Test
    public void testNodesDefaultWithUnHealthyNode() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        RMNode node3 = this.getRunningRMNode("h3", 1236, 5122);
        NodeId nodeId3 = node3.getNodeID();
        RMNode node = (RMNode)rm.getRMContext().getRMNodes().get(nodeId3);
        NodeHealthStatus nodeHealth = NodeHealthStatus.newInstance((boolean)false, (String)"test health report", (long)System.currentTimeMillis());
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)nodeId3, (int)1, new ArrayList(), null, (NodeHealthStatus)nodeHealth, null, null, null);
        ((RMNodeImpl)node).handle((RMNodeEvent)new RMNodeStatusEvent(nodeId3, nodeStatus, null));
        rm.waitForState(nodeId3, NodeState.UNHEALTHY);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)nodeArray.length());
    }

    private RMNode getRunningRMNode(String host, int port, int memory) {
        RMNodeImpl rmnode1 = this.getNewRMNode(host, port, memory);
        this.sendStartedEvent((RMNode)rmnode1);
        return rmnode1;
    }

    private void sendStartedEvent(RMNode node) {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        ((RMNodeImpl)node).handle((RMNodeEvent)new RMNodeStartedEvent(node.getNodeID(), null, null, mockNodeStatus));
    }

    private void sendLostEvent(RMNode node) {
        ((RMNodeImpl)node).handle(new RMNodeEvent(node.getNodeID(), RMNodeEventType.EXPIRE));
    }

    private RMNodeImpl getNewRMNode(String host, int port, int memory) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)port);
        RMNodeImpl nodeImpl = new RMNodeImpl(nodeId, rm.getRMContext(), nodeId.getHost(), nodeId.getPort(), nodeId.getPort() + 1, RackResolver.resolve((String)nodeId.getHost()), Resource.newInstance((int)memory, (int)4), YarnVersionInfo.getVersion());
        rm.getRMContext().getRMNodes().put(nodeId, nodeImpl);
        return nodeImpl;
    }

    @Test
    public void testNodesQueryNew() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        RMNodeImpl rmnode2 = this.getNewRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.NEW.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodeArray.length());
        JSONObject info = nodeArray.getJSONObject(0);
        this.verifyNodeInfo(info, (RMNode)rmnode2);
    }

    @Test
    public void testNodesQueryStateNone() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.DECOMMISSIONED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"nodes is not empty", (Object)new JSONObject().toString(), (Object)json.get("nodes").toString());
    }

    @Test
    public void testNodesQueryStateInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "BOGUSSTATE").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception querying invalid state");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"org.apache.hadoop.yarn.api.records.NodeState.BOGUSSTATE", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
        }
    }

    @Test
    public void testNodesQueryStateLost() throws JSONException, Exception {
        WebResource r = this.resource();
        RMNode rmnode1 = this.getRunningRMNode("h1", 1234, 5120);
        this.sendLostEvent(rmnode1);
        RMNode rmnode2 = this.getRunningRMNode("h2", 1235, 5121);
        this.sendLostEvent(rmnode2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", NodeState.LOST.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodeArray.length());
        for (int i = 0; i < nodeArray.length(); ++i) {
            JSONObject info = nodeArray.getJSONObject(i);
            String[] node = info.get("id").toString().split(":");
            NodeId nodeId = NodeId.newInstance((String)node[0], (int)Integer.parseInt(node[1]));
            RMNode rmNode = (RMNode)rm.getRMContext().getInactiveRMNodes().get(nodeId);
            WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)"", (String)info.getString("nodeHTTPAddress"));
            if (rmNode == null) continue;
            WebServicesTestUtils.checkStringMatch((String)"state", (String)rmNode.getState().toString(), (String)info.getString("state"));
        }
    }

    @Test
    public void testSingleNodeQueryStateLost() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        RMNode rmnode2 = this.getRunningRMNode("h2", 1234, 5121);
        this.sendLostEvent(rmnode2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("h2:1234").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject info = json.getJSONObject("node");
        String id = info.get("id").toString();
        Assert.assertEquals((String)"Incorrect Node Information.", (Object)"h2:1234", (Object)id);
        RMNode rmNode = (RMNode)rm.getRMContext().getInactiveRMNodes().get(rmnode2.getNodeID());
        WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)"", (String)info.getString("nodeHTTPAddress"));
        if (rmNode != null) {
            WebServicesTestUtils.checkStringMatch((String)"state", (String)rmNode.getState().toString(), (String)info.getString("state"));
        }
    }

    @Test
    public void testNodesQueryRunning() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "running").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodeArray.length());
    }

    @Test
    public void testNodesQueryHealthyFalse() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", "UNHEALTHY").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"nodes is not empty", (Object)new JSONObject().toString(), (Object)json.get("nodes").toString());
    }

    public void testNodesHelper(String path, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        RMNode rmnode1 = this.getRunningRMNode("h1", 1234, 5120);
        RMNode rmnode2 = this.getRunningRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path(path).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodeArray.length());
        JSONObject info = nodeArray.getJSONObject(0);
        String id = info.get("id").toString();
        if (id.matches("h1:1234")) {
            this.verifyNodeInfo(info, rmnode1);
            this.verifyNodeInfo(nodeArray.getJSONObject(1), rmnode2);
        } else {
            this.verifyNodeInfo(info, rmnode2);
            this.verifyNodeInfo(nodeArray.getJSONObject(1), rmnode1);
        }
    }

    @Test
    public void testSingleNode() throws JSONException, Exception {
        this.getRunningRMNode("h1", 1234, 5120);
        RMNode rmnode2 = this.getRunningRMNode("h2", 1235, 5121);
        this.testSingleNodeHelper("h2:1235", rmnode2, "application/json");
    }

    @Test
    public void testSingleNodeSlash() throws JSONException, Exception {
        RMNode rmnode1 = this.getRunningRMNode("h1", 1234, 5120);
        this.getRunningRMNode("h2", 1235, 5121);
        this.testSingleNodeHelper("h1:1234/", rmnode1, "application/json");
    }

    @Test
    public void testSingleNodeDefault() throws JSONException, Exception {
        RMNode rmnode1 = this.getRunningRMNode("h1", 1234, 5120);
        this.getRunningRMNode("h2", 1235, 5121);
        this.testSingleNodeHelper("h1:1234/", rmnode1, "");
    }

    public void testSingleNodeHelper(String nodeid, RMNode nm, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path(nodeid).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("node");
        this.verifyNodeInfo(info, nm);
    }

    @Test
    public void testNonexistNode() throws JSONException, Exception {
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
    }

    @Test
    public void testNonexistNodeDefault() throws JSONException, Exception {
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
    }

    @Test
    public void testNonexistNodeXML() throws JSONException, Exception {
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid:99").accept(new String[]{"application/xml"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            String msg = (String)response.getEntity(String.class);
            System.out.println(msg);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(msg));
            Document dom = db.parse(is);
            NodeList nodes = dom.getElementsByTagName("RemoteException");
            Element element = (Element)nodes.item(0);
            String message = WebServicesTestUtils.getXmlString((Element)element, (String)"message");
            String type = WebServicesTestUtils.getXmlString((Element)element, (String)"exception");
            String classname = WebServicesTestUtils.getXmlString((Element)element, (String)"javaClassName");
            this.verifyNonexistNodeException(message, type, classname);
        }
    }

    private void verifyNonexistNodeException(String message, String type, String classname) {
        Assert.assertTrue((String)("exception message incorrect: " + message), (boolean)"java.lang.Exception: nodeId, node_invalid:99, is not found".matches(message));
        Assert.assertTrue((String)"exception type incorrect", (boolean)"NotFoundException".matches(type));
        Assert.assertTrue((String)"exception className incorrect", (boolean)"org.apache.hadoop.yarn.webapp.NotFoundException".matches(classname));
    }

    @Test
    public void testInvalidNode() throws JSONException, Exception {
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("nodes").path("node_invalid_foo").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on non-existent nodeid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"Invalid NodeId \\[node_invalid_foo\\]. Expected host:port", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
        }
    }

    @Test
    public void testNodesXML() throws JSONException, Exception {
        WebResource r = this.resource();
        RMNodeImpl rmnode1 = this.getNewRMNode("h1", 1234, 5120);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyNodesXML(nodes, (RMNode)rmnode1);
    }

    @Test
    public void testSingleNodesXML() throws JSONException, Exception {
        WebResource r = this.resource();
        RMNodeImpl rmnode1 = this.getNewRMNode("h1", 1234, 5120);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("h1:1234").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyNodesXML(nodes, (RMNode)rmnode1);
    }

    @Test
    public void testNodes2XML() throws JSONException, Exception {
        WebResource r = this.resource();
        this.getNewRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
    }

    @Test
    public void testQueryAll() throws Exception {
        WebResource r = this.resource();
        this.getRunningRMNode("h1", 1234, 5120);
        this.getNewRMNode("h2", 1235, 5121);
        RMNode nm3 = this.getRunningRMNode("h3", 1236, 5122);
        this.sendLostEvent(nm3);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").queryParam("states", Joiner.on((char)',').join(EnumSet.allOf(NodeState.class))).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)nodeArray.length());
    }

    @Test
    public void testNodesResourceUtilization() throws JSONException, Exception {
        WebResource r = this.resource();
        RMNode rmnode1 = this.getRunningRMNode("h1", 1234, 5120);
        NodeId nodeId1 = rmnode1.getNodeID();
        RMNodeImpl node = (RMNodeImpl)rm.getRMContext().getRMNodes().get(nodeId1);
        NodeHealthStatus nodeHealth = NodeHealthStatus.newInstance((boolean)true, (String)"test health report", (long)System.currentTimeMillis());
        ResourceUtilization nodeResource = ResourceUtilization.newInstance((int)4096, (int)0, (float)10.5f);
        ResourceUtilization containerResource = ResourceUtilization.newInstance((int)2048, (int)0, (float)5.05f);
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)nodeId1, (int)0, new ArrayList(), null, (NodeHealthStatus)nodeHealth, (ResourceUtilization)containerResource, (ResourceUtilization)nodeResource, null);
        node.handle((RMNodeEvent)new RMNodeStatusEvent(nodeId1, nodeStatus, null));
        rm.waitForState(nodeId1, NodeState.RUNNING);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject nodes = json.getJSONObject("nodes");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.length());
        JSONArray nodeArray = nodes.getJSONArray("node");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodeArray.length());
        JSONObject info = nodeArray.getJSONObject(0);
        this.verifyNodeInfo(info, rmnode1);
    }

    @Test
    public void testUpdateNodeResource() throws Exception {
        WebResource r = this.resource().path("/ws/v1/cluster");
        r = r.queryParam("user.name", userName);
        RMNode rmnode = this.getRunningRMNode("h1", 1234, 5120);
        String rmnodeId = rmnode.getNodeID().toString();
        Assert.assertEquals((Object)"h1:1234", (Object)rmnodeId);
        ClientResponse response = (ClientResponse)r.path("/nodes").path(rmnodeId).accept(new String[]{"application/xml"}).get(ClientResponse.class);
        NodeInfo nodeInfo0 = (NodeInfo)response.getEntity(NodeInfo.class);
        ResourceInfo nodeResource0 = nodeInfo0.getTotalResource();
        Assert.assertEquals((long)5120L, (long)nodeResource0.getMemorySize());
        Assert.assertEquals((long)4L, (long)nodeResource0.getvCores());
        rm.start();
        Resource resource = Resource.newInstance((int)8192, (int)5);
        ResourceOptionInfo resourceOption = new ResourceOptionInfo(ResourceOption.newInstance((Resource)resource, (int)1000));
        response = (ClientResponse)((WebResource.Builder)r.path("/nodes").path(rmnodeId).path("resource").entity((Object)resourceOption, MediaType.APPLICATION_XML_TYPE).accept(new String[]{"application/xml"})).post(ClientResponse.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.OK, (Response.StatusType)response.getStatusInfo());
        ResourceInfo updatedResource = (ResourceInfo)response.getEntity(ResourceInfo.class);
        Assert.assertEquals((long)8192L, (long)updatedResource.getMemorySize());
        Assert.assertEquals((long)5L, (long)updatedResource.getvCores());
        response = (ClientResponse)r.path("/nodes").path(rmnodeId).accept(new String[]{"application/xml"}).get(ClientResponse.class);
        NodeInfo nodeInfo1 = (NodeInfo)response.getEntity(NodeInfo.class);
        ResourceInfo nodeResource1 = nodeInfo1.getTotalResource();
        Assert.assertEquals((long)8192L, (long)nodeResource1.getMemorySize());
        Assert.assertEquals((long)5L, (long)nodeResource1.getvCores());
        response = (ClientResponse)((WebResource.Builder)r.path("/nodes").path("badnode").path("resource").entity((Object)resourceOption, MediaType.APPLICATION_XML_TYPE).accept(new String[]{"application/json"})).post(ClientResponse.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = json.getJSONObject("RemoteException");
        Assert.assertEquals((Object)"IllegalArgumentException", (Object)exception.getString("exception"));
        String msg = exception.getString("message");
        Assert.assertTrue((String)("Wrong message: " + msg), (boolean)msg.startsWith("Invalid NodeId"));
        rm.stop();
    }

    public void verifyNodesXML(NodeList nodes, RMNode nm) throws JSONException, Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyNodeInfoGeneric(nm, WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"rack"), WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHostName"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHTTPAddress"), WebServicesTestUtils.getXmlLong((Element)element, (String)"lastHealthUpdate"), WebServicesTestUtils.getXmlString((Element)element, (String)"healthReport"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numContainers"), WebServicesTestUtils.getXmlLong((Element)element, (String)"usedMemoryMB"), WebServicesTestUtils.getXmlLong((Element)element, (String)"availMemoryMB"), WebServicesTestUtils.getXmlLong((Element)element, (String)"usedVirtualCores"), WebServicesTestUtils.getXmlLong((Element)element, (String)"availableVirtualCores"), WebServicesTestUtils.getXmlString((Element)element, (String)"version"), WebServicesTestUtils.getXmlInt((Element)element, (String)"nodePhysicalMemoryMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"nodeVirtualMemoryMB"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"nodeCPUUsage"), WebServicesTestUtils.getXmlInt((Element)element, (String)"aggregatedContainersPhysicalMemoryMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"aggregatedContainersVirtualMemoryMB"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"containersCPUUsage"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numRunningOpportContainers"), WebServicesTestUtils.getXmlLong((Element)element, (String)"usedMemoryOpportGB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"usedVirtualCoresOpport"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numQueuedContainers"));
        }
    }

    public void verifyNodeInfo(JSONObject nodeInfo, RMNode nm) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)23L, (long)nodeInfo.length());
        JSONObject resourceInfo = nodeInfo.getJSONObject("resourceUtilization");
        this.verifyNodeInfoGeneric(nm, nodeInfo.getString("state"), nodeInfo.getString("rack"), nodeInfo.getString("id"), nodeInfo.getString("nodeHostName"), nodeInfo.getString("nodeHTTPAddress"), nodeInfo.getLong("lastHealthUpdate"), nodeInfo.getString("healthReport"), nodeInfo.getInt("numContainers"), nodeInfo.getLong("usedMemoryMB"), nodeInfo.getLong("availMemoryMB"), nodeInfo.getLong("usedVirtualCores"), nodeInfo.getLong("availableVirtualCores"), nodeInfo.getString("version"), resourceInfo.getInt("nodePhysicalMemoryMB"), resourceInfo.getInt("nodeVirtualMemoryMB"), resourceInfo.getDouble("nodeCPUUsage"), resourceInfo.getInt("aggregatedContainersPhysicalMemoryMB"), resourceInfo.getInt("aggregatedContainersVirtualMemoryMB"), resourceInfo.getDouble("containersCPUUsage"), nodeInfo.getInt("numRunningOpportContainers"), nodeInfo.getLong("usedMemoryOpportGB"), nodeInfo.getInt("usedVirtualCoresOpport"), nodeInfo.getInt("numQueuedContainers"));
    }

    public void verifyNodeInfoGeneric(RMNode node, String state, String rack, String id, String nodeHostName, String nodeHTTPAddress, long lastHealthUpdate, String healthReport, int numContainers, long usedMemoryMB, long availMemoryMB, long usedVirtualCores, long availVirtualCores, String version, int nodePhysicalMemoryMB, int nodeVirtualMemoryMB, double nodeCPUUsage, int containersPhysicalMemoryMB, int containersVirtualMemoryMB, double containersCPUUsage, int numRunningOpportContainers, long usedMemoryOpportGB, int usedVirtualCoresOpport, int numQueuedContainers) throws JSONException, Exception {
        ResourceScheduler sched = rm.getResourceScheduler();
        SchedulerNodeReport report = sched.getNodeReport(node.getNodeID());
        OpportunisticContainersStatus opportunisticStatus = node.getOpportunisticContainersStatus();
        WebServicesTestUtils.checkStringMatch((String)"state", (String)node.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"rack", (String)node.getRackName(), (String)rack);
        WebServicesTestUtils.checkStringMatch((String)"id", (String)node.getNodeID().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"nodeHostName", (String)node.getNodeID().getHost(), (String)nodeHostName);
        WebServicesTestUtils.checkStringMatch((String)"healthReport", (String)String.valueOf(node.getHealthReport()), (String)healthReport);
        String expectedHttpAddress = node.getNodeID().getHost() + ":" + node.getHttpPort();
        WebServicesTestUtils.checkStringMatch((String)"nodeHTTPAddress", (String)expectedHttpAddress, (String)nodeHTTPAddress);
        WebServicesTestUtils.checkStringMatch((String)"version", (String)node.getNodeManagerVersion(), (String)version);
        if (node.getNodeUtilization() != null) {
            ResourceUtilization nodeResource = ResourceUtilization.newInstance((int)nodePhysicalMemoryMB, (int)nodeVirtualMemoryMB, (float)((float)nodeCPUUsage));
            Assert.assertEquals((String)"nodeResourceUtilization doesn't match", (Object)node.getNodeUtilization(), (Object)nodeResource);
        }
        if (node.getAggregatedContainersUtilization() != null) {
            ResourceUtilization containerResource = ResourceUtilization.newInstance((int)containersPhysicalMemoryMB, (int)containersVirtualMemoryMB, (float)((float)containersCPUUsage));
            Assert.assertEquals((String)"containerResourceUtilization doesn't match", (Object)node.getAggregatedContainersUtilization(), (Object)containerResource);
        }
        long expectedHealthUpdate = node.getLastHealthReportTime();
        Assert.assertEquals((String)("lastHealthUpdate doesn't match, got: " + lastHealthUpdate + " expected: " + expectedHealthUpdate), (long)expectedHealthUpdate, (long)lastHealthUpdate);
        if (report != null) {
            Assert.assertEquals((String)("numContainers doesn't match: " + numContainers), (long)report.getNumContainers(), (long)numContainers);
            Assert.assertEquals((String)("usedMemoryMB doesn't match: " + usedMemoryMB), (long)report.getUsedResource().getMemorySize(), (long)usedMemoryMB);
            Assert.assertEquals((String)("availMemoryMB doesn't match: " + availMemoryMB), (long)report.getAvailableResource().getMemorySize(), (long)availMemoryMB);
            Assert.assertEquals((String)("usedVirtualCores doesn't match: " + usedVirtualCores), (long)report.getUsedResource().getVirtualCores(), (long)usedVirtualCores);
            Assert.assertEquals((String)("availVirtualCores doesn't match: " + availVirtualCores), (long)report.getAvailableResource().getVirtualCores(), (long)availVirtualCores);
        }
        if (opportunisticStatus != null) {
            Assert.assertEquals((String)("numRunningOpportContainers doesn't match: " + numRunningOpportContainers), (long)opportunisticStatus.getRunningOpportContainers(), (long)numRunningOpportContainers);
            Assert.assertEquals((String)("usedMemoryOpportGB doesn't match: " + usedMemoryOpportGB), (long)opportunisticStatus.getOpportMemoryUsed(), (long)usedMemoryOpportGB);
            Assert.assertEquals((String)("usedVirtualCoresOpport doesn't match: " + usedVirtualCoresOpport), (long)opportunisticStatus.getOpportCoresUsed(), (long)usedVirtualCoresOpport);
            Assert.assertEquals((String)("numQueuedContainers doesn't match: " + numQueuedContainers), (long)opportunisticStatus.getQueuedOpportContainers(), (long)numQueuedContainers);
        }
    }

    @Test
    public void testNodesAllocationTags() throws Exception {
        NodeId nm1 = NodeId.newInstance((String)"host1", (int)1234);
        NodeId nm2 = NodeId.newInstance((String)"host2", (int)2345);
        AllocationTagsManager atm = (AllocationTagsManager)Mockito.mock(AllocationTagsManager.class);
        TreeMap<String, Map<String, Long>> expectedAllocationTags = new TreeMap<String, Map<String, Long>>();
        TreeMap<String, Long> nm1Tags = new TreeMap<String, Long>();
        nm1Tags.put("A", 1L);
        nm1Tags.put("B", 2L);
        TreeMap<String, Long> nm2Tags = new TreeMap<String, Long>();
        nm2Tags.put("C", 1L);
        nm2Tags.put("D", 2L);
        expectedAllocationTags.put(nm1.toString(), nm1Tags);
        expectedAllocationTags.put(nm2.toString(), nm2Tags);
        Mockito.when((Object)atm.getAllocationTagsWithCount(nm1)).thenReturn(nm1Tags);
        Mockito.when((Object)atm.getAllocationTagsWithCount(nm2)).thenReturn(nm2Tags);
        rm.getRMContext().setAllocationTagsManager(atm);
        rm.start();
        rm.registerNode(nm1.toString(), 1024);
        rm.registerNode(nm2.toString(), 1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject nodesInfoJson = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyNodeAllocationTag(nodesInfoJson, expectedAllocationTags);
        rm.stop();
    }

    @Test
    public void testNodeAttributesInfo() throws Exception {
        ResourceTrackerService resourceTrackerService = rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host1", (int)1234);
        Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        HashSet<NodeAttribute> nodeAttributes = new HashSet<NodeAttribute>();
        nodeAttributes.add(NodeAttribute.newInstance((String)"nm.yarn.io", (String)"host", (NodeAttributeType)NodeAttributeType.STRING, (String)"host1"));
        nodeAttributes.add(NodeAttribute.newInstance((String)"nm.yarn.io", (String)"rack", (NodeAttributeType)NodeAttributeType.STRING, (String)"rack1"));
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus nodeStatus = NodeStatus.newInstance((NodeId)nodeId, (int)0, new ArrayList(), null, null, null, null, null);
        heartbeatReq.setNodeStatus(nodeStatus);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        heartbeatReq.setNodeAttributes(nodeAttributes);
        resourceTrackerService.nodeHeartbeat(heartbeatReq);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject nodesInfoJson = (JSONObject)response.getEntity(JSONObject.class);
        JSONArray nodes = nodesInfoJson.getJSONObject("nodes").getJSONArray("node");
        JSONObject nodeJson = nodes.getJSONObject(0);
        JSONArray nodeAttributesInfo = nodeJson.getJSONObject("nodeAttributesInfo").getJSONArray("nodeAttributeInfo");
        Assert.assertEquals((long)nodeAttributes.size(), (long)nodeAttributesInfo.length());
        Iterator it = nodeAttributes.iterator();
        for (int j = 0; j < nodeAttributesInfo.length(); ++j) {
            JSONObject nodeAttributeInfo = nodeAttributesInfo.getJSONObject(j);
            NodeAttribute expectedNodeAttribute = (NodeAttribute)it.next();
            String expectedPrefix = expectedNodeAttribute.getAttributeKey().getAttributePrefix();
            String expectedName = expectedNodeAttribute.getAttributeKey().getAttributeName();
            String expectedType = expectedNodeAttribute.getAttributeType().toString();
            String expectedValue = expectedNodeAttribute.getAttributeValue();
            Assert.assertEquals((Object)expectedPrefix, (Object)nodeAttributeInfo.getString("prefix"));
            Assert.assertEquals((Object)expectedName, (Object)nodeAttributeInfo.getString("name"));
            Assert.assertEquals((Object)expectedType, (Object)nodeAttributeInfo.getString("type"));
            Assert.assertEquals((Object)expectedValue, (Object)nodeAttributeInfo.getString("value"));
        }
    }

    private void verifyNodeAllocationTag(JSONObject json, Map<String, Map<String, Long>> expectedAllocationTags) throws JSONException {
        JSONArray nodes = json.getJSONObject("nodes").getJSONArray("node");
        Assert.assertEquals((long)expectedAllocationTags.size(), (long)nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject nodeJson = nodes.getJSONObject(i);
            String nodeId = nodeJson.getString("id");
            Assert.assertTrue((String)"Nodes info should have expected node IDs", (boolean)expectedAllocationTags.containsKey(nodeId));
            Map<String, Long> expectedTags = expectedAllocationTags.get(nodeId);
            JSONArray tagsInfo = nodeJson.getJSONObject("allocationTags").getJSONArray("allocationTagInfo");
            Assert.assertEquals((long)expectedTags.size(), (long)tagsInfo.length());
            Iterator<String> it = expectedTags.keySet().iterator();
            for (int j = 0; j < tagsInfo.length(); ++j) {
                JSONObject tagInfo = tagsInfo.getJSONObject(j);
                String expectedTag = it.next();
                Assertions.assertThat((String)tagInfo.getString("allocationTag")).isEqualTo((Object)expectedTag);
                Assertions.assertThat((long)tagInfo.getLong("allocationsCount")).isEqualTo(expectedTags.get(expectedTag).longValue());
            }
        }
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    @Singleton
    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "true");
            return props;
        }
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            conf = new YarnConfiguration();
            conf.set("yarn.admin.acl", userName);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            rm = new MockRM((Configuration)conf);
            rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
            rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
            rm.disableDrainEventsImplicitly();
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.filter("/*", new String[0]).through(TestRMCustomAuthFilter.class);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

