/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler.FairSchedulerJsonVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler.FairSchedulerXmlVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.JsonCustomResourceTypeTestcase;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class TestRMWebServicesFairSchedulerCustomResourceTypes
extends JerseyTestBase {
    private static MockRM rm;
    private static YarnConfiguration conf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createInjectorForWebServletModule();
    }

    @After
    public void tearDown() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    private void createInjectorForWebServletModule() {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    @After
    public void teardown() {
        CustomResourceTypesConfigurationProvider.reset();
    }

    public TestRMWebServicesFairSchedulerCustomResourceTypes() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testClusterSchedulerWithCustomResourceTypesJson() {
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebResource path = this.resource().path("ws").path("v1").path("cluster").path("scheduler");
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/json"}).get(ClientResponse.class);
        this.verifyJsonResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerWithCustomResourceTypesXml() {
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebResource path = this.resource().path("ws").path("v1").path("cluster").path("scheduler");
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        this.verifyXmlResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerWithElevenCustomResourceTypesXml() {
        CustomResourceTypesConfigurationProvider.setResourceTypes((int)11, (String)"k");
        this.createInjectorForWebServletModule();
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebResource path = this.resource().path("ws").path("v1").path("cluster").path("scheduler");
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        this.verifyXmlResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerElevenWithCustomResourceTypesJson() {
        CustomResourceTypesConfigurationProvider.setResourceTypes((int)11, (String)"k");
        this.createInjectorForWebServletModule();
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebResource path = this.resource().path("ws").path("v1").path("cluster").path("scheduler");
        ClientResponse response = (ClientResponse)path.accept(new String[]{"application/json"}).get(ClientResponse.class);
        this.verifyJsonResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    private void verifyJsonResponse(WebResource path, ClientResponse response, List<String> customResourceTypes) {
        JsonCustomResourceTypeTestcase testCase = new JsonCustomResourceTypeTestcase(path, new BufferedClientResponse(response));
        testCase.verify(json -> {
            try {
                JSONArray queues = json.getJSONObject("scheduler").getJSONObject("schedulerInfo").getJSONObject("rootQueue").getJSONObject("childQueues").getJSONArray("queue");
                Assert.assertEquals((long)2L, (long)queues.length());
                JSONObject firstChildQueue = queues.getJSONObject(0);
                new FairSchedulerJsonVerifications(customResourceTypes).verify(firstChildQueue);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void verifyXmlResponse(WebResource path, ClientResponse response, List<String> customResourceTypes) {
        XmlCustomResourceTypeTestCase testCase = new XmlCustomResourceTypeTestCase(path, new BufferedClientResponse(response));
        testCase.verify(xml -> {
            Element scheduler = (Element)xml.getElementsByTagName("scheduler").item(0);
            Element schedulerInfo = (Element)scheduler.getElementsByTagName("schedulerInfo").item(0);
            Element rootQueue = (Element)schedulerInfo.getElementsByTagName("rootQueue").item(0);
            Element childQueues = (Element)rootQueue.getElementsByTagName("childQueues").item(0);
            Element queue = (Element)childQueues.getElementsByTagName("queue").item(0);
            new FairSchedulerXmlVerifications(customResourceTypes).verify(queue);
        });
    }

    private void incrementUsedResourcesOnQueue(FSLeafQueue queue, long value) {
        try {
            Method incUsedResourceMethod = queue.getClass().getSuperclass().getDeclaredMethod("incUsedResource", Resource.class);
            incUsedResourceMethod.setAccessible(true);
            Map customResources = CustomResourceTypesConfigurationProvider.getCustomResourceTypes().stream().collect(Collectors.toMap(Function.identity(), v -> value));
            incUsedResourceMethod.invoke((Object)queue, Resource.newInstance((long)20L, (int)30, customResources));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            conf = new YarnConfiguration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
            this.initResourceTypes(conf);
            rm = new MockRM((Configuration)conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }

        private void initResourceTypes(YarnConfiguration conf) {
            conf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
    }
}

