/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.junit.Assert;
import org.w3c.dom.Element;

public final class AppInfoXmlVerifications {
    private AppInfoXmlVerifications() {
    }

    public static void verify(Element info, RMApp app) {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)app.getApplicationId().toString(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"id"));
        WebServicesTestUtils.checkStringMatch((String)"user", (String)app.getUser(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"user"));
        WebServicesTestUtils.checkStringMatch((String)"name", (String)app.getName(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"name"));
        WebServicesTestUtils.checkStringMatch((String)"applicationType", (String)app.getApplicationType(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"applicationType"));
        WebServicesTestUtils.checkStringMatch((String)"queue", (String)app.getQueue(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"queue"));
        Assert.assertEquals((String)"priority doesn't match", (long)0L, (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"priority"));
        WebServicesTestUtils.checkStringMatch((String)"state", (String)app.getState().toString(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"state"));
        WebServicesTestUtils.checkStringMatch((String)"finalStatus", (String)app.getFinalApplicationStatus().toString(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"finalStatus"));
        Assert.assertEquals((String)"progress doesn't match", (double)0.0, (double)WebServicesTestUtils.getXmlFloat((Element)info, (String)"progress"), (double)0.0);
        if ("UNASSIGNED".equals(WebServicesTestUtils.getXmlString((Element)info, (String)"trackingUI"))) {
            WebServicesTestUtils.checkStringMatch((String)"trackingUI", (String)"UNASSIGNED", (String)WebServicesTestUtils.getXmlString((Element)info, (String)"trackingUI"));
        }
        WebServicesTestUtils.checkStringEqual((String)"diagnostics", (String)app.getDiagnostics().toString(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"diagnostics"));
        Assert.assertEquals((String)"clusterId doesn't match", (long)ResourceManager.getClusterTimeStamp(), (long)WebServicesTestUtils.getXmlLong((Element)info, (String)"clusterId"));
        Assert.assertEquals((String)"startedTime doesn't match", (long)app.getStartTime(), (long)WebServicesTestUtils.getXmlLong((Element)info, (String)"startedTime"));
        Assert.assertEquals((String)"finishedTime doesn't match", (long)app.getFinishTime(), (long)WebServicesTestUtils.getXmlLong((Element)info, (String)"finishedTime"));
        Assert.assertTrue((String)"elapsed time not greater than 0", (WebServicesTestUtils.getXmlLong((Element)info, (String)"elapsedTime") > 0L ? 1 : 0) != 0);
        WebServicesTestUtils.checkStringMatch((String)"amHostHttpAddress", (String)app.getCurrentAppAttempt().getMasterContainer().getNodeHttpAddress(), (String)WebServicesTestUtils.getXmlString((Element)info, (String)"amHostHttpAddress"));
        Assert.assertTrue((String)"amContainerLogs doesn't match", (boolean)WebServicesTestUtils.getXmlString((Element)info, (String)"amContainerLogs").startsWith("http://"));
        Assert.assertTrue((String)"amContainerLogs doesn't contain user info", (boolean)WebServicesTestUtils.getXmlString((Element)info, (String)"amContainerLogs").endsWith("/" + app.getUser()));
        Assert.assertEquals((String)"allocatedMB doesn't match", (long)1024L, (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"allocatedMB"));
        Assert.assertEquals((String)"allocatedVCores doesn't match", (long)1L, (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"allocatedVCores"));
        Assert.assertEquals((String)"queueUsagePerc doesn't match", (float)50.0f, (float)WebServicesTestUtils.getXmlFloat((Element)info, (String)"queueUsagePercentage"), (float)0.01f);
        Assert.assertEquals((String)"clusterUsagePerc doesn't match", (float)50.0f, (float)WebServicesTestUtils.getXmlFloat((Element)info, (String)"clusterUsagePercentage"), (float)0.01f);
        Assert.assertEquals((String)"numContainers doesn't match", (long)1L, (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"runningContainers"));
        Assert.assertNotNull((String)"preemptedResourceSecondsMap should not be null", (Object)info.getElementsByTagName("preemptedResourceSecondsMap"));
        Assert.assertEquals((String)"preemptedResourceMB doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getMemorySize(), (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"preemptedResourceMB"));
        Assert.assertEquals((String)"preemptedResourceVCores doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getVirtualCores(), (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"preemptedResourceVCores"));
        Assert.assertEquals((String)"numNonAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumNonAMContainersPreempted(), (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"numNonAMContainerPreempted"));
        Assert.assertEquals((String)"numAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumAMContainersPreempted(), (long)WebServicesTestUtils.getXmlInt((Element)info, (String)"numAMContainerPreempted"));
        Assert.assertEquals((String)"Log aggregation Status doesn't match", (Object)app.getLogAggregationStatusForAppReport().toString(), (Object)WebServicesTestUtils.getXmlString((Element)info, (String)"logAggregationStatus"));
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)app.getApplicationSubmissionContext().getUnmanagedAM(), (Object)WebServicesTestUtils.getXmlBoolean((Element)info, (String)"unmanagedApplication"));
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)app.getApplicationSubmissionContext().getNodeLabelExpression(), (Object)WebServicesTestUtils.getXmlString((Element)info, (String)"appNodeLabelExpression"));
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression(), (Object)WebServicesTestUtils.getXmlString((Element)info, (String)"amNodeLabelExpression"));
        Assert.assertEquals((String)"amRPCAddress", (Object)AppInfo.getAmRPCAddressFromRMAppAttempt((RMAppAttempt)app.getCurrentAppAttempt()), (Object)WebServicesTestUtils.getXmlString((Element)info, (String)"amRPCAddress"));
    }
}

