/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.util.Records;

public final class MockRMAppSubmissionData {
    private final List<ResourceRequest> amResourceRequests;
    private final String name;
    private final String user;
    private final Map<ApplicationAccessType, String> acls;
    private final boolean unmanaged;
    private final String queue;
    private final int maxAppAttempts;
    private final String appType;
    private final boolean waitForAccepted;
    private final boolean keepContainers;
    private final boolean isAppIdProvided;
    private final ApplicationId applicationId;
    private final long attemptFailuresValidityInterval;
    private final LogAggregationContext logAggregationContext;
    private final boolean cancelTokensWhenComplete;
    private final Priority priority;
    private final String amLabel;
    private final Map<ApplicationTimeoutType, Long> applicationTimeouts;
    private final ByteBuffer tokensConf;
    private final Set<String> applicationTags;
    private final String appNodeLabel;
    private final Credentials credentials;
    private final Resource resource;

    public List<ResourceRequest> getAmResourceRequests() {
        return this.amResourceRequests;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public Map<ApplicationAccessType, String> getAcls() {
        return this.acls;
    }

    public boolean isUnmanaged() {
        return this.unmanaged;
    }

    public String getQueue() {
        return this.queue;
    }

    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    public String getAppType() {
        return this.appType;
    }

    public boolean isWaitForAccepted() {
        return this.waitForAccepted;
    }

    public boolean isKeepContainers() {
        return this.keepContainers;
    }

    public boolean isAppIdProvided() {
        return this.isAppIdProvided;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public long getAttemptFailuresValidityInterval() {
        return this.attemptFailuresValidityInterval;
    }

    public LogAggregationContext getLogAggregationContext() {
        return this.logAggregationContext;
    }

    public boolean isCancelTokensWhenComplete() {
        return this.cancelTokensWhenComplete;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getAmLabel() {
        return this.amLabel;
    }

    public Map<ApplicationTimeoutType, Long> getApplicationTimeouts() {
        return this.applicationTimeouts;
    }

    public ByteBuffer getTokensConf() {
        return this.tokensConf;
    }

    public Set<String> getApplicationTags() {
        return this.applicationTags;
    }

    public String getAppNodeLabel() {
        return this.appNodeLabel;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Resource getResource() {
        return this.resource;
    }

    private MockRMAppSubmissionData(Builder builder) {
        this.amLabel = builder.amLabel;
        this.tokensConf = builder.tokensConf;
        this.maxAppAttempts = builder.maxAppAttempts;
        this.logAggregationContext = builder.logAggregationContext;
        this.queue = builder.queue;
        this.amResourceRequests = builder.amResourceRequests;
        this.user = builder.user;
        this.priority = builder.priority;
        this.waitForAccepted = builder.waitForAccepted;
        this.keepContainers = builder.keepContainers;
        this.name = builder.name;
        this.applicationId = builder.applicationId;
        this.attemptFailuresValidityInterval = builder.attemptFailuresValidityInterval;
        this.acls = builder.acls;
        this.appType = builder.appType;
        this.appNodeLabel = builder.appNodeLabel;
        this.isAppIdProvided = builder.isAppIdProvided;
        this.unmanaged = builder.unmanaged;
        this.applicationTags = builder.applicationTags;
        this.cancelTokensWhenComplete = builder.cancelTokensWhenComplete;
        this.applicationTimeouts = builder.applicationTimeouts;
        this.credentials = builder.credentials;
        this.resource = builder.resource;
    }

    public static final class Builder {
        private List<ResourceRequest> amResourceRequests;
        private String name;
        private String user;
        private Map<ApplicationAccessType, String> acls;
        private boolean unmanaged;
        private String queue;
        private int maxAppAttempts;
        private String appType;
        private boolean waitForAccepted;
        private boolean keepContainers;
        private boolean isAppIdProvided;
        private ApplicationId applicationId;
        private long attemptFailuresValidityInterval;
        private LogAggregationContext logAggregationContext;
        private boolean cancelTokensWhenComplete;
        private Priority priority;
        private String amLabel;
        private Map<ApplicationTimeoutType, Long> applicationTimeouts;
        private ByteBuffer tokensConf;
        private Set<String> applicationTags;
        private String appNodeLabel;
        private Credentials credentials;
        private Resource resource;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder createWithMemory(long memory, MockRM mockRM) throws IOException {
            Resource resource = (Resource)Records.newRecord(Resource.class);
            resource.setMemorySize(memory);
            return Builder.createWithResource(resource, mockRM);
        }

        public static Builder createWithResource(Resource resource, MockRM mockRM) throws IOException {
            int maxAppAttempts = mockRM.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2);
            return Builder.create().withResource(resource).withAppName("").withUser(UserGroupInformation.getCurrentUser().getShortUserName()).withAcls(null).withUnmanagedAM(false).withQueue(null).withMaxAppAttempts(maxAppAttempts).withCredentials(null).withAppType(null).withWaitForAppAcceptedState(true).withKeepContainers(false).withApplicationId(null).withAttemptFailuresValidityInterval(0L).withLogAggregationContext(null).withCancelTokensWhenComplete(true).withAppPriority(Priority.newInstance((int)0)).withAmLabel("").withApplicationTimeouts(null).withTokensConf(null);
        }

        public Builder withAmResourceRequests(List<ResourceRequest> amResourceRequests) {
            this.amResourceRequests = amResourceRequests;
            return this;
        }

        public Builder withAppName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withAcls(Map<ApplicationAccessType, String> acls) {
            this.acls = acls;
            return this;
        }

        public Builder withUnmanagedAM(boolean unmanaged) {
            this.unmanaged = unmanaged;
            return this;
        }

        public Builder withQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public Builder withMaxAppAttempts(int maxAppAttempts) {
            this.maxAppAttempts = maxAppAttempts;
            return this;
        }

        public Builder withAppType(String appType) {
            this.appType = appType;
            return this;
        }

        public Builder withWaitForAppAcceptedState(boolean waitForAccepted) {
            this.waitForAccepted = waitForAccepted;
            return this;
        }

        public Builder withKeepContainers(boolean keepContainers) {
            this.keepContainers = keepContainers;
            return this;
        }

        public Builder withApplicationId(ApplicationId applicationId) {
            this.applicationId = applicationId;
            this.isAppIdProvided = applicationId != null;
            return this;
        }

        public Builder withAttemptFailuresValidityInterval(long attemptFailuresValidityInterval) {
            this.attemptFailuresValidityInterval = attemptFailuresValidityInterval;
            return this;
        }

        public Builder withLogAggregationContext(LogAggregationContext logAggregationContext) {
            this.logAggregationContext = logAggregationContext;
            return this;
        }

        public Builder withCancelTokensWhenComplete(boolean cancelTokensWhenComplete) {
            this.cancelTokensWhenComplete = cancelTokensWhenComplete;
            return this;
        }

        public Builder withAppPriority(Priority priority2) {
            this.priority = priority2;
            return this;
        }

        public Builder withAmLabel(String amLabel) {
            this.amLabel = amLabel;
            return this;
        }

        public Builder withApplicationTimeouts(Map<ApplicationTimeoutType, Long> applicationTimeouts) {
            this.applicationTimeouts = applicationTimeouts;
            return this;
        }

        public Builder withTokensConf(ByteBuffer tokensConf) {
            this.tokensConf = tokensConf;
            return this;
        }

        public Builder withApplicationTags(Set<String> applicationTags) {
            this.applicationTags = applicationTags;
            return this;
        }

        public Builder withAppNodeLabel(String appNodeLabel) {
            this.appNodeLabel = appNodeLabel;
            return this;
        }

        public Builder withCredentials(Credentials cred) {
            this.credentials = cred;
            return this;
        }

        public Builder withResource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public MockRMAppSubmissionData build() {
            return new MockRMAppSubmissionData(this);
        }
    }
}

