/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMDelegationTokenIdentifierForTest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientRMTokens {
    private static final Logger LOG = LoggerFactory.getLogger(TestClientRMTokens.class);

    @BeforeClass
    public static void setUp() {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setConfiguration((Configuration)conf);
    }

    @AfterClass
    public static void tearDown() {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.token.service.use_ip", false);
        SecurityUtil.setConfiguration((Configuration)conf);
    }

    @Before
    public void resetSecretManager() {
        RMDelegationTokenIdentifier.Renewer.setSecretManager(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationToken() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.principal", "testuser/localhost@apache.org");
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ResourceScheduler scheduler = TestClientRMTokens.createMockScheduler((Configuration)conf);
        long initialInterval = 10000L;
        long maxLifetime = 20000L;
        long renewInterval = 10000L;
        long delegationTokenRemoverScanInterval = conf.getTimeDuration("yarn.resourcemanager.delegation.token.remove-scan-interval", 3600000L, TimeUnit.MILLISECONDS);
        RMDelegationTokenSecretManager rmDtSecretManager = TestClientRMTokens.createRMDelegationTokenSecretManager(initialInterval, maxLifetime, renewInterval, delegationTokenRemoverScanInterval);
        rmDtSecretManager.startThreads();
        LOG.info("Creating DelegationTokenSecretManager with initialInterval: " + initialInterval + ", maxLifetime: " + maxLifetime + ", renewInterval: " + renewInterval);
        ClientRMServiceForTest clientRMService = new ClientRMServiceForTest((Configuration)conf, scheduler, rmDtSecretManager);
        clientRMService.init((Configuration)conf);
        clientRMService.start();
        ApplicationClientProtocol clientRMWithDT = null;
        try {
            UserGroupInformation loggedInUser = UserGroupInformation.createRemoteUser((String)"testrenewer@APACHE.ORG");
            Assert.assertEquals((Object)"testrenewer", (Object)loggedInUser.getShortUserName());
            loggedInUser.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
            org.apache.hadoop.yarn.api.records.Token token = this.getDelegationToken(loggedInUser, (ApplicationClientProtocol)clientRMService, loggedInUser.getShortUserName());
            long tokenFetchTime = System.currentTimeMillis();
            LOG.info("Got delegation token at: " + tokenFetchTime);
            clientRMWithDT = this.getClientRMProtocolWithDT(token, clientRMService.getBindAddress(), "loginuser1", (Configuration)conf);
            GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
            try {
                clientRMWithDT.getNewApplication(request);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception" + e));
            }
            catch (YarnException e) {
                Assert.fail((String)("Unexpected exception" + (Object)((Object)e)));
            }
            while (System.currentTimeMillis() < tokenFetchTime + initialInterval / 2L) {
                Thread.sleep(500L);
            }
            long nextExpTime = this.renewDelegationToken(loggedInUser, (ApplicationClientProtocol)clientRMService, token);
            long renewalTime = System.currentTimeMillis();
            LOG.info("Renewed token at: " + renewalTime + ", NextExpiryTime: " + nextExpTime);
            while (System.currentTimeMillis() > tokenFetchTime + initialInterval && System.currentTimeMillis() < nextExpTime) {
                Thread.sleep(500L);
            }
            Thread.sleep(50L);
            try {
                clientRMWithDT.getNewApplication(request);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception" + e));
            }
            catch (YarnException e) {
                Assert.fail((String)("Unexpected exception" + (Object)((Object)e)));
            }
            while (System.currentTimeMillis() < renewalTime + renewInterval) {
                Thread.sleep(500L);
            }
            Thread.sleep(50L);
            LOG.info("At time: " + System.currentTimeMillis() + ", token should be invalid");
            ApplicationClientProtocol finalClientRMWithDT = clientRMWithDT;
            GetNewApplicationRequest finalRequest = request;
            LambdaTestUtils.intercept(SecretManager.InvalidToken.class, (String)"Token  has expired", () -> finalClientRMWithDT.getNewApplication(finalRequest));
            if (clientRMWithDT != null) {
                RPC.stopProxy((Object)clientRMWithDT);
                clientRMWithDT = null;
            }
            token = this.getDelegationToken(loggedInUser, (ApplicationClientProtocol)clientRMService, loggedInUser.getShortUserName());
            tokenFetchTime = System.currentTimeMillis();
            LOG.info("Got delegation token at: " + tokenFetchTime);
            clientRMWithDT = this.getClientRMProtocolWithDT(token, clientRMService.getBindAddress(), "loginuser2", (Configuration)conf);
            request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
            try {
                clientRMWithDT.getNewApplication(request);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception" + e));
            }
            catch (YarnException e) {
                Assert.fail((String)("Unexpected exception" + (Object)((Object)e)));
            }
            this.cancelDelegationToken(loggedInUser, (ApplicationClientProtocol)clientRMService, token);
            if (clientRMWithDT != null) {
                RPC.stopProxy((Object)clientRMWithDT);
                clientRMWithDT = null;
            }
            clientRMWithDT = this.getClientRMProtocolWithDT(token, clientRMService.getBindAddress(), "loginuser2", (Configuration)conf);
            LOG.info("Cancelled delegation token at: " + System.currentTimeMillis());
            try {
                clientRMWithDT.getNewApplication(request);
                Assert.fail((String)"Should not have succeeded with a cancelled delegation token");
            }
            catch (IOException e) {
            }
            catch (YarnException e) {
                // empty catch block
            }
            if (clientRMWithDT != null) {
                RPC.stopProxy((Object)clientRMWithDT);
                clientRMWithDT = null;
            }
            token = this.getDelegationToken(loggedInUser, (ApplicationClientProtocol)clientRMService, loggedInUser.getShortUserName());
            byte[] tokenIdentifierContent = token.getIdentifier().array();
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier();
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(tokenIdentifierContent, tokenIdentifierContent.length);
            tokenIdentifier.readFields((DataInput)dib);
            RMDelegationTokenIdentifierForTest newVersionTokenIdentifier = new RMDelegationTokenIdentifierForTest(tokenIdentifier, "message");
            Token newRMDTtoken = new Token((TokenIdentifier)newVersionTokenIdentifier, (SecretManager)rmDtSecretManager);
            org.apache.hadoop.yarn.api.records.Token newToken = BuilderUtils.newDelegationToken((byte[])newRMDTtoken.getIdentifier(), (String)newRMDTtoken.getKind().toString(), (byte[])newRMDTtoken.getPassword(), (String)newRMDTtoken.getService().toString());
            clientRMWithDT = this.getClientRMProtocolWithDT(newToken, clientRMService.getBindAddress(), "loginuser3", (Configuration)conf);
            request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
            try {
                clientRMWithDT.getNewApplication(request);
            }
            catch (IOException e) {
                Assert.fail((String)("Unexpected exception" + e));
            }
            catch (YarnException e) {
                Assert.fail((String)("Unexpected exception" + (Object)((Object)e)));
            }
        }
        catch (Throwable throwable) {
            rmDtSecretManager.stopThreads();
            if (clientRMWithDT != null) {
                RPC.stopProxy(clientRMWithDT);
            }
            throw throwable;
        }
        rmDtSecretManager.stopThreads();
        if (clientRMWithDT != null) {
            RPC.stopProxy((Object)clientRMWithDT);
        }
    }

    @Test
    public void testShortCircuitRenewCancel() throws IOException, InterruptedException {
        InetSocketAddress addr = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)123, null);
        this.checkShortCircuitRenewCancel(addr, addr, true);
    }

    @Test
    public void testShortCircuitRenewCancelWildcardAddress() throws IOException, InterruptedException {
        InetSocketAddress rmAddr = new InetSocketAddress(123);
        InetSocketAddress serviceAddr = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)rmAddr.getPort(), null);
        this.checkShortCircuitRenewCancel(rmAddr, serviceAddr, true);
    }

    @Test
    public void testShortCircuitRenewCancelSameHostDifferentPort() throws IOException, InterruptedException {
        InetSocketAddress rmAddr = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)123, null);
        this.checkShortCircuitRenewCancel(rmAddr, new InetSocketAddress(rmAddr.getAddress(), rmAddr.getPort() + 1), false);
    }

    @Test
    public void testShortCircuitRenewCancelDifferentHostSamePort() throws IOException, InterruptedException {
        InetSocketAddress rmAddr = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)123, null);
        this.checkShortCircuitRenewCancel(rmAddr, new InetSocketAddress("1.1.1.1", rmAddr.getPort()), false);
    }

    @Test
    public void testShortCircuitRenewCancelDifferentHostDifferentPort() throws IOException, InterruptedException {
        InetSocketAddress rmAddr = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)123, null);
        this.checkShortCircuitRenewCancel(rmAddr, new InetSocketAddress("1.1.1.1", rmAddr.getPort() + 1), false);
    }

    @Test
    public void testReadOldFormatFields() throws IOException {
        RMDelegationTokenIdentifier token = new RMDelegationTokenIdentifier(new Text("alice"), new Text("bob"), new Text("colin"));
        token.setIssueDate(123L);
        token.setMasterKeyId(321);
        token.setMaxDate(314L);
        token.setSequenceNumber(12345);
        DataInputBuffer inBuf = new DataInputBuffer();
        DataOutputBuffer outBuf = new DataOutputBuffer();
        token.writeInOldFormat((DataOutput)outBuf);
        outBuf.writeLong(42L);
        inBuf.reset(outBuf.getData(), 0, outBuf.getLength());
        RMDelegationTokenIdentifier identifier = null;
        try {
            RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
            identifierData.readFields((DataInput)inBuf);
            Assert.fail((String)("Should have thrown a " + InvalidProtocolBufferException.class.getName() + " because the token is not a protobuf"));
        }
        catch (InvalidProtocolBufferException e) {
            identifier = new RMDelegationTokenIdentifier();
            inBuf.reset();
            identifier.readFieldsInOldFormat((DataInput)inBuf);
            Assert.assertEquals((long)42L, (long)inBuf.readLong());
        }
        Assert.assertEquals((Object)"alice", (Object)identifier.getUser().getUserName());
        Assert.assertEquals((Object)new Text("bob"), (Object)identifier.getRenewer());
        Assert.assertEquals((Object)"colin", (Object)identifier.getUser().getRealUser().getUserName());
        Assert.assertEquals((long)123L, (long)identifier.getIssueDate());
        Assert.assertEquals((long)321L, (long)identifier.getMasterKeyId());
        Assert.assertEquals((long)314L, (long)identifier.getMaxDate());
        Assert.assertEquals((long)12345L, (long)identifier.getSequenceNumber());
    }

    private void checkShortCircuitRenewCancel(InetSocketAddress rmAddr, InetSocketAddress serviceAddr, boolean shouldShortCircuit) throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.setClass("yarn.ipc.rpc.class", YarnBadRPC.class, YarnRPC.class);
        RMDelegationTokenSecretManager secretManager = (RMDelegationTokenSecretManager)Mockito.mock(RMDelegationTokenSecretManager.class);
        RMDelegationTokenIdentifier.Renewer.setSecretManager((AbstractDelegationTokenSecretManager)secretManager, (InetSocketAddress)rmAddr);
        RMDelegationTokenIdentifier ident = new RMDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), null);
        Token token = new Token((TokenIdentifier)ident, (SecretManager)secretManager);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
        if (shouldShortCircuit) {
            token.renew(conf);
            ((RMDelegationTokenSecretManager)Mockito.verify((Object)secretManager)).renewToken((Token)ArgumentMatchers.eq((Object)token), (String)ArgumentMatchers.eq((Object)"renewer"));
            Mockito.reset((Object[])new RMDelegationTokenSecretManager[]{secretManager});
            token.cancel(conf);
            ((RMDelegationTokenSecretManager)Mockito.verify((Object)secretManager)).cancelToken((Token)ArgumentMatchers.eq((Object)token), (String)ArgumentMatchers.eq((Object)"renewer"));
        } else {
            try {
                token.renew(conf);
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)"getProxy", (Object)e.getMessage());
            }
            ((RMDelegationTokenSecretManager)Mockito.verify((Object)secretManager, (VerificationMode)Mockito.never())).renewToken((Token)ArgumentMatchers.any(Token.class), ArgumentMatchers.anyString());
            try {
                token.cancel(conf);
                Assert.fail();
            }
            catch (RuntimeException e) {
                Assert.assertEquals((Object)"getProxy", (Object)e.getMessage());
            }
            ((RMDelegationTokenSecretManager)Mockito.verify((Object)secretManager, (VerificationMode)Mockito.never())).cancelToken((Token)ArgumentMatchers.any(Token.class), ArgumentMatchers.anyString());
        }
    }

    private org.apache.hadoop.yarn.api.records.Token getDelegationToken(UserGroupInformation loggedInUser, final ApplicationClientProtocol clientRMService, final String renewerString) throws IOException, InterruptedException {
        org.apache.hadoop.yarn.api.records.Token token = (org.apache.hadoop.yarn.api.records.Token)loggedInUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<org.apache.hadoop.yarn.api.records.Token>(){

            @Override
            public org.apache.hadoop.yarn.api.records.Token run() throws YarnException, IOException {
                GetDelegationTokenRequest request = (GetDelegationTokenRequest)Records.newRecord(GetDelegationTokenRequest.class);
                request.setRenewer(renewerString);
                return clientRMService.getDelegationToken(request).getRMDelegationToken();
            }
        });
        return token;
    }

    private long renewDelegationToken(UserGroupInformation loggedInUser, final ApplicationClientProtocol clientRMService, final org.apache.hadoop.yarn.api.records.Token dToken) throws IOException, InterruptedException {
        long nextExpTime = (Long)loggedInUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws YarnException, IOException {
                RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
                request.setDelegationToken(dToken);
                return clientRMService.renewDelegationToken(request).getNextExpirationTime();
            }
        });
        return nextExpTime;
    }

    private void cancelDelegationToken(UserGroupInformation loggedInUser, final ApplicationClientProtocol clientRMService, final org.apache.hadoop.yarn.api.records.Token dToken) throws IOException, InterruptedException {
        loggedInUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws YarnException, IOException {
                CancelDelegationTokenRequest request = (CancelDelegationTokenRequest)Records.newRecord(CancelDelegationTokenRequest.class);
                request.setDelegationToken(dToken);
                clientRMService.cancelDelegationToken(request);
                return null;
            }
        });
    }

    private ApplicationClientProtocol getClientRMProtocolWithDT(org.apache.hadoop.yarn.api.records.Token token, final InetSocketAddress rmAddress, String user, final Configuration conf) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        ugi.addToken(ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, (InetSocketAddress)rmAddress));
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        ApplicationClientProtocol clientRMWithDT = (ApplicationClientProtocol)ugi.doAs((PrivilegedAction)new PrivilegedAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() {
                return (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
            }
        });
        return clientRMWithDT;
    }

    private static ResourceScheduler createMockScheduler(Configuration conf) {
        ResourceScheduler mockSched = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        ((ResourceScheduler)Mockito.doReturn((Object)Resources.createResource((int)512)).when((Object)mockSched)).getMinimumResourceCapability();
        ((ResourceScheduler)Mockito.doReturn((Object)Resources.createResource((int)5120)).when((Object)mockSched)).getMaximumResourceCapability();
        return mockSched;
    }

    private static RMDelegationTokenSecretManager createRMDelegationTokenSecretManager(long secretKeyInterval, long tokenMaxLifetime, long tokenRenewInterval, long delegationTokenRemoverScanInterval) {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rmContext.getResourceManager()).thenReturn((Object)rm);
        RMDelegationTokenSecretManager rmDtSecretManager = new RMDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, delegationTokenRemoverScanInterval, rmContext);
        return rmDtSecretManager;
    }

    class ClientRMServiceForTest
    extends ClientRMService {
        public ClientRMServiceForTest(Configuration conf, ResourceScheduler scheduler, RMDelegationTokenSecretManager rmDTSecretManager) {
            super((RMContext)Mockito.mock(RMContext.class), (YarnScheduler)scheduler, (RMAppManager)Mockito.mock(RMAppManager.class), new ApplicationACLsManager(conf), QueueACLsManager.getQueueACLsManager((ResourceScheduler)scheduler, (Configuration)conf), rmDTSecretManager);
        }

        InetSocketAddress getBindAddress(Configuration conf) {
            return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 0);
        }

        protected void serviceStop() throws Exception {
            if (this.rmDTSecretManager != null) {
                this.rmDTSecretManager.stopThreads();
            }
            super.serviceStop();
        }
    }

    public static class YarnBadRPC
    extends YarnRPC {
        public Object getProxy(Class protocol, InetSocketAddress addr, Configuration conf) {
            throw new RuntimeException("getProxy");
        }

        public void stopProxy(Object proxy, Configuration conf) {
            throw new RuntimeException("stopProxy");
        }

        public Server getServer(Class protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, String portRangeConfig) {
            throw new RuntimeException("getServer");
        }
    }
}

