/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.TestZKRMStateStore;
import org.junit.Assert;
import org.junit.Test;

public class TestRMStoreCommands {
    @Test
    public void testFormatStateStoreCmdForZK() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        try (TestingServer curatorTestingServer = TestZKRMStateStore.setupCuratorServer();
             CuratorFramework curatorFramework = TestZKRMStateStore.setupCuratorFramework(curatorTestingServer);){
            Configuration conf = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm1", 1234, false, curatorTestingServer);
            MockRM rm = new MockRM(conf);
            rm.start();
            rm.getRMContext().getRMAdminService().transitionToActive(req);
            String zkStateRoot = "ZKRMStateRoot";
            Assert.assertEquals((String)("RM State store parent path should have a child node " + zkStateRoot), (Object)zkStateRoot, ((List)curatorFramework.getChildren().forPath("/rmstore")).get(0));
            rm.close();
            try {
                ResourceManager.deleteRMStateStore((Configuration)conf);
            }
            catch (Exception e) {
                Assert.fail((String)"Exception should not be thrown during format rm state store operation.");
            }
            Assert.assertTrue((String)"After store format parent path should have no child nodes", (boolean)((List)curatorFramework.getChildren().forPath("/rmstore")).isEmpty());
        }
    }

    @Test
    public void testFormatConfStoreCmdForZK() throws Exception {
        try (TestingServer curatorTestingServer = TestZKRMStateStore.setupCuratorServer();
             CuratorFramework curatorFramework = TestZKRMStateStore.setupCuratorFramework(curatorTestingServer);){
            Configuration conf = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm1", 1234, false, curatorTestingServer);
            conf.set("yarn.scheduler.configuration.store.class", "zk");
            MockRM rm = new MockRM(conf);
            rm.start();
            String confStorePath = conf.get("yarn.scheduler.configuration.zk-store.parent-path", "/confstore") + "/CONF_STORE";
            Assert.assertNotNull((String)"Failed to initialize ZKConfigurationStore", (Object)curatorFramework.checkExists().forPath(confStorePath));
            rm.close();
            try {
                ResourceManager.deleteRMConfStore((Configuration)conf);
            }
            catch (Exception e) {
                Assert.fail((String)"Exception should not be thrown during format rm conf store operation.");
            }
            Assert.assertNull((String)"Failed to format ZKConfigurationStore", (Object)curatorFramework.checkExists().forPath(confStorePath));
        }
    }

    @Test
    public void testRemoveApplicationFromStateStoreCmdForZK() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        try (TestingServer curatorTestingServer = TestZKRMStateStore.setupCuratorServer();
             CuratorFramework curatorFramework = TestZKRMStateStore.setupCuratorFramework(curatorTestingServer);){
            Configuration conf = TestZKRMStateStore.createHARMConf("rm1,rm2", "rm1", 1234, false, curatorTestingServer);
            MockRM rm = new MockRM(conf);
            rm.start();
            rm.getRMContext().getRMAdminService().transitionToActive(req);
            rm.close();
            String appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1).toString();
            String appRootPath = "/rmstore/ZKRMStateRoot/RMAppRoot";
            String appIdPath = appRootPath + "/" + appId;
            curatorFramework.create().forPath(appIdPath);
            for (String path : (List)curatorFramework.getChildren().forPath(appRootPath)) {
                if (path.equals("HIERARCHIES")) continue;
                Assert.assertEquals((String)("Application node for " + appId + " should exist"), (Object)appId, (Object)path);
            }
            try {
                ResourceManager.removeApplication((Configuration)conf, (String)appId);
            }
            catch (Exception e) {
                Assert.fail((String)"Exception should not be thrown while removing app from rm state store.");
            }
            Assert.assertTrue((String)"After remove app from store there should be no child nodes for application in app root path", (((List)curatorFramework.getChildren().forPath(appRootPath)).size() == 1 && ((String)((List)curatorFramework.getChildren().forPath(appRootPath)).get(0)).equals("HIERARCHIES") ? 1 : 0) != 0);
        }
    }
}

