/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeUpdateType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public abstract class MockAsm
extends MockApps {
    public static RMApp newApplication(int i) {
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)MockAsm.newAppID((int)i), (int)0);
        Container masterContainer = (Container)Records.newRecord(Container.class);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
        masterContainer.setId(containerId);
        masterContainer.setNodeHttpAddress("node:port");
        final String user = MockAsm.newUserName();
        final String name = MockAsm.newAppName();
        final String queue = MockAsm.newQueue();
        final long start = 123456 + i * 1000;
        final long submit = start + (long)(i * 50);
        final long launch = start + (long)(i * 100);
        final long finish = 234567 + i * 1000;
        String type = "YARN";
        YarnApplicationState[] allStates = YarnApplicationState.values();
        final YarnApplicationState state = allStates[i % allStates.length];
        final int maxAppAttempts = i % 1000;
        return new ApplicationBase(){

            @Override
            public ApplicationId getApplicationId() {
                return appAttemptId.getApplicationId();
            }

            @Override
            public String getUser() {
                return user;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getApplicationType() {
                return "YARN";
            }

            @Override
            public String getQueue() {
                return queue;
            }

            @Override
            public long getStartTime() {
                return start;
            }

            @Override
            public long getSubmitTime() {
                return submit;
            }

            @Override
            public long getLaunchTime() {
                return launch;
            }

            @Override
            public long getFinishTime() {
                return finish;
            }

            @Override
            public String getTrackingUrl() {
                return null;
            }

            @Override
            public YarnApplicationState createApplicationState() {
                return state;
            }

            @Override
            public StringBuilder getDiagnostics() {
                return new StringBuilder();
            }

            @Override
            public float getProgress() {
                return (float)Math.random();
            }

            @Override
            public FinalApplicationStatus getFinalApplicationStatus() {
                return FinalApplicationStatus.UNDEFINED;
            }

            @Override
            public RMAppAttempt getCurrentAppAttempt() {
                return null;
            }

            @Override
            public int getMaxAppAttempts() {
                return maxAppAttempts;
            }

            @Override
            public Set<String> getApplicationTags() {
                return null;
            }

            @Override
            public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
                ApplicationResourceUsageReport usageReport = ApplicationResourceUsageReport.newInstance((int)0, (int)0, null, null, null, new HashMap(), (float)0.0f, (float)0.0f, new HashMap());
                ApplicationReport report = ApplicationReport.newInstance((ApplicationId)this.getApplicationId(), (ApplicationAttemptId)appAttemptId, (String)this.getUser(), (String)this.getQueue(), (String)this.getName(), null, (int)0, null, null, (String)this.getDiagnostics().toString(), (String)this.getTrackingUrl(), (long)this.getStartTime(), (long)this.getSubmitTime(), (long)this.getLaunchTime(), (long)this.getFinishTime(), (FinalApplicationStatus)this.getFinalApplicationStatus(), (ApplicationResourceUsageReport)usageReport, null, (float)this.getProgress(), (String)"YARN", null);
                return report;
            }
        };
    }

    public static List<RMApp> newApplications(int n) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(MockAsm.newApplication(i));
        }
        return list;
    }

    public static class ApplicationBase
    implements RMApp {
        List<ResourceRequest> amReqs;

        public String getUser() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getRealUser() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getQueue() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getStartTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSubmitTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getLaunchTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public StringBuilder getDiagnostics() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AppCollectorData getCollectorData() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationId getApplicationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getCurrentAppAttempt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public float getProgress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppState getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getTrackingUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getOriginalTrackingUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getMaxAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void handle(RMAppEvent event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FinalApplicationStatus getFinalApplicationStatus() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int pullRMNodeUpdates(Map<RMNode, NodeUpdateType> updatedNodes) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getApplicationType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<String> getApplicationTags() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setQueue(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isAppFinalStateStored() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public YarnApplicationState createApplicationState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<NodeId> getRanNodes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppMetrics getRMAppMetrics() {
            return new RMAppMetrics(Resource.newInstance((int)0, (int)0), 0, 0, new HashMap(), new HashMap(), 0);
        }

        public ReservationId getReservationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<ResourceRequest> getAMResourceRequests() {
            return this.amReqs;
        }

        public Map<NodeId, LogAggregationReport> getLogAggregationReportsForApp() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogAggregationStatus getLogAggregationStatusForAppReport() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAmNodeLabelExpression() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAppNodeLabelExpression() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CallerContext getCallerContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<ApplicationTimeoutType, Long> getApplicationTimeouts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Priority getApplicationPriority() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isAppInCompletedStates() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationPlacementContext getApplicationPlacementContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CollectorInfo getCollectorInfo() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, String> getApplicationSchedulingEnvs() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

