/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestPreemptionForQueueWithPriorities
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        this.resourceCalculator = new DefaultResourceCalculator();
        super.setup();
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testPreemptionForHighestPriorityUnderutilizedQueue() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 40 50]){priority=1};-b(=[30 100 59 50]){priority=2};-c(=[40 100 1 25]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,40,false);b\t(1,1,n1,,59,false);c\t(1,1,n1,,1,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)10))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)15))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testPreemptionForLowestPriorityUnderutilizedQueue() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 40 50]){priority=1};-b(=[30 100 59 50]){priority=2};-c(=[40 100 1 25]){priority=0}";
        String appsConfig = "a\t(1,1,n1,,40,false);b\t(1,1,n1,,59,false);c\t(1,1,n1,,1,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)10))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)15))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testPreemptionWontHappenBetweenSatisfiedQueues() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 0 0]){priority=1};-b(=[30 100 40 50]){priority=1};-c(=[40 100 60 25]){priority=2}";
        String appsConfig = "b\t(1,1,n1,,40,false);c\t(1,1,n1,,60,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testPreemptionForMultipleQueuesInTheSamePriorityBuckets() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[10 100 35 50]){priority=1};-b(=[15 100 25 50]){priority=1};-c(=[20 100 39 50]){priority=2};-d(=[25 100 0 0]){priority=2};-e(=[30 100 1 99]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,35,false);b\t(1,1,n1,,25,false);c\t(1,1,n1,,39,false);e\t(1,1,n1,,1,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)23))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)6))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPreemptionForPriorityAndDisablePreemption() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[10 100 35 50]){priority=1,disable_preemption=true};-b(=[15 100 25 50]){priority=1};-c(=[20 100 39 50]){priority=2};-d(=[25 100 0 0]){priority=2};-e(=[30 100 1 99]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,35,false);b\t(1,1,n1,,25,false);c\t(1,1,n1,,39,false);e\t(1,1,n1,,1,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)9))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)19))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPriorityPreemptionForHierarchicalOfQueues() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[29 100 40 50]){priority=1};--a1(=[12 100 20 50]){priority=1};--a2(=[17 100 20 50]){priority=1};-b(=[31 100 59 50]){priority=1};--b1(=[16 100 30 50]){priority=1};--b2(=[15 100 29 50]){priority=2};-c(=[40 100 1 30]){priority=1}";
        String appsConfig = "a1\t(1,1,n1,,20,false);a2\t(1,1,n1,,20,false);b1\t(1,1,n1,,30,false);b2\t(1,1,n1,,29,false);c\t(1,1,n1,,1,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)6))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)13))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)10))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPriorityPreemptionWithMandatoryResourceForHierarchicalOfQueues() throws Exception {
        String labelsConfig = "=100:200,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100:200 100:200 100:200 100:200]);-a(=[50:100 100:200 20:40 60:100]){priority=1};--a1(=[10:20 100:200 10:30 30:20]){priority=1};--a2(=[40:80 100:200 10:10 30:80]){priority=1};-b(=[50:100 100:200 80:160 40:100]){priority=1};--b1(=[20:40 100:200 20:40 20:70]){priority=2};--b2(=[30:60 100:200 60:120 20:30]){priority=1}";
        String appsConfig = "a1\t(1,1:4,n1,,10,false);a2\t(1,1:1,n1,,10,false);b1\t(1,3:4,n1,,10,false);b2\t(1,20:40,n1,,3,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPriorityPreemptionWithMultipleResource() throws Exception {
        String RESOURCE_1 = "res1";
        this.riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
        ResourceUtils.initializeResourcesFromResourceInformationMap((Map)this.riMap);
        String labelsConfig = "=100:100:10,true;";
        String nodesConfig = "n1=;";
        String queuesConfig = "root(=[100:100:10 100:100:10 100:100:10 100:100:10]);-a(=[50:60:3 100:100:10 80:90:10 30:20:4]){priority=1};--a1(=[20:15:3 100:50:10 60:50:10 0]){priority=1};--a2(=[30:45 100:50:10 20:40 30:20:4]){priority=2};-b(=[50:40:7 100:100:10 20:10 30:10:2]){priority=1}";
        String appsConfig = "a1\t(1,6:5:1,n1,,10,false);a2\t(1,2:4,n1,,10,false);b\t(1,2:1,n1,,10,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void test3ResourceTypesInterQueuePreemption() throws IOException {
        this.resourceCalculator = new DominantResourceCalculator();
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        String RESOURCE_1 = "res1";
        this.riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
        ResourceUtils.initializeResourcesFromResourceInformationMap((Map)this.riMap);
        String labelsConfig = "=30:18:6,true;";
        String nodesConfig = "n1= res=30:18:6;";
        String queuesConfig = "root(=[30:18:6 30:18:6 12:12:6 1:1:1]){priority=1};-a(=[10:6:2 10:6:2 6:6:3 0:0:0]){priority=1};-b(=[10:6:2 10:6:2 6:6:3 0:0:0]){priority=1};-c(=[10:6:2 10:6:2 0:0:0 1:1:1]){priority=2}";
        String appsConfig = "a\t(1,2:2:1,n1,,3,false);b\t(1,2:2:1,n1,,3,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testPriorityPreemptionForBalanceBetweenSatisfiedQueues() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 0 0]){priority=1};-b(=[30 100 40 50]){priority=1};-c(=[40 100 60 25]){priority=2}";
        String appsConfig = "b\t(1,1,n1,,40,false);c\t(1,1,n1,,60,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        boolean isPreemptionToBalanceRequired = true;
        newConf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", isPreemptionToBalanceRequired);
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)newConf);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.times((int)10))).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.eventHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.argThat((ArgumentMatcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }
}

