/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockSchedulerNodes {
    private static final Logger LOG = LoggerFactory.getLogger(MockSchedulerNodes.class);
    private String config;
    private Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes = new HashMap<NodeId, FiCaSchedulerNode>();

    MockSchedulerNodes(String config) {
        this.config = config;
        this.init();
    }

    private void init() {
        String[] nodesConfigStrArray;
        for (String p : nodesConfigStrArray = this.config.split(";")) {
            String res;
            String[] arr = p.split(" ");
            NodeId nodeId = NodeId.newInstance((String)arr[0].substring(0, arr[0].indexOf("=")), (int)1);
            String partition = arr[0].substring(arr[0].indexOf("=") + 1);
            FiCaSchedulerNode sn = (FiCaSchedulerNode)Mockito.mock(FiCaSchedulerNode.class);
            Mockito.when((Object)sn.getNodeID()).thenReturn((Object)nodeId);
            Mockito.when((Object)sn.getPartition()).thenReturn((Object)partition);
            Resource totalRes = Resources.createResource((int)0);
            if (arr.length > 1 && (res = arr[1]).contains("res=")) {
                String resString = res.substring(res.indexOf("res=") + "res=".length());
                totalRes = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(resString);
            }
            Mockito.when((Object)sn.getTotalResource()).thenReturn((Object)totalRes);
            Mockito.when((Object)sn.getUnallocatedResource()).thenReturn((Object)Resources.clone((Resource)totalRes));
            Mockito.when((Object)sn.getTotalKillableResources()).thenReturn((Object)Resources.none());
            ArrayList liveContainers = new ArrayList();
            Mockito.when((Object)sn.getCopiedListOfRunningContainers()).thenReturn(liveContainers);
            this.nodeIdToSchedulerNodes.put(nodeId, sn);
            LOG.debug("add scheduler node, id=" + nodeId + ", partition=" + partition);
        }
    }

    Map<NodeId, FiCaSchedulerNode> getNodeIdToSchedulerNodes() {
        return this.nodeIdToSchedulerNodes;
    }
}

