/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeLabelFileReplication {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeLabelFileReplication() throws IOException {
        int expectedReplication = 10;
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        conf.setInt("yarn.fs-store.file.replication", expectedReplication);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            String nodeLabelDir = fs.getUri().toString() + "/nodelabel";
            conf.set("yarn.node-labels.fs-store.root-dir", nodeLabelDir);
            CommonNodeLabelsManager manager = new CommonNodeLabelsManager();
            manager.init(conf);
            manager.start();
            short fileReplication = fs.getFileStatus(new Path(nodeLabelDir, "nodelabel.mirror")).getReplication();
            Assert.assertEquals((String)("Node label file replication should be " + expectedReplication), (long)expectedReplication, (long)fileReplication);
            manager.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

