/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.yarn.server.resourcemanager.placement.FairQueuePlacementUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFairQueuePlacementUtils {
    @Test
    public void testCleanName() {
        String clean = "clean";
        String dotted = "not.clean";
        String multiDot = "more.un.clean";
        String seqDot = "not..clean";
        String unTrimmed = " .invalid. ";
        String cleaned = FairQueuePlacementUtils.cleanName((String)"clean");
        Assert.assertEquals((String)"Name was changed and it should not", (Object)"clean", (Object)cleaned);
        cleaned = FairQueuePlacementUtils.cleanName((String)"not.clean");
        Assert.assertFalse((String)"Cleaned name contains dots and it should not", (boolean)cleaned.contains("."));
        cleaned = FairQueuePlacementUtils.cleanName((String)"more.un.clean");
        Assert.assertFalse((String)"Cleaned name contains dots and it should not", (boolean)cleaned.contains("."));
        Assert.assertNotEquals((String)"Multi dot failed: wrong replacements found", (long)cleaned.indexOf("_dot_"), (long)cleaned.lastIndexOf("_dot_"));
        cleaned = FairQueuePlacementUtils.cleanName((String)"not..clean");
        Assert.assertFalse((String)"Cleaned name contains dots and it should not", (boolean)cleaned.contains("."));
        Assert.assertNotEquals((String)"Sequential dot failed: wrong replacements found", (long)cleaned.indexOf("_dot_"), (long)cleaned.lastIndexOf("_dot_"));
        cleaned = FairQueuePlacementUtils.cleanName((String)" .invalid. ");
        Assert.assertTrue((String)"Trimming start failed: space not removed or dot not replaced", (boolean)cleaned.startsWith("_dot_"));
        Assert.assertTrue((String)"Trimming end failed: space not removed or dot not replaced", (boolean)cleaned.endsWith("_dot_"));
    }

    @Test
    public void testAssureRoot() {
        String queueName = "base";
        String rootOnly = "root";
        String rootNoDot = "rootbase";
        String alreadyRoot = "root.base";
        String rooted = FairQueuePlacementUtils.assureRoot((String)"base");
        Assert.assertTrue((String)"Queue should have root prefix (base)", (boolean)rooted.startsWith("root."));
        rooted = FairQueuePlacementUtils.assureRoot((String)"root");
        Assert.assertEquals((String)"'root' queue should not have root prefix (root)", (Object)"root", (Object)rooted);
        rooted = FairQueuePlacementUtils.assureRoot((String)"rootbase");
        Assert.assertTrue((String)"Queue should have root prefix (rootbase)", (boolean)rooted.startsWith("root."));
        Assert.assertEquals((String)"'root' queue base was replaced and not prefixed", (long)5L, (long)rooted.lastIndexOf("root"));
        rooted = FairQueuePlacementUtils.assureRoot((String)"root.base");
        Assert.assertEquals((String)"Root prefixed queue changed and it should not (root.base)", (Object)rooted, (Object)"root.base");
        Assert.assertNull((String)"Null queue did not return null queue", (Object)FairQueuePlacementUtils.assureRoot(null));
        Assert.assertEquals((String)"Empty queue did not return empty name", (Object)"", (Object)FairQueuePlacementUtils.assureRoot((String)""));
    }

    @Test
    public void testIsValidQueueName() {
        String valid = "valid";
        String validRooted = "root.valid";
        String rootOnly = "root";
        String startDot = ".invalid";
        String endDot = "invalid.";
        String startSpace = " invalid";
        String endSpace = "invalid ";
        String unicodeSpace = "\u00a0invalid";
        Assert.assertFalse((String)"'null' queue was not marked as invalid", (boolean)FairQueuePlacementUtils.isValidQueueName(null));
        Assert.assertTrue((String)"empty queue was not tagged valid", (boolean)FairQueuePlacementUtils.isValidQueueName((String)""));
        Assert.assertTrue((String)"Simple queue name was not tagged valid (valid)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"valid"));
        Assert.assertTrue((String)"Root only queue was not tagged valid (root)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"root"));
        Assert.assertTrue((String)"Root prefixed queue was not tagged valid (root.valid)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"root.valid"));
        Assert.assertFalse((String)"Queue starting with dot was not tagged invalid (.invalid)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)".invalid"));
        Assert.assertFalse((String)"Queue ending with dot was not tagged invalid (invalid.)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"invalid."));
        Assert.assertFalse((String)"Queue starting with space was not tagged invalid ( invalid)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)" invalid"));
        Assert.assertFalse((String)"Queue ending with space was not tagged invalid (invalid )", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"invalid "));
        Assert.assertFalse((String)"Queue with unicode space was not tagged as invalid (unicode)", (boolean)FairQueuePlacementUtils.isValidQueueName((String)"\u00a0invalid"));
    }
}

