/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementFactory;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.junit.Assert;
import org.junit.Test;

public class TestPlacementFactory {
    @Test(expected=ClassNotFoundException.class)
    public void testGetNonExistRuleText() throws ClassNotFoundException {
        String nonExist = "my.placement.Rule";
        PlacementFactory.getPlacementRule((String)"my.placement.Rule", null);
    }

    @Test
    public void testGetExistRuleText() {
        String exists = DefaultPlacementRule.class.getCanonicalName();
        PlacementRule rule = null;
        try {
            rule = PlacementFactory.getPlacementRule((String)exists, null);
        }
        catch (ClassNotFoundException cnfe) {
            Assert.fail((String)"Class should have been found");
        }
        Assert.assertNotNull((String)"Rule object is null", (Object)rule);
        Assert.assertEquals((String)"Names not equal", (Object)rule.getName(), (Object)exists);
    }

    @Test
    public void testGetRuleClass() {
        PlacementRule rule = PlacementFactory.getPlacementRule(DefaultPlacementRule.class, null);
        Assert.assertNotNull((String)"Rule object is null", (Object)rule);
        rule = PlacementFactory.getPlacementRule(DefaultPlacementRule.class, (Object)"");
        Assert.assertNotNull((String)"Rule object is null", (Object)rule);
    }
}

