/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInfo;

public final class QueueMetricsTestData {
    final Map<String, Long> customResourceValues;
    final int containers;
    final Resource resourceToDecrease;
    final int containersToDecrease;
    final Resource resource;
    final String partition;
    final QueueInfo leafQueue;
    final String user;

    private QueueMetricsTestData(Builder builder) {
        this.customResourceValues = builder.customResourceValues;
        this.containers = builder.containers;
        this.resourceToDecrease = builder.resourceToDecrease;
        this.containersToDecrease = builder.containersToDecrease;
        this.resource = builder.resource;
        this.partition = builder.partition;
        this.leafQueue = builder.queueInfo;
        this.user = builder.user;
    }

    public static final class Builder {
        private int containers;
        private Resource resource;
        private Resource resourceToDecrease;
        private Map<String, Long> customResourceValues;
        private int containersToDecrease;
        private String user;
        private String partition;
        private QueueInfo queueInfo;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withContainers(int containers) {
            this.containers = containers;
            return this;
        }

        public Builder withResourceToDecrease(Resource res, int containers) {
            this.resourceToDecrease = res;
            this.containersToDecrease = containers;
            return this;
        }

        public Builder withResources(Resource res) {
            this.resource = res;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withPartition(String partition) {
            this.partition = partition;
            return this;
        }

        public Builder withLeafQueue(QueueInfo qInfo) {
            this.queueInfo = qInfo;
            return this;
        }

        public QueueMetricsTestData build() {
            this.customResourceValues = ResourceTypesTestHelper.extractCustomResources((Resource)this.resource);
            return new QueueMetricsTestData(this);
        }
    }
}

