/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PartitionQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPartitionQueueMetrics {
    static final int GB = 1024;
    private static final Configuration CONF = new Configuration();
    private MetricsSystem ms;

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
        PartitionQueueMetrics.clearQueueMetrics();
    }

    @After
    public void tearDown() {
        this.ms.shutdown();
    }

    @Test
    public void testSinglePartitionWithSingleLevelQueueMetrics() throws Exception {
        String parentQueueName = "root";
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        String user = "alice";
        QueueMetrics root = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root", null, (boolean)true, (Configuration)CONF);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)root);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        QueueMetrics q1 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1", (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        QueueMetrics q2 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q2", (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        q1.submitApp(user, false);
        q1.submitAppAttempt(user, false);
        root.setAvailableResourcesToQueue("x", Resources.createResource((int)204800, (int)200));
        q1.setAvailableResourcesToQueue("x", Resources.createResource((int)102400, (int)100));
        q1.incrPendingResources("x", user, 2, Resource.newInstance((int)1024, (int)1));
        MetricsSource partitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "x");
        MetricsSource rootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "x", parentQueueName);
        MetricsSource q1Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 2048L, 2, 2);
        q2.incrPendingResources("x", user, 3, Resource.newInstance((int)1024, (int)1));
        MetricsSource q2Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q2");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(q2Source, 0L, 0, 0, 0L, 0, 3072L, 3, 3);
        PartitionQueueMetrics pq1 = new PartitionQueueMetrics(this.ms, "root.q1", parentQueue, true, CONF, "x");
        Assert.assertTrue((String)("Name of registry should be \"" + PartitionQueueMetrics.P_RECORD_INFO.name() + "\", but was \"" + pq1.registry.info().name() + "\"."), (pq1.registry.info().name().compareTo(PartitionQueueMetrics.P_RECORD_INFO.name()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTwoPartitionWithSingleLevelQueueMetrics() throws Exception {
        String parentQueueName = "root";
        String user = "alice";
        QueueMetrics root = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)false, (Configuration)CONF);
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)root);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        QueueMetrics q1 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1", (Queue)parentQueue, (boolean)false, (Configuration)CONF);
        QueueMetrics q2 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q2", (Queue)parentQueue, (boolean)false, (Configuration)CONF);
        AppSchedulingInfo app = TestPartitionQueueMetrics.mockApp(user);
        q1.submitApp(user, false);
        q1.submitAppAttempt(user, false);
        root.setAvailableResourcesToQueue("x", Resources.createResource((int)204800, (int)200));
        q1.setAvailableResourcesToQueue("x", Resources.createResource((int)102400, (int)100));
        q1.incrPendingResources("x", user, 2, Resource.newInstance((int)1024, (int)1));
        MetricsSource xPartitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "x");
        MetricsSource xRootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "x", parentQueueName);
        MetricsSource q1Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1");
        TestPartitionQueueMetrics.checkResources(xPartitionSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(xRootQueueSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 2048L, 2, 2);
        root.setAvailableResourcesToQueue("y", Resources.createResource((int)409600, (int)400));
        q2.setAvailableResourcesToQueue("y", Resources.createResource((int)204800, (int)200));
        q2.incrPendingResources("y", user, 3, Resource.newInstance((int)1024, (int)1));
        MetricsSource yPartitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "y");
        MetricsSource yRootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "y", parentQueueName);
        MetricsSource q2Source = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q2");
        TestPartitionQueueMetrics.checkResources(yPartitionSource, 0L, 0, 0, 409600L, 400, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(yRootQueueSource, 0L, 0, 0, 409600L, 400, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(q2Source, 0L, 0, 0, 204800L, 200, 3072L, 3, 3);
    }

    @Test
    public void testMultiplePartitionWithSingleQueueMetrics() throws Exception {
        String parentQueueName = "root";
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        QueueMetrics root = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)CONF);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)root);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        QueueMetrics q1 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1", (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        root.setAvailableResourcesToQueue("x", Resources.createResource((int)204800, (int)200));
        root.setAvailableResourcesToQueue("y", Resources.createResource((int)307200, (int)300));
        q1.incrPendingResources("x", "test_user", 2, Resource.newInstance((int)1024, (int)1));
        MetricsSource partitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "x");
        MetricsSource rootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "x", parentQueueName);
        MetricsSource q1Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1");
        MetricsSource userSource = TestPartitionQueueMetrics.userSource(this.ms, "x", "test_user", "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 0L, 0, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0, 2048L, 2, 2);
        q1.incrPendingResources("x", "test_user", 3, Resource.newInstance((int)1024, (int)1));
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        q1.incrPendingResources("x", "test_user1", 4, Resource.newInstance((int)1024, (int)1));
        MetricsSource userSource1 = TestPartitionQueueMetrics.userSource(this.ms, "x", "test_user1", "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 9216L, 9, 9);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 9216L, 9, 9);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 0L, 0, 9216L, 9, 9);
        TestPartitionQueueMetrics.checkResources(userSource1, 0L, 0, 0, 0L, 0, 4096L, 4, 4);
        q1.incrPendingResources("y", "test_user1", 6, Resource.newInstance((int)1024, (int)1));
        MetricsSource partitionSourceY = TestPartitionQueueMetrics.partitionSource(this.ms, "y");
        MetricsSource rootQueueSourceY = TestPartitionQueueMetrics.queueSource(this.ms, "y", parentQueueName);
        MetricsSource q1SourceY = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q1");
        MetricsSource userSourceY = TestPartitionQueueMetrics.userSource(this.ms, "y", "test_user1", "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSourceY, 0L, 0, 0, 307200L, 300, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(rootQueueSourceY, 0L, 0, 0, 307200L, 300, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(q1SourceY, 0L, 0, 0, 0L, 0, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(userSourceY, 0L, 0, 0, 0L, 0, 6144L, 6, 6);
    }

    @Test
    public void testMultiplePartitionsWithMultiLevelQueuesMetrics() throws Exception {
        String parentQueueName = "root";
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        QueueMetrics root = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)CONF);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)root);
        QueueMetrics q1 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1", (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        Queue childQueue1 = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)childQueue1.getQueueName()).thenReturn((Object)"root.q1");
        Mockito.when((Object)childQueue1.getMetrics()).thenReturn((Object)q1);
        QueueMetrics q11 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1.q11", (Queue)childQueue1, (boolean)true, (Configuration)CONF);
        QueueMetrics q12 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q1.q12", (Queue)childQueue1, (boolean)true, (Configuration)CONF);
        QueueMetrics q2 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q2", (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        Queue childQueue2 = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)childQueue2.getQueueName()).thenReturn((Object)"root.q2");
        Mockito.when((Object)childQueue2.getMetrics()).thenReturn((Object)q2);
        QueueMetrics q21 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q2.q21", (Queue)childQueue2, (boolean)true, (Configuration)CONF);
        QueueMetrics q22 = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)"root.q2.q22", (Queue)childQueue2, (boolean)true, (Configuration)CONF);
        root.setAvailableResourcesToQueue("x", Resources.createResource((int)204800, (int)200));
        q1.setAvailableResourcesToQueue("x", Resources.createResource((int)102400, (int)100));
        q11.setAvailableResourcesToQueue("x", Resources.createResource((int)51200, (int)50));
        q11.incrPendingResources("x", "test_user", 2, Resource.newInstance((int)1024, (int)1));
        MetricsSource partitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "x");
        MetricsSource rootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "x", parentQueueName);
        MetricsSource q1Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1");
        MetricsSource userSource = TestPartitionQueueMetrics.userSource(this.ms, "x", "test_user", "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0, 2048L, 2, 2);
        q11.incrPendingResources("x", "test_user", 4, Resource.newInstance((int)1024, (int)1));
        MetricsSource q11Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1.q11");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(q11Source, 0L, 0, 0, 51200L, 50, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0, 6144L, 6, 6);
        q11.incrPendingResources("x", "test_user1", 5, Resource.newInstance((int)1024, (int)1));
        MetricsSource q1UserSource1 = TestPartitionQueueMetrics.userSource(this.ms, "x", "test_user1", "root.q1");
        MetricsSource userSource1 = TestPartitionQueueMetrics.userSource(this.ms, "x", "test_user1", "root.q1.q11");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 11264L, 11, 11);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 11264L, 11, 11);
        TestPartitionQueueMetrics.checkResources(q11Source, 0L, 0, 0, 51200L, 50, 11264L, 11, 11);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 11264L, 11, 11);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0, 6144L, 6, 6);
        TestPartitionQueueMetrics.checkResources(q1UserSource1, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(userSource1, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        q12.incrPendingResources("x", "test_user", 5, Resource.newInstance((int)1024, (int)1));
        MetricsSource q12Source = TestPartitionQueueMetrics.queueSource(this.ms, "x", "root.q1.q12");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 16384L, 16, 16);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 16384L, 16, 16);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 102400L, 100, 16384L, 16, 16);
        TestPartitionQueueMetrics.checkResources(q12Source, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        root.setAvailableResourcesToQueue("y", Resources.createResource((int)204800, (int)200));
        q1.setAvailableResourcesToQueue("y", Resources.createResource((int)102400, (int)100));
        q12.setAvailableResourcesToQueue("y", Resources.createResource((int)51200, (int)50));
        q12.incrPendingResources("y", "test_user", 3, Resource.newInstance((int)1024, (int)1));
        MetricsSource yPartitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, "y");
        MetricsSource yRootQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, "y", parentQueueName);
        MetricsSource q1YSource = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q1");
        MetricsSource q12YSource = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q1.q12");
        TestPartitionQueueMetrics.checkResources(yPartitionSource, 0L, 0, 0, 204800L, 200, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(yRootQueueSource, 0L, 0, 0, 204800L, 200, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(q1YSource, 0L, 0, 0, 102400L, 100, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(q12YSource, 0L, 0, 0, 51200L, 50, 3072L, 3, 3);
        root.setAvailableResourcesToQueue("y", Resources.createResource((int)204800, (int)200));
        q2.setAvailableResourcesToQueue("y", Resources.createResource((int)102400, (int)100));
        q21.setAvailableResourcesToQueue("y", Resources.createResource((int)51200, (int)50));
        q21.incrPendingResources("y", "test_user", 5, Resource.newInstance((int)1024, (int)1));
        MetricsSource q21Source = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q2.q21");
        MetricsSource q2YSource = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q2");
        TestPartitionQueueMetrics.checkResources(yPartitionSource, 0L, 0, 0, 204800L, 200, 8192L, 8, 8);
        TestPartitionQueueMetrics.checkResources(yRootQueueSource, 0L, 0, 0, 204800L, 200, 8192L, 8, 8);
        TestPartitionQueueMetrics.checkResources(q2YSource, 0L, 0, 0, 102400L, 100, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(q21Source, 0L, 0, 0, 51200L, 50, 5120L, 5, 5);
        q22.incrPendingResources("y", "test_user", 6, Resource.newInstance((int)1024, (int)1));
        MetricsSource q22Source = TestPartitionQueueMetrics.queueSource(this.ms, "y", "root.q2.q22");
        TestPartitionQueueMetrics.checkResources(yPartitionSource, 0L, 0, 0, 204800L, 200, 14336L, 14, 14);
        TestPartitionQueueMetrics.checkResources(yRootQueueSource, 0L, 0, 0, 204800L, 200, 14336L, 14, 14);
        TestPartitionQueueMetrics.checkResources(q22Source, 0L, 0, 0, 0L, 0, 6144L, 6, 6);
    }

    @Test
    public void testTwoLevelWithUserMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        String user = "alice";
        String partition = "x";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)CONF);
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)parentMetrics);
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        AppSchedulingInfo app = TestPartitionQueueMetrics.mockApp(user);
        metrics.submitApp(user, false);
        metrics.submitAppAttempt(user, false);
        parentMetrics.setAvailableResourcesToQueue(partition, Resources.createResource((int)102400, (int)100));
        metrics.setAvailableResourcesToQueue(partition, Resources.createResource((int)102400, (int)100));
        parentMetrics.setAvailableResourcesToUser(partition, user, Resources.createResource((int)10240, (int)10));
        metrics.setAvailableResourcesToUser(partition, user, Resources.createResource((int)10240, (int)10));
        metrics.incrPendingResources(partition, user, 6, Resources.createResource((int)3072, (int)3));
        MetricsSource partitionSource = TestPartitionQueueMetrics.partitionSource(this.ms, partition);
        MetricsSource parentQueueSource = TestPartitionQueueMetrics.queueSource(this.ms, partition, parentQueueName);
        MetricsSource queueSource = TestPartitionQueueMetrics.queueSource(this.ms, partition, leafQueueName);
        MetricsSource userSource = TestPartitionQueueMetrics.userSource(this.ms, partition, user, leafQueueName);
        MetricsSource userSource1 = TestPartitionQueueMetrics.userSource(this.ms, partition, user, parentQueueName);
        TestPartitionQueueMetrics.checkResources(queueSource, 0L, 0, 0, 0L, 0L, 102400L, 100, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentQueueSource, 0L, 0, 0, 0L, 0L, 102400L, 100, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource, 0L, 0, 0, 0L, 0L, 10240L, 10, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource1, 0L, 0, 0, 0L, 0L, 10240L, 10, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 0L, 0L, 102400L, 100, 18432L, 18, 6, 0L, 0, 0);
        metrics.runAppAttempt(app.getApplicationId(), user, false);
        metrics.allocateResources(partition, user, 3, Resources.createResource((int)1024, (int)1), true);
        metrics.reserveResource(partition, user, Resources.createResource((int)3072, (int)3));
        TestPartitionQueueMetrics.checkResources(queueSource, 3072L, 3, 3, 3L, 0L, 102400L, 100, 15360L, 15, 3, 3072L, 3, 1);
        TestPartitionQueueMetrics.checkResources(parentQueueSource, 3072L, 3, 3, 3L, 0L, 102400L, 100, 15360L, 15, 3, 3072L, 3, 1);
        TestPartitionQueueMetrics.checkResources(partitionSource, 3072L, 3, 3, 3L, 0L, 102400L, 100, 15360L, 15, 3, 3072L, 3, 1);
        TestPartitionQueueMetrics.checkResources(userSource, 3072L, 3, 3, 3L, 0L, 10240L, 10, 15360L, 15, 3, 3072L, 3, 1);
        TestPartitionQueueMetrics.checkResources(userSource1, 3072L, 3, 3, 3L, 0L, 10240L, 10, 15360L, 15, 3, 3072L, 3, 1);
        metrics.allocateResources(partition, user, 3, Resources.createResource((int)1024, (int)1), true);
        TestPartitionQueueMetrics.checkResources(queueSource, 6144L, 6, 6, 6L, 0L, 102400L, 100, 12288L, 12, 0, 3072L, 3, 1);
        TestPartitionQueueMetrics.checkResources(parentQueueSource, 6144L, 6, 6, 6L, 0L, 102400L, 100, 12288L, 12, 0, 3072L, 3, 1);
        metrics.releaseResources(partition, user, 1, Resources.createResource((int)2048, (int)2));
        metrics.unreserveResource(partition, user, Resources.createResource((int)3072, (int)3));
        TestPartitionQueueMetrics.checkResources(queueSource, 4096L, 4, 5, 6L, 1L, 102400L, 100, 12288L, 12, 0, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentQueueSource, 4096L, 4, 5, 6L, 1L, 102400L, 100, 12288L, 12, 0, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(partitionSource, 4096L, 4, 5, 6L, 1L, 102400L, 100, 12288L, 12, 0, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource, 4096L, 4, 5, 6L, 1L, 10240L, 10, 12288L, 12, 0, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource1, 4096L, 4, 5, 6L, 1L, 10240L, 10, 12288L, 12, 0, 0L, 0, 0);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        metrics.finishApp(user, RMAppState.FINISHED, false);
    }

    @Test
    public void testThreeLevelWithUserMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        String leafQueueName1 = "root.leaf.leaf1";
        String user = "alice";
        String partitionX = "x";
        String partitionY = "y";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((String)parentQueueName, null, (boolean)true, (Configuration)CONF);
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)parentMetrics);
        QueueMetrics metrics = QueueMetrics.forQueue((String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)CONF);
        Queue leafQueue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)leafQueue.getQueueName()).thenReturn((Object)leafQueueName);
        Mockito.when((Object)leafQueue.getMetrics()).thenReturn((Object)metrics);
        QueueMetrics metrics1 = QueueMetrics.forQueue((String)leafQueueName1, (Queue)leafQueue, (boolean)true, (Configuration)CONF);
        AppSchedulingInfo app = TestPartitionQueueMetrics.mockApp(user);
        metrics1.submitApp(user, false);
        metrics1.submitAppAttempt(user, false);
        parentMetrics.setAvailableResourcesToQueue(partitionX, Resources.createResource((int)204800, (int)200));
        parentMetrics.setAvailableResourcesToQueue(partitionY, Resources.createResource((int)512000, (int)500));
        metrics.setAvailableResourcesToQueue(partitionX, Resources.createResource((int)102400, (int)100));
        metrics.setAvailableResourcesToQueue(partitionY, Resources.createResource((int)409600, (int)400));
        metrics1.setAvailableResourcesToQueue(partitionX, Resources.createResource((int)51200, (int)50));
        metrics1.setAvailableResourcesToQueue(partitionY, Resources.createResource((int)307200, (int)300));
        parentMetrics.setAvailableResourcesToUser(partitionX, user, Resources.createResource((int)20480, (int)20));
        parentMetrics.setAvailableResourcesToUser(partitionY, user, Resources.createResource((int)51200, (int)50));
        metrics.setAvailableResourcesToUser(partitionX, user, Resources.createResource((int)10240, (int)10));
        metrics.setAvailableResourcesToUser(partitionY, user, Resources.createResource((int)40960, (int)40));
        metrics1.setAvailableResourcesToUser(partitionX, user, Resources.createResource((int)5120, (int)5));
        metrics1.setAvailableResourcesToUser(partitionY, user, Resources.createResource((int)30720, (int)30));
        metrics1.incrPendingResources(partitionX, user, 6, Resources.createResource((int)3072, (int)3));
        metrics1.incrPendingResources(partitionY, user, 6, Resources.createResource((int)4096, (int)4));
        MetricsSource partitionSourceX = TestPartitionQueueMetrics.partitionSource(metrics1.getMetricsSystem(), partitionX);
        MetricsSource parentQueueSourceWithPartX = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionX, parentQueueName);
        MetricsSource queueSourceWithPartX = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionX, leafQueueName);
        MetricsSource queueSource1WithPartX = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionX, leafQueueName1);
        MetricsSource parentUserSourceWithPartX = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionX, user, parentQueueName);
        MetricsSource userSourceWithPartX = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionX, user, leafQueueName);
        MetricsSource userSource1WithPartX = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionX, user, leafQueueName1);
        TestPartitionQueueMetrics.checkResources(partitionSourceX, 0L, 0, 0, 0L, 0L, 204800L, 200, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentQueueSourceWithPartX, 0L, 0, 0, 0L, 0L, 204800L, 200, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(queueSourceWithPartX, 0L, 0, 0, 0L, 0L, 102400L, 100, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(queueSource1WithPartX, 0L, 0, 0, 0L, 0L, 51200L, 50, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentUserSourceWithPartX, 0L, 0, 0, 0L, 0L, 20480L, 20, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSourceWithPartX, 0L, 0, 0, 0L, 0L, 10240L, 10, 18432L, 18, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource1WithPartX, 0L, 0, 0, 0L, 0L, 5120L, 5, 18432L, 18, 6, 0L, 0, 0);
        MetricsSource partitionSourceY = TestPartitionQueueMetrics.partitionSource(metrics1.getMetricsSystem(), partitionY);
        MetricsSource parentQueueSourceWithPartY = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionY, parentQueueName);
        MetricsSource queueSourceWithPartY = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionY, leafQueueName);
        MetricsSource queueSource1WithPartY = TestPartitionQueueMetrics.queueSource(metrics1.getMetricsSystem(), partitionY, leafQueueName1);
        MetricsSource parentUserSourceWithPartY = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionY, user, parentQueueName);
        MetricsSource userSourceWithPartY = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionY, user, leafQueueName);
        MetricsSource userSource1WithPartY = TestPartitionQueueMetrics.userSource(metrics1.getMetricsSystem(), partitionY, user, leafQueueName1);
        TestPartitionQueueMetrics.checkResources(partitionSourceY, 0L, 0, 0, 0L, 0L, 512000L, 500, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentQueueSourceWithPartY, 0L, 0, 0, 0L, 0L, 512000L, 500, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(queueSourceWithPartY, 0L, 0, 0, 0L, 0L, 409600L, 400, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(queueSource1WithPartY, 0L, 0, 0, 0L, 0L, 307200L, 300, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(parentUserSourceWithPartY, 0L, 0, 0, 0L, 0L, 51200L, 50, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSourceWithPartY, 0L, 0, 0, 0L, 0L, 40960L, 40, 24576L, 24, 6, 0L, 0, 0);
        TestPartitionQueueMetrics.checkResources(userSource1WithPartY, 0L, 0, 0, 0L, 0L, 30720L, 30, 24576L, 24, 6, 0L, 0, 0);
        metrics1.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        metrics1.finishApp(user, RMAppState.FINISHED, false);
    }

    @Test(expected=NullPointerException.class)
    public void testSinglePartitionWithSingleLevelQueueMetricsWithoutUserMetrics() throws Exception {
        String parentQueueName = "root";
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        String user = "alice";
        QueueMetrics root = QueueMetrics.forQueue((String)"root", null, (boolean)false, (Configuration)CONF);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)root);
        Mockito.when((Object)parentQueue.getQueueName()).thenReturn((Object)parentQueueName);
        CSQueueMetrics q1 = CSQueueMetrics.forQueue((String)"root.q1", (Queue)parentQueue, (boolean)false, (Configuration)CONF);
        CSQueueMetrics q2 = CSQueueMetrics.forQueue((String)"root.q2", (Queue)parentQueue, (boolean)false, (Configuration)CONF);
        AppSchedulingInfo app = TestPartitionQueueMetrics.mockApp(user);
        q1.submitApp(user, false);
        q1.submitAppAttempt(user, false);
        root.setAvailableResourcesToQueue("x", Resources.createResource((int)204800, (int)200));
        q1.incrPendingResources("x", user, 2, Resource.newInstance((int)1024, (int)1));
        MetricsSource partitionSource = TestPartitionQueueMetrics.partitionSource(q1.getMetricsSystem(), "x");
        MetricsSource rootQueueSource = TestPartitionQueueMetrics.queueSource(q1.getMetricsSystem(), "x", parentQueueName);
        MetricsSource q1Source = TestPartitionQueueMetrics.queueSource(q1.getMetricsSystem(), "x", "root.q1");
        MetricsSource q1UserSource = TestPartitionQueueMetrics.userSource(q1.getMetricsSystem(), "x", user, "root.q1");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 204800L, 200, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1Source, 0L, 0, 0, 0L, 0, 2048L, 2, 2);
        TestPartitionQueueMetrics.checkResources(q1UserSource, 0L, 0, 0, 0L, 0, 2048L, 2, 2);
        q2.incrPendingResources("x", user, 3, Resource.newInstance((int)1024, (int)1));
        MetricsSource q2Source = TestPartitionQueueMetrics.queueSource(q2.getMetricsSystem(), "x", "root.q2");
        MetricsSource q2UserSource = TestPartitionQueueMetrics.userSource(q1.getMetricsSystem(), "x", user, "root.q2");
        TestPartitionQueueMetrics.checkResources(partitionSource, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(rootQueueSource, 0L, 0, 0, 0L, 0, 5120L, 5, 5);
        TestPartitionQueueMetrics.checkResources(q2Source, 0L, 0, 0, 0L, 0, 3072L, 3, 3);
        TestPartitionQueueMetrics.checkResources(q2UserSource, 0L, 0, 0, 0L, 0, 3072L, 3, 3);
        q1.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        q1.finishApp(user, RMAppState.FINISHED, false);
    }

    public static MetricsSource partitionSource(MetricsSystem ms, String partition) {
        MetricsSource s = ms.getSource(QueueMetrics.pSourceName((String)partition).toString());
        return s;
    }

    public static MetricsSource queueSource(MetricsSystem ms, String partition, String queue) {
        MetricsSource s = ms.getSource(QueueMetrics.pSourceName((String)partition).append((CharSequence)QueueMetrics.qSourceName((String)queue)).toString());
        return s;
    }

    public static MetricsSource userSource(MetricsSystem ms, String partition, String user, String queue) {
        MetricsSource s = ms.getSource(QueueMetrics.pSourceName((String)partition).append((CharSequence)QueueMetrics.qSourceName((String)queue)).append(",user=").append(user).toString());
        return s;
    }

    public static void checkResources(MetricsSource source, long allocatedMB, int allocatedCores, int allocCtnrs, long availableMB, int availableCores, long pendingMB, int pendingCores, int pendingCtnrs) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertGauge((String)"AllocatedMB", (long)allocatedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedVCores", (int)allocatedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedContainers", (int)allocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableMB", (long)availableMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableVCores", (int)availableCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingMB", (long)pendingMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingVCores", (int)pendingCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingContainers", (int)pendingCtnrs, (MetricsRecordBuilder)rb);
    }

    private static AppSchedulingInfo mockApp(String user) {
        AppSchedulingInfo app = (AppSchedulingInfo)Mockito.mock(AppSchedulingInfo.class);
        Mockito.when((Object)app.getUser()).thenReturn((Object)user);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId id = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)id);
        return app;
    }

    public static void checkResources(MetricsSource source, long allocatedMB, int allocatedCores, int allocCtnrs, long aggreAllocCtnrs, long aggreReleasedCtnrs, long availableMB, int availableCores, long pendingMB, int pendingCores, int pendingCtnrs, long reservedMB, int reservedCores, int reservedCtnrs) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertGauge((String)"AllocatedMB", (long)allocatedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedVCores", (int)allocatedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedContainers", (int)allocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersAllocated", (long)aggreAllocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersReleased", (long)aggreReleasedCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableMB", (long)availableMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableVCores", (int)availableCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingMB", (long)pendingMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingVCores", (int)pendingCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingContainers", (int)pendingCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedMB", (long)reservedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedVCores", (int)reservedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedContainers", (int)reservedCtnrs, (MetricsRecordBuilder)rb);
    }
}

