/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppMetricsChecker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceMetricsChecker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueMetrics {
    private static final int GB = 1024;
    private static final String USER = "alice";
    private static final String USER_2 = "dodo";
    private static final Configuration conf = new Configuration();
    private MetricsSystem ms;

    private static Queue createMockQueue(QueueMetrics metrics) {
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)queue.getMetrics()).thenReturn((Object)metrics);
        return queue;
    }

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
    }

    @Test
    public void testDefaultSingleQueueMetrics() {
        String queueName = "single";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(USER);
        metrics.submitApp(USER, false);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, USER);
        AppMetricsChecker appMetricsChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.setAvailableResourcesToQueue("", Resources.createResource((int)102400, (int)100));
        metrics.incrPendingResources("", USER, 5, Resources.createResource((int)3072, (int)3));
        ResourceMetricsChecker rmChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 102400L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 100).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(queueSource);
        metrics.runAppAttempt(app.getApplicationId(), USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.allocateResources("", USER, 3, Resources.createResource((int)2048, (int)2), true);
        rmChecker = ResourceMetricsChecker.createFromChecker(rmChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).checkAgainst(queueSource);
        metrics.releaseResources("", USER, 1, Resources.createResource((int)2048, (int)2));
        rmChecker = ResourceMetricsChecker.createFromChecker(rmChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).checkAgainst(queueSource);
        metrics.incrPendingResources("", USER, 0, Resources.createResource((int)2048, (int)2));
        rmChecker = ResourceMetricsChecker.createFromChecker(rmChecker).checkAgainst(queueSource);
        metrics.decrPendingResources("", USER, 0, Resources.createResource((int)2048, (int)2));
        ResourceMetricsChecker.createFromChecker(rmChecker).checkAgainst(queueSource);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.finishApp(USER, RMAppState.FINISHED, false);
        AppMetricsChecker.createFromChecker(appMetricsChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(queueSource, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testQueueAppMetricsForMultipleFailures() {
        String queueName = "single";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)new Configuration());
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(USER);
        metrics.submitApp(USER, false);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, USER);
        AppMetricsChecker appMetricsChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.finishApp(USER, RMAppState.FAILED, false);
        AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).counter(AppMetricsChecker.AppMetricsKey.APPS_FAILED, 1).checkAgainst(queueSource, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testQueueUnmanagedAppMetricsForMultipleFailures() {
        String queueName = "single";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)new Configuration());
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(USER);
        metrics.submitApp(USER, true);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, USER);
        AppMetricsChecker appMetricsChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_SUBMITTED, 1).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.submitAppAttempt(USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        metrics.runAppAttempt(app.getApplicationId(), USER, true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), true);
        appMetricsChecker = AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        metrics.finishApp(USER, RMAppState.FAILED, true);
        AppMetricsChecker.createFromChecker(appMetricsChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_RUNNING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).counter(AppMetricsChecker.AppMetricsKey.UNMANAGED_APPS_FAILED, 1).counter(AppMetricsChecker.AppMetricsKey.APPS_FAILED, 1).checkAgainst(queueSource, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testSingleQueueWithUserMetrics() {
        String queueName = "single2";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)true, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(USER_2);
        metrics.submitApp(USER_2, false);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, USER_2);
        AppMetricsChecker appMetricsQueueSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(queueSource, true);
        AppMetricsChecker appMetricsUserSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(userSource, true);
        metrics.submitAppAttempt(USER_2, false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(userSource, true);
        metrics.setAvailableResourcesToQueue("", Resources.createResource((int)102400, (int)100));
        metrics.setAvailableResourcesToUser("", USER_2, Resources.createResource((int)10240, (int)10));
        metrics.incrPendingResources("", USER_2, 5, Resources.createResource((int)3072, (int)3));
        ResourceMetricsChecker resMetricsQueueSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 102400L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 100).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(queueSource);
        ResourceMetricsChecker resMetricsUserSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 10240L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 10).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(userSource);
        metrics.runAppAttempt(app.getApplicationId(), USER_2, false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(userSource, true);
        metrics.allocateResources("", USER_2, 3, Resources.createResource((int)2048, (int)2), true);
        resMetricsQueueSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).checkAgainst(queueSource);
        resMetricsUserSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).checkAgainst(userSource);
        metrics.releaseResources("", USER_2, 1, Resources.createResource((int)2048, (int)2));
        ResourceMetricsChecker.createFromChecker(resMetricsQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).checkAgainst(queueSource);
        ResourceMetricsChecker.createFromChecker(resMetricsUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).checkAgainst(userSource);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(userSource, true);
        metrics.finishApp(USER_2, RMAppState.FINISHED, false);
        AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(queueSource, true);
        AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(userSource, true);
    }

    @Test
    public void testNodeTypeMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)conf);
        Queue parentQueue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)parentQueue.getMetrics()).thenReturn((Object)parentMetrics);
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)conf);
        MetricsSource parentQueueSource = TestQueueMetrics.queueSource(this.ms, parentQueueName);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, leafQueueName);
        metrics.submitApp(USER, false);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, leafQueueName, USER);
        MetricsSource parentUserSource = TestQueueMetrics.userSource(this.ms, parentQueueName, USER);
        metrics.incrNodeTypeAggregations(USER, NodeType.NODE_LOCAL);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 0L, 0L);
        metrics.incrNodeTypeAggregations(USER, NodeType.RACK_LOCAL);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 0L);
        metrics.incrNodeTypeAggregations(USER, NodeType.OFF_SWITCH);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 1L);
        metrics.incrNodeTypeAggregations(USER, NodeType.OFF_SWITCH);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 2L);
    }

    @Test
    public void testTwoLevelWithUserMetrics() {
        AppSchedulingInfo app = TestQueueMetrics.mockApp(USER);
        QueueInfo root = new QueueInfo(null, "root", this.ms, conf, USER);
        QueueInfo leaf = new QueueInfo(root, "root.leaf", this.ms, conf, USER);
        leaf.queueMetrics.submitApp(USER, false);
        AppMetricsChecker appMetricsQueueSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(leaf.queueSource, true);
        AppMetricsChecker appMetricsParentQueueSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(root.queueSource, true);
        AppMetricsChecker appMetricsUserSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(leaf.userSource, true);
        AppMetricsChecker appMetricsParentUserSourceChecker = AppMetricsChecker.create().counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).checkAgainst(root.userSource, true);
        leaf.queueMetrics.submitAppAttempt(USER, false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(leaf.queueSource, true);
        appMetricsParentQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsParentQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(root.queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(leaf.userSource, true);
        appMetricsParentUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsParentUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 1).checkAgainst(root.userSource, true);
        root.queueMetrics.setAvailableResourcesToQueue("", Resources.createResource((int)102400, (int)100));
        leaf.queueMetrics.setAvailableResourcesToQueue("", Resources.createResource((int)102400, (int)100));
        root.queueMetrics.setAvailableResourcesToUser("", USER, Resources.createResource((int)10240, (int)10));
        leaf.queueMetrics.setAvailableResourcesToUser("", USER, Resources.createResource((int)10240, (int)10));
        leaf.queueMetrics.incrPendingResources("", USER, 5, Resources.createResource((int)3072, (int)3));
        ResourceMetricsChecker resMetricsQueueSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 102400L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 100).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(leaf.queueSource);
        ResourceMetricsChecker resMetricsParentQueueSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 102400L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 100).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(root.queueSource);
        ResourceMetricsChecker resMetricsUserSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 10240L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 10).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(leaf.userSource);
        ResourceMetricsChecker resMetricsParentUserSourceChecker = ResourceMetricsChecker.createMandatoryResourceChecker().gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_MB, 10240L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.AVAILABLE_V_CORES, 10).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 15360L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 15).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 5).checkAgainst(root.userSource);
        leaf.queueMetrics.runAppAttempt(app.getApplicationId(), USER, false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(leaf.queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 1).checkAgainst(leaf.userSource, true);
        leaf.queueMetrics.allocateResources("", USER, 3, Resources.createResource((int)2048, (int)2), true);
        leaf.queueMetrics.reserveResource("", USER, Resources.createResource((int)3072, (int)3));
        resMetricsQueueSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 3072L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 3).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 1).checkAgainst(leaf.queueSource);
        resMetricsParentQueueSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsParentQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 3072L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 3).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 1).checkAgainst(root.queueSource);
        resMetricsUserSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 3072L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 3).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 1).checkAgainst(leaf.userSource);
        resMetricsParentUserSourceChecker = ResourceMetricsChecker.createFromChecker(resMetricsParentUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 6144L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 6).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 3).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_ALLOCATED, 3L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.PENDING_MB, 9216L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_V_CORES, 9).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.PENDING_CONTAINERS, 2).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 3072L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 3).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 1).checkAgainst(root.userSource);
        leaf.queueMetrics.releaseResources("", USER, 1, Resources.createResource((int)2048, (int)2));
        leaf.queueMetrics.unreserveResource("", USER, Resources.createResource((int)3072, (int)3));
        ResourceMetricsChecker.createFromChecker(resMetricsQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 0).checkAgainst(leaf.queueSource);
        ResourceMetricsChecker.createFromChecker(resMetricsParentQueueSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 0).checkAgainst(root.queueSource);
        ResourceMetricsChecker.createFromChecker(resMetricsUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 0).checkAgainst(leaf.userSource);
        ResourceMetricsChecker.createFromChecker(resMetricsParentUserSourceChecker).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_MB, 4096L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_V_CORES, 4).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.ALLOCATED_CONTAINERS, 2).counter(ResourceMetricsChecker.ResourceMetricsKey.AGGREGATE_CONTAINERS_RELEASED, 1L).gaugeLong(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_MB, 0L).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_V_CORES, 0).gaugeInt(ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS, 0).checkAgainst(root.userSource);
        leaf.queueMetrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser(), false);
        appMetricsQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(leaf.queueSource, true);
        appMetricsParentQueueSourceChecker = AppMetricsChecker.createFromChecker(appMetricsParentQueueSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(root.queueSource, true);
        appMetricsUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(leaf.userSource, true);
        appMetricsParentUserSourceChecker = AppMetricsChecker.createFromChecker(appMetricsParentUserSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_SUBMITTED, 1).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_PENDING, 0).gaugeInt(AppMetricsChecker.AppMetricsKey.APPS_RUNNING, 0).checkAgainst(root.userSource, true);
        leaf.queueMetrics.finishApp(USER, RMAppState.FINISHED, false);
        AppMetricsChecker.createFromChecker(appMetricsQueueSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(leaf.queueSource, true);
        AppMetricsChecker.createFromChecker(appMetricsParentQueueSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(root.queueSource, true);
        AppMetricsChecker.createFromChecker(appMetricsUserSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(leaf.userSource, true);
        AppMetricsChecker.createFromChecker(appMetricsParentUserSourceChecker).counter(AppMetricsChecker.AppMetricsKey.APPS_COMPLETED, 1).checkAgainst(root.userSource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsCache() {
        MetricsSystemImpl ms = new MetricsSystemImpl("cache");
        ms.start();
        try {
            String p1 = "root1";
            String leafQueueName = "root1.leaf";
            QueueMetrics p1Metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)p1, null, (boolean)true, (Configuration)conf);
            Queue parentQueue1 = (Queue)Mockito.mock(Queue.class);
            Mockito.when((Object)parentQueue1.getMetrics()).thenReturn((Object)p1Metrics);
            QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for A shoudn't be null", (Object)metrics);
            QueueMetrics alterMetrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for alterMetrics shoudn't be null", (Object)alterMetrics);
        }
        finally {
            ms.shutdown();
        }
    }

    @Test
    public void testMetricsInitializedOnRMInit() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        QueueMetrics metrics = rm.getResourceScheduler().getRootQueueMetrics();
        AppMetricsChecker.create().checkAgainst((MetricsSource)metrics, true);
        MetricsAsserts.assertGauge((String)ResourceMetricsChecker.ResourceMetricsKey.RESERVED_CONTAINERS.getValue(), (int)0, (MetricsSource)metrics);
    }

    @Test
    public void testCollectAllMetrics() {
        String queueName = "single";
        QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppMetricsChecker.create().checkAgainst(queueSource, true);
        try {
            AppMetricsChecker.create().checkAgainst(queueSource, false);
            Assert.fail();
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("Expected exactly one metric for name "));
        }
        AppMetricsChecker.create().checkAgainst(queueSource, true);
    }

    @Test
    public void testQueueMetricsRaceCondition() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        int numIterations = 100000;
        AtomicInteger exceptionCount = new AtomicInteger(0);
        AtomicInteger getCount = new AtomicInteger(0);
        String queueName = "test";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        QueueMetrics.getQueueMetrics().put(queueName, metrics);
        Thread threadA = new Thread(() -> {
            try {
                for (int i = 0; i < 100000; ++i) {
                    QueueMetrics qm = (QueueMetrics)QueueMetrics.getQueueMetrics().get(queueName);
                    if (qm == null) continue;
                    getCount.incrementAndGet();
                }
            }
            catch (Exception e) {
                System.out.println("Exception: " + e.getMessage());
                exceptionCount.incrementAndGet();
            }
            finally {
                latch.countDown();
            }
        });
        Thread threadB = new Thread(() -> {
            try {
                for (int i = 0; i < 100000; ++i) {
                    QueueMetrics.getQueueMetrics().put("q" + i, metrics);
                }
            }
            catch (Exception e) {
                exceptionCount.incrementAndGet();
            }
            finally {
                latch.countDown();
            }
        });
        threadA.start();
        threadB.start();
        latch.await();
        Assert.assertEquals((long)100000L, (long)getCount.get());
        Assert.assertEquals((long)0L, (long)exceptionCount.get());
    }

    private static void checkAggregatedNodeTypes(MetricsSource source, long nodeLocal, long rackLocal, long offSwitch) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertCounter((String)"AggregateNodeLocalContainersAllocated", (long)nodeLocal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateRackLocalContainersAllocated", (long)rackLocal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateOffSwitchContainersAllocated", (long)offSwitch, (MetricsRecordBuilder)rb);
    }

    static AppSchedulingInfo mockApp(String user) {
        AppSchedulingInfo app = (AppSchedulingInfo)Mockito.mock(AppSchedulingInfo.class);
        Mockito.when((Object)app.getUser()).thenReturn((Object)user);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId id = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)id);
        return app;
    }

    public static MetricsSource queueSource(MetricsSystem ms, String queue) {
        return ms.getSource(QueueMetrics.sourceName((String)queue).toString());
    }

    public static MetricsSource userSource(MetricsSystem ms, String queue, String user) {
        return ms.getSource(QueueMetrics.sourceName((String)queue).append(",user=").append(user).toString());
    }
}

