/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.TestGroupsCaching;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.CSQueueMetricsForCustomResources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerOvercommit;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacityScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacityScheduler.class);
    private static final ContainerUpdates NULL_UPDATE_REQUESTS = new ContainerUpdates();
    private ResourceManager resourceManager = null;
    private RMContext mockContext;
    private static final double DELTA = 1.0E-4;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = CapacitySchedulerTestUtilities.createResourceManager();
        this.mockContext = CapacitySchedulerTestUtilities.createMockRMContext();
    }

    @After
    public void tearDown() throws Exception {
        CapacitySchedulerTestUtilities.stopResourceManager(this.resourceManager);
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setRMContext(this.resourceManager.getRMContext());
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfigGeneratorForTest.setMinAllocMb((Configuration)conf, 2048);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)conf, 1024);
        try {
            scheduler.init((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        CapacitySchedulerConfigGeneratorForTest.setMinAllocVcores((Configuration)conf, 2);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)conf, 1);
        try {
            scheduler.reinitialize((Configuration)conf, this.mockContext);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    @Test
    public void testCapacityScheduler() throws Exception {
        LOG.info("--- START: testCapacityScheduler ---");
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host_0 = "host_0";
        NodeManager nm_0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1), mockNodeStatus);
        String host_1 = "host_1";
        NodeManager nm_1 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1), mockNodeStatus);
        Priority priority_0 = Priority.newInstance((int)0);
        Priority priority_1 = Priority.newInstance((int)1);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", "b2", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072, (int)1);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)2048, (int)1);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        LOG.info("Kick!");
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_1);
        application_0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application_1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm_0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(0, nm_1);
        LOG.info("Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_1);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_0, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        application_0.schedule();
        LOG.info("Sending hb from " + nm_0.getHostName());
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_0);
        LOG.info("Sending hb from " + nm_1.getHostName());
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_1);
        LOG.info("Trying to allocate...");
        application_0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(5120, application_1);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_0);
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm_1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm_0);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(2048, nm_1);
        LOG.info("--- END: testCapacityScheduler ---");
    }

    @Test
    public void testNotAssignMultiple() throws Exception {
        LOG.info("--- START: testNotAssignMultiple ---");
        ResourceManager rm = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", false);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        rm.init((Configuration)conf);
        rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)rm.getRMContext().getDispatcher()).start();
        RMContext mC = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mC.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(rm, host0, 1234, 2345, "/default-rack", Resources.createResource((int)10240, (int)10), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application("user_0", "a1", rm);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        Resource capability00 = Resources.createResource((int)1024, (int)1);
        application0.addResourceRequestSpec(priority0, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority1, capability01);
        Task task00 = new Task(application0, priority0, new String[]{host0});
        Task task01 = new Task(application0, priority1, new String[]{host0});
        application0.addTask(task00);
        application0.addTask(task01);
        Application application1 = new Application("user_1", "b2", rm);
        application1.submit();
        application1.addNodeManager(host0, 1234, nm0);
        Resource capability10 = Resources.createResource((int)3072, (int)1);
        application1.addResourceRequestSpec(priority0, capability10);
        Resource capability11 = Resources.createResource((int)4096, (int)1);
        application1.addResourceRequestSpec(priority1, capability11);
        Task task10 = new Task(application1, priority0, new String[]{host0});
        Task task11 = new Task(application1, priority1, new String[]{host0});
        application1.addTask(task10);
        application1.addTask(task11);
        application0.schedule();
        application1.schedule();
        LOG.info("Kick!");
        CapacitySchedulerTestUtilities.nodeUpdate(rm, nm0);
        application0.schedule();
        application1.schedule();
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(3072, nm0);
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(0, application0);
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application1);
        CapacitySchedulerTestUtilities.nodeUpdate(rm, nm0);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application0);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm0);
        LOG.info("--- END: testNotAssignMultiple ---");
        rm.stop();
    }

    @Test
    public void testAssignMultiple() throws Exception {
        LOG.info("--- START: testAssignMultiple ---");
        ResourceManager rm = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", true);
        csConf.setInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", 2);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        rm.init((Configuration)conf);
        rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)rm.getRMContext().getDispatcher()).start();
        RMContext mC = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mC.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(rm, host0, 1234, 2345, "/default-rack", Resources.createResource((int)10240, (int)10), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Priority priority1 = Priority.newInstance((int)1);
        Application application0 = new Application("user_0", "a1", rm);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        Resource capability00 = Resources.createResource((int)1024, (int)1);
        application0.addResourceRequestSpec(priority0, capability00);
        Resource capability01 = Resources.createResource((int)2048, (int)1);
        application0.addResourceRequestSpec(priority1, capability01);
        Task task00 = new Task(application0, priority0, new String[]{host0});
        Task task01 = new Task(application0, priority1, new String[]{host0});
        application0.addTask(task00);
        application0.addTask(task01);
        Application application1 = new Application("user_1", "b2", rm);
        application1.submit();
        application1.addNodeManager(host0, 1234, nm0);
        Resource capability10 = Resources.createResource((int)3072, (int)1);
        application1.addResourceRequestSpec(priority0, capability10);
        Resource capability11 = Resources.createResource((int)4096, (int)1);
        application1.addResourceRequestSpec(priority1, capability11);
        Task task10 = new Task(application1, priority0, new String[]{host0});
        Task task11 = new Task(application1, priority1, new String[]{host0});
        application1.addTask(task10);
        application1.addTask(task11);
        application0.schedule();
        application1.schedule();
        LOG.info("Kick!");
        CapacitySchedulerTestUtilities.nodeUpdate(rm, nm0);
        application0.schedule();
        application1.schedule();
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(4096, nm0);
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(1024, application0);
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application1);
        CapacitySchedulerTestUtilities.nodeUpdate(rm, nm0);
        application0.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(3072, application0);
        application1.schedule();
        CapacitySchedulerTestUtilities.checkApplicationResourceUsage(7168, application1);
        CapacitySchedulerTestUtilities.checkNodeResourceUsage(10240, nm0);
        LOG.info("--- END: testAssignMultiple ---");
        rm.stop();
    }

    @Test
    public void testMaximumCapacitySetup() {
        float delta = 1.0E-7f;
        QueuePath queuePathA = new QueuePath("root.a");
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        Assert.assertEquals((float)100.0f, (float)conf.getNonLabeledQueueMaximumCapacity(queuePathA), (float)delta);
        conf.setMaximumCapacity("root.a", 50.0f);
        Assert.assertEquals((float)50.0f, (float)conf.getNonLabeledQueueMaximumCapacity(queuePathA), (float)delta);
        conf.setMaximumCapacity("root.a", -1.0f);
        Assert.assertEquals((float)100.0f, (float)conf.getNonLabeledQueueMaximumCapacity(queuePathA), (float)delta);
    }

    @Test
    public void testQueueMaximumAllocations() {
        CapacityScheduler scheduler = new CapacityScheduler();
        scheduler.setConf((Configuration)new YarnConfiguration());
        scheduler.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(conf, "root.a.a1", 1024);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(conf, "root.a.a1", 1);
        scheduler.init((Configuration)conf);
        scheduler.start();
        Resource maxAllocationForQueue = scheduler.getMaximumResourceCapability("a1");
        Resource maxAllocation1 = scheduler.getMaximumResourceCapability("");
        Resource maxAllocation2 = scheduler.getMaximumResourceCapability(null);
        Resource maxAllocation3 = scheduler.getMaximumResourceCapability();
        Assert.assertEquals((Object)maxAllocation1, (Object)maxAllocation2);
        Assert.assertEquals((Object)maxAllocation1, (Object)maxAllocation3);
        Assert.assertEquals((long)8192L, (long)maxAllocation1.getMemorySize());
        Assert.assertEquals((long)4L, (long)maxAllocation1.getVirtualCores());
        Assert.assertEquals((long)1024L, (long)maxAllocationForQueue.getMemorySize());
        Assert.assertEquals((long)1L, (long)maxAllocationForQueue.getVirtualCores());
        scheduler.stop();
    }

    @Test
    public void testParseQueueWithAbsoluteResource() {
        String childQueue = "testQueue";
        String labelName = "testLabel";
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setQueues("root", new String[]{childQueue});
        conf.setCapacity("root." + childQueue, "[memory=20480,vcores=200]");
        conf.setAccessibleNodeLabels("root." + childQueue, (Set)Sets.newHashSet((Object[])new String[]{labelName}));
        conf.setCapacityByLabel("root", labelName, "[memory=10240,vcores=100]");
        conf.setCapacityByLabel("root." + childQueue, labelName, "[memory=4096,vcores=10]");
        cs.init((Configuration)conf);
        cs.start();
        Resource rootQueueLableCapacity = cs.getQueue("root").getQueueResourceQuotas().getConfiguredMinResource(labelName);
        Assert.assertEquals((long)10240L, (long)rootQueueLableCapacity.getMemorySize());
        Assert.assertEquals((long)100L, (long)rootQueueLableCapacity.getVirtualCores());
        QueueResourceQuotas childQueueQuotas = cs.getQueue(childQueue).getQueueResourceQuotas();
        Resource childQueueCapacity = childQueueQuotas.getConfiguredMinResource();
        Assert.assertEquals((long)20480L, (long)childQueueCapacity.getMemorySize());
        Assert.assertEquals((long)200L, (long)childQueueCapacity.getVirtualCores());
        Resource childQueueLabelCapacity = childQueueQuotas.getConfiguredMinResource(labelName);
        Assert.assertEquals((long)4096L, (long)childQueueLabelCapacity.getMemorySize());
        Assert.assertEquals((long)10L, (long)childQueueLabelCapacity.getVirtualCores());
        cs.stop();
    }

    @Test
    public void testCapacitySchedulerInfo() throws Exception {
        QueueInfo queueInfo = this.resourceManager.getResourceScheduler().getQueueInfo("a", true, true);
        Assert.assertEquals((String)"Queue Name should be a", (Object)"a", (Object)queueInfo.getQueueName());
        Assert.assertEquals((String)"Queue Path should be root.a", (Object)"root.a", (Object)queueInfo.getQueuePath());
        Assert.assertEquals((String)"Child Queues size should be 2", (long)2L, (long)queueInfo.getChildQueues().size());
        List userACLInfo = this.resourceManager.getResourceScheduler().getQueueUserAclInfo();
        Assert.assertNotNull((Object)userACLInfo);
        for (QueueUserACLInfo queueUserACLInfo : userACLInfo) {
            Assert.assertEquals((long)1L, (long)this.getQueueCount(userACLInfo, queueUserACLInfo.getQueueName()));
        }
    }

    private int getQueueCount(List<QueueUserACLInfo> queueInformation, String queueName) {
        int result = 0;
        for (QueueUserACLInfo queueUserACLInfo : queueInformation) {
            if (!queueName.equals(queueUserACLInfo.getQueueName())) continue;
            ++result;
        }
        return result;
    }

    @Test
    public void testAllocateReorder() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue q = (LeafQueue)cs.getQueue("default");
        Assert.assertNotNull((Object)q);
        FairOrderingPolicy fop = new FairOrderingPolicy();
        fop.setSizeBasedWeight(true);
        q.setOrderingPolicy((OrderingPolicy)fop);
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationAttemptId appAttemptId1 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 1, "default", "user");
        ApplicationAttemptId appAttemptId2 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 2, "default", "user");
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        Priority priority2 = TestUtils.createMockPriority(1);
        ResourceRequest r1 = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId1, Collections.singletonList(r1), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        CapacityScheduler.schedule((CapacityScheduler)cs);
        Assert.assertEquals((Object)((FiCaSchedulerApp)q.getOrderingPolicy().getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR).next()).getId(), (Object)appAttemptId1.getApplicationId().toString());
        ResourceRequest r2 = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId2, Collections.singletonList(r2), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        Assert.assertEquals((Object)((FiCaSchedulerApp)q.getOrderingPolicy().getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR).next()).getId(), (Object)appAttemptId2.getApplicationId().toString());
        rm.stop();
    }

    @Test
    public void testResourceOverCommit() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        ResourceScheduler scheduler = rm.getResourceScheduler();
        MockNM nm = rm.registerNode("127.0.0.1:1234", 4096);
        NodeId nmId = nm.getNodeId();
        RMApp app = MockRMAppSubmitter.submitWithMemory(2048L, rm);
        nm.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am.registerAppAttempt();
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 2048L, 2048L);
        am.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am.schedule();
        nm.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().isEmpty()) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(100L);
            alloc1Response = am.schedule();
        }
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)2048L, (long)c1.getResource().getMemorySize());
        Assert.assertEquals((Object)nmId, (Object)c1.getNodeId());
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 4096L, 0L);
        nm.nodeHeartbeat(true);
        Assert.assertEquals((long)4096L, (long)nm.getCapability().getMemorySize());
        TestCapacitySchedulerOvercommit.updateNodeResource(rm, nmId, 2048, 2, -1);
        TestCapacitySchedulerOvercommit.waitMemory(scheduler, nmId, 4096, -2048, 200, 5000);
        TestCapacitySchedulerOvercommit.assertNoPreemption(am.schedule().getPreemptionMessage());
        nm.nodeHeartbeat(true);
        Assert.assertEquals((long)2048L, (long)nm.getCapability().getMemorySize());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0, (Resource)c1.getResource());
        nm.containerStatus(containerStatus);
        LOG.info("Waiting for containers to be finished for app 1...");
        GenericTestUtils.waitFor(() -> attempt1.getJustFinishedContainers().size() == 1, (long)100L, (long)2000L);
        Assert.assertEquals((long)1L, (long)am.schedule().getCompletedContainersStatuses().size());
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 2048L, 0L);
        am.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 3072, 1, 1);
        AllocateResponse allocResponse2 = am.schedule();
        Assert.assertTrue((String)"Shouldn't have enough resource to allocate containers", (boolean)allocResponse2.getAllocatedContainers().isEmpty());
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            allocResponse2 = am.schedule();
            Assert.assertTrue((String)"Shouldn't have enough resource to allocate containers", (boolean)allocResponse2.getAllocatedContainers().isEmpty());
        }
        TestCapacitySchedulerOvercommit.updateNodeResource(rm, nmId, 5120, 2, -1);
        TestCapacitySchedulerOvercommit.waitMemory(scheduler, nmId, 2048, 3072, 100, 5000);
        nm.nodeHeartbeat(true);
        while (allocResponse2.getAllocatedContainers().isEmpty()) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(100L);
            allocResponse2 = am.schedule();
        }
        Assert.assertEquals((long)1L, (long)allocResponse2.getAllocatedContainers().size());
        Container c2 = (Container)allocResponse2.getAllocatedContainers().get(0);
        Assert.assertEquals((long)3072L, (long)c2.getResource().getMemorySize());
        Assert.assertEquals((Object)nmId, (Object)c2.getNodeId());
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 5120L, 0L);
        TestCapacitySchedulerOvercommit.updateNodeResource(rm, nmId, 3072, 2, 2000);
        TestCapacitySchedulerOvercommit.waitMemory(scheduler, nmId, 5120, -2048, 200, 5000);
        PreemptionMessage preemptMsg = am.schedule().getPreemptionMessage();
        TestCapacitySchedulerOvercommit.assertPreemption(c2.getId(), preemptMsg);
        TestCapacitySchedulerOvercommit.updateNodeResource(rm, nmId, 5120, 2, -1);
        TestCapacitySchedulerOvercommit.waitMemory(scheduler, nmId, 5120, 0, 200, 5000);
        Thread.sleep(3000L);
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 5120L, 0L);
        long t0 = Time.now();
        TestCapacitySchedulerOvercommit.updateNodeResource(rm, nmId, 3072, 2, 2000);
        TestCapacitySchedulerOvercommit.waitMemory(scheduler, nmId, 5120, -2048, 200, 5000);
        preemptMsg = am.schedule().getPreemptionMessage();
        TestCapacitySchedulerOvercommit.assertPreemption(c2.getId(), preemptMsg);
        GenericTestUtils.waitFor(() -> {
            try {
                nm.nodeHeartbeat(true);
            }
            catch (Exception e) {
                LOG.error("Cannot heartbeat", (Throwable)e);
            }
            SchedulerNodeReport report = scheduler.getNodeReport(nmId);
            return report.getAvailableResource().getMemorySize() > 0L;
        }, (long)200L, (long)5000L);
        TestCapacitySchedulerOvercommit.assertMemory(scheduler, nmId, 2048L, 1024L);
        List completedContainers = am.schedule().getCompletedContainersStatuses();
        Assert.assertEquals((long)1L, (long)completedContainers.size());
        ContainerStatus c2status = (ContainerStatus)completedContainers.get(0);
        TestCapacitySchedulerOvercommit.assertContainerKilled(c2.getId(), c2status);
        TestCapacitySchedulerOvercommit.assertTime(2000L, Time.now() - t0);
        rm.stop();
    }

    @Test
    public void testAsyncScheduling() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        int NODES = 100;
        for (i = 0; i < 100; ++i) {
            String host = "192.168.1." + i;
            RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
            cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        }
        for (i = 0; i < 100; ++i) {
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
        rm.stop();
    }

    private void waitForAppPreemptionInfo(RMApp app, Resource preempted, int numAMPreempted, int numTaskPreempted, Resource currentAttemptPreempted, boolean currentAttemptAMPreempted, int numLatestAttemptTaskPreempted) throws InterruptedException {
        while (true) {
            RMAppMetrics appPM = app.getRMAppMetrics();
            RMAppAttemptMetrics attemptPM = app.getCurrentAppAttempt().getRMAppAttemptMetrics();
            if (appPM.getResourcePreempted().equals((Object)preempted) && appPM.getNumAMContainersPreempted() == numAMPreempted && appPM.getNumNonAMContainersPreempted() == numTaskPreempted && attemptPM.getResourcePreempted().equals((Object)currentAttemptPreempted) && app.getCurrentAppAttempt().getRMAppAttemptMetrics().getIsPreempted() == currentAttemptAMPreempted && attemptPM.getNumNonAMContainersPreempted() == numLatestAttemptTaskPreempted) {
                return;
            }
            Thread.sleep(500L);
        }
    }

    private void waitForNewAttemptCreated(RMApp app, ApplicationAttemptId previousAttemptId) throws InterruptedException {
        while (app.getCurrentAppAttempt().equals(previousAttemptId)) {
            Thread.sleep(500L);
        }
    }

    @Test(timeout=30000L)
    public void testAllocateDoesNotBlockOnSchedulerLock() throws Exception {
        final YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS((Configuration)conf, containerManager);
        rm.start();
        MockNM nm1 = rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("appname").withUser("appuser").withAcls(acls).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        int msecToSleep = 100;
        for (int msecToWait = 10000; attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && msecToWait > 0; msecToWait -= msecToSleep) {
            LOG.info("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState());
            Thread.sleep(msecToSleep);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        final InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rmBindAddress, (Configuration)conf);
            }
        });
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance((String)"localhost", (int)12345, (String)"");
        client.registerApplicationMaster(request);
        List<ResourceRequest> asks = Collections.singletonList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1));
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)0, (float)0.0f, asks, null, null);
        client.allocate(allocateRequest);
        nm1.nodeHeartbeat(true);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId2, RMContainerState.ALLOCATED));
        allocateRequest = AllocateRequest.newInstance((int)1, (float)0.0f, null, null, null);
        client.allocate(allocateRequest);
        final CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMContainer rmContainer = cs.getRMContainer(containerId2);
        rmContainer.handle((Event)new RMContainerEvent(containerId2, RMContainerEventType.LAUNCHED));
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread otherThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CapacityScheduler capacityScheduler = cs;
                synchronized (capacityScheduler) {
                    try {
                        barrier.await();
                        barrier.await();
                    }
                    catch (InterruptedException | BrokenBarrierException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        otherThread.start();
        barrier.await();
        List<ContainerId> release = Collections.singletonList(containerId2);
        allocateRequest = AllocateRequest.newInstance((int)2, (float)0.0f, null, release, null);
        client.allocate(allocateRequest);
        barrier.await();
        otherThread.join();
        rm.stop();
    }

    @Test(timeout=120000L)
    public void testPreemptionInfo() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 3);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        int CONTAINER_MEMORY = 1024;
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(CONTAINER_MEMORY, rm1);
        MockAM am0 = MockRM.launchAM(app0, rm1, nm1);
        am0.registerAppAttempt();
        FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app0.getApplicationId())).getCurrentAppAttempt();
        List<Container> allocatedContainers = am0.allocateAndWaitForContainers(3, CONTAINER_MEMORY, nm1);
        for (Container c : allocatedContainers) {
            cs.markContainerForKillable(schedulerAppAttempt.getRMContainer(c.getId()));
        }
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3), 0, 3, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3), false, 3);
        cs.markContainerForKillable(schedulerAppAttempt.getRMContainer(app0.getCurrentAppAttempt().getMasterContainer().getId()));
        this.waitForNewAttemptCreated(app0, am0.getApplicationAttemptId());
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 4), (int)4), 1, 3, Resource.newInstance((int)0, (int)0), false, 0);
        MockAM am1 = MockRM.launchAM(app0, rm1, nm1);
        am1.registerAppAttempt();
        schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app0.getApplicationId())).getCurrentAppAttempt();
        allocatedContainers = am1.allocateAndWaitForContainers(3, CONTAINER_MEMORY, nm1);
        for (Container c : allocatedContainers) {
            cs.markContainerForKillable(schedulerAppAttempt.getRMContainer(c.getId()));
        }
        this.waitForAppPreemptionInfo(app0, Resource.newInstance((int)(CONTAINER_MEMORY * 7), (int)7), 1, 6, Resource.newInstance((int)(CONTAINER_MEMORY * 3), (int)3), false, 3);
        rm1.stop();
    }

    @Test(timeout=300000L)
    public void testRecoverRequestAfterPreemption() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId1, RMContainerState.ALLOCATED);
        RMContainer rmContainer = cs.getRMContainer(containerId1);
        List requests = rmContainer.getContainerRequest().getResourceRequests();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerNode node = cs.getNode(rmContainer.getAllocatedNode());
        for (ResourceRequest request : requests) {
            if (request.getResourceName().equals(node.getRackName()) || request.getResourceName().equals("*")) continue;
            Assert.assertEquals((long)0L, (long)app.getOutstandingAsksCount(SchedulerRequestKey.create((ResourceRequest)request), request.getResourceName()));
        }
        cs.markContainerForKillable(rmContainer);
        Assert.assertEquals((long)3L, (long)requests.size());
        for (ResourceRequest request : requests) {
            Assert.assertEquals((long)1L, (long)app.getOutstandingAsksCount(SchedulerRequestKey.create((ResourceRequest)request), request.getResourceName()));
        }
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertTrue((containers.size() == 1 ? 1 : 0) != 0);
        rm1.stop();
    }

    @Test
    public void testPreemptionDisabled() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, "root.b");
        CSQueue queueB2 = CapacitySchedulerQueueHelpers.findQueue(queueB, "root.b.b2");
        Assert.assertFalse((String)"queue root.b.b2 should default to preemptable", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(rootQueue.getQueuePath(), true);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertTrue((String)"queue root.b.b2 should have inherited non-preemptability from root", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(rootQueue.getQueuePath(), false);
        conf.setPreemptionDisabled(queueB.getQueuePath(), true);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertTrue((String)"queue root.b.b2 should have inherited non-preemptability from parent", (boolean)queueB2.getPreemptionDisabled());
        conf.setPreemptionDisabled(queueB2.getQueuePath(), false);
        cs.reinitialize((Configuration)conf, (RMContext)rmContext);
        Assert.assertFalse((String)"queue root.b.b2 should have been preemptable", (boolean)queueB2.getPreemptionDisabled());
        cs.stop();
    }

    private void waitContainerAllocated(MockAM am, int mem, int nContainer, int startContainerId, MockRM rm, MockNM nm) throws Exception {
        for (int cId = startContainerId; cId < startContainerId + nContainer; ++cId) {
            am.allocate("*", mem, 1, new ArrayList<ContainerId>());
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)cId);
            Assert.assertTrue((boolean)rm.waitForState(nm, containerId, RMContainerState.ALLOCATED));
        }
    }

    @Test
    public void testSchedulerKeyGarbageCollection() throws Exception {
        YarnConfiguration conf = new YarnConfiguration((Configuration)new CapacitySchedulerConfiguration());
        conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        ApplicationAttemptId attemptId = app1.getCurrentAppAttempt().getAppAttemptId();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        ResourceScheduler scheduler = rm.getResourceScheduler();
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        nm4.nodeHeartbeat(true);
        Thread.sleep(1000L);
        AllocateResponse allocateResponse = am1.allocate(Arrays.asList(TestCapacityScheduler.newResourceRequest(1, 1L, "*", Resources.createResource((int)3072), 1, true, ExecutionType.GUARANTEED), TestCapacityScheduler.newResourceRequest(2, 2L, "*", Resources.createResource((int)3072), 1, true, ExecutionType.GUARANTEED), TestCapacityScheduler.newResourceRequest(3, 3L, "*", Resources.createResource((int)3072), 1, true, ExecutionType.GUARANTEED), TestCapacityScheduler.newResourceRequest(4, 4L, "*", Resources.createResource((int)3072), 1, true, ExecutionType.GUARANTEED)), null);
        List allocatedContainers = allocateResponse.getAllocatedContainers();
        Assert.assertEquals((long)0L, (long)allocatedContainers.size());
        Collection schedulerKeys = ((CapacityScheduler)scheduler).getApplicationAttempt(attemptId).getAppSchedulingInfo().getSchedulerKeys();
        Assert.assertEquals((long)4L, (long)schedulerKeys.size());
        nm1.nodeHeartbeat(true);
        Thread.sleep(200L);
        allocateResponse = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
        allocatedContainers = allocateResponse.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        Assert.assertEquals((long)3L, (long)schedulerKeys.size());
        List resReqs = ((CapacityScheduler)scheduler).getApplicationAttempt(attemptId).getAppSchedulingInfo().getAllResourceRequests();
        Assert.assertEquals((long)3L, (long)resReqs.size());
        nm2.nodeHeartbeat(true);
        Thread.sleep(200L);
        allocateResponse = am1.allocate(Arrays.asList(TestCapacityScheduler.newResourceRequest(1, ((Container)allocatedContainers.get(0)).getAllocationRequestId(), "*", Resources.createResource((int)3072), 0, true, ExecutionType.GUARANTEED)), new ArrayList<ContainerId>());
        allocatedContainers = allocateResponse.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        Assert.assertEquals((long)2L, (long)schedulerKeys.size());
        resReqs = ((CapacityScheduler)scheduler).getApplicationAttempt(attemptId).getAppSchedulingInfo().getAllResourceRequests();
        Assert.assertEquals((long)2L, (long)resReqs.size());
        SchedulerRequestKey sk = (SchedulerRequestKey)schedulerKeys.iterator().next();
        am1.allocate(Arrays.asList(TestCapacityScheduler.newResourceRequest(sk.getPriority().getPriority(), sk.getAllocationRequestId(), "*", Resources.createResource((int)3072), 0, true, ExecutionType.GUARANTEED)), null);
        schedulerKeys = ((CapacityScheduler)scheduler).getApplicationAttempt(attemptId).getAppSchedulingInfo().getSchedulerKeys();
        Thread.sleep(200L);
        Assert.assertEquals((long)1L, (long)schedulerKeys.size());
        nm3.nodeHeartbeat(true);
        Thread.sleep(200L);
        allocateResponse = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
        allocatedContainers = allocateResponse.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        Assert.assertEquals((long)0L, (long)schedulerKeys.size());
        resReqs = ((CapacityScheduler)scheduler).getApplicationAttempt(attemptId).getAppSchedulingInfo().getAllResourceRequests();
        Assert.assertEquals((long)0L, (long)resReqs.size());
        rm.stop();
    }

    private static ResourceRequest newResourceRequest(int priority2, long allocReqId, String rName, Resource resource, int numContainers, boolean relaxLoc, ExecutionType eType) {
        ResourceRequest rr = ResourceRequest.newInstance((Priority)Priority.newInstance((int)priority2), (String)rName, (Resource)resource, (int)numContainers, (boolean)relaxLoc, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)eType, (boolean)true));
        rr.setAllocationRequestId(allocReqId);
        return rr;
    }

    @Test
    public void testHierarchyQueuesCurrentLimits() throws Exception {
        YarnConfiguration conf = new YarnConfiguration((Configuration)CapacitySchedulerQueueHelpers.setupQueueConfiguration(new CapacitySchedulerConfiguration()));
        conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 102400, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 2, rm1, nm1);
        Assert.assertEquals((long)70656L, (long)am1.doHeartbeat().getAvailableResources().getMemorySize());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        this.waitContainerAllocated(am2, 8192, 5, 2, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 3, rm1, nm1);
        Assert.assertEquals((long)57344L, (long)am1.doHeartbeat().getAvailableResources().getMemorySize());
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        this.waitContainerAllocated(am3, 8192, 3, 2, rm1, nm1);
        this.waitContainerAllocated(am1, 1024, 1, 4, rm1, nm1);
        Assert.assertEquals((long)30720L, (long)am1.doHeartbeat().getAvailableResources().getMemorySize());
        rm1.stop();
    }

    @Test
    public void testParentQueueMaxCapsAreRespected() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacity("root.a", 50.0f);
        csConf.setMaximumCapacity("root.a", 50.0f);
        csConf.setCapacity("root.b", 50.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setUserLimitFactor("root.a.a1", 100.0f);
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setUserLimitFactor("root.a.a2", 100.0f);
        csConf.setCapacity("root.b.b1", 79.2f);
        csConf.setUserLimitFactor("root.b.b1", 100.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 24576, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        this.waitContainerAllocated(am1, 4096, 2, 2, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        try {
            this.waitContainerAllocated(am2, 2048, 1, 2, rm1, nm1);
        }
        catch (AssertionError failure) {
            return;
        }
        Assert.fail((String)"Shouldn't successfully allocate containers for am2, queue-a's max capacity will be violated if container allocated");
        rm1.stop();
    }

    @Test
    public void testQueueHierarchyPendingResourceUpdate() throws Exception {
        Configuration conf = TestUtils.getConfigurationWithQueueLabels(new Configuration(false));
        conf.setBoolean("yarn.node-labels.enabled", true);
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init(conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), CapacitySchedulerTestUtilities.toSet("x")));
        MockRM rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.start();
        MockNM nm1 = new MockNM("h1:1234", 204800, rm.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("h2:1234", 204800, rm.getResourceTrackerService());
        nm2.registerNode();
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)8)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 8192, null);
        am2.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)8)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 16384, null);
        am2.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"*", (Resource)Resources.createResource((int)1024), (int)8)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 24576, null);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)4096), (int)1)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 20480, null);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"*", (Resource)Resources.createResource((int)8192), (int)1, (boolean)true, (String)"x")), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 20480, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 8192, "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResourceGreaterThanZero(rm, "b1", null);
        CapacitySchedulerTestUtilities.checkPendingResourceGreaterThanZero(rm, "b", null);
        CapacitySchedulerTestUtilities.checkPendingResourceGreaterThanZero(rm, "root", null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, "x");
        AppAttemptRemovedSchedulerEvent appRemovedEvent = new AppAttemptRemovedSchedulerEvent(am2.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        rm.getResourceScheduler().handle((Event)appRemovedEvent);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, "x");
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAMUsedResource() throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove();
        rm.registerNode("127.0.0.1:1234", 4096);
        Configuration conf = rm.getConfig();
        int minAllocMb = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int amMemory = 50;
        Assert.assertTrue((String)"AM memory is greater than or equal to minAllocation", (amMemory < minAllocMb ? 1 : 0) != 0);
        Resource minAllocResource = Resource.newInstance((int)minAllocMb, (int)1);
        String queueName = "a1";
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(amMemory, rm).withAppName("app-1").withUser("user_0").withAcls(null).withQueue(queueName).withUnmanagedAM(false).build();
        RMApp rmApp = MockRMAppSubmitter.submit(rm, data);
        Assert.assertEquals((String)"RMApp does not containes minimum allocation", (Object)minAllocResource, (Object)((ResourceRequest)rmApp.getAMResourceRequests().get(0)).getCapability());
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue(queueName);
        Assert.assertEquals((String)"Minimum Resource for AM is incorrect", (Object)minAllocResource, (Object)queueA.getUser("user_0").getResourceUsage().getAMUsed());
        rm.stop();
    }

    @Test
    public void testApplicationHeadRoom() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        RMAppAttemptMetrics attemptMetric = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)attempt.getMasterContainer()).thenReturn((Object)container);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)attempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        rm.getRMContext().getRMApps().put(appId, app);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "default", "user");
        cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        Allocation allocate = cs.allocate(appAttemptId, Collections.emptyList(), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        Assert.assertNotNull((Object)attempt);
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)allocate.getResourceLimit());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)attemptMetric.getApplicationAttemptHeadroom());
        Resource newResource = Resource.newInstance((int)4096, (int)1);
        RMNode node = MockNodes.newNodeInfo(0, newResource, 1, "127.0.0.1");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        allocate = cs.allocate(appAttemptId, Collections.emptyList(), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        Assert.assertEquals((Object)newResource, (Object)allocate.getResourceLimit());
        Assert.assertEquals((Object)newResource, (Object)attemptMetric.getApplicationAttemptHeadroom());
        rm.stop();
    }

    @Test
    public void testHeadRoomCalculationWithDRC() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qb = (LeafQueue)cs.getQueue("default");
        qb.setUserLimitFactor(0.8f);
        ApplicationAttemptId appAttemptId = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 1, "default", "user1");
        ApplicationAttemptId appAttemptId2 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 2, "default", "user2");
        Resource newResource = Resource.newInstance((int)10240, (int)10);
        RMNode node = MockNodes.newNodeInfo(0, newResource, 1, "127.0.0.1");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        Resource newResource2 = Resource.newInstance((int)10240, (int)10);
        RMNode node2 = MockNodes.newNodeInfo(0, newResource2, 1, "127.0.0.2");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node2));
        FiCaSchedulerApp fiCaApp1 = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appAttemptId.getApplicationId())).getCurrentAppAttempt();
        FiCaSchedulerApp fiCaApp2 = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appAttemptId2.getApplicationId())).getCurrentAppAttempt();
        Priority u0Priority = TestUtils.createMockPriority(1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        fiCaApp1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 10240, 1, true, u0Priority, recordFactory)));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)6144L, (long)fiCaApp1.getHeadroom().getMemorySize());
        Assert.assertEquals((long)15L, (long)fiCaApp1.getHeadroom().getVirtualCores());
        fiCaApp2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 1, true, u0Priority, recordFactory)));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)9216L, (long)fiCaApp2.getHeadroom().getMemorySize());
        Assert.assertEquals((long)15L, (long)fiCaApp2.getHeadroom().getVirtualCores());
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testAMLimitUsage() throws Exception {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DefaultResourceCalculator.class.getName());
        this.verifyAMLimitForLeafQueue(config);
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.verifyAMLimitForLeafQueue(config);
    }

    private FiCaSchedulerApp getFiCaSchedulerApp(MockRM rm, ApplicationId appId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        return (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appId)).getCurrentAppAttempt();
    }

    @Test
    public void testPendingResourceUpdatedAccordingToIncreaseRequestChanges() throws Exception {
        Configuration conf = TestUtils.getConfigurationWithQueueLabels(new Configuration(false));
        conf.setBoolean("yarn.node-labels.enabled", true);
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init(conf);
        MockRM rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.start();
        MockNM nm1 = new MockNM("h1:1234", 204800, rm.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)2)), null);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId3, RMContainerState.ALLOCATED));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L));
        this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L));
        this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L));
        am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId1, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)3072), null)));
        FiCaSchedulerApp app = this.getFiCaSchedulerApp(rm, app1.getApplicationId());
        Assert.assertEquals((long)2048L, (long)app.getAppAttemptResourceUsage().getPending().getMemorySize());
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 2048, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 2048, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 2048, null);
        am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId2, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)3072), null), UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId3, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)5120), null)));
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemorySize());
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 6144, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 6144, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 6144, null);
        am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId1, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)3072), null), UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId2, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)4096), null), UpdateContainerRequest.newInstance((int)0, (ContainerId)containerId3, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)2048), null)));
        Assert.assertEquals((long)4096L, (long)app.getAppAttemptResourceUsage().getPending().getMemorySize());
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 4096, null);
        rm.stop();
    }

    private void verifyAMLimitForLeafQueue(CapacitySchedulerConfiguration config) throws Exception {
        MockRM rm = CapacitySchedulerTestUtilities.setUpMove((Configuration)config);
        final int nodeMemory = 4096;
        rm.registerNode("127.0.0.1:1234", nodeMemory);
        String queueName = "a1";
        String userName = "user_0";
        final ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue(queueName);
        Resource amResourceLimit = queueA.getAMResourceLimit();
        Resource amResource1 = Resource.newInstance((long)(amResourceLimit.getMemorySize() + 1024L), (int)(amResourceLimit.getVirtualCores() + 1));
        Resource amResource2 = Resource.newInstance((long)(amResourceLimit.getMemorySize() + 2048L), (int)(amResourceLimit.getVirtualCores() + 1));
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return scheduler.getMaximumResourceCapability().getMemorySize() == (long)nodeMemory;
            }
        }, (long)100L, (long)60000L);
        MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource1, rm).withResource(amResource1).withAppName("app-1").withUser(userName).withAcls(null).withQueue(queueName).build());
        MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource2, rm).withResource(amResource2).withAppName("app-2").withUser(userName).withAcls(null).withQueue(queueName).build());
        Assert.assertEquals((String)"PendingApplications should be 1", (long)1L, (long)queueA.getNumPendingApplications());
        Assert.assertEquals((String)"Active applications should be 1", (long)1L, (long)queueA.getNumActiveApplications());
        Assert.assertEquals((String)"User PendingApplications should be 1", (long)1L, (long)queueA.getUser(userName).getPendingApplications());
        Assert.assertEquals((String)"User Active applications should be 1", (long)1L, (long)queueA.getUser(userName).getActiveApplications());
        rm.stop();
    }

    private void sentRMContainerLaunched(MockRM rm, ContainerId containerId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMContainer rmContainer = cs.getRMContainer(containerId);
        if (rmContainer != null) {
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        } else {
            Assert.fail((String)"Cannot find RMContainer");
        }
    }

    @Test
    public void testCSReservationWithRootUnblocked() throws Exception {
        int i;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setResourceComparator(DominantResourceCalculator.class);
        CapacitySchedulerQueueHelpers.setupOtherBlockedQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ParentQueue q = (ParentQueue)cs.getQueue("p1");
        Assert.assertNotNull((Object)q);
        String host = "127.0.0.1";
        String host1 = "test";
        RMNode node = MockNodes.newNodeInfo(0, Resource.newInstance((int)8192, (int)8), 1, host);
        RMNode node1 = MockNodes.newNodeInfo(0, Resource.newInstance((int)8192, (int)8), 2, host1);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node1));
        ApplicationAttemptId appAttemptId1 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 1, "x1", "userX1");
        ApplicationAttemptId appAttemptId2 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 2, "x2", "userX2");
        ApplicationAttemptId appAttemptId3 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 3, "y1", "userY1");
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        Priority priority2 = TestUtils.createMockPriority(1);
        ResourceRequest y1Req = null;
        ResourceRequest x1Req = null;
        ResourceRequest x2Req = null;
        for (i = 0; i < 4; ++i) {
            y1Req = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
            cs.allocate(appAttemptId3, Collections.singletonList(y1Req), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
        Assert.assertEquals((String)"Y1 Used Resource should be 4 GB", (long)4096L, (long)cs.getQueue("y1").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P2 Used Resource should be 4 GB", (long)4096L, (long)cs.getQueue("p2").getUsedResources().getMemorySize());
        for (i = 0; i < 7; ++i) {
            x1Req = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
            cs.allocate(appAttemptId1, Collections.singletonList(x1Req), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
        Assert.assertEquals((String)"X1 Used Resource should be 7 GB", (long)7168L, (long)cs.getQueue("x1").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P1 Used Resource should be 7 GB", (long)7168L, (long)cs.getQueue("p1").getUsedResources().getMemorySize());
        x2Req = TestUtils.createResourceRequest("*", 2048, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId2, Collections.singletonList(x2Req), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        CapacityScheduler.schedule((CapacityScheduler)cs);
        Assert.assertEquals((String)"X2 Used Resource should be 0", (long)0L, (long)cs.getQueue("x2").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P1 Used Resource should be 7 GB", (long)7168L, (long)cs.getQueue("p1").getUsedResources().getMemorySize());
        x1Req = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId1, Collections.singletonList(x1Req), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        CapacityScheduler.schedule((CapacityScheduler)cs);
        Assert.assertEquals((String)"X1 Used Resource should be 7 GB", (long)7168L, (long)cs.getQueue("x1").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P1 Used Resource should be 7 GB", (long)7168L, (long)cs.getQueue("p1").getUsedResources().getMemorySize());
        for (i = 0; i < 4; ++i) {
            y1Req = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
            cs.allocate(appAttemptId3, Collections.singletonList(y1Req), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
        Assert.assertEquals((String)"P2 Used Resource should be 8 GB", (long)8192L, (long)cs.getQueue("p2").getUsedResources().getMemorySize());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId1, (long)2L);
        cs.handle((SchedulerEvent)new ContainerExpiredSchedulerEvent(containerId));
        CapacityScheduler.schedule((CapacityScheduler)cs);
        Assert.assertEquals((String)"X2 Used Resource should be 2 GB", (long)2048L, (long)cs.getQueue("x2").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P1 Used Resource should be 8 GB", (long)8192L, (long)cs.getQueue("p1").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"P2 Used Resource should be 8 GB", (long)8192L, (long)cs.getQueue("p2").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"Root Used Resource should be 16 GB", (long)16384L, (long)cs.getRootQueue().getUsedResources().getMemorySize());
        rm.stop();
    }

    @Test
    public void testCSQueueBlocked() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupBlockedQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue q = (LeafQueue)cs.getQueue("a");
        Assert.assertNotNull((Object)q);
        String host = "127.0.0.1";
        String host1 = "test";
        RMNode node = MockNodes.newNodeInfo(0, Resource.newInstance((int)8192, (int)8), 1, host);
        RMNode node1 = MockNodes.newNodeInfo(0, Resource.newInstance((int)8192, (int)8), 2, host1);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node1));
        ApplicationAttemptId appAttemptId1 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 1, "a", "user1");
        ApplicationAttemptId appAttemptId2 = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 2, "b", "user2");
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        Priority priority2 = TestUtils.createMockPriority(1);
        ResourceRequest r1 = TestUtils.createResourceRequest("*", 2048, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId1, Collections.singletonList(r1), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS).getContainers().size();
        CapacityScheduler.schedule((CapacityScheduler)cs);
        ResourceRequest r2 = null;
        for (int i = 0; i < 13; ++i) {
            r2 = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
            cs.allocate(appAttemptId2, Collections.singletonList(r2), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
            CapacityScheduler.schedule((CapacityScheduler)cs);
        }
        Assert.assertEquals((String)"A Used Resource should be 2 GB", (long)2048L, (long)cs.getQueue("a").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"B Used Resource should be 13 GB", (long)13312L, (long)cs.getQueue("b").getUsedResources().getMemorySize());
        r1 = TestUtils.createResourceRequest("*", 2048, 1, true, priority2, recordFactory);
        r2 = TestUtils.createResourceRequest("*", 1024, 1, true, priority2, recordFactory);
        cs.allocate(appAttemptId1, Collections.singletonList(r1), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS).getContainers().size();
        CapacityScheduler.schedule((CapacityScheduler)cs);
        cs.allocate(appAttemptId2, Collections.singletonList(r2), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        CapacityScheduler.schedule((CapacityScheduler)cs);
        Assert.assertEquals((String)"A Used Resource should be 2 GB", (long)2048L, (long)cs.getQueue("a").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"B Used Resource should be 13 GB", (long)13312L, (long)cs.getQueue("b").getUsedResources().getMemorySize());
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId2, (long)10L);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId2, (long)11L);
        cs.handle((SchedulerEvent)new ContainerExpiredSchedulerEvent(containerId1));
        rm.drainEvents();
        CapacityScheduler.schedule((CapacityScheduler)cs);
        cs.handle((SchedulerEvent)new ContainerExpiredSchedulerEvent(containerId2));
        CapacityScheduler.schedule((CapacityScheduler)cs);
        rm.drainEvents();
        Assert.assertEquals((String)"A Used Resource should be 4 GB", (long)4096L, (long)cs.getQueue("a").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"B Used Resource should be 12 GB", (long)12288L, (long)cs.getQueue("b").getUsedResources().getMemorySize());
        Assert.assertEquals((String)"Used Resource on Root should be 16 GB", (long)16384L, (long)cs.getRootQueue().getUsedResources().getMemorySize());
        rm.stop();
    }

    @Test
    public void testAppAttemptLocalityStatistics() throws Exception {
        Configuration conf = TestUtils.getConfigurationWithMultipleQueues(new Configuration(false));
        conf.setBoolean("yarn.node-labels.enabled", true);
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init(conf);
        MockRM rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.start();
        MockNM nm1 = new MockNM("h1:1234", 204800, rm.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)2), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)2), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"h1", (Resource)Resources.createResource((int)1024), (int)1)), null);
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        cs.nodeUpdate((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId()));
        cs.nodeUpdate((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId()));
        RMAppAttemptMetrics attemptMetrics = ((RMApp)rm.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt().getRMAppAttemptMetrics();
        Assert.assertArrayEquals((Object[])new int[][]{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, (Object[])attemptMetrics.getLocalityStatistics());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testAMLimitDouble() throws Exception {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration((Configuration)config);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 10240);
        rm.registerNode("127.0.0.1:1235", 10240);
        rm.registerNode("127.0.0.1:1236", 10240);
        rm.registerNode("127.0.0.1:1237", 10240);
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        CapacitySchedulerTestUtilities.waitforNMRegistered(scheduler, 4, 5);
        LeafQueue queueA = (LeafQueue)((CapacityScheduler)scheduler).getQueue("default");
        Resource amResourceLimit = queueA.getAMResourceLimit();
        Assert.assertEquals((long)4096L, (long)amResourceLimit.getMemorySize());
        Assert.assertEquals((long)4L, (long)amResourceLimit.getVirtualCores());
        rm.stop();
    }

    @Test
    public void testQueueMappingWithCurrentUserQueueMappingForaGroup() throws Exception {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(config);
        config.setClass("hadoop.security.group.mapping", TestGroupsCaching.FakeunPrivilegedGroupMapping.class, ShellBasedUnixGroupsMapping.class);
        config.set("hadoop.user.group.static.mapping.overrides", "a1=agroup");
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)config);
        config.set("yarn.scheduler.capacity.queue-mappings", "g:agroup:%user");
        MockRM rm = new MockRM((Configuration)config);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.start();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("appname").withUser("a1").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        List appsInA1 = cs.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testcheckAndGetApplicationLifetime() throws Exception {
        long maxLifetime = 10L;
        long defaultLifetime = 5L;
        CapacityScheduler cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)maxLifetime, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)9L, (long)cs.checkAndGetApplicationLifetime("default", 9L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
        Assert.assertEquals((long)maxLifetime, (long)cs.getMaximumApplicationLifetime("default"));
        maxLifetime = -1L;
        defaultLifetime = -1L;
        cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)100L, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
        Assert.assertEquals((long)maxLifetime, (long)cs.getMaximumApplicationLifetime("default"));
        maxLifetime = 10L;
        defaultLifetime = 10L;
        cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)maxLifetime, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
        Assert.assertEquals((long)maxLifetime, (long)cs.getMaximumApplicationLifetime("default"));
        maxLifetime = 0L;
        defaultLifetime = 0L;
        cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)100L, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
        maxLifetime = 10L;
        defaultLifetime = -1L;
        cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)maxLifetime, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)maxLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)maxLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
        maxLifetime = 5L;
        defaultLifetime = 10L;
        try {
            this.setUpCSQueue(maxLifetime, defaultLifetime);
            Assert.fail((String)"Expected to fails since maxLifetime < defaultLifetime.");
        }
        catch (ServiceStateException sse) {
            Throwable rootCause = sse.getCause().getCause();
            Assert.assertTrue((boolean)rootCause.getMessage().contains("can't exceed maximum lifetime"));
        }
        maxLifetime = -1L;
        defaultLifetime = 10L;
        cs = this.setUpCSQueue(maxLifetime, defaultLifetime);
        Assert.assertEquals((long)100L, (long)cs.checkAndGetApplicationLifetime("default", 100L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", -1L));
        Assert.assertEquals((long)defaultLifetime, (long)cs.checkAndGetApplicationLifetime("default", 0L));
    }

    private CapacityScheduler setUpCSQueue(long maxLifetime, long defaultLifetime) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"default"});
        csConf.setCapacity("root.default", 100.0f);
        csConf.setMaximumLifetimePerQueue("root.default", maxLifetime);
        csConf.setDefaultLifetimePerQueue("root.default", defaultLifetime);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        cs.setConf((Configuration)conf);
        cs.setRMContext(rmContext);
        cs.init((Configuration)conf);
        return cs;
    }

    @Test(timeout=60000L)
    public void testClearRequestsBeforeApplyTheProposal() throws Exception {
        MockRM rm = new MockRM((Configuration)new CapacitySchedulerConfiguration());
        rm.start();
        MockNM nm = rm.registerNode("h1:1234", 204800);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm).withAppName("app").withUser("user").build();
        final RMApp app = MockRMAppSubmitter.submit(rm, data);
        MockRM.launchAndRegisterAM(app, rm, nm);
        final Priority priority2 = Priority.newInstance((int)1);
        final CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        final CapacityScheduler spyCs = (CapacityScheduler)Mockito.spy((Object)cs);
        ((CapacityScheduler)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Exception {
                spyCs.allocate(app.getCurrentAppAttempt().getAppAttemptId(), Arrays.asList(ResourceRequest.newInstance((Priority)priority2, (String)"*", (Resource)Resources.createResource((int)1024), (int)0)), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
                try {
                    FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(app.getCurrentAppAttempt().getAppAttemptId());
                    schedulerApp.apply((Resource)invocation.getArguments()[0], (ResourceCommitRequest)invocation.getArguments()[1], ((Boolean)invocation.getArguments()[2]).booleanValue());
                    Assert.assertEquals((long)1L, (long)schedulerApp.getLiveContainers().size());
                }
                catch (Throwable e) {
                    Assert.fail();
                }
                return null;
            }
        }).when((Object)spyCs)).tryCommit((Resource)Mockito.any(Resource.class), (ResourceCommitRequest)Mockito.any(ResourceCommitRequest.class), Mockito.anyBoolean());
        spyCs.allocate(app.getCurrentAppAttempt().getAppAttemptId(), Arrays.asList(ResourceRequest.newInstance((Priority)priority2, (String)"*", (Resource)Resources.createResource((int)1024), (int)1)), null, Collections.emptyList(), null, null, NULL_UPDATE_REQUESTS);
        spyCs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(spyCs.getNode(nm.getNodeId()).getRMNode()));
        rm.stop();
    }

    @Test
    public void testContainerAllocationLocalitySkipped() throws Exception {
        Assert.assertEquals((Object)AllocationState.APP_SKIPPED, (Object)ContainerAllocation.APP_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.LOCALITY_SKIPPED, (Object)ContainerAllocation.LOCALITY_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.PRIORITY_SKIPPED, (Object)ContainerAllocation.PRIORITY_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.QUEUE_SKIPPED, (Object)ContainerAllocation.QUEUE_SKIPPED.getAllocationState());
        MockRM rm = new MockRM((Configuration)new CapacitySchedulerConfiguration());
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 4096);
        MockNM nm2 = rm.registerNode("h2:1234", 6144);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").build();
        RMApp app = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchAndRegisterAM(app, rm, nm1);
        am.addRequests(new String[]{"*"}, 5120, 1, 1, 2L);
        am.schedule();
        RMNode node1 = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        ContainerId cid = ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)1L);
        Assertions.assertThat((Comparable)cs.getRMContainer(cid).getState()).isEqualTo((Object)RMContainerState.ACQUIRED);
        cid = ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)2L);
        Assert.assertNull((Object)cs.getRMContainer(cid));
        Assert.assertEquals((Object)AllocationState.APP_SKIPPED, (Object)ContainerAllocation.APP_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.LOCALITY_SKIPPED, (Object)ContainerAllocation.LOCALITY_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.PRIORITY_SKIPPED, (Object)ContainerAllocation.PRIORITY_SKIPPED.getAllocationState());
        Assert.assertEquals((Object)AllocationState.QUEUE_SKIPPED, (Object)ContainerAllocation.QUEUE_SKIPPED.getAllocationState());
        rm.stop();
    }

    @Test
    public void testCSQueueMetricsDoesNotLeakOnReinit() throws Exception {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setResourceComparator(DominantResourceCalculator.class);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupAdditionalQueues(csConf);
        cs.reinitialize((Configuration)csConf, cs.getRMContext());
        QueueMetrics a3DefaultPartitionMetrics = (QueueMetrics)QueueMetrics.getQueueMetrics().get("default.root.a.a3");
        Assert.assertSame((String)"Different ParentQueue of siblings is a sign of a memory leak", (Object)((QueueMetrics)QueueMetrics.getQueueMetrics().get("root.a.a1")).getParentQueue(), (Object)((QueueMetrics)QueueMetrics.getQueueMetrics().get("root.a.a3")).getParentQueue());
        Assert.assertSame((String)"Different ParentQueue of partition metrics is a sign of a memory leak", (Object)((QueueMetrics)QueueMetrics.getQueueMetrics().get("root.a.a1")).getParentQueue(), (Object)a3DefaultPartitionMetrics.getParentQueue());
        rm.stop();
    }

    @Test
    public void testCSQueueMetrics() throws Exception {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        riMap.put("custom_res_1", ResourceInformation.newInstance((String)"custom_res_1", (String)"", (long)1L, (long)10L));
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setResourceComparator(DominantResourceCalculator.class);
        csConf.set("yarn.resource-types", "custom_res_1");
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(51200L, 50, (Map<String, String>)ImmutableMap.builder().put((Object)"custom_res_1", (Object)String.valueOf(1000)).build()), 1, "n1");
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(51200L, 50, (Map<String, String>)ImmutableMap.builder().put((Object)"custom_res_1", (Object)String.valueOf(2000)).build()), 2, "n2");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Map guaranteedCapA11 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a1").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)94L, (long)((Long)guaranteedCapA11.get("custom_res_1")));
        Map maxCapA11 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a1").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)3000L, (long)((Long)maxCapA11.get("custom_res_1")));
        Assert.assertEquals((long)10240L, (long)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)71680L, (long)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)102400L, (long)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getMaxCapacityMB());
        Assert.assertEquals((long)102400L, (long)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getMaxCapacityMB());
        Map guaranteedCapA = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)314L, (long)((Long)guaranteedCapA.get("custom_res_1")));
        Map maxCapA = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)3000L, (long)((Long)maxCapA.get("custom_res_1")));
        Map guaranteedCapB1 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)2126L, (long)((Long)guaranteedCapB1.get("custom_res_1")));
        Map maxCapB1 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)3000L, (long)((Long)maxCapB1.get("custom_res_1")));
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n2));
        Assert.assertEquals((long)5120L, (long)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)35840L, (long)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)51200L, (long)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getMaxCapacityMB());
        Assert.assertEquals((long)51200L, (long)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getMaxCapacityMB());
        Map guaranteedCapA1 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)104L, (long)((Long)guaranteedCapA1.get("custom_res_1")));
        Map maxCapA1 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)1000L, (long)((Long)maxCapA1.get("custom_res_1")));
        Map guaranteedCapB11 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)708L, (long)((Long)guaranteedCapB11.get("custom_res_1")));
        Map maxCapB11 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)1000L, (long)((Long)maxCapB11.get("custom_res_1")));
        Assert.assertEquals((double)0.105f, (double)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getGuaranteedCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)0.105f, (double)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getGuaranteedAbsoluteCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)0.792f, (double)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getGuaranteedCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)0.7088399529457092, (double)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getGuaranteedAbsoluteCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getMaxCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)((CSQueueMetrics)cs.getQueue("a").getMetrics()).getMaxAbsoluteCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getMaxCapacity(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)((CSQueueMetrics)cs.getQueue("b1").getMetrics()).getMaxAbsoluteCapacity(), (double)1.0E-4);
        csConf.setQueues("root.a", new String[]{"a1", "a2", "a3"});
        csConf.setCapacity("root.a.a2", 29.5f);
        csConf.setCapacity("root.a.a3", 40.5f);
        csConf.setMaximumCapacity("root.a.a3", 50.0f);
        cs.reinitialize((Configuration)csConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null));
        Assert.assertEquals((long)1024L, (long)((CSQueueMetrics)cs.getQueue("a2").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)2048L, (long)((CSQueueMetrics)cs.getQueue("a3").getMetrics()).getGuaranteedMB());
        Assert.assertEquals((long)51200L, (long)((CSQueueMetrics)cs.getQueue("a2").getMetrics()).getMaxCapacityMB());
        Assert.assertEquals((long)25600L, (long)((CSQueueMetrics)cs.getQueue("a3").getMetrics()).getMaxCapacityMB());
        Map guaranteedCapA2 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a2").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)30L, (long)((Long)guaranteedCapA2.get("custom_res_1")));
        Map maxCapA2 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a2").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)1000L, (long)((Long)maxCapA2.get("custom_res_1")));
        Map guaranteedCapA3 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a3").getMetrics()).getQueueMetricsForCustomResources()).getGuaranteedCapacity();
        Assert.assertEquals((long)42L, (long)((Long)guaranteedCapA3.get("custom_res_1")));
        Map maxCapA3 = ((CSQueueMetricsForCustomResources)((CSQueueMetrics)cs.getQueue("a3").getMetrics()).getQueueMetricsForCustomResources()).getMaxCapacity();
        Assert.assertEquals((long)500L, (long)((Long)maxCapA3.get("custom_res_1")));
        rm.stop();
    }

    @Test
    public void testReservedContainerLeakWhenMoveApplication() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacity("root.a", 50.0f);
        csConf.setMaximumCapacity("root.a", 100.0f);
        csConf.setUserLimitFactor("root.a", 100.0f);
        csConf.setCapacity("root.b", 50.0f);
        csConf.setMaximumCapacity("root.b", 100.0f);
        csConf.setUserLimitFactor("root.b", 100.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)csConf);
        CapacityScheduler scheduler = (CapacityScheduler)rm1.getResourceScheduler();
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8192);
        MockNM nm2 = rm1.registerNode("127.0.0.2:1234", 8192);
        MockRMAppSubmissionData submissionData = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app_1").withUser("user_1").withAcls(null).withQueue("a").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, submissionData);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        submissionData = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app_2").withUser("user_1").withAcls(null).withQueue("a").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, submissionData);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = scheduler.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = scheduler.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getReservedContainers().size());
        LeafQueue srcQueue = (LeafQueue)scheduler.getQueue("a");
        LeafQueue desQueue = (LeafQueue)scheduler.getQueue("b");
        Assert.assertEquals((long)4L, (long)srcQueue.getNumContainers());
        Assert.assertEquals((long)10240L, (long)srcQueue.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)desQueue.getNumContainers());
        Assert.assertEquals((long)0L, (long)desQueue.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)schedulerApp1.getAppAttemptResourceUsage().getAllUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)1024L, (long)schedulerApp2.getAppAttemptResourceUsage().getAllUsed().getMemorySize());
        Assert.assertEquals((long)4096L, (long)schedulerApp2.getCurrentReservation().getMemorySize());
        scheduler.moveApplication(app2.getApplicationId(), "b");
        rm1.killApp(app2.getApplicationId());
        rm1.killApp(app1.getApplicationId());
        Assert.assertEquals((long)0L, (long)srcQueue.getNumContainers());
        Assert.assertEquals((long)0L, (long)desQueue.getNumContainers());
        Assert.assertEquals((long)0L, (long)srcQueue.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)desQueue.getUsedResources().getMemorySize());
        rm1.close();
    }

    @Test(timeout=20000L)
    public void testRefreshQueueWithOpenPreemption() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a"});
        csConf.setCapacity("root.a", 100.0f);
        csConf.setQueues("root.a", new String[]{"b"});
        csConf.setCapacity("root.a.b", 100.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        try (MockRM rm = new MockRM((Configuration)csConf);){
            CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
            PreemptionManager preemptionManager = scheduler.getPreemptionManager();
            rm.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
            rm.start();
            AbstractParentQueue queue = (AbstractParentQueue)scheduler.getQueue("a");
            Thread schedulerThread = new Thread(() -> {
                queue.readLock.lock();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                preemptionManager.getKillableContainers("a", queue.getDefaultNodeLabelExpression());
                queue.readLock.unlock();
            }, "SCHEDULE");
            Thread completeThread = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                queue.writeLock.lock();
                queue.writeLock.unlock();
            }, "COMPLETE");
            Thread refreshThread = new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                preemptionManager.refreshQueues(queue.getParent(), (CSQueue)queue);
            }, "REFRESH");
            schedulerThread.start();
            completeThread.start();
            refreshThread.start();
            schedulerThread.join();
            completeThread.join();
            refreshThread.join();
        }
    }
}

