/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Test;

public class TestCapacitySchedulerSchedulingRequestUpdate {
    @Test
    public void testBasicPendingResourceUpdate() throws Exception {
        Configuration conf = TestUtils.getConfigurationWithQueueLabels(new Configuration(false));
        conf.setBoolean("yarn.node-labels.enabled", true);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init(conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), CapacitySchedulerTestUtilities.toSet("x")));
        MockRM rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.start();
        MockNM nm1 = new MockNM("h1:1234", 204800, rm.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("h2:1234", 204800, rm.getResourceTrackerService());
        nm2.registerNode();
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)8, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 0L, (Set<String>)ImmutableSet.of((Object)"mapper", (Object)"reducer"), "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 8192, null);
        am2.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)8)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 16384, null);
        am2.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"*", (Resource)Resources.createResource((int)1024), (int)8)), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 24576, null);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)4, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 0L, (Set<String>)ImmutableSet.of((Object)"mapper", (Object)"reducer"), "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 20480, null);
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)2), (String)"*", (Resource)Resources.createResource((int)8192), (int)1, (boolean)true, (String)"x")), null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 4096, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 16384, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 20480, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 8192, "x");
        AppAttemptRemovedSchedulerEvent appRemovedEvent = new AppAttemptRemovedSchedulerEvent(am2.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        rm.getResourceScheduler().handle((Event)appRemovedEvent);
        appRemovedEvent = new AppAttemptRemovedSchedulerEvent(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        rm.getResourceScheduler().handle((Event)appRemovedEvent);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, "x");
        rm.stop();
    }

    @Test
    public void testNodePartitionPendingResourceUpdate() throws Exception {
        Configuration conf = TestUtils.getConfigurationWithQueueLabels(new Configuration(false));
        conf.setBoolean("yarn.node-labels.enabled", true);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init(conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), CapacitySchedulerTestUtilities.toSet("x")));
        MockRM rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm.start();
        MockNM nm1 = new MockNM("h1:1234", 204800, rm.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("h2:1234", 204800, rm.getResourceTrackerService());
        nm2.registerNode();
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am1.allocateIntraAppAntiAffinity("x", ResourceSizing.newInstance((int)8, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 0L, "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 8192, "x");
        am2.allocateIntraAppAntiAffinity("x", ResourceSizing.newInstance((int)8, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 0L, "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 16384, "x");
        am1.allocateIntraAppAntiAffinity("x", ResourceSizing.newInstance((int)6, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)2), 0L, "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 14336, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 14336, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 22528, "x");
        am1.allocateIntraAppAntiAffinity("x", ResourceSizing.newInstance((int)4, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 0L, "mapper", "reducer");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 10240, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 10240, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 8192, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 18432, "x");
        AppAttemptRemovedSchedulerEvent appRemovedEvent = new AppAttemptRemovedSchedulerEvent(am2.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        rm.getResourceScheduler().handle((Event)appRemovedEvent);
        appRemovedEvent = new AppAttemptRemovedSchedulerEvent(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        rm.getResourceScheduler().handle((Event)appRemovedEvent);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a1", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "a", 0, "x");
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b1", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "b", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, null);
        CapacitySchedulerTestUtilities.checkPendingResource(rm, "root", 0, "x");
        rm.stop();
    }
}

