/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueConfigurationAutoRefreshPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueueConfigurationAutoRefreshPolicy {
    private Configuration configuration;
    private MockRM rm = null;
    private FileSystem fs;
    private Path workingPath;
    private Path workingPathRecover;
    private Path fileSystemWorkingPath;
    private Path tmpDir;
    private QueueConfigurationAutoRefreshPolicy policy;

    @Before
    public void setup() throws IOException {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.configuration = new YarnConfiguration();
        this.configuration.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        this.fs = FileSystem.get((Configuration)this.configuration);
        this.workingPath = new Path(QueueConfigurationAutoRefreshPolicy.class.getClassLoader().getResource(".").toString());
        this.workingPathRecover = new Path(QueueConfigurationAutoRefreshPolicy.class.getClassLoader().getResource(".").toString() + "/Recover");
        this.fileSystemWorkingPath = new Path(new File("target", this.getClass().getSimpleName() + "-remoteDir").getAbsolutePath());
        this.tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        this.fs.delete(this.fileSystemWorkingPath, true);
        this.fs.mkdirs(this.fileSystemWorkingPath);
        this.fs.delete(this.tmpDir, true);
        this.fs.mkdirs(this.tmpDir);
        this.policy = new QueueConfigurationAutoRefreshPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeConfigurationXML(Configuration conf, String confXMLName) throws IOException {
        try (FilterOutputStream output = null;){
            File confFile = new File(this.tmpDir.toString(), confXMLName);
            if (confFile.exists()) {
                confFile.delete();
            }
            if (!confFile.createNewFile()) {
                Assert.fail((String)("Can not create " + confXMLName));
            }
            output = new DataOutputStream(new FileOutputStream(confFile));
            conf.writeXml((OutputStream)output);
            String string = confFile.getAbsolutePath();
            return string;
        }
    }

    private void uploadConfiguration(Boolean isFileSystemBased, Configuration conf, String confFileName) throws IOException {
        String csConfFile = this.writeConfigurationXML(conf, confFileName);
        if (isFileSystemBased.booleanValue()) {
            this.uploadToRemoteFileSystem(new Path(csConfFile), this.fileSystemWorkingPath);
        } else {
            this.uploadToRemoteFileSystem(new Path(csConfFile), this.workingPath);
        }
    }

    private void uploadToRemoteFileSystem(Path filePath, Path remotePath) throws IOException {
        this.fs.copyFromLocalFile(filePath, remotePath);
    }

    private void uploadDefaultConfiguration(Boolean isFileSystemBased) throws IOException {
        Configuration conf = new Configuration();
        this.uploadConfiguration(isFileSystemBased, conf, "core-site.xml");
        YarnConfiguration yarnConf = new YarnConfiguration();
        this.uploadConfiguration(isFileSystemBased, (Configuration)yarnConf, "yarn-site.xml");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.uploadConfiguration(isFileSystemBased, (Configuration)csConf, "capacity-scheduler.xml");
        Configuration hadoopPolicyConf = new Configuration(false);
        hadoopPolicyConf.addResource("hadoop-policy.xml");
        this.uploadConfiguration(isFileSystemBased, hadoopPolicyConf, "hadoop-policy.xml");
    }

    @Test
    public void testFileSystemBasedEditSchedule() throws Exception {
        this.testCommon(true);
    }

    @Test
    public void testLocalFileBasedEditSchedule() throws Exception {
        this.fs.mkdirs(this.workingPath);
        this.fs.copyFromLocalFile(new Path(this.workingPath.toString() + "/" + "core-site.xml"), new Path(this.workingPathRecover.toString() + "/" + "core-site.xml"));
        this.fs.copyFromLocalFile(new Path(this.workingPath.toString() + "/" + "yarn-site.xml"), new Path(this.workingPathRecover.toString() + "/" + "yarn-site.xml"));
        this.fs.copyFromLocalFile(new Path(this.workingPath.toString() + "/" + "capacity-scheduler.xml"), new Path(this.workingPathRecover.toString() + "/" + "capacity-scheduler.xml"));
        this.testCommon(false);
        this.fs.copyFromLocalFile(new Path(this.workingPathRecover.toString() + "/" + "core-site.xml"), new Path(this.workingPath.toString() + "/" + "core-site.xml"));
        this.fs.copyFromLocalFile(new Path(this.workingPathRecover.toString() + "/" + "yarn-site.xml"), new Path(this.workingPath.toString() + "/" + "yarn-site.xml"));
        this.fs.copyFromLocalFile(new Path(this.workingPathRecover.toString() + "/" + "capacity-scheduler.xml"), new Path(this.workingPath.toString() + "/" + "capacity-scheduler.xml"));
        this.fs.delete(this.workingPathRecover, true);
    }

    public void testCommon(Boolean isFileSystemBased) throws Exception {
        this.configuration.setLong("yarn.scheduler.capacity.queue.auto.refresh.monitoring-interval", 1000L);
        if (isFileSystemBased.booleanValue()) {
            this.configuration.set("yarn.resourcemanager.configuration.file-system-based-store", this.fileSystemWorkingPath.toString());
        }
        this.uploadDefaultConfiguration(isFileSystemBased);
        if (isFileSystemBased.booleanValue()) {
            this.configuration.set("yarn.resourcemanager.configuration.provider-class", FileSystemBasedConfigurationProvider.class.getCanonicalName());
        } else {
            this.configuration.set("yarn.resourcemanager.configuration.provider-class", LocalConfigurationProvider.class.getCanonicalName());
        }
        this.uploadConfiguration(isFileSystemBased, this.configuration, "yarn-site.xml");
        this.uploadConfiguration(isFileSystemBased, this.configuration, "capacity-scheduler.xml");
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.policy.init(this.configuration, this.rm.getRMContext(), this.rm.getResourceScheduler());
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        int maxAppsBefore = cs.getConfiguration().getMaximumSystemApplications();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setInt("yarn.scheduler.capacity.maximum-applications", 5000);
        this.uploadConfiguration(isFileSystemBased, (Configuration)csConf, "capacity-scheduler.xml");
        this.policy.editSchedule();
        Assert.assertFalse((boolean)this.policy.getLastReloadAttemptFailed());
        long oldModified = this.policy.getLastModified();
        long oldSuccess = this.policy.getLastReloadAttempt();
        Assert.assertTrue((oldSuccess > oldModified ? 1 : 0) != 0);
        int maxAppsAfter = cs.getConfiguration().getMaximumSystemApplications();
        Assert.assertEquals((long)maxAppsAfter, (long)5000L);
        Assert.assertTrue((maxAppsAfter != maxAppsBefore ? 1 : 0) != 0);
        GenericTestUtils.waitFor(() -> (this.policy.getClock().getTime() - this.policy.getLastReloadAttempt()) / 1000L > 1L, (long)500L, (long)3000L);
        csConf.setInt("yarn.scheduler.capacity.maximum-applications", 3000);
        this.uploadConfiguration(isFileSystemBased, (Configuration)csConf, "capacity-scheduler.xml");
        this.policy.editSchedule();
        GenericTestUtils.waitFor(() -> this.policy.getLastReloadAttempt() > this.policy.getLastModified(), (long)500L, (long)3000L);
        Assert.assertFalse((boolean)this.policy.getLastReloadAttemptFailed());
        oldModified = this.policy.getLastModified();
        oldSuccess = this.policy.getLastReloadAttempt();
        Assert.assertTrue((oldSuccess > oldModified ? 1 : 0) != 0);
        Assert.assertEquals((long)cs.getConfiguration().getMaximumSystemApplications(), (long)3000L);
        GenericTestUtils.waitFor(() -> (this.policy.getClock().getTime() - this.policy.getLastReloadAttempt()) / 1000L > 1L, (long)500L, (long)3000L);
        this.policy.editSchedule();
        Assert.assertEquals((long)oldModified, (long)this.policy.getLastModified());
        Assert.assertEquals((long)oldSuccess, (long)this.policy.getLastReloadAttempt());
    }

    @After
    public void tearDown() throws IOException {
        if (this.rm != null) {
            this.rm.stop();
        }
        this.fs.delete(this.fileSystemWorkingPath, true);
        this.fs.delete(this.tmpDir, true);
    }

    static {
        YarnConfiguration.addDefaultResource((String)"capacity-scheduler.xml");
        YarnConfiguration.addDefaultResource((String)"dynamic-resources.xml");
    }
}

