/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.QueueACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;

public class TestFairSchedulerQueueACLs
extends QueueACLsTestBase {
    @Override
    protected Configuration createConfiguration() {
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        String testDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        String allocFile = new File(testDir, "test-queues.xml").getAbsolutePath();
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").aclSubmitApps(" ").aclAdministerApps("root_admin ").subQueue(new AllocationFileQueue.Builder("queueA").aclSubmitApps("queueA_user,common_user ").aclAdministerApps("queueA_admin ").build()).subQueue(new AllocationFileQueue.Builder("queueB").aclSubmitApps("queueB_user,common_user ").aclAdministerApps("queueB_admin ").build()).build()).writeToFile(allocFile);
        fsConf.set("yarn.scheduler.fair.allocation.file", allocFile);
        fsConf.setBoolean("yarn.acl.enable", true);
        fsConf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        return fsConf;
    }

    @Override
    public String getQueueD() {
        return "root.D";
    }

    @Override
    public String getQueueD1() {
        return "root.D.D1";
    }

    @Override
    public void updateConfigWithDAndD1Queues(String rootAcl, String queueDAcl, String queueD1Acl) throws IOException {
        FairSchedulerConfiguration fsConf = (FairSchedulerConfiguration)this.getConf();
        fsConf.clear();
        String testDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        String allocFile = new File(testDir, "test-queues.xml").getAbsolutePath();
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").aclSubmitApps(rootAcl).aclAdministerApps(rootAcl).subQueue(new AllocationFileQueue.Builder("D").aclAdministerApps(queueDAcl).aclSubmitApps(queueDAcl).subQueue(new AllocationFileQueue.Builder("D1").aclSubmitApps(queueD1Acl).aclAdministerApps(queueD1Acl).build()).build()).build()).writeToFile(allocFile);
        fsConf.set("yarn.scheduler.fair.allocation.file", allocFile);
        fsConf.setBoolean("yarn.acl.enable", true);
        fsConf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        this.resourceManager.getResourceScheduler().reinitialize((Configuration)fsConf, this.resourceManager.getRMContext());
    }
}

