/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.AbstractComparatorOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.MockSchedulableEntity;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestFairOrderingPolicy {
    static final int GB = 1024;

    @Test
    public void testSimpleComparison() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setUsed(Resources.createResource((int)1, (int)0));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSizeBasedWeight() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        policy.setSizeBasedWeight(true);
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setUsed(Resources.createResource((int)4096));
        r2.setUsed(Resources.createResource((int)4096));
        r1.setPending(Resources.createResource((int)4096));
        r2.setPending(Resources.createResource((int)4096));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r2.setUsed(Resources.createResource((int)5120));
        r2.setPending(Resources.createResource((int)5120));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
        r2.setPending(Resources.createResource((int)102400));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIterators() {
        FairOrderingPolicy schedOrder = new FairOrderingPolicy();
        MockSchedulableEntity msp1 = new MockSchedulableEntity();
        MockSchedulableEntity msp2 = new MockSchedulableEntity();
        MockSchedulableEntity msp3 = new MockSchedulableEntity();
        msp1.setId("1");
        msp2.setId("2");
        msp3.setId("3");
        msp1.setUsed(Resources.createResource((int)3));
        msp2.setUsed(Resources.createResource((int)2));
        msp3.setUsed(Resources.createResource((int)1));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp2.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)msp2.getSchedulingResourceUsage());
        schedOrder.addSchedulableEntity((SchedulableEntity)msp1);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp2);
        schedOrder.addSchedulableEntity((SchedulableEntity)msp3);
        this.checkIds(schedOrder.getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR), new String[]{"3", "2", "1"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"1", "2", "3"});
        msp2.setUsed(Resources.createResource((int)6));
        this.checkIds(schedOrder.getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR), new String[]{"3", "2", "1"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"1", "2", "3"});
        schedOrder.containerAllocated((SchedulableEntity)msp2, null);
        this.checkIds(schedOrder.getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR), new String[]{"3", "1", "2"});
        this.checkIds(schedOrder.getPreemptionIterator(), new String[]{"2", "1", "3"});
    }

    @Test
    public void testSizeBasedWeightNotAffectAppActivation() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        String queuePath = "root.default";
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        csConf.setOrderingPolicy(queuePath, "fair");
        csConf.setOrderingPolicyParameter(queuePath, "fair.enable-size-based-weight", "true");
        csConf.setMaximumApplicationMasterResourcePerQueuePercent(queuePath, 0.1f);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue lq = (LeafQueue)cs.getQueue("default");
        OrderingPolicy policy = lq.getOrderingPolicy();
        Assert.assertTrue((boolean)(policy instanceof FairOrderingPolicy));
        Assert.assertTrue((boolean)((FairOrderingPolicy)policy).getSizeBasedWeight());
        rm.registerNode("h1:1234", 10240);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm, data3);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm, data2);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm, data1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        MockRMAppSubmitter.submit(rm, data);
        Assert.assertEquals((long)1L, (long)lq.getNumActiveApplications());
        Assert.assertEquals((long)3L, (long)lq.getNumPendingApplications());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(NodeId.newInstance((String)"h1", (int)1234))));
        Assert.assertEquals((long)1L, (long)lq.getNumActiveApplications());
        Assert.assertEquals((long)3L, (long)lq.getNumPendingApplications());
    }

    public void checkIds(Iterator<MockSchedulableEntity> si, String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            Assert.assertEquals((Object)si.next().getId(), (Object)ids[i]);
        }
    }

    @Test
    public void testOrderingUsingUsedAndPendingResources() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        policy.setSizeBasedWeight(true);
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        r1.setUsed(Resources.createResource((int)4096));
        r2.setUsed(Resources.createResource((int)4096));
        r1.setPending(Resources.createResource((int)4096));
        r2.setPending(Resources.createResource((int)4096));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setUsed(Resources.createResource((int)4096));
        r2.setUsed(Resources.createResource((int)8192));
        r1.setPending(Resources.createResource((int)4096));
        r2.setPending(Resources.createResource((int)8192));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderingUsingAppSubmitTime() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        policy.setSizeBasedWeight(true);
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        Assert.assertEquals((long)r1.getStartTime(), (long)r2.getStartTime());
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setStartTime(5L);
        r2.setStartTime(10L);
        Assert.assertTrue((policy.getComparator().compare(r1, r2) < 0 ? 1 : 0) != 0);
        r1.setStartTime(10L);
        r2.setStartTime(5L);
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderingUsingAppDemand() {
        FairOrderingPolicy policy = new FairOrderingPolicy();
        MockSchedulableEntity r1 = new MockSchedulableEntity();
        MockSchedulableEntity r2 = new MockSchedulableEntity();
        r1.setUsed(Resources.createResource((int)0));
        r2.setUsed(Resources.createResource((int)0));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
        r1.setPending(Resources.createResource((int)0));
        r2.setPending(Resources.createResource((int)8192));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertTrue((policy.getComparator().compare(r1, r2) > 0 ? 1 : 0) != 0);
        r1.setPending(Resources.createResource((int)4096));
        r2.setPending(Resources.createResource((int)12288));
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r1.getSchedulingResourceUsage());
        AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r2.getSchedulingResourceUsage());
        Assert.assertEquals((String)"Comparator Output", (long)0L, (long)policy.getComparator().compare(r1, r2));
    }

    @Test
    public void testRemoveEntitiesWithSizeBasedWeightAsCompletedJobs() {
        MockSchedulableEntity r;
        int i;
        FairOrderingPolicy policy = new FairOrderingPolicy();
        policy.setSizeBasedWeight(true);
        ArrayList<MockSchedulableEntity> entities = new ArrayList<MockSchedulableEntity>(10);
        for (i = 1; i <= 10; ++i) {
            r = new MockSchedulableEntity();
            r.setApplicationPriority(Priority.newInstance((int)i));
            r.setUsed(Resources.createResource((int)(4 * i)));
            r.setPending(Resources.createResource((int)(4 * i)));
            AbstractComparatorOrderingPolicy.updateSchedulingResourceUsage((ResourceUsage)r.getSchedulingResourceUsage());
            policy.addSchedulableEntity((SchedulableEntity)r);
            entities.add(r);
        }
        for (i = 0; i < 5; ++i) {
            r = (MockSchedulableEntity)entities.get(i);
            r.getSchedulingResourceUsage().setCachedUsed("*", Resources.createResource((int)0));
            r.getSchedulingResourceUsage().setCachedPending("*", Resources.createResource((int)0));
            policy.entityRequiresReordering((SchedulableEntity)r);
        }
        policy.reorderScheduleEntities();
        for (i = 0; i < 5; ++i) {
            policy.removeSchedulableEntity((SchedulableEntity)entities.get(i));
        }
        Assert.assertEquals((long)5L, (long)policy.getNumSchedulableEntities());
    }
}

