/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;

public final class ActivitiesTestUtils {
    public static final String TOTAL_RESOURCE_INSUFFICIENT_DIAGNOSTIC_PREFIX = "Node's total resource is insufficient for request, insufficient resources=";
    public static final String UNMATCHED_PARTITION_OR_PC_DIAGNOSTIC_PREFIX = "Node does not match partition or placement constraints, unsatisfied PC expression=";
    public static final String FN_ACT_ALLOCATIONS = "allocations";
    public static final String FN_ACT_DIAGNOSTIC = "diagnostic";
    public static final String FN_ACT_ALLOCATION_STATE = "allocationState";
    public static final String FN_ACT_FINAL_ALLOCATION_STATE = "finalAllocationState";
    public static final String FN_ACT_NODE_ID = "nodeId";
    public static final String FN_ACT_NODE_IDS = "nodeIds";
    public static final String FN_ACT_COUNT = "count";
    public static final String FN_ACT_APP_PRIORITY = "appPriority";
    public static final String FN_ACT_REQUEST_PRIORITY = "requestPriority";
    public static final String FN_ACT_ALLOCATION_REQUEST_ID = "allocationRequestId";
    public static final String FN_APP_ACT_CHILDREN = "children";
    public static final String FN_APP_ACT_ROOT = "appActivities";
    public static final String FN_SCHEDULER_ACT_NAME = "name";
    public static final String FN_SCHEDULER_ACT_ALLOCATIONS_ROOT = "root";
    public static final String FN_SCHEDULER_ACT_CHILDREN = "children";
    public static final String FN_SCHEDULER_ACT_ROOT = "activities";
    public static final String FN_SCHEDULER_BULK_ACT_ROOT = "bulkActivities";

    private ActivitiesTestUtils() {
    }

    public static List<JSONObject> findInAllocations(JSONObject allocationObj, Predicate p) throws JSONException {
        ArrayList<JSONObject> target = new ArrayList<JSONObject>();
        ActivitiesTestUtils.recursiveFindObj(allocationObj.getJSONObject(FN_SCHEDULER_ACT_ALLOCATIONS_ROOT), p, target);
        return target;
    }

    private static void recursiveFindObj(JSONObject obj, Predicate p, List<JSONObject> target) throws JSONException {
        if (p.test(obj)) {
            target.add(obj);
        }
        if (obj.has("children")) {
            JSONArray childrenObjs = obj.optJSONArray("children");
            if (childrenObjs != null) {
                for (int i = 0; i < childrenObjs.length(); ++i) {
                    ActivitiesTestUtils.recursiveFindObj(childrenObjs.getJSONObject(i), p, target);
                }
            } else {
                JSONObject childrenObj = obj.optJSONObject("children");
                ActivitiesTestUtils.recursiveFindObj(childrenObj, p, target);
            }
        }
    }

    public static SchedulingRequest schedulingRequest(int numContainers, int priority2, long allocReqId, int cores, int mem, PlacementConstraint placementConstraintExpression, String ... tags) {
        return SchedulingRequest.newBuilder().priority(Priority.newInstance((int)priority2)).allocationRequestId(allocReqId).allocationTags(new HashSet<String>(Arrays.asList(tags))).executionType(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED, (boolean)true)).resourceSizing(ResourceSizing.newInstance((int)numContainers, (Resource)Resource.newInstance((int)mem, (int)cores))).placementConstraintExpression(placementConstraintExpression).build();
    }

    public static void verifyNumberOfNodes(JSONObject allocation, int expectValue) throws Exception {
        if (allocation.isNull(FN_SCHEDULER_ACT_ALLOCATIONS_ROOT)) {
            Assert.assertEquals((String)"State of allocation is wrong", (long)expectValue, (long)0L);
        } else {
            Assert.assertEquals((String)"State of allocation is wrong", (long)expectValue, (long)(1 + ActivitiesTestUtils.getNumberOfNodes(allocation.getJSONObject(FN_SCHEDULER_ACT_ALLOCATIONS_ROOT))));
        }
    }

    public static int getNumberOfNodes(JSONObject allocation) throws Exception {
        if (!allocation.isNull("children")) {
            Object object = allocation.get("children");
            if (object.getClass() == JSONObject.class) {
                return 1 + ActivitiesTestUtils.getNumberOfNodes((JSONObject)object);
            }
            int count = 0;
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                count += 1 + ActivitiesTestUtils.getNumberOfNodes(((JSONArray)object).getJSONObject(i));
            }
            return count;
        }
        return 0;
    }

    public static void verifyStateOfAllocations(JSONObject allocation, String nameToCheck, String expectState) throws Exception {
        Assert.assertEquals((String)"State of allocation is wrong", (Object)expectState, (Object)allocation.get(nameToCheck));
    }

    public static void verifyNumberOfAllocations(JSONObject json, int expectValue) throws Exception {
        JSONObject activitiesJson;
        if (json.has(FN_APP_ACT_ROOT)) {
            activitiesJson = json.getJSONObject(FN_APP_ACT_ROOT);
        } else if (json.has(FN_SCHEDULER_ACT_ROOT)) {
            activitiesJson = json.getJSONObject(FN_SCHEDULER_ACT_ROOT);
        } else {
            throw new IllegalArgumentException("Can't parse allocations!");
        }
        if (activitiesJson.isNull(FN_ACT_ALLOCATIONS)) {
            Assert.assertEquals((String)"Number of allocations is wrong", (long)expectValue, (long)0L);
        } else {
            Object object = activitiesJson.get(FN_ACT_ALLOCATIONS);
            if (object.getClass() == JSONObject.class) {
                Assert.assertEquals((String)"Number of allocations is wrong", (long)expectValue, (long)1L);
            } else if (object.getClass() == JSONArray.class) {
                Assert.assertEquals((String)("Number of allocations is wrong in: " + object), (long)expectValue, (long)((JSONArray)object).length());
            }
        }
    }

    public static void verifyQueueOrder(JSONObject json, String expectOrder) throws Exception {
        String order = "";
        if (!json.isNull(FN_SCHEDULER_ACT_ALLOCATIONS_ROOT)) {
            JSONObject root = json.getJSONObject(FN_SCHEDULER_ACT_ALLOCATIONS_ROOT);
            order = root.getString(FN_SCHEDULER_ACT_NAME) + "-" + ActivitiesTestUtils.getQueueOrder(root);
        }
        Assert.assertEquals((String)"Order of queue is wrong", (Object)expectOrder, (Object)order.substring(0, order.length() - 1));
    }

    public static String getQueueOrder(JSONObject node) throws Exception {
        if (!node.isNull("children")) {
            Object children = node.get("children");
            if (children.getClass() == JSONObject.class) {
                if (!((JSONObject)children).isNull(FN_ACT_APP_PRIORITY)) {
                    return "";
                }
                return ((JSONObject)children).getString(FN_SCHEDULER_ACT_NAME) + "-" + ActivitiesTestUtils.getQueueOrder((JSONObject)children);
            }
            if (children.getClass() == JSONArray.class) {
                String order = "";
                for (int i = 0; i < ((JSONArray)children).length(); ++i) {
                    JSONObject child = (JSONObject)((JSONArray)children).get(i);
                    if (!child.isNull(FN_ACT_APP_PRIORITY)) {
                        return "";
                    }
                    order = order + child.getString(FN_SCHEDULER_ACT_NAME) + "-" + ActivitiesTestUtils.getQueueOrder(child);
                }
                return order;
            }
        }
        return "";
    }

    public static JSONObject getFirstSubNodeFromJson(JSONObject json, String ... hierarchicalFieldNames) {
        return ActivitiesTestUtils.getSubNodesFromJson(json, hierarchicalFieldNames).get(0);
    }

    public static List<JSONObject> getSubNodesFromJson(JSONObject json, String ... hierarchicalFieldNames) {
        List<Object> results = Lists.newArrayList((Object[])new JSONObject[]{json});
        for (String fieldName : hierarchicalFieldNames) {
            if (!(results = results.stream().filter(e -> e.has(fieldName)).flatMap(e -> ActivitiesTestUtils.getJSONObjects(e, fieldName).stream()).collect(Collectors.toList())).isEmpty()) continue;
            throw new IllegalArgumentException("Can't find hierarchical fields " + Arrays.toString(hierarchicalFieldNames));
        }
        return results;
    }

    private static List<JSONObject> getJSONObjects(JSONObject json, String fieldName) {
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        if (json.has(fieldName)) {
            try {
                Object tmpObj = json.get(fieldName);
                if (tmpObj.getClass() == JSONObject.class) {
                    objects.add((JSONObject)tmpObj);
                } else if (tmpObj.getClass() == JSONArray.class) {
                    for (int i = 0; i < ((JSONArray)tmpObj).length(); ++i) {
                        objects.add(((JSONArray)tmpObj).getJSONObject(i));
                    }
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return objects;
    }

    public static void verifyNumberOfAllocationAttempts(JSONObject allocation, int expectValue) throws Exception {
        if (allocation.isNull("children")) {
            Assert.assertEquals((String)"Number of allocation attempts is wrong", (long)expectValue, (long)0L);
        } else {
            Object object = allocation.get("children");
            if (object.getClass() == JSONObject.class) {
                Assert.assertEquals((String)"Number of allocations attempts is wrong", (long)expectValue, (long)1L);
            } else if (object.getClass() == JSONArray.class) {
                Assert.assertEquals((String)"Number of allocations attempts is wrong", (long)expectValue, (long)((JSONArray)object).length());
            }
        }
    }

    public static JSONObject requestWebResource(WebResource webResource, MultivaluedMap<String, String> params) {
        if (params != null) {
            webResource = webResource.queryParams(params);
        }
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        return (JSONObject)response.getEntity(JSONObject.class);
    }

    public static String format(String format, Object ... args) {
        Pattern p = Pattern.compile("\\{.*?}");
        Matcher m = p.matcher(format);
        String newFormat = m.replaceAll("%s");
        return String.format(newFormat, args);
    }
}

