/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedLegacyQueueCreation
extends JerseyTestBase {
    private final boolean legacyQueueMode;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    public TestRMWebServicesCapacitySchedLegacyQueueCreation(boolean legacyQueueMode) {
        super(TestWebServiceUtil.createWebAppDescriptor());
        this.legacyQueueMode = legacyQueueMode;
    }

    @Test
    public void testSchedulerResponsePercentageModeLegacyAutoCreation() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, managed");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "25");
        conf.put("yarn.scheduler.capacity.root.managed.capacity", "75");
        conf.put("yarn.scheduler.capacity.root.managed.auto-create-child-queue.enabled", "true");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            rm.registerNode("h1:1234", 32768, 32);
            TestWebServiceUtil.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-PercentageModeLegacyAutoCreation.json");
        }
    }

    @Test
    public void testSchedulerResponseAbsoluteModeLegacyAutoCreation() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.put("yarn.scheduler.capacity.root.queues", "default, managed");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=28672,vcores=28]");
        conf.put("yarn.scheduler.capacity.root.managed.capacity", "[memory=4096,vcores=4]");
        conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.capacity", "[memory=2048,vcores=2]");
        conf.put("yarn.scheduler.capacity.root.managed.auto-create-child-queue.enabled", "true");
        conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.acl_submit_applications", "user");
        conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.acl_administer_queue", "admin");
        try (MockRM rm = TestWebServiceUtil.createMutableRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            rm.registerNode("h1:1234", 32768, 32);
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            CapacitySchedulerQueueManager autoQueueHandler = cs.getCapacitySchedulerQueueManager();
            autoQueueHandler.createQueue(new QueuePath("root.managed.queue1"));
            TestWebServiceUtil.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-AbsoluteModeLegacyAutoCreation.json");
        }
    }

    private ClientResponse sendRequest() {
        return (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
    }
}

