/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCapacitySched;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class TestWebServiceUtil {
    private TestWebServiceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTest(String template, String name, MockRM rm, WebResource resource) throws Exception {
        boolean reinitAfterNodeChane = TestWebServiceUtil.isMutableConfig(rm.getConfig());
        try {
            boolean legacyQueueMode = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration().isLegacyQueueMode();
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "0", legacyQueueMode));
            MockNM nm1 = rm.registerNode("h1:1234", 8192, 8);
            rm.registerNode("h2:1234", 8192, 8);
            if (reinitAfterNodeChane) {
                TestWebServiceUtil.reinitialize(rm, rm.getConfig());
            }
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "16", legacyQueueMode));
            rm.registerNode("h3:1234", 8192, 8);
            MockNM nm4 = rm.registerNode("h4:1234", 8192, 8);
            if (reinitAfterNodeChane) {
                TestWebServiceUtil.reinitialize(rm, rm.getConfig());
            }
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "32", legacyQueueMode));
            rm.unRegisterNode(nm1);
            rm.unRegisterNode(nm4);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "16", legacyQueueMode));
        }
        finally {
            rm.close();
        }
    }

    public static String getExpectedResourceFile(String template, String name, String suffix, boolean legacyQueueMode) throws IOException {
        String legacyResource = String.format(template, TestWebServiceUtil.legacySuffix(legacyQueueMode, name), suffix);
        try (InputStream stream = TestWebServiceUtil.getResourceAsStream(legacyResource);){
            if (stream != null) {
                String string = legacyResource;
                return string;
            }
        }
        return String.format(template, name, suffix);
    }

    public static String legacySuffix(boolean legacyQueueMode, String text) {
        if (legacyQueueMode) {
            return text + "-legacy";
        }
        return text;
    }

    public static boolean isMutableConfig(Configuration config) {
        return Objects.equals(config.get("yarn.scheduler.configuration.store.class"), "memory");
    }

    public static ClientResponse sendRequest(WebResource resource) {
        return (ClientResponse)resource.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    public static void assertXmlType(ClientResponse response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
    }

    public static void assertXmlResponse(ClientResponse response, String expectedResourceFilename) throws Exception {
        TestWebServiceUtil.assertXmlType(response);
        Document document = TestWebServiceUtil.loadDocument((String)response.getEntity(String.class));
        String actual = TestWebServiceUtil.serializeDocument(document).trim();
        TestWebServiceUtil.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)TestWebServiceUtil.getResourceAsString(expectedResourceFilename), (Object)actual);
    }

    public static String serializeDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = XMLUtils.newSecureTransformerFactory();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static Document loadDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    public static void assertJsonResponse(ClientResponse response, String expectedResourceFilename) throws JSONException, IOException {
        TestWebServiceUtil.assertJsonType(response);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        String actual = TestWebServiceUtil.prettyPrintJson(json.toString(2));
        TestWebServiceUtil.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)TestWebServiceUtil.prettyPrintJson(TestWebServiceUtil.getResourceAsString(expectedResourceFilename)), (Object)actual);
    }

    private static String prettyPrintJson(String in) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectMapper.readTree(in));
    }

    public static void assertJsonType(ClientResponse response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
    }

    public static InputStream getResourceAsStream(String configFilename) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(configFilename);
    }

    /*
     * Exception decompiling
     */
    public static String getResourceAsString(String configFilename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void updateTestDataAutomatically(String configFilename, String actualContent) {
        if (System.getenv("UPDATE_TESTDATA") == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String resource = Objects.requireNonNull(Objects.requireNonNull(classLoader.getResource(configFilename)).toURI().getPath()).replaceAll("/target/test-classes/", "/src/test/resources/");
            try (FileWriter writer = new FileWriter(resource, false);){
                writer.write(actualContent);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)("overwrite should not fail " + e.getMessage()));
        }
    }

    public static WebAppDescriptor createWebAppDescriptor() {
        return new WebAppDescriptor.Builder(new String[]{TestRMWebServicesCapacitySched.class.getPackage().getName()}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build();
    }

    public static MockRM createRM(Configuration config) {
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        config.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm = new MockRM(config);
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule(rm)}));
        rm.start();
        return rm;
    }

    public static MockRM createMutableRM(Configuration conf) throws IOException {
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        MockRM rm = TestWebServiceUtil.createRM((Configuration)new CapacitySchedulerConfiguration(conf));
        TestWebServiceUtil.reinitialize(rm, conf);
        return rm;
    }

    public static void reinitialize(MockRM rm, Configuration conf) throws IOException {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.reinitialize(conf, rm.getRMContext(), true);
    }

    public static class WebServletModule
    extends ServletModule {
        private final MockRM rm;

        WebServletModule(MockRM rm) {
            this.rm = rm;
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(ResourceManager.class).toInstance((Object)this.rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

