/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;

public class ResourceRequestsJsonVerifications {
    private final ResourceRequest resourceRequest;
    private final JSONObject requestInfo;
    private final Map<String, Long> customResourceTypes;
    private final List<String> expectedCustomResourceTypes;

    ResourceRequestsJsonVerifications(Builder builder) {
        this.resourceRequest = builder.resourceRequest;
        this.requestInfo = builder.requestInfo;
        this.customResourceTypes = builder.customResourceTypes;
        this.expectedCustomResourceTypes = builder.expectedCustomResourceTypes;
    }

    public static void verify(JSONObject requestInfo, ResourceRequest rr) throws JSONException {
        ResourceRequestsJsonVerifications.createDefaultBuilder(requestInfo, rr).build().verify();
    }

    public static void verifyWithCustomResourceTypes(JSONObject requestInfo, ResourceRequest resourceRequest, List<String> expectedResourceTypes) throws JSONException {
        ResourceRequestsJsonVerifications.createDefaultBuilder(requestInfo, resourceRequest).withExpectedCustomResourceTypes(expectedResourceTypes).withCustomResourceTypes(ResourceRequestsJsonVerifications.extractActualCustomResourceTypes(requestInfo, expectedResourceTypes)).build().verify();
    }

    private static Builder createDefaultBuilder(JSONObject requestInfo, ResourceRequest resourceRequest) {
        return new Builder().withRequest(resourceRequest).withRequestInfoJson(requestInfo);
    }

    private static Map<String, Long> extractActualCustomResourceTypes(JSONObject requestInfo, List<String> expectedResourceTypes) throws JSONException {
        JSONObject capability = requestInfo.getJSONObject("capability");
        Map<String, Long> resourceAndValue = ResourceRequestsJsonVerifications.extractCustomResorceTypeValues(capability, expectedResourceTypes);
        Map.Entry<String, Long> resourceEntry = resourceAndValue.entrySet().iterator().next();
        TestCase.assertTrue((String)("Found resource type: " + resourceEntry.getKey() + " is not in expected resource types: " + expectedResourceTypes), (boolean)expectedResourceTypes.contains(resourceEntry.getKey()));
        return resourceAndValue;
    }

    private static Map<String, Long> extractCustomResorceTypeValues(JSONObject capability, List<String> expectedResourceTypes) throws JSONException {
        TestCase.assertTrue((String)("resourceCategory does not have resourceInformations: " + capability), (boolean)capability.has("resourceInformations"));
        JSONObject resourceInformations = capability.getJSONObject("resourceInformations");
        TestCase.assertTrue((String)("resourceInformations does not have resourceInformation object: " + resourceInformations), (boolean)resourceInformations.has("resourceInformation"));
        JSONArray customResources = resourceInformations.getJSONArray("resourceInformation");
        Assert.assertEquals((String)"Different number of custom resource types found than expected", (long)expectedResourceTypes.size(), (long)(customResources.length() - 2));
        HashMap resourceValues = Maps.newHashMap();
        for (int i = 0; i < customResources.length(); ++i) {
            JSONObject customResource = customResources.getJSONObject(i);
            TestCase.assertTrue((String)("Resource type does not have name field: " + customResource), (boolean)customResource.has("name"));
            TestCase.assertTrue((String)("Resource type does not have name resourceType field: " + customResource), (boolean)customResource.has("resourceType"));
            TestCase.assertTrue((String)("Resource type does not have name units field: " + customResource), (boolean)customResource.has("units"));
            TestCase.assertTrue((String)("Resource type does not have name value field: " + customResource), (boolean)customResource.has("value"));
            String name = customResource.getString("name");
            String unit = customResource.getString("units");
            String resourceType = customResource.getString("resourceType");
            Long value = customResource.getLong("value");
            if ("memory-mb".equals(name) || "vcores".equals(name)) continue;
            TestCase.assertTrue((String)("Custom resource type " + name + " not found"), (boolean)expectedResourceTypes.contains(name));
            Assert.assertEquals((Object)"k", (Object)unit);
            Assert.assertEquals((Object)ResourceTypes.COUNTABLE, (Object)ResourceTypes.valueOf((String)resourceType));
            Assert.assertNotNull((String)("Custom resource value " + value + " is null!"), (Object)value);
            resourceValues.put(name, value);
        }
        return resourceValues;
    }

    private void verify() throws JSONException {
        Assert.assertEquals((String)"nodeLabelExpression doesn't match", (Object)this.resourceRequest.getNodeLabelExpression(), (Object)this.requestInfo.getString("nodeLabelExpression"));
        Assert.assertEquals((String)"numContainers doesn't match", (long)this.resourceRequest.getNumContainers(), (long)this.requestInfo.getInt("numContainers"));
        Assert.assertEquals((String)"relaxLocality doesn't match", (Object)this.resourceRequest.getRelaxLocality(), (Object)this.requestInfo.getBoolean("relaxLocality"));
        Assert.assertEquals((String)"priority does not match", (long)this.resourceRequest.getPriority().getPriority(), (long)this.requestInfo.getInt("priority"));
        Assert.assertEquals((String)"resourceName does not match", (Object)this.resourceRequest.getResourceName(), (Object)this.requestInfo.getString("resourceName"));
        Assert.assertEquals((String)"memory does not match", (long)this.resourceRequest.getCapability().getMemorySize(), (long)this.requestInfo.getJSONObject("capability").getLong("memory"));
        Assert.assertEquals((String)"vCores does not match", (long)this.resourceRequest.getCapability().getVirtualCores(), (long)this.requestInfo.getJSONObject("capability").getLong("vCores"));
        this.verifyAtLeastOneCustomResourceIsSerialized();
        JSONObject executionTypeRequest = this.requestInfo.getJSONObject("executionTypeRequest");
        Assert.assertEquals((String)"executionType does not match", (Object)this.resourceRequest.getExecutionTypeRequest().getExecutionType().name(), (Object)executionTypeRequest.getString("executionType"));
        Assert.assertEquals((String)"enforceExecutionType does not match", (Object)this.resourceRequest.getExecutionTypeRequest().getEnforceExecutionType(), (Object)executionTypeRequest.getBoolean("enforceExecutionType"));
    }

    private void verifyAtLeastOneCustomResourceIsSerialized() {
        boolean resourceFound = false;
        for (String expectedCustomResourceType : this.expectedCustomResourceTypes) {
            if (!this.customResourceTypes.containsKey(expectedCustomResourceType)) continue;
            resourceFound = true;
            Long resourceValue = this.customResourceTypes.get(expectedCustomResourceType);
            Assert.assertNotNull((String)"Resource value should not be null!", (Object)resourceValue);
        }
        TestCase.assertTrue((String)"No custom resource type can be found in the response!", (boolean)resourceFound);
    }

    public static final class Builder {
        private List<String> expectedCustomResourceTypes = Lists.newArrayList();
        private Map<String, Long> customResourceTypes;
        private ResourceRequest resourceRequest;
        private JSONObject requestInfo;

        Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        Builder withExpectedCustomResourceTypes(List<String> expectedCustomResourceTypes) {
            this.expectedCustomResourceTypes = expectedCustomResourceTypes;
            return this;
        }

        Builder withCustomResourceTypes(Map<String, Long> customResourceTypes) {
            this.customResourceTypes = customResourceTypes;
            return this;
        }

        Builder withRequest(ResourceRequest resourceRequest) {
            this.resourceRequest = resourceRequest;
            return this;
        }

        Builder withRequestInfoJson(JSONObject requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        public ResourceRequestsJsonVerifications build() {
            return new ResourceRequestsJsonVerifications(this);
        }
    }
}

