/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.SCMUploaderProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.SCMUploaderNotifyRequest;
import org.apache.hadoop.yarn.server.sharedcachemanager.AppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.DummyAppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.SharedCacheUploaderService;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.SharedCacheUploaderMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSharedCacheUploaderService {
    private static File testDir = null;
    private SharedCacheUploaderService service;
    private SCMUploaderProtocol proxy;
    private SCMStore store;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @BeforeClass
    public static void setupTestDirs() throws IOException {
        testDir = new File("target", TestSharedCacheUploaderService.class.getCanonicalName());
        testDir.delete();
        testDir.mkdirs();
        testDir = testDir.getAbsoluteFile();
    }

    @AfterClass
    public static void cleanupTestDirs() throws IOException {
        if (testDir != null) {
            testDir.delete();
        }
    }

    @Before
    public void startUp() {
        Configuration conf = new Configuration();
        conf.set("yarn.sharedcache.store.class", InMemorySCMStore.class.getName());
        conf.set("yarn.sharedcache.root-dir", testDir.getPath());
        AppChecker appChecker = (AppChecker)Mockito.spy((Object)new DummyAppChecker());
        this.store = new InMemorySCMStore(appChecker);
        this.store.init(conf);
        this.store.start();
        this.service = new SharedCacheUploaderService(this.store);
        this.service.init(conf);
        this.service.start();
        YarnRPC rpc = YarnRPC.create((Configuration)new Configuration());
        InetSocketAddress scmAddress = conf.getSocketAddr("yarn.sharedcache.uploader.server.address", "0.0.0.0:8046", 8046);
        this.proxy = (SCMUploaderProtocol)rpc.getProxy(SCMUploaderProtocol.class, scmAddress, conf);
    }

    @After
    public void cleanUp() {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.service != null) {
            this.service.stop();
        }
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    @Test
    public void testNotify_noEntry() throws Exception {
        long accepted = SharedCacheUploaderMetrics.getInstance().getAcceptedUploads();
        SCMUploaderNotifyRequest request = (SCMUploaderNotifyRequest)this.recordFactory.newRecordInstance(SCMUploaderNotifyRequest.class);
        request.setResourceKey("key1");
        request.setFilename("foo.jar");
        Assert.assertTrue((boolean)this.proxy.notify(request).getAccepted());
        Collection set = this.store.getResourceReferences("key1");
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertEquals((String)"NM upload metrics aren't updated.", (long)1L, (long)(SharedCacheUploaderMetrics.getInstance().getAcceptedUploads() - accepted));
    }

    @Test
    public void testNotify_entryExists_differentName() throws Exception {
        long rejected = SharedCacheUploaderMetrics.getInstance().getRejectUploads();
        this.store.addResource("key1", "foo.jar");
        SCMUploaderNotifyRequest request = (SCMUploaderNotifyRequest)this.recordFactory.newRecordInstance(SCMUploaderNotifyRequest.class);
        request.setResourceKey("key1");
        request.setFilename("foobar.jar");
        Assert.assertFalse((boolean)this.proxy.notify(request).getAccepted());
        Collection set = this.store.getResourceReferences("key1");
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertEquals((String)"NM upload metrics aren't updated.", (long)1L, (long)(SharedCacheUploaderMetrics.getInstance().getRejectUploads() - rejected));
    }

    @Test
    public void testNotify_entryExists_sameName() throws Exception {
        long accepted = SharedCacheUploaderMetrics.getInstance().getAcceptedUploads();
        this.store.addResource("key1", "foo.jar");
        SCMUploaderNotifyRequest request = (SCMUploaderNotifyRequest)this.recordFactory.newRecordInstance(SCMUploaderNotifyRequest.class);
        request.setResourceKey("key1");
        request.setFilename("foo.jar");
        Assert.assertTrue((boolean)this.proxy.notify(request).getAccepted());
        Collection set = this.store.getResourceReferences("key1");
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertEquals((String)"NM upload metrics aren't updated.", (long)1L, (long)(SharedCacheUploaderMetrics.getInstance().getAcceptedUploads() - accepted));
    }
}

