/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.webapp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.ClientSCMMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.SharedCacheUploaderMetrics;

@XmlRootElement(name="SCMMetrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SCMMetricsInfo {
    protected long totalDeletedFiles;
    protected long totalProcessedFiles;
    protected long cacheHits;
    protected long cacheMisses;
    protected long cacheReleases;
    protected long acceptedUploads;
    protected long rejectedUploads;

    public SCMMetricsInfo() {
    }

    public SCMMetricsInfo(CleanerMetrics cleanerMetrics, ClientSCMMetrics clientSCMMetrics, SharedCacheUploaderMetrics scmUploaderMetrics) {
        this.totalDeletedFiles = cleanerMetrics.getTotalDeletedFiles();
        this.totalProcessedFiles = cleanerMetrics.getTotalProcessedFiles();
        this.cacheHits = clientSCMMetrics.getCacheHits();
        this.cacheMisses = clientSCMMetrics.getCacheMisses();
        this.cacheReleases = clientSCMMetrics.getCacheReleases();
        this.acceptedUploads = scmUploaderMetrics.getAcceptedUploads();
        this.rejectedUploads = scmUploaderMetrics.getRejectUploads();
    }

    public long getTotalDeletedFiles() {
        return this.totalDeletedFiles;
    }

    public long getTotalProcessedFiles() {
        return this.totalProcessedFiles;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getCacheReleases() {
        return this.cacheReleases;
    }

    public long getAcceptedUploads() {
        return this.acceptedUploads;
    }

    public long getRejectUploads() {
        return this.rejectedUploads;
    }
}

