/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.store;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SharedCacheResourceReference;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class SharedCacheResource {
    private long accessTime = System.currentTimeMillis();
    private final Set<SharedCacheResourceReference> refs = new HashSet<SharedCacheResourceReference>();
    private final String fileName;

    SharedCacheResource(String fileName) {
        this.fileName = fileName;
    }

    long getAccessTime() {
        return this.accessTime;
    }

    void updateAccessTime() {
        this.accessTime = System.currentTimeMillis();
    }

    String getFileName() {
        return this.fileName;
    }

    Set<SharedCacheResourceReference> getResourceReferences() {
        return this.refs;
    }

    boolean addReference(SharedCacheResourceReference ref) {
        return this.refs.add(ref);
    }
}

