/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricsSourceBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@Metrics(name="CleanerActivity", about="Cleaner service metrics", context="yarn")
public class CleanerMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(CleanerMetrics.class);
    private final MetricsRegistry registry = new MetricsRegistry("cleaner");
    private static final CleanerMetrics INSTANCE = CleanerMetrics.create();
    @Metric(value={"number of deleted files over all runs"})
    private MutableCounterLong totalDeletedFiles;
    @Metric(value={"number of deleted files in the last run"})
    private MutableGaugeLong deletedFiles;
    @Metric(value={"number of processed files over all runs"})
    private MutableCounterLong totalProcessedFiles;
    @Metric(value={"number of processed files in the last run"})
    private MutableGaugeLong processedFiles;
    @Metric(value={"number of file errors over all runs"})
    private MutableCounterLong totalFileErrors;
    @Metric(value={"number of file errors in the last run"})
    private MutableGaugeLong fileErrors;
    MetricsSource metricSource;

    public static CleanerMetrics getInstance() {
        return INSTANCE;
    }

    public long getTotalDeletedFiles() {
        return this.totalDeletedFiles.value();
    }

    public long getDeletedFiles() {
        return this.deletedFiles.value();
    }

    public long getTotalProcessedFiles() {
        return this.totalProcessedFiles.value();
    }

    public long getProcessedFiles() {
        return this.processedFiles.value();
    }

    public long getTotalFileErrors() {
        return this.totalFileErrors.value();
    }

    public long getFileErrors() {
        return this.fileErrors.value();
    }

    private CleanerMetrics() {
    }

    static CleanerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        CleanerMetrics metricObject = new CleanerMetrics();
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)metricObject);
        MetricsSource s = sb.build();
        ms.register("cleaner", "The cleaner service of truly shared cache", (Object)s);
        metricObject.metricSource = s;
        return metricObject;
    }

    public void reportAFileDelete() {
        this.totalProcessedFiles.incr();
        this.processedFiles.incr();
        this.totalDeletedFiles.incr();
        this.deletedFiles.incr();
    }

    public void reportAFileProcess() {
        this.totalProcessedFiles.incr();
        this.processedFiles.incr();
    }

    public void reportAFileError() {
        this.totalProcessedFiles.incr();
        this.processedFiles.incr();
        this.totalFileErrors.incr();
        this.fileErrors.incr();
    }

    public void reportCleaningStart() {
        this.processedFiles.set(0L);
        this.deletedFiles.set(0L);
        this.fileErrors.set(0L);
    }
}

