/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@Metrics(about="shared cache upload metrics", context="yarn")
public class SharedCacheUploaderMetrics {
    static final Logger LOG = LoggerFactory.getLogger(SharedCacheUploaderMetrics.class);
    final MetricsRegistry registry = new MetricsRegistry("SharedCacheUploaderRequests");
    private static final SharedCacheUploaderMetrics INSTANCE = SharedCacheUploaderMetrics.create();
    @Metric(value={"Number of accepted uploads"})
    MutableCounterLong acceptedUploads;
    @Metric(value={"Number of rejected uploads"})
    MutableCounterLong rejectedUploads;

    private SharedCacheUploaderMetrics() {
        LOG.debug("Initialized {}", (Object)this.registry);
    }

    public static SharedCacheUploaderMetrics getInstance() {
        return INSTANCE;
    }

    static SharedCacheUploaderMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        SharedCacheUploaderMetrics metrics = new SharedCacheUploaderMetrics();
        ms.register("SharedCacheUploaderRequests", null, (Object)metrics);
        return metrics;
    }

    public void incAcceptedUploads() {
        this.acceptedUploads.incr();
    }

    public void incRejectedUploads() {
        this.rejectedUploads.incr();
    }

    public long getAcceptedUploads() {
        return this.acceptedUploads.value();
    }

    public long getRejectUploads() {
        return this.rejectedUploads.value();
    }
}

