/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.sharedcachemanager.SharedCacheManager;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.ClientSCMMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.SharedCacheUploaderMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.webapp.SCMMetricsInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.TwoColumnLayout;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SCMOverviewPage
extends TwoColumnLayout {
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return SCMOverviewBlock.class;
    }

    protected Class<? extends SubView> nav() {
        return SCMOverviewNavBlock.class;
    }

    private static class SCMOverviewBlock
    extends HtmlBlock {
        final SharedCacheManager scm;

        @Inject
        SCMOverviewBlock(SharedCacheManager scm, View.ViewContext ctx) {
            super(ctx);
            this.scm = scm;
        }

        protected void render(HtmlBlock.Block html) {
            SCMMetricsInfo metricsInfo = new SCMMetricsInfo(CleanerMetrics.getInstance(), ClientSCMMetrics.getInstance(), SharedCacheUploaderMetrics.getInstance());
            this.info("Shared Cache Manager overview").__("Started on:", (Object)Times.format((long)this.scm.getStartTime())).__("Cache hits: ", (Object)metricsInfo.getCacheHits()).__("Cache misses: ", (Object)metricsInfo.getCacheMisses()).__("Cache releases: ", (Object)metricsInfo.getCacheReleases()).__("Accepted uploads: ", (Object)metricsInfo.getAcceptedUploads()).__("Rejected uploads: ", (Object)metricsInfo.getRejectUploads()).__("Deleted files by the cleaner: ", (Object)metricsInfo.getTotalDeletedFiles()).__("Processed files by the cleaner: ", (Object)metricsInfo.getTotalProcessedFiles());
            html.__(InfoBlock.class);
        }
    }

    private static class SCMOverviewNavBlock
    extends HtmlBlock {
        private SCMOverviewNavBlock() {
        }

        protected void render(HtmlBlock.Block html) {
            ((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Tools").ul().li().a("/conf", "Configuration").__()).li().a("/stacks", "Thread dump").__()).li().a("/logs", "Logs").__()).li().a("/metrics", "Metrics").__()).__()).__();
        }
    }
}

