/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.ServerRMProxy;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMiniYarnClusterNodeUtilization {
    private static final int NUM_RM = 1;
    private static final int NUM_NM = 1;
    private static final int CONTAINER_PMEM_1 = 1024;
    private static final int CONTAINER_VMEM_1 = 2048;
    private static final float CONTAINER_CPU_1 = 11.0f;
    private static final int NODE_PMEM_1 = 10240;
    private static final int NODE_VMEM_1 = 20480;
    private static final float NODE_CPU_1 = 51.0f;
    private static final int CONTAINER_PMEM_2 = 2048;
    private static final int CONTAINER_VMEM_2 = 4096;
    private static final float CONTAINER_CPU_2 = 22.0f;
    private static final int NODE_PMEM_2 = 20480;
    private static final int NODE_VMEM_2 = 40960;
    private static final float NODE_CPU_2 = 61.0f;
    private MiniYARNCluster cluster;
    private MiniYARNCluster.CustomNodeManager nm;
    private Configuration conf;
    private NodeStatus nodeStatus;

    @Before
    public void setup() {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        this.conf.setInt("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 100);
        String name = TestMiniYarnClusterNodeUtilization.class.getName();
        this.cluster = new MiniYARNCluster(name, 1, 1, 1, 1);
        this.cluster.init(this.conf);
        this.cluster.start();
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
        this.nm = (MiniYARNCluster.CustomNodeManager)this.cluster.getNodeManager(0);
        int responseId = 1;
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), responseId, 1024, 2048, 11.0f, 10240, 20480, 51.0f);
        this.nm.setNodeStatus(this.nodeStatus);
    }

    @Test(timeout=60000L)
    public void testUpdateNodeUtilization() throws InterruptedException, IOException, YarnException {
        Assert.assertTrue((String)"NMs fail to connect to the RM", (boolean)this.cluster.waitForNodeManagersToConnect(10000L));
        NodeHeartbeatRequest request = NodeHeartbeatRequest.newInstance((NodeStatus)this.nodeStatus, null, null, null);
        ResourceTracker tracker = (ResourceTracker)ServerRMProxy.createRMProxy((Configuration)this.conf, ResourceTracker.class);
        tracker.nodeHeartbeat(request);
        this.verifySimulatedUtilization();
        int responseId = 10;
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), responseId, 2048, 4096, 22.0f, 20480, 40960, 61.0f);
        this.nm.setNodeStatus(this.nodeStatus);
        tracker.nodeHeartbeat(request);
        this.verifySimulatedUtilization();
    }

    @Test(timeout=60000L)
    public void testMockNodeStatusHeartbeat() throws InterruptedException, YarnException {
        Assert.assertTrue((String)"NMs fail to connect to the RM", (boolean)this.cluster.waitForNodeManagersToConnect(10000L));
        NodeStatusUpdater updater = this.nm.getNodeStatusUpdater();
        updater.sendOutofBandHeartBeat();
        this.verifySimulatedUtilization();
        int responseId = 20;
        this.nodeStatus = this.createNodeStatus(this.nm.getNMContext().getNodeId(), responseId, 2048, 4096, 22.0f, 20480, 40960, 61.0f);
        this.nm.setNodeStatus(this.nodeStatus);
        updater.sendOutofBandHeartBeat();
        this.verifySimulatedUtilization();
    }

    private NodeStatus createNodeStatus(NodeId nodeId, int responseId, int containerPMem, int containerVMem, float containerCPU, int nodePMem, int nodeVMem, float nodeCPU) {
        ResourceUtilization containersUtilization = ResourceUtilization.newInstance((int)containerPMem, (int)containerVMem, (float)containerCPU);
        ResourceUtilization nodeUtilization = ResourceUtilization.newInstance((int)nodePMem, (int)nodeVMem, (float)nodeCPU);
        NodeStatus status = NodeStatus.newInstance((NodeId)nodeId, (int)responseId, new ArrayList(), null, (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, null, (long)0L), (ResourceUtilization)containersUtilization, (ResourceUtilization)nodeUtilization, null);
        return status;
    }

    private void verifySimulatedUtilization() throws InterruptedException {
        ResourceManager rm = this.cluster.getResourceManager(0);
        RMContext rmContext = rm.getRMContext();
        ResourceUtilization containersUtilization = this.nodeStatus.getContainersUtilization();
        ResourceUtilization nodeUtilization = this.nodeStatus.getNodeUtilization();
        for (int i = 0; i < 100; ++i) {
            RMNode ni;
            Iterator i$ = rmContext.getRMNodes().values().iterator();
            while (i$.hasNext() && ((ni = (RMNode)i$.next()).getNodeUtilization() == null || !ni.getNodeUtilization().equals((Object)nodeUtilization))) {
            }
            Thread.sleep(100L);
        }
        for (RMNode ni : rmContext.getRMNodes().values()) {
            ResourceUtilization cu = ni.getAggregatedContainersUtilization();
            Assert.assertEquals((String)"Containers Utillization not propagated to RMNode", (Object)containersUtilization, (Object)cu);
            ResourceUtilization nu = ni.getNodeUtilization();
            Assert.assertEquals((String)"Node Utillization not propagated to RMNode", (Object)nodeUtilization, (Object)nu);
            SchedulerNode scheduler = rmContext.getScheduler().getSchedulerNode(ni.getNodeID());
            cu = scheduler.getAggregatedContainersUtilization();
            Assert.assertEquals((String)"Containers Utillization not propagated to SchedulerNode", (Object)containersUtilization, (Object)cu);
            nu = scheduler.getNodeUtilization();
            Assert.assertEquals((String)"Node Utillization not propagated to SchedulerNode", (Object)nodeUtilization, (Object)nu);
        }
    }
}

